/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.SocketFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoCodec;
import org.apache.hadoop.crypto.CryptoInputStream;
import org.apache.hadoop.crypto.CryptoOutputStream;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderTokenIssuer;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.FsTracer;
import org.apache.hadoop.fs.HdfsBlockLocation;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsCreateModes;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.ClientContext;
import org.apache.hadoop.hdfs.DFSHedgedReadMetrics;
import org.apache.hadoop.hdfs.DFSInotifyEventInputStream;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSStripedInputStream;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.DeadNodeDetector;
import org.apache.hadoop.hdfs.FileChecksumHelper;
import org.apache.hadoop.hdfs.HAUtilClient;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.HdfsKMSUtil;
import org.apache.hadoop.hdfs.LocatedBlocksRefresher;
import org.apache.hadoop.hdfs.NameNodeProxiesClient;
import org.apache.hadoop.hdfs.RemotePeerFactory;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.client.HdfsClientConfigKeys;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.client.impl.DfsClientConf;
import org.apache.hadoop.hdfs.client.impl.LeaseRenewer;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.protocol.AclException;
import org.apache.hadoop.hdfs.protocol.AddErasureCodingPolicyResponse;
import org.apache.hadoop.hdfs.protocol.BatchedDirectoryListing;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveIterator;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolIterator;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ECTopologyVerifierResult;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.protocol.EncryptionZoneIterator;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsPathHandle;
import org.apache.hadoop.hdfs.protocol.LastBlockWithStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.NoECPolicySetException;
import org.apache.hadoop.hdfs.protocol.OpenFileEntry;
import org.apache.hadoop.hdfs.protocol.OpenFilesIterator;
import org.apache.hadoop.hdfs.protocol.QuotaByStorageTypeExceededException;
import org.apache.hadoop.hdfs.protocol.ReencryptionStatusIterator;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.protocol.SnapshotAccessControlException;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReportListing;
import org.apache.hadoop.hdfs.protocol.SnapshotStatus;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.protocol.ZoneReencryptionStatus;
import org.apache.hadoop.hdfs.protocol.datatransfer.DataTransferProtoUtil;
import org.apache.hadoop.hdfs.protocol.datatransfer.IOStreamPair;
import org.apache.hadoop.hdfs.protocol.datatransfer.ReplaceDatanodeOnFailure;
import org.apache.hadoop.hdfs.protocol.datatransfer.Sender;
import org.apache.hadoop.hdfs.protocol.datatransfer.TrustedChannelResolver;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.DataEncryptionKeyFactory;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.DataTransferSaslUtil;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.SaslDataTransferClient;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.util.IOUtilsClient;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.ipc.RpcNoSuchMethodException;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenRenewer;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.thirdparty.com.google.common.net.InetAddresses;
import org.apache.hadoop.tracing.TraceScope;
import org.apache.hadoop.tracing.Tracer;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DFSClient
implements Closeable,
RemotePeerFactory,
DataEncryptionKeyFactory,
KeyProviderTokenIssuer {
    public static final Logger LOG = LoggerFactory.getLogger(DFSClient.class);
    private final Configuration conf;
    private final Tracer tracer;
    private final DfsClientConf dfsClientConf;
    final ClientProtocol namenode;
    private Text dtService;
    final UserGroupInformation ugi;
    volatile boolean clientRunning = true;
    volatile long lastLeaseRenewal;
    private volatile FsServerDefaults serverDefaults;
    private volatile long serverDefaultsLastUpdate;
    final String clientName;
    final SocketFactory socketFactory;
    final ReplaceDatanodeOnFailure dtpReplaceDatanodeOnFailure;
    final short dtpReplaceDatanodeOnFailureReplication;
    private final FileSystem.Statistics stats;
    private final URI namenodeUri;
    private final Random r = new Random();
    private SocketAddress[] localInterfaceAddrs;
    private DataEncryptionKey encryptionKey;
    final SaslDataTransferClient saslClient;
    private final CachingStrategy defaultReadCachingStrategy;
    private final CachingStrategy defaultWriteCachingStrategy;
    private final ClientContext clientContext;
    private static final DFSHedgedReadMetrics HEDGED_READ_METRIC = new DFSHedgedReadMetrics();
    private static ThreadPoolExecutor HEDGED_READ_THREAD_POOL;
    private static volatile ThreadPoolExecutor STRIPED_READ_THREAD_POOL;
    private final long serverDefaultsValidityPeriod;
    private static volatile boolean disabledStopDeadNodeDetectorThreadForTest;
    private final Map<String, DFSOutputStream> filesBeingWritten = new HashMap<String, DFSOutputStream>();

    @VisibleForTesting
    public static void setDisabledStopDeadNodeDetectorThreadForTest(boolean disabledStopDeadNodeDetectorThreadForTest) {
        DFSClient.disabledStopDeadNodeDetectorThreadForTest = disabledStopDeadNodeDetectorThreadForTest;
    }

    public DfsClientConf getConf() {
        return this.dfsClientConf;
    }

    Configuration getConfiguration() {
        return this.conf;
    }

    @Deprecated
    public DFSClient(Configuration conf) throws IOException {
        this(DFSUtilClient.getNNAddress(conf), conf);
    }

    public DFSClient(InetSocketAddress address, Configuration conf) throws IOException {
        this(DFSUtilClient.getNNUri(address), conf);
    }

    public DFSClient(URI nameNodeUri, Configuration conf) throws IOException {
        this(nameNodeUri, conf, null);
    }

    public DFSClient(URI nameNodeUri, Configuration conf, FileSystem.Statistics stats) throws IOException {
        this(nameNodeUri, null, conf, stats);
    }

    @VisibleForTesting
    public DFSClient(URI nameNodeUri, ClientProtocol rpcNamenode, Configuration conf, FileSystem.Statistics stats) throws IOException {
        this.tracer = FsTracer.get(conf);
        this.dfsClientConf = new DfsClientConf(conf);
        this.conf = conf;
        this.stats = stats;
        this.socketFactory = NetUtils.getSocketFactory(conf, ClientProtocol.class);
        this.dtpReplaceDatanodeOnFailure = ReplaceDatanodeOnFailure.get(conf);
        this.dtpReplaceDatanodeOnFailureReplication = (short)conf.getInt("dfs.client.block.write.replace-datanode-on-failure.min-replication", 0);
        LOG.debug("Sets {} to {}", (Object)"dfs.client.block.write.replace-datanode-on-failure.min-replication", (Object)this.dtpReplaceDatanodeOnFailureReplication);
        this.ugi = UserGroupInformation.getCurrentUser();
        this.namenodeUri = nameNodeUri;
        this.clientName = "DFSClient_" + this.dfsClientConf.getTaskId() + "_" + ThreadLocalRandom.current().nextInt() + "_" + Thread.currentThread().getId();
        int numResponseToDrop = conf.getInt("dfs.client.test.drop.namenode.response.number", 0);
        NameNodeProxiesClient.ProxyAndInfo<ClientProtocol> proxyInfo = null;
        AtomicBoolean nnFallbackToSimpleAuth = new AtomicBoolean(false);
        if (numResponseToDrop > 0) {
            LOG.warn("{} is set to {} , this hacked client will proactively drop responses", (Object)"dfs.client.test.drop.namenode.response.number", (Object)numResponseToDrop);
            proxyInfo = NameNodeProxiesClient.createProxyWithLossyRetryHandler(conf, nameNodeUri, ClientProtocol.class, numResponseToDrop, nnFallbackToSimpleAuth);
        }
        if (proxyInfo != null) {
            this.dtService = proxyInfo.getDelegationTokenService();
            this.namenode = (ClientProtocol)proxyInfo.getProxy();
        } else if (rpcNamenode != null) {
            Preconditions.checkArgument(nameNodeUri == null);
            this.namenode = rpcNamenode;
            this.dtService = null;
        } else {
            Preconditions.checkArgument(nameNodeUri != null, "null URI");
            proxyInfo = NameNodeProxiesClient.createProxyWithClientProtocol(conf, nameNodeUri, nnFallbackToSimpleAuth);
            this.dtService = proxyInfo.getDelegationTokenService();
            this.namenode = proxyInfo.getProxy();
        }
        Object[] localInterfaces = conf.getTrimmedStrings("dfs.client.local.interfaces");
        this.localInterfaceAddrs = DFSClient.getLocalInterfaceAddrs((String[])localInterfaces);
        if (LOG.isDebugEnabled() && 0 != localInterfaces.length) {
            LOG.debug("Using local interfaces [{}] with addresses [{}]", (Object)Joiner.on((char)',').join(localInterfaces), (Object)Joiner.on((char)',').join((Object[])this.localInterfaceAddrs));
        }
        Boolean readDropBehind = conf.get("dfs.client.cache.drop.behind.reads") == null ? null : Boolean.valueOf(conf.getBoolean("dfs.client.cache.drop.behind.reads", false));
        Long readahead = conf.get("dfs.client.cache.readahead") == null ? null : Long.valueOf(conf.getLongBytes("dfs.client.cache.readahead", 0L));
        this.serverDefaultsValidityPeriod = conf.getTimeDuration("dfs.client.server-defaults.validity.period.ms", HdfsClientConfigKeys.DFS_CLIENT_SERVER_DEFAULTS_VALIDITY_PERIOD_MS_DEFAULT, TimeUnit.MILLISECONDS);
        Boolean writeDropBehind = conf.get("dfs.client.cache.drop.behind.writes") == null ? null : Boolean.valueOf(conf.getBoolean("dfs.client.cache.drop.behind.writes", false));
        this.defaultReadCachingStrategy = new CachingStrategy(readDropBehind, readahead);
        this.defaultWriteCachingStrategy = new CachingStrategy(writeDropBehind, readahead);
        this.clientContext = ClientContext.get(conf.get("dfs.client.context", "default"), this.dfsClientConf, conf);
        if (this.dfsClientConf.getHedgedReadThreadpoolSize() > 0) {
            DFSClient.initThreadsNumForHedgedReads(this.dfsClientConf.getHedgedReadThreadpoolSize());
        }
        this.initThreadsNumForStripedReads(this.dfsClientConf.getStripedReadThreadpoolSize());
        this.saslClient = new SaslDataTransferClient(conf, DataTransferSaslUtil.getSaslPropertiesResolver(conf), TrustedChannelResolver.getInstance(conf), nnFallbackToSimpleAuth);
    }

    private static SocketAddress[] getLocalInterfaceAddrs(String[] interfaceNames) throws UnknownHostException {
        ArrayList<InetSocketAddress> localAddrs = new ArrayList<InetSocketAddress>();
        for (String interfaceName : interfaceNames) {
            if (InetAddresses.isInetAddress((String)interfaceName)) {
                localAddrs.add(new InetSocketAddress(interfaceName, 0));
                continue;
            }
            if (NetUtils.isValidSubnet(interfaceName)) {
                for (InetAddress addr : NetUtils.getIPs(interfaceName, false)) {
                    localAddrs.add(new InetSocketAddress(addr, 0));
                }
                continue;
            }
            for (String ip : DNS.getIPs(interfaceName, false)) {
                localAddrs.add(new InetSocketAddress(ip, 0));
            }
        }
        return localAddrs.toArray(new SocketAddress[localAddrs.size()]);
    }

    SocketAddress getRandomLocalInterfaceAddr() {
        if (this.localInterfaceAddrs.length == 0) {
            return null;
        }
        int idx = this.r.nextInt(this.localInterfaceAddrs.length);
        SocketAddress addr = this.localInterfaceAddrs[idx];
        LOG.debug("Using local interface {}", (Object)addr);
        return addr;
    }

    int getDatanodeWriteTimeout(int numNodes) {
        int t = this.dfsClientConf.getDatanodeSocketWriteTimeout();
        return t > 0 ? t + 5000 * numNodes : 0;
    }

    int getDatanodeReadTimeout(int numNodes) {
        int t = this.dfsClientConf.getSocketTimeout();
        return t > 0 ? 5000 * numNodes + t : 0;
    }

    @VisibleForTesting
    public String getClientName() {
        return this.clientName;
    }

    void checkOpen() throws IOException {
        if (!this.clientRunning) {
            throw new IOException("Filesystem closed");
        }
    }

    public LeaseRenewer getLeaseRenewer() {
        return LeaseRenewer.getInstance(this.namenodeUri != null ? this.namenodeUri.getAuthority() : "null", this.ugi, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginFileLease(String key, DFSOutputStream out) {
        Map<String, DFSOutputStream> map = this.filesBeingWritten;
        synchronized (map) {
            this.putFileBeingWritten(key, out);
            LeaseRenewer renewer = this.getLeaseRenewer();
            boolean result = renewer.put(this);
            if (!result) {
                LeaseRenewer.remove(renewer);
                renewer = this.getLeaseRenewer();
                renewer.put(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endFileLease(String renewLeaseKey) {
        Map<String, DFSOutputStream> map = this.filesBeingWritten;
        synchronized (map) {
            this.removeFileBeingWritten(renewLeaseKey);
            if (this.filesBeingWritten.isEmpty()) {
                this.getLeaseRenewer().closeClient(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFileBeingWritten(String key, DFSOutputStream out) {
        Map<String, DFSOutputStream> map = this.filesBeingWritten;
        synchronized (map) {
            this.filesBeingWritten.put(key, out);
            if (this.lastLeaseRenewal == 0L) {
                this.updateLastLeaseRenewal();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileBeingWritten(String key) {
        Map<String, DFSOutputStream> map = this.filesBeingWritten;
        synchronized (map) {
            this.filesBeingWritten.remove(key);
            if (this.filesBeingWritten.isEmpty()) {
                this.lastLeaseRenewal = 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFilesBeingWrittenEmpty() {
        Map<String, DFSOutputStream> map = this.filesBeingWritten;
        synchronized (map) {
            return this.filesBeingWritten.isEmpty();
        }
    }

    public boolean isClientRunning() {
        return this.clientRunning;
    }

    long getLastLeaseRenewal() {
        return this.lastLeaseRenewal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateLastLeaseRenewal() {
        Map<String, DFSOutputStream> map = this.filesBeingWritten;
        synchronized (map) {
            if (this.filesBeingWritten.isEmpty()) {
                return;
            }
            this.lastLeaseRenewal = Time.monotonicNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public int getNumOfFilesBeingWritten() {
        Map<String, DFSOutputStream> map = this.filesBeingWritten;
        synchronized (map) {
            return this.filesBeingWritten.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getNamespaces() {
        HashSet<String> namespaces = new HashSet<String>();
        Map<String, DFSOutputStream> map = this.filesBeingWritten;
        synchronized (map) {
            for (DFSOutputStream outputStream : this.filesBeingWritten.values()) {
                String namespace = outputStream.getNamespace();
                if (namespace == null || namespace.isEmpty()) {
                    return null;
                }
                namespaces.add(namespace);
            }
            if (namespaces.isEmpty()) {
                return null;
            }
        }
        return new ArrayList<String>(namespaces);
    }

    public boolean renewLease() throws IOException {
        if (this.clientRunning && !this.isFilesBeingWrittenEmpty()) {
            try {
                this.namenode.renewLease(this.clientName, this.getNamespaces());
                this.updateLastLeaseRenewal();
                return true;
            }
            catch (IOException e) {
                long elapsed = Time.monotonicNow() - this.getLastLeaseRenewal();
                if (elapsed > this.dfsClientConf.getleaseHardLimitPeriod()) {
                    LOG.warn("Failed to renew lease for {} for {} seconds (>= hard-limit ={} seconds.) Closing all files being written ...", new Object[]{this.clientName, elapsed / 1000L, this.dfsClientConf.getleaseHardLimitPeriod() / 1000L, e});
                    this.closeAllFilesBeingWritten(true);
                }
                throw e;
            }
        }
        return false;
    }

    void closeConnectionToNamenode() {
        RPC.stopProxy(this.namenode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllFilesBeingWritten(boolean abort) {
        while (true) {
            DFSOutputStream out;
            String key;
            Map<String, DFSOutputStream> map = this.filesBeingWritten;
            synchronized (map) {
                if (this.filesBeingWritten.isEmpty()) {
                    return;
                }
                key = this.filesBeingWritten.keySet().iterator().next();
                out = this.filesBeingWritten.remove(key);
            }
            if (out == null) continue;
            try {
                if (abort) {
                    out.abort();
                    continue;
                }
                out.close();
                continue;
            }
            catch (IOException ie) {
                LOG.error("Failed to {} file: {} with renewLeaseKey: {}", new Object[]{abort ? "abort" : "close", out.getSrc(), key, ie});
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.clientRunning) {
            this.closeAllFilesBeingWritten(false);
            this.clientRunning = false;
            if (!disabledStopDeadNodeDetectorThreadForTest) {
                this.clientContext.unreference();
            }
            this.closeConnectionToNamenode();
        }
    }

    public void closeOutputStreams(boolean abort) {
        if (this.clientRunning) {
            this.closeAllFilesBeingWritten(abort);
        }
    }

    public long getBlockSize(String f) throws IOException {
        this.checkOpen();
        TraceScope ignored = this.newPathTraceScope("getBlockSize", f);
        try {
            long l = this.namenode.getPreferredBlockSize(f);
            if (ignored != null) {
                ignored.close();
            }
            return l;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException ie) {
                LOG.warn("Problem getting block size", (Throwable)ie);
                throw ie;
            }
        }
    }

    public FsServerDefaults getServerDefaults() throws IOException {
        this.checkOpen();
        long now = Time.monotonicNow();
        if (this.serverDefaults == null || now - this.serverDefaultsLastUpdate > this.serverDefaultsValidityPeriod) {
            this.serverDefaults = this.namenode.getServerDefaults();
            this.serverDefaultsLastUpdate = now;
        }
        assert (this.serverDefaults != null);
        return this.serverDefaults;
    }

    @Override
    @InterfaceAudience.LimitedPrivate(value={"HDFS"})
    public String getCanonicalServiceName() {
        return this.dtService != null ? this.dtService.toString() : null;
    }

    @Override
    public Token<?> getDelegationToken(String renewer) throws IOException {
        return this.getDelegationToken(renewer == null ? null : new Text(renewer));
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        assert (this.dtService != null);
        try (TraceScope ignored = this.tracer.newScope("getDelegationToken");){
            Token<DelegationTokenIdentifier> token = this.namenode.getDelegationToken(renewer);
            if (token != null) {
                token.setService(this.dtService);
                LOG.info("Created {}", (Object)DelegationTokenIdentifier.stringifyToken(token));
            } else {
                LOG.info("Cannot get delegation token from {}", (Object)renewer);
            }
            Token<DelegationTokenIdentifier> token2 = token;
            return token2;
        }
    }

    @Deprecated
    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        LOG.info("Renewing {}", (Object)DelegationTokenIdentifier.stringifyToken(token));
        try {
            return token.renew(this.conf);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("caught interrupted", ie);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(SecretManager.InvalidToken.class, AccessControlException.class);
        }
    }

    @Deprecated
    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        LOG.info("Cancelling {}", (Object)DelegationTokenIdentifier.stringifyToken(token));
        try {
            token.cancel(this.conf);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("caught interrupted", ie);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(SecretManager.InvalidToken.class, AccessControlException.class);
        }
    }

    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        this.checkOpen();
        this.namenode.reportBadBlocks(blocks);
    }

    public long getRefreshReadBlkLocationsInterval() {
        return this.dfsClientConf.getLocatedBlocksRefresherInterval();
    }

    public LocatedBlocks getLocatedBlocks(String src, long start) throws IOException {
        return this.getLocatedBlocks(src, start, this.dfsClientConf.getPrefetchSize());
    }

    @VisibleForTesting
    public LocatedBlocks getLocatedBlocks(String src, long start, long length) throws IOException {
        try (TraceScope ignored = this.newPathTraceScope("getBlockLocations", src);){
            LocatedBlocks locatedBlocks = DFSClient.callGetBlockLocations(this.namenode, src, start, length);
            return locatedBlocks;
        }
    }

    static LocatedBlocks callGetBlockLocations(ClientProtocol namenode, String src, long start, long length) throws IOException {
        try {
            return namenode.getBlockLocations(src, start, length);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class);
        }
    }

    boolean recoverLease(String src) throws IOException {
        this.checkOpen();
        TraceScope ignored = this.newPathTraceScope("recoverLease", src);
        try {
            boolean bl = this.namenode.recoverLease(src, this.clientName);
            if (ignored != null) {
                ignored.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(FileNotFoundException.class, AccessControlException.class, UnresolvedPathException.class);
            }
        }
    }

    public BlockLocation[] getBlockLocations(String src, long start, long length) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("getBlockLocations", src);){
            LocatedBlocks blocks = this.getLocatedBlocks(src, start, length);
            BlockLocation[] locations = DFSUtilClient.locatedBlocks2Locations(blocks);
            BlockLocation[] hdfsLocations = new HdfsBlockLocation[locations.length];
            for (int i = 0; i < locations.length; ++i) {
                hdfsLocations[i] = new HdfsBlockLocation(locations[i], blocks.get(i));
            }
            BlockLocation[] blockLocationArray = hdfsLocations;
            return blockLocationArray;
        }
    }

    public HdfsDataInputStream createWrappedInputStream(DFSInputStream dfsis) throws IOException {
        FileEncryptionInfo feInfo = dfsis.getFileEncryptionInfo();
        if (feInfo != null) {
            CryptoInputStream cryptoIn;
            try (TraceScope ignored = this.getTracer().newScope("decryptEDEK");){
                cryptoIn = HdfsKMSUtil.createWrappedInputStream(dfsis, this.getKeyProvider(), feInfo, this.getConfiguration());
            }
            return new HdfsDataInputStream(cryptoIn);
        }
        return new HdfsDataInputStream(dfsis);
    }

    public HdfsDataOutputStream createWrappedOutputStream(DFSOutputStream dfsos, FileSystem.Statistics statistics) throws IOException {
        return this.createWrappedOutputStream(dfsos, statistics, 0L);
    }

    public HdfsDataOutputStream createWrappedOutputStream(DFSOutputStream dfsos, FileSystem.Statistics statistics, long startPos) throws IOException {
        FileEncryptionInfo feInfo = dfsos.getFileEncryptionInfo();
        if (feInfo != null) {
            KeyProvider.KeyVersion decrypted;
            HdfsKMSUtil.getCryptoProtocolVersion(feInfo);
            CryptoCodec codec = HdfsKMSUtil.getCryptoCodec(this.conf, feInfo);
            try (TraceScope ignored = this.tracer.newScope("decryptEDEK");){
                LOG.debug("Start decrypting EDEK for file: {}, output stream: 0x{}", (Object)dfsos.getSrc(), (Object)Integer.toHexString(dfsos.hashCode()));
                decrypted = HdfsKMSUtil.decryptEncryptedDataEncryptionKey(feInfo, this.getKeyProvider());
                LOG.debug("Decrypted EDEK for file: {}, output stream: 0x{}", (Object)dfsos.getSrc(), (Object)Integer.toHexString(dfsos.hashCode()));
            }
            CryptoOutputStream cryptoOut = new CryptoOutputStream((OutputStream)dfsos, codec, decrypted.getMaterial(), feInfo.getIV(), startPos);
            return new HdfsDataOutputStream(cryptoOut, statistics, startPos);
        }
        return new HdfsDataOutputStream(dfsos, statistics, startPos);
    }

    public DFSInputStream open(String src) throws IOException {
        return this.open(src, this.dfsClientConf.getIoBufferSize(), true);
    }

    @Deprecated
    public DFSInputStream open(String src, int buffersize, boolean verifyChecksum, FileSystem.Statistics stats) throws IOException {
        return this.open(src, buffersize, verifyChecksum);
    }

    public DFSInputStream open(String src, int buffersize, boolean verifyChecksum) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("newDFSInputStream", src);){
            LocatedBlocks locatedBlocks = this.getLocatedBlocks(src, 0L);
            DFSInputStream dFSInputStream = this.openInternal(locatedBlocks, src, verifyChecksum);
            return dFSInputStream;
        }
    }

    public DFSInputStream open(HdfsPathHandle fd, int buffersize, boolean verifyChecksum) throws IOException {
        this.checkOpen();
        String src = fd.getPath();
        try (TraceScope ignored = this.newPathTraceScope("newDFSInputStream", src);){
            HdfsLocatedFileStatus s = this.getLocatedFileInfo(src, true);
            fd.verify(s);
            LocatedBlocks locatedBlocks = s.getLocatedBlocks();
            DFSInputStream dFSInputStream = this.openInternal(locatedBlocks, src, verifyChecksum);
            return dFSInputStream;
        }
    }

    private DFSInputStream openInternal(LocatedBlocks locatedBlocks, String src, boolean verifyChecksum) throws IOException {
        if (locatedBlocks != null) {
            ErasureCodingPolicy ecPolicy = locatedBlocks.getErasureCodingPolicy();
            if (ecPolicy != null) {
                return new DFSStripedInputStream(this, src, verifyChecksum, ecPolicy, locatedBlocks);
            }
            return new DFSInputStream(this, src, verifyChecksum, locatedBlocks);
        }
        throw new IOException("Cannot open filename " + src);
    }

    public ClientProtocol getNamenode() {
        return this.namenode;
    }

    public OutputStream create(String src, boolean overwrite) throws IOException {
        return this.create(src, overwrite, this.dfsClientConf.getDefaultReplication(), this.dfsClientConf.getDefaultBlockSize(), null);
    }

    public OutputStream create(String src, boolean overwrite, Progressable progress) throws IOException {
        return this.create(src, overwrite, this.dfsClientConf.getDefaultReplication(), this.dfsClientConf.getDefaultBlockSize(), progress);
    }

    public OutputStream create(String src, boolean overwrite, short replication, long blockSize) throws IOException {
        return this.create(src, overwrite, replication, blockSize, null);
    }

    public OutputStream create(String src, boolean overwrite, short replication, long blockSize, Progressable progress) throws IOException {
        return this.create(src, overwrite, replication, blockSize, progress, this.dfsClientConf.getIoBufferSize());
    }

    public OutputStream create(String src, boolean overwrite, short replication, long blockSize, Progressable progress, int buffersize) throws IOException {
        return this.create(src, FsPermission.getFileDefault(), overwrite ? EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE) : EnumSet.of(CreateFlag.CREATE), replication, blockSize, progress, buffersize, null);
    }

    public DFSOutputStream create(String src, FsPermission permission, EnumSet<CreateFlag> flag, short replication, long blockSize, Progressable progress, int buffersize, Options.ChecksumOpt checksumOpt) throws IOException {
        return this.create(src, permission, flag, true, replication, blockSize, progress, buffersize, checksumOpt, null);
    }

    public DFSOutputStream create(String src, FsPermission permission, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize, Progressable progress, int buffersize, Options.ChecksumOpt checksumOpt) throws IOException {
        return this.create(src, permission, flag, createParent, replication, blockSize, progress, buffersize, checksumOpt, null);
    }

    private FsPermission applyUMask(FsPermission permission) {
        if (permission == null) {
            permission = FsPermission.getFileDefault();
        }
        return FsCreateModes.applyUMask(permission, this.dfsClientConf.getUMask());
    }

    private FsPermission applyUMaskDir(FsPermission permission) {
        if (permission == null) {
            permission = FsPermission.getDirDefault();
        }
        return FsCreateModes.applyUMask(permission, this.dfsClientConf.getUMask());
    }

    public DFSOutputStream create(String src, FsPermission permission, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize, Progressable progress, int buffersize, Options.ChecksumOpt checksumOpt, InetSocketAddress[] favoredNodes) throws IOException {
        return this.create(src, permission, flag, createParent, replication, blockSize, progress, buffersize, checksumOpt, favoredNodes, null);
    }

    public DFSOutputStream create(String src, FsPermission permission, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize, Progressable progress, int buffersize, Options.ChecksumOpt checksumOpt, InetSocketAddress[] favoredNodes, String ecPolicyName) throws IOException {
        return this.create(src, permission, flag, createParent, replication, blockSize, progress, buffersize, checksumOpt, favoredNodes, ecPolicyName, null);
    }

    public DFSOutputStream create(String src, FsPermission permission, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize, Progressable progress, int buffersize, Options.ChecksumOpt checksumOpt, InetSocketAddress[] favoredNodes, String ecPolicyName, String storagePolicy) throws IOException {
        this.checkOpen();
        FsPermission masked = this.applyUMask(permission);
        LOG.debug("{}: masked={}", (Object)src, (Object)masked);
        DFSOutputStream result = DFSOutputStream.newStreamForCreate(this, src, masked, flag, createParent, replication, blockSize, progress, this.dfsClientConf.createChecksum(checksumOpt), this.getFavoredNodesStr(favoredNodes), ecPolicyName, storagePolicy);
        this.beginFileLease(result.getUniqKey(), result);
        return result;
    }

    private String[] getFavoredNodesStr(InetSocketAddress[] favoredNodes) {
        String[] favoredNodeStrs = null;
        if (favoredNodes != null) {
            favoredNodeStrs = new String[favoredNodes.length];
            for (int i = 0; i < favoredNodes.length; ++i) {
                favoredNodeStrs[i] = favoredNodes[i].getHostName() + ":" + favoredNodes[i].getPort();
            }
        }
        return favoredNodeStrs;
    }

    private DFSOutputStream primitiveAppend(String src, EnumSet<CreateFlag> flag, Progressable progress) throws IOException {
        if (flag.contains((Object)CreateFlag.APPEND)) {
            HdfsFileStatus stat = this.getFileInfo(src);
            if (stat == null) {
                if (!flag.contains((Object)CreateFlag.CREATE)) {
                    throw new FileNotFoundException("failed to append to non-existent file " + src + " on client " + this.clientName);
                }
                return null;
            }
            return this.callAppend(src, flag, progress, null);
        }
        return null;
    }

    public DFSOutputStream primitiveCreate(String src, FsPermission absPermission, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize, Progressable progress, int buffersize, Options.ChecksumOpt checksumOpt) throws IOException {
        this.checkOpen();
        CreateFlag.validate(flag);
        DFSOutputStream result = this.primitiveAppend(src, flag, progress);
        if (result == null) {
            DataChecksum checksum = this.dfsClientConf.createChecksum(checksumOpt);
            result = DFSOutputStream.newStreamForCreate(this, src, absPermission, flag, createParent, replication, blockSize, progress, checksum, null, null, null);
        }
        this.beginFileLease(result.getUniqKey(), result);
        return result;
    }

    public void createSymlink(String target, String link, boolean createParent) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("createSymlink", target);){
            FsPermission dirPerm = this.applyUMask(null);
            this.namenode.createSymlink(target, link, dirPerm, createParent);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, FileAlreadyExistsException.class, FileNotFoundException.class, ParentNotDirectoryException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, QuotaByStorageTypeExceededException.class, UnresolvedPathException.class, SnapshotAccessControlException.class);
        }
    }

    public String getLinkTarget(String path) throws IOException {
        this.checkOpen();
        TraceScope ignored = this.newPathTraceScope("getLinkTarget", path);
        try {
            String string = this.namenode.getLinkTarget(path);
            if (ignored != null) {
                ignored.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class);
            }
        }
    }

    private LastBlockWithStatus callAppend(String src, EnumSetWritable<CreateFlag> flag) throws IOException {
        long startTime = Time.monotonicNow();
        while (true) {
            try {
                return this.namenode.append(src, this.clientName, flag);
            }
            catch (RemoteException re) {
                if (Time.monotonicNow() - startTime > 5000L || !RetriableException.class.getName().equals(re.getClassName())) {
                    throw re;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    throw DFSUtilClient.toInterruptedIOException("callAppend", e);
                }
            }
        }
    }

    private DFSOutputStream callAppend(String src, EnumSet<CreateFlag> flag, Progressable progress, String[] favoredNodes) throws IOException {
        CreateFlag.validateForAppend(flag);
        try {
            LastBlockWithStatus blkWithStatus = this.callAppend(src, new EnumSetWritable<CreateFlag>(flag, CreateFlag.class));
            HdfsFileStatus status = blkWithStatus.getFileStatus();
            if (status == null) {
                LOG.debug("NameNode is on an older version, request file info with additional RPC call for file: {}", (Object)src);
                status = this.getFileInfo(src);
            }
            return DFSOutputStream.newStreamForAppend(this, src, flag, progress, blkWithStatus.getLastBlock(), status, this.dfsClientConf.createChecksum(null), favoredNodes);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class, SafeModeException.class, DSQuotaExceededException.class, QuotaByStorageTypeExceededException.class, UnsupportedOperationException.class, UnresolvedPathException.class, SnapshotAccessControlException.class);
        }
    }

    public HdfsDataOutputStream append(String src, int buffersize, EnumSet<CreateFlag> flag, Progressable progress, FileSystem.Statistics statistics) throws IOException {
        DFSOutputStream out = this.append(src, buffersize, flag, null, progress);
        return this.createWrappedOutputStream(out, statistics, out.getInitialLen());
    }

    public HdfsDataOutputStream append(String src, int buffersize, EnumSet<CreateFlag> flag, Progressable progress, FileSystem.Statistics statistics, InetSocketAddress[] favoredNodes) throws IOException {
        DFSOutputStream out = this.append(src, buffersize, flag, this.getFavoredNodesStr(favoredNodes), progress);
        return this.createWrappedOutputStream(out, statistics, out.getInitialLen());
    }

    private DFSOutputStream append(String src, int buffersize, EnumSet<CreateFlag> flag, String[] favoredNodes, Progressable progress) throws IOException {
        this.checkOpen();
        DFSOutputStream result = this.callAppend(src, flag, progress, favoredNodes);
        this.beginFileLease(result.getUniqKey(), result);
        return result;
    }

    public boolean setReplication(String src, short replication) throws IOException {
        this.checkOpen();
        TraceScope ignored = this.newPathTraceScope("setReplication", src);
        try {
            boolean bl = this.namenode.setReplication(src, replication);
            if (ignored != null) {
                ignored.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class, SafeModeException.class, DSQuotaExceededException.class, QuotaByStorageTypeExceededException.class, UnresolvedPathException.class, SnapshotAccessControlException.class);
            }
        }
    }

    public void setStoragePolicy(String src, String policyName) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("setStoragePolicy", src);){
            this.namenode.setStoragePolicy(src, policyName);
        }
        catch (RemoteException e) {
            throw e.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class, SafeModeException.class, NSQuotaExceededException.class, UnresolvedPathException.class, SnapshotAccessControlException.class);
        }
    }

    public void unsetStoragePolicy(String src) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("unsetStoragePolicy", src);){
            this.namenode.unsetStoragePolicy(src);
        }
        catch (RemoteException e) {
            throw e.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class, SafeModeException.class, NSQuotaExceededException.class, UnresolvedPathException.class, SnapshotAccessControlException.class);
        }
    }

    public BlockStoragePolicy getStoragePolicy(String path) throws IOException {
        this.checkOpen();
        TraceScope ignored = this.newPathTraceScope("getStoragePolicy", path);
        try {
            BlockStoragePolicy blockStoragePolicy = this.namenode.getStoragePolicy(path);
            if (ignored != null) {
                ignored.close();
            }
            return blockStoragePolicy;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException e) {
                throw e.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class, SafeModeException.class, UnresolvedPathException.class);
            }
        }
    }

    public BlockStoragePolicy[] getStoragePolicies() throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("getStoragePolicies");){
            BlockStoragePolicy[] blockStoragePolicyArray = this.namenode.getStoragePolicies();
            return blockStoragePolicyArray;
        }
    }

    @Deprecated
    public boolean rename(String src, String dst) throws IOException {
        this.checkOpen();
        TraceScope ignored = this.newSrcDstTraceScope("rename", src, dst);
        try {
            boolean bl = this.namenode.rename(src, dst);
            if (ignored != null) {
                ignored.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(AccessControlException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, QuotaByStorageTypeExceededException.class, UnresolvedPathException.class, SnapshotAccessControlException.class, ParentNotDirectoryException.class);
            }
        }
    }

    public void concat(String trg, String[] srcs) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("concat");){
            this.namenode.concat(trg, srcs);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, UnresolvedPathException.class, SnapshotAccessControlException.class);
        }
    }

    public void rename(String src, String dst, Options.Rename ... options) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newSrcDstTraceScope("rename2", src, dst);){
            this.namenode.rename2(src, dst, options);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, DSQuotaExceededException.class, QuotaByStorageTypeExceededException.class, FileAlreadyExistsException.class, FileNotFoundException.class, ParentNotDirectoryException.class, SafeModeException.class, NSQuotaExceededException.class, UnresolvedPathException.class, SnapshotAccessControlException.class);
        }
    }

    public boolean truncate(String src, long newLength) throws IOException {
        this.checkOpen();
        if (newLength < 0L) {
            throw new HadoopIllegalArgumentException("Cannot truncate to a negative file size: " + newLength + ".");
        }
        TraceScope ignored = this.newPathTraceScope("truncate", src);
        try {
            boolean bl = this.namenode.truncate(src, newLength, this.clientName);
            if (ignored != null) {
                ignored.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(AccessControlException.class, UnresolvedPathException.class);
            }
        }
    }

    @Deprecated
    public boolean delete(String src) throws IOException {
        this.checkOpen();
        return this.delete(src, true);
    }

    public boolean delete(String src, boolean recursive) throws IOException {
        this.checkOpen();
        TraceScope ignored = this.newPathTraceScope("delete", src);
        try {
            boolean bl = this.namenode.delete(src, recursive);
            if (ignored != null) {
                ignored.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class, SafeModeException.class, UnresolvedPathException.class, SnapshotAccessControlException.class, PathIsNotEmptyDirectoryException.class);
            }
        }
    }

    public boolean exists(String src) throws IOException {
        this.checkOpen();
        return this.getFileInfo(src) != null;
    }

    public DirectoryListing listPaths(String src, byte[] startAfter) throws IOException {
        return this.listPaths(src, startAfter, false);
    }

    public DirectoryListing listPaths(String src, byte[] startAfter, boolean needLocation) throws IOException {
        this.checkOpen();
        TraceScope ignored = this.newPathTraceScope("listPaths", src);
        try {
            DirectoryListing directoryListing = this.namenode.getListing(src, startAfter, needLocation);
            if (ignored != null) {
                ignored.close();
            }
            return directoryListing;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class);
            }
        }
    }

    public BatchedDirectoryListing batchedListPaths(String[] srcs, byte[] startAfter, boolean needLocation) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.getBatchedListing(srcs, startAfter, needLocation);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class);
        }
    }

    public HdfsFileStatus getFileInfo(String src) throws IOException {
        this.checkOpen();
        TraceScope ignored = this.newPathTraceScope("getFileInfo", src);
        try {
            HdfsFileStatus hdfsFileStatus = this.namenode.getFileInfo(src);
            if (ignored != null) {
                ignored.close();
            }
            return hdfsFileStatus;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class);
            }
        }
    }

    public HdfsLocatedFileStatus getLocatedFileInfo(String src, boolean needBlockToken) throws IOException {
        this.checkOpen();
        TraceScope ignored = this.newPathTraceScope("getLocatedFileInfo", src);
        try {
            HdfsLocatedFileStatus hdfsLocatedFileStatus = this.namenode.getLocatedFileInfo(src, needBlockToken);
            if (ignored != null) {
                ignored.close();
            }
            return hdfsLocatedFileStatus;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class);
            }
        }
    }

    public boolean isFileClosed(String src) throws IOException {
        this.checkOpen();
        TraceScope ignored = this.newPathTraceScope("isFileClosed", src);
        try {
            boolean bl = this.namenode.isFileClosed(src);
            if (ignored != null) {
                ignored.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class);
            }
        }
    }

    public HdfsFileStatus getFileLinkInfo(String src) throws IOException {
        this.checkOpen();
        TraceScope ignored = this.newPathTraceScope("getFileLinkInfo", src);
        try {
            HdfsFileStatus hdfsFileStatus = this.namenode.getFileLinkInfo(src);
            if (ignored != null) {
                ignored.close();
            }
            return hdfsFileStatus;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(AccessControlException.class, UnresolvedPathException.class);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public void clearDataEncryptionKey() {
        LOG.debug("Clearing encryption key");
        DFSClient dFSClient = this;
        synchronized (dFSClient) {
            this.encryptionKey = null;
        }
    }

    boolean shouldEncryptData() throws IOException {
        FsServerDefaults d = this.getServerDefaults();
        return d != null && d.getEncryptDataTransfer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataEncryptionKey newDataEncryptionKey() throws IOException {
        if (this.shouldEncryptData()) {
            DFSClient dFSClient = this;
            synchronized (dFSClient) {
                if (this.encryptionKey == null || this.encryptionKey.expiryDate < Time.now()) {
                    LOG.debug("Getting new encryption token from NN");
                    this.encryptionKey = this.namenode.getDataEncryptionKey();
                }
                return this.encryptionKey;
            }
        }
        return null;
    }

    @VisibleForTesting
    public DataEncryptionKey getEncryptionKey() {
        return this.encryptionKey;
    }

    private FileChecksum getFileChecksumInternal(String src, long length, Options.ChecksumCombineMode combineMode) throws IOException {
        this.checkOpen();
        Preconditions.checkArgument(length >= 0L);
        LocatedBlocks blockLocations = null;
        FileChecksumHelper.FileChecksumComputer maker = null;
        ErasureCodingPolicy ecPolicy = null;
        if (length > 0L) {
            blockLocations = this.getBlockLocations(src, length);
            ecPolicy = blockLocations.getErasureCodingPolicy();
        }
        maker = ecPolicy != null ? new FileChecksumHelper.StripedFileNonStripedChecksumComputer(src, length, blockLocations, this.namenode, this, ecPolicy, combineMode) : new FileChecksumHelper.ReplicatedFileChecksumComputer(src, length, blockLocations, this.namenode, this, combineMode);
        maker.compute();
        return maker.getFileChecksum();
    }

    public FileChecksum getFileChecksumWithCombineMode(String src, long length) throws IOException {
        Options.ChecksumCombineMode combineMode = this.getConf().getChecksumCombineMode();
        return this.getFileChecksumInternal(src, length, combineMode);
    }

    public MD5MD5CRC32FileChecksum getFileChecksum(String src, long length) throws IOException {
        return (MD5MD5CRC32FileChecksum)this.getFileChecksumInternal(src, length, Options.ChecksumCombineMode.MD5MD5CRC);
    }

    protected LocatedBlocks getBlockLocations(String src, long length) throws IOException {
        LocatedBlocks blockLocations = DFSClient.callGetBlockLocations(this.namenode, src, 0L, length);
        if (null == blockLocations) {
            throw new FileNotFoundException("File does not exist: " + src);
        }
        if (blockLocations.isUnderConstruction()) {
            throw new IOException("Fail to get checksum, since file " + src + " is under construction.");
        }
        return blockLocations;
    }

    protected IOStreamPair connectToDN(DatanodeInfo dn, int timeout, Token<BlockTokenIdentifier> blockToken) throws IOException {
        return DFSUtilClient.connectToDN(dn, timeout, this.conf, this.saslClient, this.socketFactory, this.getConf().isConnectToDnViaHostname(), this, blockToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataChecksum.Type inferChecksumTypeByReading(LocatedBlock lb, DatanodeInfo dn) throws IOException {
        DataChecksum.Type type;
        IOStreamPair pair = this.connectToDN(dn, this.dfsClientConf.getSocketTimeout(), lb.getBlockToken());
        try {
            new Sender((DataOutputStream)pair.out).readBlock(lb.getBlock(), lb.getBlockToken(), this.clientName, 0L, 1L, true, CachingStrategy.newDefaultStrategy());
            DataTransferProtos.BlockOpResponseProto reply = DataTransferProtos.BlockOpResponseProto.parseFrom(PBHelperClient.vintPrefixed(pair.in));
            String logInfo = "trying to read " + lb.getBlock() + " from datanode " + dn;
            DataTransferProtoUtil.checkBlockOpStatus(reply, logInfo);
            type = PBHelperClient.convert(reply.getReadOpChecksumInfo().getChecksum().getType());
        }
        catch (Throwable throwable) {
            IOUtilsClient.cleanupWithLogger(LOG, pair.in, pair.out);
            throw throwable;
        }
        IOUtilsClient.cleanupWithLogger(LOG, pair.in, pair.out);
        return type;
    }

    public void setPermission(String src, FsPermission permission) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("setPermission", src);){
            this.namenode.setPermission(src, permission);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class, SafeModeException.class, UnresolvedPathException.class, SnapshotAccessControlException.class);
        }
    }

    public void setOwner(String src, String username, String groupname) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("setOwner", src);){
            this.namenode.setOwner(src, username, groupname);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class, SafeModeException.class, UnresolvedPathException.class, SnapshotAccessControlException.class);
        }
    }

    private long getStateByIndex(int stateIndex) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("getStats");){
            long[] states = this.namenode.getStats();
            long l = states.length > stateIndex ? states[stateIndex] : -1L;
            return l;
        }
    }

    public FsStatus getDiskStatus() throws IOException {
        TraceScope ignored = this.tracer.newScope("getStats");
        try {
            long[] states = this.namenode.getStats();
            FsStatus fsStatus = new FsStatus(DFSClient.getStateAtIndex(states, 0), DFSClient.getStateAtIndex(states, 1), DFSClient.getStateAtIndex(states, 2));
            if (ignored != null) {
                ignored.close();
            }
            return fsStatus;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException();
            }
        }
    }

    public static long getStateAtIndex(long[] states, int index) {
        return states.length > index ? states[index] : -1L;
    }

    public long getMissingBlocksCount() throws IOException {
        return this.getStateByIndex(5);
    }

    public long getMissingReplOneBlocksCount() throws IOException {
        return this.getStateByIndex(6);
    }

    public long getPendingDeletionBlocksCount() throws IOException {
        return this.getStateByIndex(8);
    }

    public long getLowRedundancyBlocksCount() throws IOException {
        return this.getStateByIndex(3);
    }

    public long getCorruptBlocksCount() throws IOException {
        return this.getStateByIndex(4);
    }

    public long getBytesInFutureBlocks() throws IOException {
        return this.getStateByIndex(7);
    }

    public CorruptFileBlocks listCorruptFileBlocks(String path, String cookie) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("listCorruptFileBlocks", path);){
            CorruptFileBlocks corruptFileBlocks = this.namenode.listCorruptFileBlocks(path, cookie);
            return corruptFileBlocks;
        }
    }

    public DatanodeInfo[] datanodeReport(HdfsConstants.DatanodeReportType type) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("datanodeReport");){
            DatanodeInfo[] datanodeInfoArray = this.namenode.getDatanodeReport(type);
            return datanodeInfoArray;
        }
    }

    public DatanodeStorageReport[] getDatanodeStorageReport(HdfsConstants.DatanodeReportType type) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("datanodeStorageReport");){
            DatanodeStorageReport[] datanodeStorageReportArray = this.namenode.getDatanodeStorageReport(type);
            return datanodeStorageReportArray;
        }
    }

    public boolean setSafeMode(HdfsConstants.SafeModeAction action) throws IOException {
        this.checkOpen();
        return this.setSafeMode(action, false);
    }

    public boolean setSafeMode(HdfsConstants.SafeModeAction action, boolean isChecked) throws IOException {
        try (TraceScope ignored = this.tracer.newScope("setSafeMode");){
            boolean bl = this.namenode.setSafeMode(action, isChecked);
            return bl;
        }
    }

    public String createSnapshot(String snapshotRoot, String snapshotName) throws IOException {
        this.checkOpen();
        TraceScope ignored = this.tracer.newScope("createSnapshot");
        try {
            String string = this.namenode.createSnapshot(snapshotRoot, snapshotName);
            if (ignored != null) {
                ignored.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException();
            }
        }
    }

    public void deleteSnapshot(String snapshotRoot, String snapshotName) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("deleteSnapshot");){
            this.namenode.deleteSnapshot(snapshotRoot, snapshotName);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException();
        }
    }

    public void renameSnapshot(String snapshotDir, String snapshotOldName, String snapshotNewName) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("renameSnapshot");){
            this.namenode.renameSnapshot(snapshotDir, snapshotOldName, snapshotNewName);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException();
        }
    }

    public SnapshottableDirectoryStatus[] getSnapshottableDirListing() throws IOException {
        this.checkOpen();
        TraceScope ignored = this.tracer.newScope("getSnapshottableDirListing");
        try {
            SnapshottableDirectoryStatus[] snapshottableDirectoryStatusArray = this.namenode.getSnapshottableDirListing();
            if (ignored != null) {
                ignored.close();
            }
            return snapshottableDirectoryStatusArray;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException();
            }
        }
    }

    public SnapshotStatus[] getSnapshotListing(String snapshotRoot) throws IOException {
        this.checkOpen();
        TraceScope ignored = this.tracer.newScope("getSnapshotListing");
        try {
            SnapshotStatus[] snapshotStatusArray = this.namenode.getSnapshotListing(snapshotRoot);
            if (ignored != null) {
                ignored.close();
            }
            return snapshotStatusArray;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException();
            }
        }
    }

    public void allowSnapshot(String snapshotRoot) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("allowSnapshot");){
            this.namenode.allowSnapshot(snapshotRoot);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException();
        }
    }

    public void disallowSnapshot(String snapshotRoot) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("disallowSnapshot");){
            this.namenode.disallowSnapshot(snapshotRoot);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException();
        }
    }

    public SnapshotDiffReport getSnapshotDiffReport(String snapshotDir, String fromSnapshot, String toSnapshot) throws IOException {
        this.checkOpen();
        TraceScope ignored = this.tracer.newScope("getSnapshotDiffReport");
        try {
            Preconditions.checkArgument(fromSnapshot != null, "null fromSnapshot");
            Preconditions.checkArgument(toSnapshot != null, "null toSnapshot");
            SnapshotDiffReport snapshotDiffReport = this.namenode.getSnapshotDiffReport(snapshotDir, fromSnapshot, toSnapshot);
            if (ignored != null) {
                ignored.close();
            }
            return snapshotDiffReport;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException();
            }
        }
    }

    public SnapshotDiffReportListing getSnapshotDiffReportListing(String snapshotDir, String fromSnapshot, String toSnapshot, byte[] startPath, int index) throws IOException {
        this.checkOpen();
        TraceScope ignored = this.tracer.newScope("getSnapshotDiffReport");
        try {
            SnapshotDiffReportListing snapshotDiffReportListing = this.namenode.getSnapshotDiffReportListing(snapshotDir, fromSnapshot, toSnapshot, startPath, index);
            if (ignored != null) {
                ignored.close();
            }
            return snapshotDiffReportListing;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException();
            }
        }
    }

    public long addCacheDirective(CacheDirectiveInfo info, EnumSet<CacheFlag> flags) throws IOException {
        this.checkOpen();
        TraceScope ignored = this.tracer.newScope("addCacheDirective");
        try {
            long l = this.namenode.addCacheDirective(info, flags);
            if (ignored != null) {
                ignored.close();
            }
            return l;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException();
            }
        }
    }

    public void modifyCacheDirective(CacheDirectiveInfo info, EnumSet<CacheFlag> flags) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("modifyCacheDirective");){
            this.namenode.modifyCacheDirective(info, flags);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException();
        }
    }

    public void removeCacheDirective(long id) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("removeCacheDirective");){
            this.namenode.removeCacheDirective(id);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException();
        }
    }

    public RemoteIterator<CacheDirectiveEntry> listCacheDirectives(CacheDirectiveInfo filter) throws IOException {
        this.checkOpen();
        return new CacheDirectiveIterator(this.namenode, filter, this.tracer);
    }

    public void addCachePool(CachePoolInfo info) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("addCachePool");){
            this.namenode.addCachePool(info);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException();
        }
    }

    public void modifyCachePool(CachePoolInfo info) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("modifyCachePool");){
            this.namenode.modifyCachePool(info);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException();
        }
    }

    public void removeCachePool(String poolName) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("removeCachePool");){
            this.namenode.removeCachePool(poolName);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException();
        }
    }

    public RemoteIterator<CachePoolEntry> listCachePools() throws IOException {
        this.checkOpen();
        return new CachePoolIterator(this.namenode, this.tracer);
    }

    boolean saveNamespace(long timeWindow, long txGap) throws IOException {
        this.checkOpen();
        TraceScope ignored = this.tracer.newScope("saveNamespace");
        try {
            boolean bl = this.namenode.saveNamespace(timeWindow, txGap);
            if (ignored != null) {
                ignored.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(AccessControlException.class);
            }
        }
    }

    long rollEdits() throws IOException {
        this.checkOpen();
        TraceScope ignored = this.tracer.newScope("rollEdits");
        try {
            long l = this.namenode.rollEdits();
            if (ignored != null) {
                ignored.close();
            }
            return l;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(AccessControlException.class);
            }
        }
    }

    @VisibleForTesting
    ExtendedBlock getPreviousBlock(String key) {
        return this.filesBeingWritten.get(key).getBlock();
    }

    boolean restoreFailedStorage(String arg) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("restoreFailedStorage");){
            boolean bl = this.namenode.restoreFailedStorage(arg);
            return bl;
        }
    }

    public void refreshNodes() throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("refreshNodes");){
            this.namenode.refreshNodes();
        }
    }

    public void metaSave(String pathname) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("metaSave");){
            this.namenode.metaSave(pathname);
        }
    }

    public void setBalancerBandwidth(long bandwidth) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("setBalancerBandwidth");){
            this.namenode.setBalancerBandwidth(bandwidth);
        }
    }

    public void finalizeUpgrade() throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("finalizeUpgrade");){
            this.namenode.finalizeUpgrade();
        }
    }

    public boolean upgradeStatus() throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("isUpgradeFinalized");){
            boolean bl = this.namenode.upgradeStatus();
            return bl;
        }
    }

    RollingUpgradeInfo rollingUpgrade(HdfsConstants.RollingUpgradeAction action) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("rollingUpgrade");){
            RollingUpgradeInfo rollingUpgradeInfo = this.namenode.rollingUpgrade(action);
            return rollingUpgradeInfo;
        }
    }

    @Deprecated
    public boolean mkdirs(String src) throws IOException {
        return this.mkdirs(src, null, true);
    }

    public boolean mkdirs(String src, FsPermission permission, boolean createParent) throws IOException {
        FsPermission masked = this.applyUMaskDir(permission);
        return this.primitiveMkdir(src, masked, createParent);
    }

    public boolean primitiveMkdir(String src, FsPermission absPermission) throws IOException {
        return this.primitiveMkdir(src, absPermission, true);
    }

    public boolean primitiveMkdir(String src, FsPermission absPermission, boolean createParent) throws IOException {
        this.checkOpen();
        if (absPermission == null) {
            absPermission = this.applyUMaskDir(null);
        }
        LOG.debug("{}: masked={}", (Object)src, (Object)absPermission);
        TraceScope ignored = this.tracer.newScope("mkdir");
        try {
            boolean bl = this.namenode.mkdirs(src, absPermission, createParent);
            if (ignored != null) {
                ignored.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(AccessControlException.class, InvalidPathException.class, FileAlreadyExistsException.class, FileNotFoundException.class, ParentNotDirectoryException.class, SafeModeException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, QuotaByStorageTypeExceededException.class, UnresolvedPathException.class, SnapshotAccessControlException.class);
            }
        }
    }

    ContentSummary getContentSummary(String src) throws IOException {
        this.checkOpen();
        TraceScope ignored = this.newPathTraceScope("getContentSummary", src);
        try {
            ContentSummary contentSummary = this.namenode.getContentSummary(src);
            if (ignored != null) {
                ignored.close();
            }
            return contentSummary;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class);
            }
        }
    }

    QuotaUsage getQuotaUsage(String src) throws IOException {
        this.checkOpen();
        TraceScope ignored = this.newPathTraceScope("getQuotaUsage", src);
        try {
            QuotaUsage quotaUsage = this.namenode.getQuotaUsage(src);
            if (ignored != null) {
                ignored.close();
            }
            return quotaUsage;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                IOException ioe = re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class, RpcNoSuchMethodException.class);
                if (ioe instanceof RpcNoSuchMethodException) {
                    LOG.debug("The version of namenode doesn't support getQuotaUsage API. Fall back to use getContentSummary API.");
                    return this.getContentSummary(src);
                }
                throw ioe;
            }
        }
    }

    void setQuota(String src, long namespaceQuota, long storagespaceQuota) throws IOException {
        this.checkOpen();
        if (namespaceQuota <= 0L && namespaceQuota != Long.MAX_VALUE && namespaceQuota != -1L || storagespaceQuota < 0L && storagespaceQuota != Long.MAX_VALUE && storagespaceQuota != -1L) {
            throw new IllegalArgumentException("Invalid values for quota : " + namespaceQuota + " and " + storagespaceQuota);
        }
        try (TraceScope ignored = this.newPathTraceScope("setQuota", src);){
            this.namenode.setQuota(src, namespaceQuota, storagespaceQuota, null);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, QuotaByStorageTypeExceededException.class, UnresolvedPathException.class, SnapshotAccessControlException.class);
        }
    }

    void setQuotaByStorageType(String src, StorageType type, long quota) throws IOException {
        this.checkOpen();
        if (quota <= 0L && quota != Long.MAX_VALUE && quota != -1L) {
            throw new IllegalArgumentException("Invalid values for quota :" + quota);
        }
        if (type == null) {
            throw new IllegalArgumentException("Invalid storage type(null)");
        }
        if (!type.supportTypeQuota()) {
            throw new IllegalArgumentException("Don't support Quota for storage type : " + type.toString());
        }
        try (TraceScope ignored = this.newPathTraceScope("setQuotaByStorageType", src);){
            this.namenode.setQuota(src, Long.MAX_VALUE, quota, type);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class, QuotaByStorageTypeExceededException.class, UnresolvedPathException.class, SnapshotAccessControlException.class);
        }
    }

    public void setTimes(String src, long mtime, long atime) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("setTimes", src);){
            this.namenode.setTimes(src, mtime, atime);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class, SnapshotAccessControlException.class);
        }
    }

    void reportChecksumFailure(String file, LocatedBlock[] lblocks) {
        try {
            this.reportBadBlocks(lblocks);
        }
        catch (IOException ie) {
            LOG.info("Found corruption while reading {}. Error repairing corrupt blocks. Bad blocks remain.", (Object)file, (Object)ie);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[clientName=" + this.clientName + ", ugi=" + this.ugi + "]";
    }

    public CachingStrategy getDefaultReadCachingStrategy() {
        return this.defaultReadCachingStrategy;
    }

    public CachingStrategy getDefaultWriteCachingStrategy() {
        return this.defaultWriteCachingStrategy;
    }

    public ClientContext getClientContext() {
        return this.clientContext;
    }

    public void modifyAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("modifyAclEntries", src);){
            this.namenode.modifyAclEntries(src, aclSpec);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, AclException.class, FileNotFoundException.class, NSQuotaExceededException.class, SafeModeException.class, SnapshotAccessControlException.class, UnresolvedPathException.class);
        }
    }

    public void removeAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("removeAclEntries");){
            this.namenode.removeAclEntries(src, aclSpec);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, AclException.class, FileNotFoundException.class, NSQuotaExceededException.class, SafeModeException.class, SnapshotAccessControlException.class, UnresolvedPathException.class);
        }
    }

    public void removeDefaultAcl(String src) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("removeDefaultAcl");){
            this.namenode.removeDefaultAcl(src);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, AclException.class, FileNotFoundException.class, NSQuotaExceededException.class, SafeModeException.class, SnapshotAccessControlException.class, UnresolvedPathException.class);
        }
    }

    public void removeAcl(String src) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("removeAcl");){
            this.namenode.removeAcl(src);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, AclException.class, FileNotFoundException.class, NSQuotaExceededException.class, SafeModeException.class, SnapshotAccessControlException.class, UnresolvedPathException.class);
        }
    }

    public void setAcl(String src, List<AclEntry> aclSpec) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("setAcl");){
            this.namenode.setAcl(src, aclSpec);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, AclException.class, FileNotFoundException.class, NSQuotaExceededException.class, SafeModeException.class, SnapshotAccessControlException.class, UnresolvedPathException.class);
        }
    }

    public AclStatus getAclStatus(String src) throws IOException {
        this.checkOpen();
        TraceScope ignored = this.newPathTraceScope("getAclStatus", src);
        try {
            AclStatus aclStatus = this.namenode.getAclStatus(src);
            if (ignored != null) {
                ignored.close();
            }
            return aclStatus;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(AccessControlException.class, AclException.class, FileNotFoundException.class, UnresolvedPathException.class);
            }
        }
    }

    public void createEncryptionZone(String src, String keyName) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("createEncryptionZone", src);){
            this.namenode.createEncryptionZone(src, keyName);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, SafeModeException.class, UnresolvedPathException.class);
        }
    }

    public EncryptionZone getEZForPath(String src) throws IOException {
        this.checkOpen();
        TraceScope ignored = this.newPathTraceScope("getEZForPath", src);
        try {
            EncryptionZone encryptionZone = this.namenode.getEZForPath(src);
            if (ignored != null) {
                ignored.close();
            }
            return encryptionZone;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(AccessControlException.class, UnresolvedPathException.class);
            }
        }
    }

    public RemoteIterator<EncryptionZone> listEncryptionZones() throws IOException {
        this.checkOpen();
        return new EncryptionZoneIterator(this.namenode, this.tracer);
    }

    public void reencryptEncryptionZone(String zone, HdfsConstants.ReencryptAction action) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("reencryptEncryptionZone", zone);){
            this.namenode.reencryptEncryptionZone(zone, action);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, SafeModeException.class, UnresolvedPathException.class);
        }
    }

    public RemoteIterator<ZoneReencryptionStatus> listReencryptionStatus() throws IOException {
        this.checkOpen();
        return new ReencryptionStatusIterator(this.namenode, this.tracer);
    }

    public void setErasureCodingPolicy(String src, String ecPolicyName) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("setErasureCodingPolicy", src);){
            this.namenode.setErasureCodingPolicy(src, ecPolicyName);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, SafeModeException.class, UnresolvedPathException.class, FileNotFoundException.class);
        }
    }

    public void unsetErasureCodingPolicy(String src) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("unsetErasureCodingPolicy", src);){
            this.namenode.unsetErasureCodingPolicy(src);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, SafeModeException.class, UnresolvedPathException.class, FileNotFoundException.class, NoECPolicySetException.class);
        }
    }

    public ECTopologyVerifierResult getECTopologyResultForPolicies(String ... policyNames) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.getECTopologyResultForPolicies(policyNames);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, SafeModeException.class);
        }
    }

    public void setXAttr(String src, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("setXAttr", src);){
            this.namenode.setXAttr(src, XAttrHelper.buildXAttr(name, value), flag);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class, NSQuotaExceededException.class, SafeModeException.class, SnapshotAccessControlException.class, UnresolvedPathException.class);
        }
    }

    public byte[] getXAttr(String src, String name) throws IOException {
        this.checkOpen();
        TraceScope ignored = this.newPathTraceScope("getXAttr", src);
        try {
            List<XAttr> xAttrs = XAttrHelper.buildXAttrAsList(name);
            List<XAttr> result = this.namenode.getXAttrs(src, xAttrs);
            byte[] byArray = XAttrHelper.getFirstXAttrValue(result);
            if (ignored != null) {
                ignored.close();
            }
            return byArray;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class);
            }
        }
    }

    public Map<String, byte[]> getXAttrs(String src) throws IOException {
        this.checkOpen();
        TraceScope ignored = this.newPathTraceScope("getXAttrs", src);
        try {
            Map<String, byte[]> map = XAttrHelper.buildXAttrMap(this.namenode.getXAttrs(src, null));
            if (ignored != null) {
                ignored.close();
            }
            return map;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class);
            }
        }
    }

    public Map<String, byte[]> getXAttrs(String src, List<String> names) throws IOException {
        this.checkOpen();
        TraceScope ignored = this.newPathTraceScope("getXAttrs", src);
        try {
            Map<String, byte[]> map = XAttrHelper.buildXAttrMap(this.namenode.getXAttrs(src, XAttrHelper.buildXAttrs(names)));
            if (ignored != null) {
                ignored.close();
            }
            return map;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class);
            }
        }
    }

    public List<String> listXAttrs(String src) throws IOException {
        this.checkOpen();
        TraceScope ignored = this.newPathTraceScope("listXAttrs", src);
        try {
            Map<String, byte[]> xattrs = XAttrHelper.buildXAttrMap(this.namenode.listXAttrs(src));
            ArrayList<String> arrayList = Lists.newArrayList(xattrs.keySet());
            if (ignored != null) {
                ignored.close();
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class);
            }
        }
    }

    public void removeXAttr(String src, String name) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("removeXAttr", src);){
            this.namenode.removeXAttr(src, XAttrHelper.buildXAttr(name));
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class, NSQuotaExceededException.class, SafeModeException.class, SnapshotAccessControlException.class, UnresolvedPathException.class);
        }
    }

    public void checkAccess(String src, FsAction mode) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("checkAccess", src);){
            this.namenode.checkAccess(src, mode);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class);
        }
    }

    public ErasureCodingPolicyInfo[] getErasureCodingPolicies() throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("getErasureCodingPolicies");){
            ErasureCodingPolicyInfo[] erasureCodingPolicyInfoArray = this.namenode.getErasureCodingPolicies();
            return erasureCodingPolicyInfoArray;
        }
    }

    public Map<String, String> getErasureCodingCodecs() throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("getErasureCodingCodecs");){
            Map<String, String> map = this.namenode.getErasureCodingCodecs();
            return map;
        }
    }

    public AddErasureCodingPolicyResponse[] addErasureCodingPolicies(ErasureCodingPolicy[] policies) throws IOException {
        this.checkOpen();
        TraceScope ignored = this.tracer.newScope("addErasureCodingPolicies");
        try {
            AddErasureCodingPolicyResponse[] addErasureCodingPolicyResponseArray = this.namenode.addErasureCodingPolicies(policies);
            if (ignored != null) {
                ignored.close();
            }
            return addErasureCodingPolicyResponseArray;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(AccessControlException.class, SafeModeException.class);
            }
        }
    }

    public void removeErasureCodingPolicy(String ecPolicyName) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("removeErasureCodingPolicy");){
            this.namenode.removeErasureCodingPolicy(ecPolicyName);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, SafeModeException.class);
        }
    }

    public void enableErasureCodingPolicy(String ecPolicyName) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("enableErasureCodingPolicy");){
            this.namenode.enableErasureCodingPolicy(ecPolicyName);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, SafeModeException.class);
        }
    }

    public void disableErasureCodingPolicy(String ecPolicyName) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("disableErasureCodingPolicy");){
            this.namenode.disableErasureCodingPolicy(ecPolicyName);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, SafeModeException.class);
        }
    }

    public DFSInotifyEventInputStream getInotifyEventStream() throws IOException {
        this.checkOpen();
        return new DFSInotifyEventInputStream(this.namenode, this.tracer);
    }

    public DFSInotifyEventInputStream getInotifyEventStream(long lastReadTxid) throws IOException {
        this.checkOpen();
        return new DFSInotifyEventInputStream(this.namenode, this.tracer, lastReadTxid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Peer newConnectedPeer(InetSocketAddress addr, Token<BlockTokenIdentifier> blockToken, DatanodeID datanodeId) throws IOException {
        Peer peer;
        block3: {
            Peer peer2 = null;
            boolean success = false;
            Socket sock = null;
            int socketTimeout = this.dfsClientConf.getSocketTimeout();
            try {
                sock = this.socketFactory.createSocket();
                NetUtils.connect(sock, addr, this.getRandomLocalInterfaceAddr(), socketTimeout);
                peer2 = DFSUtilClient.peerFromSocketAndKey(this.saslClient, sock, this, blockToken, datanodeId, socketTimeout);
                success = true;
                peer = peer2;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtilsClient.cleanupWithLogger(LOG, peer2);
                    IOUtils.closeSocket(sock);
                }
                throw throwable;
            }
            IOUtilsClient.cleanupWithLogger(LOG, peer2);
            IOUtils.closeSocket(sock);
        }
        return peer;
    }

    void updateFileSystemReadStats(int distance, int readBytes, long readTimeMS) {
        if (this.stats != null) {
            this.stats.incrementBytesRead(readBytes);
            this.stats.incrementBytesReadByDistance(distance, readBytes);
            if (distance > 0) {
                this.stats.increaseRemoteReadTime(readTimeMS);
            }
        }
    }

    void updateFileSystemECReadStats(int nRead) {
        if (this.stats != null) {
            this.stats.incrementBytesReadErasureCoded(nRead);
        }
    }

    private static synchronized void initThreadsNumForHedgedReads(int num) {
        if (num <= 0 || HEDGED_READ_THREAD_POOL != null) {
            return;
        }
        HEDGED_READ_THREAD_POOL = new ThreadPoolExecutor(1, num, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new Daemon.DaemonFactory(){
            private final AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = super.newThread(r);
                t.setName("hedgedRead-" + this.threadIndex.getAndIncrement());
                return t;
            }
        }, new ThreadPoolExecutor.CallerRunsPolicy(){

            @Override
            public void rejectedExecution(Runnable runnable, ThreadPoolExecutor e) {
                LOG.info("Execution rejected, Executing in current thread");
                HEDGED_READ_METRIC.incHedgedReadOpsInCurThread();
                super.rejectedExecution(runnable, e);
            }
        });
        HEDGED_READ_THREAD_POOL.allowCoreThreadTimeOut(true);
        LOG.debug("Using hedged reads; pool threads={}", (Object)num);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initThreadsNumForStripedReads(int numThreads) {
        assert (numThreads > 0);
        if (STRIPED_READ_THREAD_POOL != null) {
            return;
        }
        Class<DFSClient> clazz = DFSClient.class;
        synchronized (DFSClient.class) {
            if (STRIPED_READ_THREAD_POOL == null) {
                ThreadPoolExecutor threadPool = DFSUtilClient.getThreadPoolExecutor(1, numThreads, 60L, "StripedRead-", true);
                threadPool.allowCoreThreadTimeOut(true);
                STRIPED_READ_THREAD_POOL = threadPool;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    ThreadPoolExecutor getHedgedReadsThreadPool() {
        return HEDGED_READ_THREAD_POOL;
    }

    ThreadPoolExecutor getStripedReadsThreadPool() {
        return STRIPED_READ_THREAD_POOL;
    }

    boolean isHedgedReadsEnabled() {
        return HEDGED_READ_THREAD_POOL != null && HEDGED_READ_THREAD_POOL.getMaximumPoolSize() > 0;
    }

    DFSHedgedReadMetrics getHedgedReadMetrics() {
        return HEDGED_READ_METRIC;
    }

    @Override
    public URI getKeyProviderUri() throws IOException {
        return HdfsKMSUtil.getKeyProviderUri(this.ugi, this.namenodeUri, this.getServerDefaults().getKeyProviderUri(), this.conf);
    }

    @Override
    public KeyProvider getKeyProvider() throws IOException {
        return this.clientContext.getKeyProviderCache().get(this.conf, this.getKeyProviderUri());
    }

    @VisibleForTesting
    public void setKeyProvider(KeyProvider provider) {
        this.clientContext.getKeyProviderCache().setKeyProvider(this.conf, provider);
    }

    boolean isHDFSEncryptionEnabled() throws IOException {
        return this.getKeyProviderUri() != null;
    }

    boolean isEZRoot(Path p) throws IOException {
        EncryptionZone ez = this.getEZForPath(p.toUri().getPath());
        if (ez == null) {
            return false;
        }
        return ez.getPath().equals(p.toString());
    }

    boolean isSnapshotTrashRootEnabled() throws IOException {
        return this.getServerDefaults().getSnapshotTrashRootEnabled();
    }

    String getSnapshotRoot(Path path) throws IOException {
        SnapshottableDirectoryStatus[] dirStatusList = this.getSnapshottableDirListing();
        if (dirStatusList == null) {
            return null;
        }
        for (SnapshottableDirectoryStatus dirStatus : dirStatusList) {
            Object currDir = dirStatus.getFullPath().toString();
            if (!((String)currDir).endsWith("/")) {
                currDir = (String)currDir + "/";
            }
            if (!path.toUri().getPath().startsWith((String)currDir)) continue;
            return currDir;
        }
        return null;
    }

    public SaslDataTransferClient getSaslDataTransferClient() {
        return this.saslClient;
    }

    TraceScope newPathTraceScope(String description, String path) {
        TraceScope scope = this.tracer.newScope(description);
        if (path != null) {
            scope.addKVAnnotation("path", path);
        }
        return scope;
    }

    TraceScope newSrcDstTraceScope(String description, String src, String dst) {
        TraceScope scope = this.tracer.newScope(description);
        if (src != null) {
            scope.addKVAnnotation("src", src);
        }
        if (dst != null) {
            scope.addKVAnnotation("dst", dst);
        }
        return scope;
    }

    public ErasureCodingPolicy getErasureCodingPolicy(String src) throws IOException {
        this.checkOpen();
        TraceScope ignored = this.newPathTraceScope("getErasureCodingPolicy", src);
        try {
            ErasureCodingPolicy erasureCodingPolicy = this.namenode.getErasureCodingPolicy(src);
            if (ignored != null) {
                ignored.close();
            }
            return erasureCodingPolicy;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(FileNotFoundException.class, AccessControlException.class, UnresolvedPathException.class);
            }
        }
    }

    public void satisfyStoragePolicy(String src) throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.newPathTraceScope("satisfyStoragePolicy", src);){
            this.namenode.satisfyStoragePolicy(src);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class, SafeModeException.class, UnresolvedPathException.class);
        }
    }

    Tracer getTracer() {
        return this.tracer;
    }

    @Deprecated
    public RemoteIterator<OpenFileEntry> listOpenFiles() throws IOException {
        this.checkOpen();
        return this.listOpenFiles(EnumSet.of(OpenFilesIterator.OpenFilesType.ALL_OPEN_FILES), "/");
    }

    public RemoteIterator<OpenFileEntry> listOpenFiles(String path) throws IOException {
        this.checkOpen();
        return this.listOpenFiles(EnumSet.of(OpenFilesIterator.OpenFilesType.ALL_OPEN_FILES), path);
    }

    public RemoteIterator<OpenFileEntry> listOpenFiles(EnumSet<OpenFilesIterator.OpenFilesType> openFilesTypes) throws IOException {
        this.checkOpen();
        return this.listOpenFiles(openFilesTypes, "/");
    }

    public RemoteIterator<OpenFileEntry> listOpenFiles(EnumSet<OpenFilesIterator.OpenFilesType> openFilesTypes, String path) throws IOException {
        this.checkOpen();
        return new OpenFilesIterator(this.namenode, this.tracer, openFilesTypes, path);
    }

    public void msync() throws IOException {
        this.namenode.msync();
    }

    @VisibleForTesting
    public HAServiceProtocol.HAServiceState getHAServiceState() throws IOException {
        return this.namenode.getHAServiceState();
    }

    public ConcurrentHashMap<DatanodeInfo, DatanodeInfo> getDeadNodes(DFSInputStream dfsInputStream) {
        if (this.clientContext.isDeadNodeDetectionEnabled()) {
            ConcurrentHashMap<DatanodeInfo, DatanodeInfo> deadNodes = new ConcurrentHashMap<DatanodeInfo, DatanodeInfo>();
            if (dfsInputStream != null) {
                deadNodes.putAll(dfsInputStream.getLocalDeadNodes());
            }
            Set<DatanodeInfo> detectDeadNodes = this.clientContext.getDeadNodeDetector().clearAndGetDetectedDeadNodes();
            for (DatanodeInfo detectDeadNode : detectDeadNodes) {
                deadNodes.put(detectDeadNode, detectDeadNode);
            }
            return deadNodes;
        }
        return dfsInputStream.getLocalDeadNodes();
    }

    public boolean isDeadNode(DFSInputStream dfsInputStream, DatanodeInfo datanodeInfo) {
        if (this.isDeadNodeDetectionEnabled()) {
            boolean isDeadNode = this.clientContext.getDeadNodeDetector().isDeadNode(datanodeInfo);
            if (dfsInputStream != null) {
                isDeadNode = isDeadNode || dfsInputStream.getLocalDeadNodes().contains(datanodeInfo);
            }
            return isDeadNode;
        }
        return dfsInputStream.getLocalDeadNodes().contains(datanodeInfo);
    }

    public void addNodeToDeadNodeDetector(DFSInputStream dfsInputStream, DatanodeInfo datanodeInfo) {
        if (!this.isDeadNodeDetectionEnabled()) {
            LOG.debug("DeadNode detection is not enabled, skip to add node {}.", (Object)datanodeInfo);
            return;
        }
        this.clientContext.getDeadNodeDetector().addNodeToDetect(dfsInputStream, datanodeInfo);
    }

    public void removeNodeFromDeadNodeDetector(DFSInputStream dfsInputStream, DatanodeInfo datanodeInfo) {
        if (!this.isDeadNodeDetectionEnabled()) {
            LOG.debug("DeadNode detection is not enabled, skip to remove node {}.", (Object)datanodeInfo);
            return;
        }
        this.clientContext.getDeadNodeDetector().removeNodeFromDeadNodeDetector(dfsInputStream, datanodeInfo);
    }

    public void removeNodeFromDeadNodeDetector(DFSInputStream dfsInputStream, LocatedBlocks locatedBlocks) {
        if (!this.isDeadNodeDetectionEnabled() || locatedBlocks == null) {
            LOG.debug("DeadNode detection is not enabled or given block {} is null, skip to remove node.", (Object)locatedBlocks);
            return;
        }
        for (LocatedBlock locatedBlock : locatedBlocks.getLocatedBlocks()) {
            for (DatanodeInfoWithStorage datanodeInfo : locatedBlock.getLocations()) {
                this.removeNodeFromDeadNodeDetector(dfsInputStream, datanodeInfo);
            }
        }
    }

    private boolean isDeadNodeDetectionEnabled() {
        return this.clientContext.isDeadNodeDetectionEnabled();
    }

    public DeadNodeDetector getDeadNodeDetector() {
        return this.clientContext.getDeadNodeDetector();
    }

    public LocatedBlocksRefresher getLocatedBlockRefresher() {
        return this.clientContext.getLocatedBlocksRefresher();
    }

    public void addLocatedBlocksRefresh(DFSInputStream dfsInputStream) {
        if (this.isLocatedBlocksRefresherEnabled()) {
            this.clientContext.getLocatedBlocksRefresher().addInputStream(dfsInputStream);
        }
    }

    public void removeLocatedBlocksRefresh(DFSInputStream dfsInputStream) {
        if (this.isLocatedBlocksRefresherEnabled()) {
            this.clientContext.getLocatedBlocksRefresher().removeInputStream(dfsInputStream);
        }
    }

    private boolean isLocatedBlocksRefresherEnabled() {
        return this.clientContext.isLocatedBlocksRefresherEnabled();
    }

    public DatanodeInfo[] slowDatanodeReport() throws IOException {
        this.checkOpen();
        try (TraceScope ignored = this.tracer.newScope("slowDatanodeReport");){
            DatanodeInfo[] datanodeInfoArray = this.namenode.getSlowDatanodeReport();
            return datanodeInfoArray;
        }
    }

    public Path getEnclosingRoot(String src) throws IOException {
        this.checkOpen();
        TraceScope ignored = this.newPathTraceScope("getEnclosingRoot", src);
        try {
            Path path = this.namenode.getEnclosingRoot(src);
            if (ignored != null) {
                ignored.close();
            }
            return path;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(AccessControlException.class, UnresolvedPathException.class);
            }
        }
    }

    static {
        disabledStopDeadNodeDetectorThreadForTest = false;
    }

    @Deprecated
    public static class DFSDataInputStream
    extends HdfsDataInputStream {
        public DFSDataInputStream(DFSInputStream in) throws IOException {
            super(in);
        }
    }

    @InterfaceAudience.Private
    public static class Renewer
    extends TokenRenewer {
        @Override
        public boolean handleKind(Text kind) {
            return DelegationTokenIdentifier.HDFS_DELEGATION_KIND.equals(kind);
        }

        @Override
        public long renew(Token<?> token, Configuration conf) throws IOException {
            Token<DelegationTokenIdentifier> delToken = token;
            ClientProtocol nn = Renewer.getNNProxy(delToken, conf);
            try {
                return nn.renewDelegationToken(delToken);
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(SecretManager.InvalidToken.class, AccessControlException.class);
            }
        }

        @Override
        public void cancel(Token<?> token, Configuration conf) throws IOException {
            Token<DelegationTokenIdentifier> delToken = token;
            LOG.info("Cancelling {}", (Object)DelegationTokenIdentifier.stringifyToken(delToken));
            ClientProtocol nn = Renewer.getNNProxy(delToken, conf);
            try {
                nn.cancelDelegationToken(delToken);
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(SecretManager.InvalidToken.class, AccessControlException.class);
            }
        }

        private static ClientProtocol getNNProxy(Token<DelegationTokenIdentifier> token, Configuration conf) throws IOException {
            URI uri = HAUtilClient.getServiceUriFromToken("hdfs", token);
            if (HAUtilClient.isTokenForLogicalUri(token) && !HAUtilClient.isLogicalUri(conf, uri)) {
                throw new IOException("Unable to map logical nameservice URI '" + uri + "' to a NameNode. Local configuration does not have a failover proxy provider configured.");
            }
            NameNodeProxiesClient.ProxyAndInfo<ClientProtocol> info = NameNodeProxiesClient.createProxyWithClientProtocol(conf, uri, null);
            assert (info.getDelegationTokenService().equals(token.getService())) : "Returned service '" + info.getDelegationTokenService().toString() + "' doesn't match expected service '" + token.getService().toString() + "'";
            return info.getProxy();
        }

        @Override
        public boolean isManaged(Token<?> token) throws IOException {
            return true;
        }

        static {
            HdfsConfiguration.init();
        }
    }
}

