/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.net.URI;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;

public class ConfigUtil {
    public static String getConfigViewFsPrefix(String mountTableName) {
        return "fs.viewfs.mounttable." + mountTableName;
    }

    public static String getConfigViewFsPrefix() {
        return ConfigUtil.getConfigViewFsPrefix("fs.viewfs.mounttable.default");
    }

    public static void addLink(Configuration conf, String mountTableName, String src, URI target) {
        conf.set(ConfigUtil.getConfigViewFsPrefix(mountTableName) + ".link." + src, target.toString());
    }

    public static void addLink(Configuration conf, String src, URI target) {
        ConfigUtil.addLink(conf, ConfigUtil.getDefaultMountTableName(conf), src, target);
    }

    public static void addLinkMergeSlash(Configuration conf, String mountTableName, URI target) {
        conf.set(ConfigUtil.getConfigViewFsPrefix(mountTableName) + ".linkMergeSlash", target.toString());
    }

    public static void addLinkMergeSlash(Configuration conf, URI target) {
        ConfigUtil.addLinkMergeSlash(conf, ConfigUtil.getDefaultMountTableName(conf), target);
    }

    public static void addLinkFallback(Configuration conf, String mountTableName, URI target) {
        conf.set(ConfigUtil.getConfigViewFsPrefix(mountTableName) + ".linkFallback", target.toString());
    }

    public static void addLinkFallback(Configuration conf, URI target) {
        ConfigUtil.addLinkFallback(conf, ConfigUtil.getDefaultMountTableName(conf), target);
    }

    public static void addLinkMerge(Configuration conf, String mountTableName, URI[] targets) {
        conf.set(ConfigUtil.getConfigViewFsPrefix(mountTableName) + ".linkMerge", Arrays.toString(targets));
    }

    public static void addLinkMerge(Configuration conf, URI[] targets) {
        ConfigUtil.addLinkMerge(conf, ConfigUtil.getDefaultMountTableName(conf), targets);
    }

    public static void addLinkNfly(Configuration conf, String mountTableName, String src, String settings, String targets) {
        conf.set(ConfigUtil.getConfigViewFsPrefix(mountTableName) + ".linkNfly." + settings + "." + src, targets);
    }

    public static void addLinkNfly(Configuration conf, String mountTableName, String src, String settings, URI ... targets) {
        settings = settings == null ? "minReplication=2,repairOnRead=true" : settings;
        ConfigUtil.addLinkNfly(conf, mountTableName, src, settings, StringUtils.uriToString(targets));
    }

    public static void addLinkNfly(Configuration conf, String src, URI ... targets) {
        ConfigUtil.addLinkNfly(conf, ConfigUtil.getDefaultMountTableName(conf), src, null, targets);
    }

    public static void addLinkRegex(Configuration conf, String mountTableName, String srcRegex, String targetStr, String interceptorSettings) {
        String prefix = ConfigUtil.getConfigViewFsPrefix(mountTableName) + ".linkRegex.";
        if (interceptorSettings != null && !interceptorSettings.isEmpty()) {
            prefix = prefix + interceptorSettings + "#.";
        }
        String key = prefix + srcRegex;
        conf.set(key, targetStr);
    }

    public static void setHomeDirConf(Configuration conf, String homedir) {
        ConfigUtil.setHomeDirConf(conf, ConfigUtil.getDefaultMountTableName(conf), homedir);
    }

    public static void setHomeDirConf(Configuration conf, String mountTableName, String homedir) {
        if (!homedir.startsWith("/")) {
            throw new IllegalArgumentException("Home dir should start with /:" + homedir);
        }
        conf.set(ConfigUtil.getConfigViewFsPrefix(mountTableName) + ".homedir", homedir);
    }

    public static String getHomeDirValue(Configuration conf) {
        return ConfigUtil.getHomeDirValue(conf, ConfigUtil.getDefaultMountTableName(conf));
    }

    public static String getHomeDirValue(Configuration conf, String mountTableName) {
        return conf.get(ConfigUtil.getConfigViewFsPrefix(mountTableName) + ".homedir");
    }

    public static String getDefaultMountTableName(Configuration conf) {
        return conf.get("fs.viewfs.mounttable.default.name.key", "default");
    }

    public static boolean isNestedMountPointSupported(Configuration conf) {
        return conf.getBoolean("fs.viewfs.mounttable.nested.mount.point.supported", true);
    }

    public static void setIsNestedMountPointSupported(Configuration conf, boolean isNestedMountPointSupported) {
        conf.setBoolean("fs.viewfs.mounttable.nested.mount.point.supported", isNestedMountPointSupported);
    }
}

