/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.utils;

import java.util.UUID;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.constants.ReadType;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.utils.Listener;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderFormat;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingContext {
    private final String clientCorrelationID;
    private final String fileSystemID;
    private String clientRequestId = "";
    private String primaryRequestId;
    private String streamID;
    private int retryCount;
    private FSOperationType opType;
    private final TracingHeaderFormat format;
    private Listener listener = null;
    private String header = "";
    private String ingressHandler = "";
    private String position = "";
    private String metricResults = "";
    private String metricHeader = "";
    private ReadType readType = ReadType.UNKNOWN_READ;
    private String primaryRequestIdForRetry = "";
    private Integer operatedBlobCount = 0;
    private static final Logger LOG = LoggerFactory.getLogger(AbfsClient.class);
    public static final int MAX_CLIENT_CORRELATION_ID_LENGTH = 72;
    public static final String CLIENT_CORRELATION_ID_PATTERN = "[a-zA-Z0-9-]*";

    public TracingContext(String clientCorrelationID, String fileSystemID, FSOperationType opType, TracingHeaderFormat tracingHeaderFormat, Listener listener) {
        this.fileSystemID = fileSystemID;
        this.opType = opType;
        this.clientCorrelationID = clientCorrelationID;
        this.streamID = "";
        this.retryCount = 0;
        this.primaryRequestId = "";
        this.format = tracingHeaderFormat;
        this.listener = listener;
    }

    public TracingContext(String clientCorrelationID, String fileSystemID, FSOperationType opType, boolean needsPrimaryReqId, TracingHeaderFormat tracingHeaderFormat, Listener listener) {
        this(clientCorrelationID, fileSystemID, opType, tracingHeaderFormat, listener);
        String string = this.primaryRequestId = needsPrimaryReqId ? UUID.randomUUID().toString() : "";
        if (listener != null) {
            listener.updatePrimaryRequestID(this.primaryRequestId);
        }
    }

    public TracingContext(String clientCorrelationID, String fileSystemID, FSOperationType opType, boolean needsPrimaryReqId, TracingHeaderFormat tracingHeaderFormat, Listener listener, String metricResults) {
        this(clientCorrelationID, fileSystemID, opType, needsPrimaryReqId, tracingHeaderFormat, listener);
        this.metricResults = metricResults;
    }

    public TracingContext(TracingContext originalTracingContext) {
        this.fileSystemID = originalTracingContext.fileSystemID;
        this.streamID = originalTracingContext.streamID;
        this.clientCorrelationID = originalTracingContext.clientCorrelationID;
        this.opType = originalTracingContext.opType;
        this.retryCount = 0;
        this.primaryRequestId = originalTracingContext.primaryRequestId;
        this.format = originalTracingContext.format;
        this.position = originalTracingContext.getPosition();
        this.ingressHandler = originalTracingContext.getIngressHandler();
        this.operatedBlobCount = originalTracingContext.operatedBlobCount;
        if (originalTracingContext.listener != null) {
            this.listener = originalTracingContext.listener.getClone();
        }
        this.metricResults = originalTracingContext.metricResults;
        this.readType = originalTracingContext.readType;
    }

    public static String validateClientCorrelationID(String clientCorrelationID) {
        if (clientCorrelationID.length() > 72 || !clientCorrelationID.matches(CLIENT_CORRELATION_ID_PATTERN)) {
            LOG.debug("Invalid config provided; correlation id not included in header.");
            return "";
        }
        return clientCorrelationID;
    }

    public void setPrimaryRequestID() {
        this.primaryRequestId = UUID.randomUUID().toString();
        if (this.listener != null) {
            this.listener.updatePrimaryRequestID(this.primaryRequestId);
        }
    }

    public void setStreamID(String stream) {
        this.streamID = stream;
    }

    public void setOperation(FSOperationType operation) {
        this.opType = operation;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public void constructHeader(AbfsHttpOperation httpOperation, String previousFailure, String retryPolicyAbbreviation) {
        this.clientRequestId = UUID.randomUUID().toString();
        switch (this.format) {
            case ALL_ID_FORMAT: {
                this.header = TracingHeaderVersion.getCurrentVersion() + ":" + this.clientCorrelationID + ":" + this.clientRequestId + ":" + this.fileSystemID + ":" + this.getPrimaryRequestIdForHeader(this.retryCount > 0) + ":" + this.streamID + ":" + this.opType + ":" + this.getRetryHeader(previousFailure, retryPolicyAbbreviation) + ":" + this.ingressHandler + ":" + this.position + ":" + this.operatedBlobCount + ":" + this.getOperationSpecificHeader(this.opType) + ":" + httpOperation.getTracingContextSuffix();
                this.metricHeader = this.metricHeader + (!this.metricResults.trim().isEmpty() ? this.metricResults : "");
                break;
            }
            case TWO_ID_FORMAT: {
                this.header = TracingHeaderVersion.getCurrentVersion() + ":" + this.clientCorrelationID + ":" + this.clientRequestId;
                this.metricHeader = this.metricHeader + (!this.metricResults.trim().isEmpty() ? this.metricResults : "");
                break;
            }
            default: {
                this.header = TracingHeaderVersion.getCurrentVersion() + ":" + this.clientRequestId;
                this.metricHeader = this.metricHeader + (!this.metricResults.trim().isEmpty() ? this.metricResults : "");
            }
        }
        if (this.listener != null) {
            this.listener.callTracingHeaderValidator(this.header, this.format);
        }
        httpOperation.setRequestProperty("x-ms-client-request-id", this.header);
        if (!this.metricHeader.equals("")) {
            httpOperation.setRequestProperty("x-ms-feclient-metrics", this.metricHeader);
        }
        if (this.primaryRequestId.isEmpty() && previousFailure == null) {
            String[] clientRequestIdParts = this.clientRequestId.split(String.valueOf('-'));
            this.primaryRequestIdForRetry = clientRequestIdParts[clientRequestIdParts.length - 1];
        }
    }

    private String getPrimaryRequestIdForHeader(Boolean isRetry) {
        if (!this.primaryRequestId.isEmpty() || !isRetry.booleanValue()) {
            return this.primaryRequestId;
        }
        return this.primaryRequestIdForRetry;
    }

    private String getRetryHeader(String previousFailure, String retryPolicyAbbreviation) {
        String retryHeader = String.format("%d", this.retryCount);
        if (previousFailure == null) {
            return retryHeader;
        }
        if ("CT".equals(previousFailure) && retryPolicyAbbreviation != null) {
            return String.format("%s_%s_%s", retryHeader, previousFailure, retryPolicyAbbreviation);
        }
        return String.format("%s_%s", retryHeader, previousFailure);
    }

    private String getOperationSpecificHeader(FSOperationType opType) {
        switch (opType) {
            case READ: {
                return this.getReadSpecificHeader();
            }
        }
        return "";
    }

    private String getReadSpecificHeader() {
        String readHeader = String.format("%s", this.readType.toString());
        return readHeader;
    }

    public void setOperatedBlobCount(Integer count) {
        this.operatedBlobCount = count;
    }

    public FSOperationType getOpType() {
        return this.opType;
    }

    public String getHeader() {
        return this.header;
    }

    public String getIngressHandler() {
        return this.ingressHandler;
    }

    public String getPosition() {
        return this.position;
    }

    public void setIngressHandler(String ingressHandler) {
        this.ingressHandler = ingressHandler;
        if (this.listener != null) {
            this.listener.updateIngressHandler(ingressHandler);
        }
    }

    public void setPosition(String position) {
        this.position = position;
        if (this.listener != null) {
            this.listener.updatePosition(position);
        }
    }

    public void setReadType(ReadType readType) {
        this.readType = readType;
        if (this.listener != null) {
            this.listener.updateReadType(readType);
        }
    }
}

