/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.azurebfs.contracts.services.ReadBufferStatus;
import org.apache.hadoop.fs.azurebfs.services.ReadBuffer;
import org.apache.hadoop.fs.azurebfs.services.ReadBufferManager;

class ReadBufferWorker
implements Runnable {
    protected static final CountDownLatch UNLEASH_WORKERS = new CountDownLatch(1);
    private int id;
    private ReadBufferManager bufferManager;

    ReadBufferWorker(int id, ReadBufferManager bufferManager) {
        this.id = id;
        this.bufferManager = bufferManager;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public void run() {
        try {
            UNLEASH_WORKERS.await();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        while (true) {
            ReadBuffer buffer;
            try {
                buffer = this.bufferManager.getNextBlockToRead();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return;
            }
            if (buffer == null) continue;
            try {
                int bytesRead = buffer.getStream().readRemote(buffer.getOffset(), buffer.getBuffer(), 0, Math.min(buffer.getRequestedLength(), buffer.getBuffer().length), buffer.getTracingContext());
                this.bufferManager.doneReading(buffer, ReadBufferStatus.AVAILABLE, bytesRead);
                continue;
            }
            catch (IOException ex) {
                buffer.setErrException(ex);
                this.bufferManager.doneReading(buffer, ReadBufferStatus.READ_FAILED, 0);
                continue;
            }
            catch (Exception ex) {
                buffer.setErrException((IOException)new PathIOException(buffer.getStream().getPath(), (Throwable)ex));
                this.bufferManager.doneReading(buffer, ReadBufferStatus.READ_FAILED, 0);
                continue;
            }
            break;
        }
    }
}

