/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.contracts.services.ReadBufferStatus;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStream;
import org.apache.hadoop.fs.azurebfs.services.ReadBuffer;
import org.apache.hadoop.fs.azurebfs.services.ReadBufferManager;
import org.apache.hadoop.fs.azurebfs.services.ReadBufferWorker;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;

final class ReadBufferManagerV2
extends ReadBufferManager {
    private static int minThreadPoolSize;
    private static int maxThreadPoolSize;
    private static int executorServiceKeepAliveTimeInMilliSec;
    private ThreadPoolExecutor workerPool;
    private static int minBufferPoolSize;
    private static int maxBufferPoolSize;
    private int numberOfActiveBuffers = 0;
    private byte[][] bufferPool;
    private static ReadBufferManagerV2 bufferManager;
    private final ThreadFactory namedThreadFactory = new ThreadFactory(){
        private int count = 0;

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "ReadAheadV2-Thread-" + this.count++);
        }
    };

    private ReadBufferManagerV2() {
        LOGGER.trace("Creating readbuffer manager with HADOOP-18546 patch");
    }

    static void setReadBufferManagerConfigs(int readAheadBlockSize, AbfsConfiguration abfsConfiguration) {
        if (bufferManager == null) {
            minThreadPoolSize = abfsConfiguration.getMinReadAheadV2ThreadPoolSize();
            maxThreadPoolSize = abfsConfiguration.getMaxReadAheadV2ThreadPoolSize();
            executorServiceKeepAliveTimeInMilliSec = abfsConfiguration.getReadAheadExecutorServiceTTLInMillis();
            minBufferPoolSize = abfsConfiguration.getMinReadAheadV2BufferPoolSize();
            maxBufferPoolSize = abfsConfiguration.getMaxReadAheadV2BufferPoolSize();
            ReadBufferManagerV2.setThresholdAgeMilliseconds(abfsConfiguration.getReadAheadV2CachedBufferTTLMillis());
            ReadBufferManagerV2.setReadAheadBlockSize(readAheadBlockSize);
        }
    }

    static ReadBufferManagerV2 getBufferManager() {
        if (bufferManager == null) {
            LOCK.lock();
            try {
                if (bufferManager == null) {
                    bufferManager = new ReadBufferManagerV2();
                    bufferManager.init();
                }
            }
            finally {
                LOCK.unlock();
            }
        }
        return bufferManager;
    }

    @Override
    void init() {
        int i;
        this.bufferPool = new byte[maxBufferPoolSize][];
        for (i = 0; i < minBufferPoolSize; ++i) {
            this.bufferPool[i] = new byte[ReadBufferManagerV2.getReadAheadBlockSize()];
            this.getFreeList().add(i);
            ++this.numberOfActiveBuffers;
        }
        this.workerPool = new ThreadPoolExecutor(minThreadPoolSize, maxThreadPoolSize, (long)executorServiceKeepAliveTimeInMilliSec, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), this.namedThreadFactory);
        this.workerPool.allowCoreThreadTimeOut(true);
        for (i = 0; i < minThreadPoolSize; ++i) {
            ReadBufferWorker worker = new ReadBufferWorker(i, this);
            this.workerPool.submit(worker);
        }
        ReadBufferWorker.UNLEASH_WORKERS.countDown();
    }

    @Override
    public void queueReadAhead(AbfsInputStream stream, long requestedOffset, int requestedLength, TracingContext tracingContext) {
    }

    @Override
    public int getBlock(AbfsInputStream stream, long position, int length, byte[] buffer) throws IOException {
        return 0;
    }

    @Override
    public ReadBuffer getNextBlockToRead() throws InterruptedException {
        return null;
    }

    @Override
    public void doneReading(ReadBuffer buffer, ReadBufferStatus result, int bytesActuallyRead) {
    }

    @Override
    public void purgeBuffersForStream(AbfsInputStream stream) {
    }

    @Override
    @VisibleForTesting
    public int getNumBuffers() {
        return this.numberOfActiveBuffers;
    }

    @Override
    @VisibleForTesting
    public void callTryEvict() {
    }

    @Override
    @VisibleForTesting
    public void testResetReadBufferManager() {
    }

    @Override
    @VisibleForTesting
    public void testResetReadBufferManager(int readAheadBlockSize, int thresholdAgeMilliseconds) {
    }

    @Override
    public void testMimicFullUseAndAddFailedBuffer(ReadBuffer buf) {
    }

    @Override
    void resetBufferManager() {
        ReadBufferManagerV2.setBufferManager(null);
    }

    private static void setBufferManager(ReadBufferManagerV2 manager) {
        bufferManager = manager;
    }
}

