/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Stack;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.azurebfs.contracts.services.ReadBufferStatus;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStream;
import org.apache.hadoop.fs.azurebfs.services.ReadBuffer;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReadBufferManager {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ReadBufferManager.class);
    protected static final ReentrantLock LOCK = new ReentrantLock();
    private static int thresholdAgeMilliseconds;
    private static int blockSize;
    private Stack<Integer> freeList = new Stack();
    private Queue<ReadBuffer> readAheadQueue = new LinkedList<ReadBuffer>();
    private LinkedList<ReadBuffer> inProgressList = new LinkedList();
    private LinkedList<ReadBuffer> completedReadList = new LinkedList();

    abstract void init();

    abstract void queueReadAhead(AbfsInputStream var1, long var2, int var4, TracingContext var5);

    abstract int getBlock(AbfsInputStream var1, long var2, int var4, byte[] var5) throws IOException;

    abstract ReadBuffer getNextBlockToRead() throws InterruptedException;

    abstract void doneReading(ReadBuffer var1, ReadBufferStatus var2, int var3);

    abstract void purgeBuffersForStream(AbfsInputStream var1);

    @VisibleForTesting
    abstract int getNumBuffers();

    @VisibleForTesting
    abstract void callTryEvict();

    @VisibleForTesting
    abstract void testResetReadBufferManager();

    @VisibleForTesting
    abstract void testResetReadBufferManager(int var1, int var2);

    abstract void resetBufferManager();

    @VisibleForTesting
    protected static int getThresholdAgeMilliseconds() {
        return thresholdAgeMilliseconds;
    }

    @VisibleForTesting
    protected static void setThresholdAgeMilliseconds(int thresholdAgeMs) {
        thresholdAgeMilliseconds = thresholdAgeMs;
    }

    @VisibleForTesting
    protected static int getReadAheadBlockSize() {
        return blockSize;
    }

    @VisibleForTesting
    protected static void setReadAheadBlockSize(int readAheadBlockSize) {
        if (readAheadBlockSize <= 0) {
            throw new IllegalArgumentException("Read-ahead block size must be positive");
        }
        blockSize = readAheadBlockSize;
    }

    public Stack<Integer> getFreeList() {
        return this.freeList;
    }

    public Queue<ReadBuffer> getReadAheadQueue() {
        return this.readAheadQueue;
    }

    public LinkedList<ReadBuffer> getInProgressList() {
        return this.inProgressList;
    }

    public LinkedList<ReadBuffer> getCompletedReadList() {
        return this.completedReadList;
    }

    @VisibleForTesting
    protected synchronized List<Integer> getFreeListCopy() {
        return new ArrayList<Integer>(this.freeList);
    }

    @VisibleForTesting
    protected synchronized List<ReadBuffer> getReadAheadQueueCopy() {
        return new ArrayList<ReadBuffer>(this.readAheadQueue);
    }

    @VisibleForTesting
    protected synchronized List<ReadBuffer> getInProgressCopiedList() {
        return new ArrayList<ReadBuffer>(this.inProgressList);
    }

    @VisibleForTesting
    protected synchronized List<ReadBuffer> getCompletedReadListCopy() {
        return new ArrayList<ReadBuffer>(this.completedReadList);
    }

    @VisibleForTesting
    protected int getCompletedReadListSize() {
        return this.completedReadList.size();
    }

    @VisibleForTesting
    protected void testMimicFullUseAndAddFailedBuffer(ReadBuffer buf) {
        this.freeList.clear();
        this.completedReadList.add(buf);
    }

    static {
        blockSize = 0x400000;
    }
}

