/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.ClosedIOException;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.http.HttpClientConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KeepAliveCache
extends LinkedBlockingDeque<HttpClientConnection>
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(KeepAliveCache.class);
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final int maxCacheConnections;
    private final String accountNamePath;
    private ExecutorService singleThreadPool = null;
    private ExecutorService fixedThreadPool = null;

    KeepAliveCache(AbfsConfiguration abfsConfiguration) {
        this.accountNamePath = abfsConfiguration.getAccountName();
        this.maxCacheConnections = abfsConfiguration.getApacheMaxCacheSize();
        if (abfsConfiguration.getApacheCacheRefreshCount() > 0) {
            this.singleThreadPool = Executors.newSingleThreadExecutor(r -> {
                Thread thread = new Thread(r);
                thread.setName("CacheRefreshThread");
                thread.setDaemon(true);
                return thread;
            });
        }
        if (abfsConfiguration.getApacheCacheWarmupCount() > 0 || abfsConfiguration.getApacheCacheRefreshCount() > 0) {
            this.fixedThreadPool = Executors.newFixedThreadPool(Math.min(5, Math.max(abfsConfiguration.getApacheCacheWarmupCount(), abfsConfiguration.getApacheCacheRefreshCount())), r -> {
                Thread thread = new Thread(r);
                thread.setName("AsyncCacheConnectionThread");
                thread.setDaemon(true);
                return thread;
            });
        }
    }

    private void closeHttpClientConnection(HttpClientConnection hc) {
        block2: {
            try {
                hc.close();
            }
            catch (IOException ex) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug("Close failed for connection: {}", (Object)hc, (Object)ex);
            }
        }
    }

    @Override
    public void close() {
        boolean closed = this.isClosed.getAndSet(true);
        if (closed) {
            return;
        }
        this.closeInternal();
        if (this.singleThreadPool != null && !this.singleThreadPool.isShutdown()) {
            this.singleThreadPool.shutdownNow();
        }
        if (this.fixedThreadPool != null && !this.fixedThreadPool.isShutdown()) {
            this.fixedThreadPool.shutdownNow();
        }
    }

    public boolean getIsClosed() {
        return this.isClosed.get();
    }

    public ExecutorService getSingleThreadPool() {
        return this.singleThreadPool;
    }

    public ExecutorService getFixedThreadPool() {
        return this.fixedThreadPool;
    }

    @VisibleForTesting
    void closeInternal() {
        while (this.size() != 0) {
            this.closeHttpClientConnection((HttpClientConnection)this.pollFirst());
        }
    }

    public HttpClientConnection get() throws IOException {
        HttpClientConnection httpClientConnection;
        if (this.getIsClosed()) {
            LOG.debug("Attempt to get connection from closed cache for account: {}", (Object)this.accountNamePath);
            throw new ClosedIOException(this.accountNamePath, "KeepAliveCache is closed");
        }
        while ((httpClientConnection = (HttpClientConnection)this.pollFirst()) != null) {
            if (!httpClientConnection.isOpen() || httpClientConnection.isStale()) {
                this.closeHttpClientConnection(httpClientConnection);
                continue;
            }
            return httpClientConnection;
        }
        LOG.debug("No valid connection found in cache for account: {}", (Object)this.accountNamePath);
        return null;
    }

    @Override
    public boolean add(HttpClientConnection conn) {
        HttpClientConnection httpClientConnection;
        if (conn == null) {
            LOG.warn("Attempt to add null HttpClientConnection to the cache for account: {}", (Object)this.accountNamePath);
            return false;
        }
        if (this.getIsClosed() || this.getMaxCacheConnections() <= 0 || !conn.isOpen() || conn.isStale()) {
            LOG.debug("Not adding connection to cache. closed: {}, maxCacheSize: {}, isOpen: {}, isStale: {} for account: {}", new Object[]{this.getIsClosed(), this.getMaxCacheConnections(), conn.isOpen(), conn.isStale(), this.accountNamePath});
            this.closeHttpClientConnection(conn);
            return false;
        }
        while (this.size() >= this.getMaxCacheConnections() && (httpClientConnection = (HttpClientConnection)this.pollFirst()) != null) {
            this.closeHttpClientConnection(httpClientConnection);
        }
        return this.offerLast(conn);
    }

    @VisibleForTesting
    public int getMaxCacheConnections() {
        return this.maxCacheConnections;
    }

    @Override
    public String toString() {
        return String.format("KeepAliveCache[closed=%s, size=%d, max=%d]", this.getIsClosed(), this.size(), this.getMaxCacheConnections());
    }
}

