/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlobClient;
import org.apache.hadoop.fs.azurebfs.services.ListActionTaker;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobDeleteHandler
extends ListActionTaker {
    private static final Logger LOG = LoggerFactory.getLogger(BlobDeleteHandler.class);
    private final Path path;
    private final boolean recursive;
    private boolean nonRecursiveDeleteDirectoryFailed = false;
    private final TracingContext tracingContext;
    private final AtomicInteger deleteCount = new AtomicInteger(0);

    public BlobDeleteHandler(Path path, boolean recursive, AbfsBlobClient abfsBlobClient, TracingContext tracingContext) {
        super(path, abfsBlobClient, tracingContext);
        this.path = path;
        this.recursive = recursive;
        this.tracingContext = tracingContext;
    }

    @Override
    int getMaxConsumptionParallelism() {
        return this.getAbfsClient().getAbfsConfiguration().getBlobDeleteDirConsumptionParallelism();
    }

    private boolean deleteInternal(Path path) throws AzureBlobFileSystemException {
        this.getAbfsClient().deleteBlobPath(path, null, this.tracingContext);
        this.deleteCount.incrementAndGet();
        return true;
    }

    public boolean execute() throws AzureBlobFileSystemException {
        boolean deleted;
        this.listRecursiveAndTakeAction();
        if (this.nonRecursiveDeleteDirectoryFailed) {
            throw new AbfsRestOperationException(409, AzureServiceErrorCode.NON_EMPTY_DIRECTORY_DELETE.getErrorCode(), AzureServiceErrorCode.NON_EMPTY_DIRECTORY_DELETE.getErrorMessage(), (Exception)new PathIOException(this.path.toString(), "Non-recursive delete of non-empty directory"));
        }
        this.tracingContext.setOperatedBlobCount(this.deleteCount.get() + 1);
        try {
            deleted = this.recursive ? this.safeDelete(this.path) : this.deleteInternal(this.path);
        }
        finally {
            this.tracingContext.setOperatedBlobCount(0);
        }
        if (this.deleteCount.get() == 0) {
            throw new AbfsRestOperationException(404, AzureServiceErrorCode.PATH_NOT_FOUND.getErrorCode(), AzureServiceErrorCode.PATH_NOT_FOUND.getErrorMessage(), (Exception)new PathIOException(this.path.toString(), "Path not found"));
        }
        if (deleted) {
            this.ensurePathParentExist();
        }
        return deleted;
    }

    private void ensurePathParentExist() throws AzureBlobFileSystemException {
        if (!this.path.isRoot() && !this.path.getParent().isRoot()) {
            try {
                this.getAbfsClient().createMarkerAtPath(this.path.getParent().toUri().getPath(), null, null, this.tracingContext);
            }
            catch (AbfsRestOperationException ex) {
                LOG.debug("Marker creation failed for parent path {} ", (Object)this.path.getParent().toUri().getPath());
            }
        }
    }

    @Override
    boolean takeAction(Path path) throws AzureBlobFileSystemException {
        if (!this.recursive) {
            this.nonRecursiveDeleteDirectoryFailed = true;
            return false;
        }
        return this.safeDelete(path);
    }

    private boolean safeDelete(Path path) throws AzureBlobFileSystemException {
        try {
            return this.deleteInternal(path);
        }
        catch (AbfsRestOperationException ex) {
            if (ex.getStatusCode() == 404) {
                return true;
            }
            throw ex;
        }
    }
}

