/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidIngressServiceException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AppendRequestParameters;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlock;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientHandler;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStream;
import org.apache.hadoop.fs.azurebfs.services.AbfsPerfInfo;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AzureBlobBlockManager;
import org.apache.hadoop.fs.azurebfs.services.AzureBlockManager;
import org.apache.hadoop.fs.azurebfs.services.AzureDFSIngressHandler;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.store.DataBlocks;
import org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureDfsToBlobIngressFallbackHandler
extends AzureDFSIngressHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbfsOutputStream.class);
    private final AzureBlobBlockManager blobBlockManager;
    private final String eTag;
    private final Lock lock = new ReentrantLock();

    public AzureDfsToBlobIngressFallbackHandler(AbfsOutputStream abfsOutputStream, DataBlocks.BlockFactory blockFactory, int bufferSize, String eTag, AbfsClientHandler clientHandler) throws AzureBlobFileSystemException {
        super(abfsOutputStream, clientHandler);
        this.eTag = eTag;
        this.blobBlockManager = new AzureBlobBlockManager(abfsOutputStream, blockFactory, bufferSize);
        LOG.trace("Created a new BlobFallbackIngress Handler for AbfsOutputStream instance {} for path {}", (Object)abfsOutputStream.getStreamID(), (Object)abfsOutputStream.getPath());
    }

    @Override
    public int bufferData(AbfsBlock block, byte[] data, int off, int length) throws IOException {
        LOG.trace("Buffering data of length {} to block at offset {}", (Object)length, (Object)off);
        return super.bufferData(block, data, off, length);
    }

    @Override
    protected AbfsRestOperation remoteWrite(AbfsBlock blockToUpload, DataBlocks.BlockUploadData uploadData, AppendRequestParameters reqParams, TracingContext tracingContext) throws IOException {
        AbfsRestOperation op;
        TracingContext tracingContextAppend = new TracingContext(tracingContext);
        String threadIdStr = String.valueOf(Thread.currentThread().getId());
        tracingContextAppend.setIngressHandler("FB T " + threadIdStr);
        tracingContextAppend.setPosition(String.valueOf(blockToUpload.getOffset()));
        try {
            op = super.remoteWrite(blockToUpload, uploadData, reqParams, tracingContextAppend);
            this.blobBlockManager.updateEntry(blockToUpload);
        }
        catch (AbfsRestOperationException ex) {
            if (this.shouldIngressHandlerBeSwitched(ex)) {
                LOG.error("Error in remote write requiring handler switch for path {}", (Object)this.getAbfsOutputStream().getPath(), (Object)ex);
                throw this.getIngressHandlerSwitchException(ex);
            }
            LOG.error("Error in remote write for path {} and offset {}", new Object[]{this.getAbfsOutputStream().getPath(), blockToUpload.getOffset(), ex});
            throw ex;
        }
        return op;
    }

    @Override
    protected synchronized AbfsRestOperation remoteFlush(long offset, boolean retainUncommitedData, boolean isClose, String leaseId, TracingContext tracingContext) throws IOException {
        AbfsRestOperation op;
        if (!this.blobBlockManager.hasBlocksToCommit()) {
            return null;
        }
        try {
            TracingContext tracingContextFlush = new TracingContext(tracingContext);
            tracingContextFlush.setIngressHandler("FB");
            tracingContextFlush.setPosition(String.valueOf(offset));
            op = super.remoteFlush(offset, retainUncommitedData, isClose, leaseId, tracingContextFlush);
        }
        catch (AbfsRestOperationException ex) {
            if (this.shouldIngressHandlerBeSwitched(ex)) {
                LOG.error("Error in remote flush requiring handler switch for path {}", (Object)this.getAbfsOutputStream().getPath(), (Object)ex);
                throw this.getIngressHandlerSwitchException(ex);
            }
            LOG.error("Error in remote flush for path {} and offset {}", new Object[]{this.getAbfsOutputStream().getPath(), offset, ex});
            throw ex;
        }
        return op;
    }

    @Override
    public AzureBlockManager getBlockManager() {
        return this.blobBlockManager;
    }

    @Override
    @VisibleForTesting
    public String getETag() {
        this.lock.lock();
        try {
            String string = this.eTag;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeAppendBlobCurrentBufferToService() throws IOException {
        AbfsBlock activeBlock = this.blobBlockManager.getActiveBlock();
        if (!this.getAbfsOutputStream().hasActiveBlockDataToUpload()) {
            return;
        }
        int bytesLength = activeBlock.dataSize();
        DataBlocks.BlockUploadData uploadData = activeBlock.startUpload();
        if (this.blobBlockManager.hasActiveBlock()) {
            this.blobBlockManager.clearActiveBlock();
        }
        this.getAbfsOutputStream().getOutputStreamStatistics().writeCurrentBuffer();
        this.getAbfsOutputStream().getOutputStreamStatistics().bytesToUpload(bytesLength);
        long offset = this.getAbfsOutputStream().getPosition();
        this.getAbfsOutputStream().setPosition(offset + (long)bytesLength);
        try (AbfsPerfInfo perfInfo = new AbfsPerfInfo(this.getClient().getAbfsPerfTracker(), "writeCurrentBufferToService", "append");){
            AbfsRestOperation op;
            LOG.trace("Writing current buffer to service at offset {} and path {}", (Object)offset, (Object)this.getAbfsOutputStream().getPath());
            AppendRequestParameters reqParams = new AppendRequestParameters(offset, 0, bytesLength, AppendRequestParameters.Mode.APPEND_MODE, true, this.getAbfsOutputStream().getLeaseId(), this.getAbfsOutputStream().isExpectHeaderEnabled(), this.getAbfsOutputStream().getMd5());
            try {
                op = this.remoteAppendBlobWrite(this.getAbfsOutputStream().getPath(), uploadData, activeBlock, reqParams, new TracingContext(this.getAbfsOutputStream().getTracingContext()));
            }
            catch (InvalidIngressServiceException ex) {
                try {
                    LOG.debug("InvalidIngressServiceException caught for path: {}, switching handler and retrying remoteAppendBlobWrite.", (Object)this.getAbfsOutputStream().getPath());
                    this.getAbfsOutputStream().switchHandler();
                    op = this.getAbfsOutputStream().getIngressHandler().remoteAppendBlobWrite(this.getAbfsOutputStream().getPath(), uploadData, activeBlock, reqParams, new TracingContext(this.getAbfsOutputStream().getTracingContext()));
                }
                catch (Throwable throwable) {
                    IOUtils.closeStreams((Closeable[])new Closeable[]{uploadData, activeBlock});
                    throw throwable;
                }
                IOUtils.closeStreams((Closeable[])new Closeable[]{uploadData, activeBlock});
            }
            IOUtils.closeStreams((Closeable[])new Closeable[]{uploadData, activeBlock});
            if (op != null) {
                this.getAbfsOutputStream().getCachedSasToken().update(op.getSasToken());
                this.getAbfsOutputStream().getOutputStreamStatistics().uploadSuccessful(bytesLength);
                perfInfo.registerResult(op.getResult());
                perfInfo.registerSuccess(true);
            }
        }
    }
}

