/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.UUID;
import javax.net.ssl.SSLSession;
import org.apache.hadoop.fs.azurebfs.services.AbfsManagedHttpClientContext;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.routing.HttpRoute;

class AbfsManagedApacheHttpConnection
implements ManagedHttpClientConnection {
    private final ManagedHttpClientConnection httpClientConnection;
    private AbfsManagedHttpClientContext managedHttpContext;
    private final HttpHost targetHost;
    private final int hashCode;

    AbfsManagedApacheHttpConnection(ManagedHttpClientConnection conn, HttpRoute route) {
        this.targetHost = route != null ? route.getTargetHost() : null;
        this.httpClientConnection = conn;
        this.hashCode = (UUID.randomUUID().toString() + this.httpClientConnection.getId()).hashCode();
    }

    void setManagedHttpContext(AbfsManagedHttpClientContext managedHttpContext) {
        this.managedHttpContext = managedHttpContext;
    }

    public HttpHost getTargetHost() {
        return this.targetHost;
    }

    public void close() throws IOException {
        this.httpClientConnection.close();
    }

    public boolean isOpen() {
        return this.httpClientConnection.isOpen();
    }

    public boolean isStale() {
        try {
            Socket socket = this.httpClientConnection.getSocket();
            if (socket == null || socket.isClosed()) {
                return true;
            }
            InputStream in = socket.getInputStream();
            if (in == null) {
                return true;
            }
            socket.setSoTimeout(1);
            int b = in.read();
            return b == -1;
        }
        catch (SocketTimeoutException e) {
            return false;
        }
        catch (IOException e) {
            return true;
        }
    }

    public void setSocketTimeout(int timeout) {
        this.httpClientConnection.setSocketTimeout(timeout);
    }

    public int getSocketTimeout() {
        return this.httpClientConnection.getSocketTimeout();
    }

    public void shutdown() throws IOException {
        this.httpClientConnection.shutdown();
    }

    public HttpConnectionMetrics getMetrics() {
        return this.httpClientConnection.getMetrics();
    }

    public boolean isResponseAvailable(int timeout) throws IOException {
        long start = System.currentTimeMillis();
        boolean val = this.httpClientConnection.isResponseAvailable(timeout);
        this.managedHttpContext.addReadTime(System.currentTimeMillis() - start);
        return val;
    }

    public void sendRequestHeader(HttpRequest request) throws HttpException, IOException {
        long start = System.currentTimeMillis();
        this.httpClientConnection.sendRequestHeader(request);
        this.managedHttpContext.addSendTime(System.currentTimeMillis() - start);
    }

    public void sendRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
        long start = System.currentTimeMillis();
        this.httpClientConnection.sendRequestEntity(request);
        this.managedHttpContext.addSendTime(System.currentTimeMillis() - start);
    }

    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        long start = System.currentTimeMillis();
        HttpResponse response = this.httpClientConnection.receiveResponseHeader();
        this.managedHttpContext.addReadTime(System.currentTimeMillis() - start);
        return response;
    }

    public void receiveResponseEntity(HttpResponse response) throws HttpException, IOException {
        long start = System.currentTimeMillis();
        this.httpClientConnection.receiveResponseEntity(response);
        this.managedHttpContext.addReadTime(System.currentTimeMillis() - start);
    }

    public void flush() throws IOException {
        long start = System.currentTimeMillis();
        this.httpClientConnection.flush();
        this.managedHttpContext.addSendTime(System.currentTimeMillis() - start);
    }

    public String getId() {
        return this.httpClientConnection.getId();
    }

    public void bind(Socket socket) throws IOException {
        this.httpClientConnection.bind(socket);
    }

    public Socket getSocket() {
        return this.httpClientConnection.getSocket();
    }

    public SSLSession getSSLSession() {
        return this.httpClientConnection.getSSLSession();
    }

    public InetAddress getLocalAddress() {
        return this.httpClientConnection.getLocalAddress();
    }

    public int getLocalPort() {
        return this.httpClientConnection.getLocalPort();
    }

    public InetAddress getRemoteAddress() {
        return this.httpClientConnection.getRemoteAddress();
    }

    public int getRemotePort() {
        return this.httpClientConnection.getRemotePort();
    }

    public boolean equals(Object o) {
        if (o instanceof AbfsManagedApacheHttpConnection) {
            return this.httpClientConnection.getId().equals(((AbfsManagedApacheHttpConnection)o).httpClientConnection.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuilder stringBuilder = this.targetHost != null ? new StringBuilder(this.targetHost.toString()) : new StringBuilder();
        stringBuilder.append(":").append(this.hashCode());
        return stringBuilder.toString();
    }
}

