/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class AbfsIoUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AbfsIoUtils.class);

    private AbfsIoUtils() {
    }

    public static void dumpHeadersToDebugLog(String origin, Map<String, List<String>> headers) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}", (Object)origin);
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                List<String> valuesList;
                String key = entry.getKey();
                if (key == null) {
                    key = "HTTP Response";
                }
                valuesList = (valuesList = entry.getValue()) == null ? Collections.emptyList() : valuesList.stream().map(v -> v == null ? "" : v).collect(Collectors.toList());
                String values = StringUtils.join((CharSequence)";", valuesList);
                if (key.contains("Cookie")) {
                    values = "*cookie info*";
                }
                if (key.equals("sig")) {
                    values = "XXXX";
                }
                LOG.debug("  {}={}", (Object)key, (Object)values);
            }
        }
    }
}

