/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.constants.AbfsServiceType;
import org.apache.hadoop.fs.azurebfs.extensions.EncryptionContextProvider;
import org.apache.hadoop.fs.azurebfs.extensions.SASTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.AccessTokenProvider;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlobClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientContext;
import org.apache.hadoop.fs.azurebfs.services.AbfsDfsClient;
import org.apache.hadoop.fs.azurebfs.services.SharedKeyCredentials;
import org.apache.hadoop.fs.azurebfs.utils.UriUtils;
import org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbfsClientHandler
implements Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(AbfsClientHandler.class);
    private AbfsServiceType defaultServiceType;
    private AbfsServiceType ingressServiceType;
    private final AbfsDfsClient dfsAbfsClient;
    private final AbfsBlobClient blobAbfsClient;

    public AbfsClientHandler(URL baseUrl, SharedKeyCredentials sharedKeyCredentials, AbfsConfiguration abfsConfiguration, AccessTokenProvider tokenProvider, EncryptionContextProvider encryptionContextProvider, AbfsClientContext abfsClientContext) throws IOException {
        this.dfsAbfsClient = this.createDfsClient(baseUrl, sharedKeyCredentials, abfsConfiguration, tokenProvider, null, encryptionContextProvider, abfsClientContext);
        this.blobAbfsClient = this.createBlobClient(baseUrl, sharedKeyCredentials, abfsConfiguration, tokenProvider, null, encryptionContextProvider, abfsClientContext);
        this.initServiceType(abfsConfiguration);
    }

    public AbfsClientHandler(URL baseUrl, SharedKeyCredentials sharedKeyCredentials, AbfsConfiguration abfsConfiguration, SASTokenProvider sasTokenProvider, EncryptionContextProvider encryptionContextProvider, AbfsClientContext abfsClientContext) throws IOException {
        this.initServiceType(abfsConfiguration);
        this.dfsAbfsClient = this.createDfsClient(baseUrl, sharedKeyCredentials, abfsConfiguration, null, sasTokenProvider, encryptionContextProvider, abfsClientContext);
        this.blobAbfsClient = this.createBlobClient(baseUrl, sharedKeyCredentials, abfsConfiguration, null, sasTokenProvider, encryptionContextProvider, abfsClientContext);
    }

    private void initServiceType(AbfsConfiguration abfsConfiguration) {
        this.defaultServiceType = abfsConfiguration.getFsConfiguredServiceType();
        this.ingressServiceType = abfsConfiguration.getIngressServiceType();
    }

    public AbfsClient getClient() {
        return this.getClient(this.defaultServiceType);
    }

    public AbfsClient getIngressClient() {
        return this.getClient(this.ingressServiceType);
    }

    public AbfsClient getClient(AbfsServiceType serviceType) {
        return serviceType == AbfsServiceType.DFS ? this.dfsAbfsClient : this.blobAbfsClient;
    }

    public AbfsDfsClient getDfsClient() {
        return this.dfsAbfsClient;
    }

    public AbfsBlobClient getBlobClient() {
        return this.blobAbfsClient;
    }

    private AbfsDfsClient createDfsClient(URL baseUrl, SharedKeyCredentials creds, AbfsConfiguration abfsConfiguration, AccessTokenProvider tokenProvider, SASTokenProvider sasTokenProvider, EncryptionContextProvider encryptionContextProvider, AbfsClientContext abfsClientContext) throws IOException {
        URL dfsUrl = UriUtils.changeUrlFromBlobToDfs(baseUrl);
        if (tokenProvider != null) {
            LOG.debug("Creating AbfsDfsClient with access token provider using the URL: {}", (Object)dfsUrl);
            return new AbfsDfsClient(dfsUrl, creds, abfsConfiguration, tokenProvider, encryptionContextProvider, abfsClientContext);
        }
        LOG.debug("Creating AbfsDfsClient with SAS token provider using the URL: {}", (Object)dfsUrl);
        return new AbfsDfsClient(dfsUrl, creds, abfsConfiguration, sasTokenProvider, encryptionContextProvider, abfsClientContext);
    }

    private AbfsBlobClient createBlobClient(URL baseUrl, SharedKeyCredentials creds, AbfsConfiguration abfsConfiguration, AccessTokenProvider tokenProvider, SASTokenProvider sasTokenProvider, EncryptionContextProvider encryptionContextProvider, AbfsClientContext abfsClientContext) throws IOException {
        URL blobUrl = UriUtils.changeUrlFromDfsToBlob(baseUrl);
        if (tokenProvider != null) {
            LOG.debug("Creating AbfsBlobClient with access token provider using the URL: {}", (Object)blobUrl);
            return new AbfsBlobClient(blobUrl, creds, abfsConfiguration, tokenProvider, encryptionContextProvider, abfsClientContext);
        }
        LOG.debug("Creating AbfsBlobClient with SAS token provider using the URL: {}", (Object)blobUrl);
        return new AbfsBlobClient(blobUrl, creds, abfsConfiguration, sasTokenProvider, encryptionContextProvider, abfsClientContext);
    }

    @Override
    public void close() throws IOException {
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.getDfsClient(), this.getBlobClient()});
    }
}

