/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.services.AbfsConnectionManager;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpClientConnectionFactory;
import org.apache.hadoop.fs.azurebfs.services.AbfsManagedHttpClientContext;
import org.apache.hadoop.fs.azurebfs.services.AbfsManagedHttpRequestExecutor;
import org.apache.hadoop.fs.azurebfs.services.KeepAliveCache;
import org.apache.hadoop.security.ssl.DelegatingSSLSocketFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;

final class AbfsApacheHttpClient
implements Closeable {
    private final CloseableHttpClient httpClient;
    private static boolean usable = true;

    static void registerFallback() {
        usable = false;
    }

    static void setUsable() {
        usable = true;
    }

    static boolean usable() {
        return usable;
    }

    AbfsApacheHttpClient(DelegatingSSLSocketFactory delegatingSSLSocketFactory, AbfsConfiguration abfsConfiguration, KeepAliveCache keepAliveCache, URL baseUrl, boolean isCacheWarmupNeeded) {
        AbfsConnectionManager connMgr = new AbfsConnectionManager(this.createSocketFactoryRegistry((ConnectionSocketFactory)new SSLConnectionSocketFactory((SSLSocketFactory)delegatingSSLSocketFactory, SSLConnectionSocketFactory.getDefaultHostnameVerifier())), new AbfsHttpClientConnectionFactory(), keepAliveCache, abfsConfiguration, baseUrl, isCacheWarmupNeeded);
        HttpClientBuilder builder = HttpClients.custom();
        builder.setConnectionManager((HttpClientConnectionManager)connMgr).setRequestExecutor((HttpRequestExecutor)new AbfsManagedHttpRequestExecutor(abfsConfiguration.isExpectHeaderEnabled() ? abfsConfiguration.getExpect100ContinueWaitTimeout() : abfsConfiguration.getHttpReadTimeout())).disableContentCompression().disableRedirectHandling().disableAutomaticRetries().setUserAgent("");
        this.httpClient = builder.build();
    }

    @Override
    public void close() throws IOException {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    public HttpResponse execute(HttpRequestBase httpRequest, AbfsManagedHttpClientContext abfsHttpClientContext, int connectTimeout, int readTimeout) throws IOException {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectTimeout(connectTimeout).setSocketTimeout(readTimeout);
        httpRequest.setConfig(requestConfigBuilder.build());
        return this.httpClient.execute((HttpUriRequest)httpRequest, (HttpContext)abfsHttpClientContext);
    }

    private Registry<ConnectionSocketFactory> createSocketFactoryRegistry(ConnectionSocketFactory sslSocketFactory) {
        if (sslSocketFactory == null) {
            return RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).build();
        }
        return RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
    }
}

