/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.oauth2;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.oauth2.AccessTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADAuthenticator;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADToken;
import org.apache.hadoop.fs.azurebfs.oauth2.ClientAssertionProvider;
import org.apache.hadoop.thirdparty.com.google.common.base.Strings;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkloadIdentityTokenProvider
extends AccessTokenProvider {
    private static final String OAUTH2_TOKEN_PATH = "/oauth2/v2.0/token";
    private static final Logger LOG = LoggerFactory.getLogger(AccessTokenProvider.class);
    private static final String EMPTY_TOKEN_FILE_ERROR = "Empty token file found at specified path: ";
    private static final String TOKEN_FILE_READ_ERROR = "Error reading token file at specified path: ";
    private final String authEndpoint;
    private final String clientId;
    private final ClientAssertionProvider clientAssertionProvider;
    private long tokenFetchTime = -1L;

    public WorkloadIdentityTokenProvider(String authority, String tenantId, String clientId, ClientAssertionProvider clientAssertionProvider) {
        Preconditions.checkNotNull((Object)authority, (Object)"authority");
        Preconditions.checkNotNull((Object)tenantId, (Object)"tenantId");
        Preconditions.checkNotNull((Object)clientId, (Object)"clientId");
        Preconditions.checkNotNull((Object)clientAssertionProvider, (Object)"clientAssertionProvider");
        this.authEndpoint = authority + tenantId + OAUTH2_TOKEN_PATH;
        this.clientId = clientId;
        this.clientAssertionProvider = clientAssertionProvider;
    }

    public WorkloadIdentityTokenProvider(String authority, String tenantId, String clientId, String tokenFile) {
        Preconditions.checkNotNull((Object)authority, (Object)"authority");
        Preconditions.checkNotNull((Object)tenantId, (Object)"tenantId");
        Preconditions.checkNotNull((Object)clientId, (Object)"clientId");
        Preconditions.checkNotNull((Object)tokenFile, (Object)"tokenFile");
        this.authEndpoint = authority + tenantId + OAUTH2_TOKEN_PATH;
        this.clientId = clientId;
        this.clientAssertionProvider = new FileBasedClientAssertionProvider(tokenFile);
    }

    @Override
    protected AzureADToken refreshToken() throws IOException {
        LOG.debug("AADToken: refreshing token from JWT Assertion");
        String clientAssertion = this.clientAssertionProvider.getClientAssertion();
        AzureADToken token = this.getTokenUsingJWTAssertion(clientAssertion);
        this.tokenFetchTime = System.currentTimeMillis();
        return token;
    }

    @Override
    protected boolean isTokenAboutToExpire() {
        boolean expiring;
        if (this.tokenFetchTime == -1L || super.isTokenAboutToExpire()) {
            return true;
        }
        long elapsedTimeSinceLastTokenRefreshInMillis = System.currentTimeMillis() - this.tokenFetchTime;
        boolean bl = expiring = elapsedTimeSinceLastTokenRefreshInMillis < 0L;
        if (expiring) {
            LOG.debug("JWTToken: token renewing. Time elapsed since last token fetch: {} milliseconds", (Object)elapsedTimeSinceLastTokenRefreshInMillis);
        }
        return expiring;
    }

    @VisibleForTesting
    AzureADToken getTokenUsingJWTAssertion(String clientAssertion) throws IOException {
        return AzureADAuthenticator.getTokenUsingJWTAssertion(this.authEndpoint, this.clientId, clientAssertion);
    }

    @VisibleForTesting
    long getTokenFetchTime() {
        return this.tokenFetchTime;
    }

    private static class FileBasedClientAssertionProvider
    implements ClientAssertionProvider {
        private final String tokenFile;

        FileBasedClientAssertionProvider(String tokenFile) {
            this.tokenFile = tokenFile;
        }

        @Override
        public void initialize(Configuration configuration, String accountName) throws IOException {
        }

        @Override
        public String getClientAssertion() throws IOException {
            String clientAssertion = "";
            try {
                File file = new File(this.tokenFile);
                clientAssertion = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                throw new IOException(WorkloadIdentityTokenProvider.TOKEN_FILE_READ_ERROR + this.tokenFile, e);
            }
            clientAssertion = clientAssertion.trim();
            if (Strings.isNullOrEmpty((String)clientAssertion)) {
                throw new IOException(WorkloadIdentityTokenProvider.EMPTY_TOKEN_FILE_ERROR + this.tokenFile);
            }
            return clientAssertion;
        }
    }
}

