/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.constants;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.VersionInfo;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class AbfsHttpConstants {
    public static final String FILESYSTEM = "filesystem";
    public static final String FILE = "file";
    public static final String DIRECTORY = "directory";
    public static final String APPEND_ACTION = "append";
    public static final String FLUSH_ACTION = "flush";
    public static final String SET_PROPERTIES_ACTION = "setProperties";
    public static final String SET_ACCESS_CONTROL = "setAccessControl";
    public static final String GET_ACCESS_CONTROL = "getAccessControl";
    public static final String CHECK_ACCESS = "checkAccess";
    public static final String GET_STATUS = "getStatus";
    public static final String ACQUIRE_LEASE_ACTION = "acquire";
    public static final String BREAK_LEASE_ACTION = "break";
    public static final String RELEASE_LEASE_ACTION = "release";
    public static final String RENEW_LEASE_ACTION = "renew";
    public static final String DEFAULT_LEASE_BREAK_PERIOD = "0";
    public static final String DEFAULT_TIMEOUT = "90";
    public static final String APPEND_BLOB_TYPE = "appendblob";
    public static final String LIST = "list";
    public static final String BLOCK_BLOB_TYPE = "BlockBlob";
    public static final String APPEND_BLOCK = "appendblock";
    public static final String CONTAINER = "container";
    public static final String METADATA = "metadata";
    public static final String BLOCK = "block";
    public static final String BLOCKLIST = "blocklist";
    public static final String LEASE = "lease";
    public static final String BLOCK_TYPE_COMMITTED = "committed";
    public static final String JAVA_VENDOR = "java.vendor";
    public static final String JAVA_VERSION = "java.version";
    public static final String OS_NAME = "os.name";
    public static final String OS_VERSION = "os.version";
    public static final String OS_ARCH = "os.arch";
    public static final String APN_VERSION = "APN/1.0";
    public static final String CLIENT_VERSION = "Azure Blob FS/" + VersionInfo.getVersion();
    public static final String TOKEN_VERSION = "2";
    public static final String HTTP_METHOD_DELETE = "DELETE";
    public static final String HTTP_METHOD_GET = "GET";
    public static final String HTTP_METHOD_HEAD = "HEAD";
    public static final String HTTP_METHOD_PATCH = "PATCH";
    public static final String HTTP_METHOD_POST = "POST";
    public static final String HTTP_METHOD_PUT = "PUT";
    public static final int HTTP_CONTINUE = 100;
    public static final String EXPECT_100_JDK_ERROR = "Server rejected operation";
    public static final String SINGLE_WHITE_SPACE = " ";
    public static final String EMPTY_STRING = "";
    public static final String FORWARD_SLASH = "/";
    public static final String DOT = ".";
    public static final String PLUS = "+";
    public static final String STAR = "*";
    public static final String COMMA = ",";
    public static final String COLON = ":";
    public static final String EQUAL = "=";
    public static final String QUESTION_MARK = "?";
    public static final String AND_MARK = "&";
    public static final String SEMICOLON = ";";
    public static final String AT = "@";
    public static final String HTTP_HEADER_PREFIX = "x-ms-";
    public static final String HASH = "#";
    public static final String TRUE = "true";
    public static final String ZERO = "0";
    public static final String PLUS_ENCODE = "%20";
    public static final String FORWARD_SLASH_ENCODE = "%2F";
    public static final String AZURE_DISTRIBUTED_FILE_SYSTEM_AUTHORITY_DELIMITER = "@";
    public static final String UTF_8 = "utf-8";
    public static final String MD5 = "MD5";
    public static final String GMT_TIMEZONE = "GMT";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String APPLICATION_XML = "application/xml";
    public static final String XMS_PROPERTIES_ENCODING_ASCII = "ISO-8859-1";
    public static final String XMS_PROPERTIES_ENCODING_UNICODE = "UTF-8";
    public static final String ROOT_PATH = "/";
    public static final String ACCESS_MASK = "mask:";
    public static final String ACCESS_USER = "user:";
    public static final String ACCESS_GROUP = "group:";
    public static final String ACCESS_OTHER = "other:";
    public static final String DEFAULT_MASK = "default:mask:";
    public static final String DEFAULT_USER = "default:user:";
    public static final String DEFAULT_GROUP = "default:group:";
    public static final String DEFAULT_OTHER = "default:other:";
    public static final String DEFAULT_SCOPE = "default:";
    public static final String PERMISSION_FORMAT = "%04d";
    public static final String SUPER_USER = "$superuser";
    public static final String HUNDRED_CONTINUE = "100-continue";
    public static final char CHAR_FORWARD_SLASH = '/';
    public static final char CHAR_EXCLAMATION_POINT = '!';
    public static final char CHAR_UNDERSCORE = '_';
    public static final char CHAR_HYPHEN = '-';
    public static final char CHAR_EQUALS = '=';
    public static final char CHAR_STAR = '*';
    public static final char CHAR_PLUS = '+';
    public static final int SPLIT_NO_LIMIT = -1;
    public static final String XML_TAG_NAME = "Name";
    public static final String XML_TAG_BLOB = "Blob";
    public static final String XML_TAG_NEXT_MARKER = "NextMarker";
    public static final String XML_TAG_METADATA = "Metadata";
    public static final String XML_TAG_PROPERTIES = "Properties";
    public static final String XML_TAG_BLOB_PREFIX = "BlobPrefix";
    public static final String XML_TAG_CONTENT_LEN = "Content-Length";
    public static final String XML_TAG_RESOURCE_TYPE = "ResourceType";
    public static final String XML_TAG_INVALID_XML = "Invalid XML";
    public static final String XML_TAG_HDI_ISFOLDER = "hdi_isfolder";
    public static final String XML_TAG_HDI_PERMISSION = "hdi_permission";
    public static final String XML_TAG_ETAG = "Etag";
    public static final String XML_TAG_LAST_MODIFIED_TIME = "Last-Modified";
    public static final String XML_TAG_CREATION_TIME = "Creation-Time";
    public static final String XML_TAG_OWNER = "Owner";
    public static final String XML_TAG_GROUP = "Group";
    public static final String XML_TAG_PERMISSIONS = "Permissions";
    public static final String XML_TAG_ACL = "Acl";
    public static final String XML_TAG_COPY_ID = "CopyId";
    public static final String XML_TAG_COPY_STATUS = "CopyStatus";
    public static final String XML_TAG_COPY_SOURCE = "CopySource";
    public static final String XML_TAG_COPY_PROGRESS = "CopyProgress";
    public static final String XML_TAG_COPY_COMPLETION_TIME = "CopyCompletionTime";
    public static final String XML_TAG_COPY_STATUS_DESCRIPTION = "CopyStatusDescription";
    public static final String XML_TAG_BLOB_ERROR_CODE_START_XML = "<Code>";
    public static final String XML_TAG_BLOB_ERROR_CODE_END_XML = "</Code>";
    public static final String XML_TAG_BLOB_ERROR_MESSAGE_START_XML = "<Message>";
    public static final String XML_TAG_BLOB_ERROR_MESSAGE_END_XML = "</Message>";
    public static final String XML_TAG_COMMITTED_BLOCKS = "CommittedBlocks";
    public static final String XML_TAG_BLOCK_NAME = "Block";
    public static final String PUT_BLOCK_LIST = "PutBlockList";
    public static final Integer HTTP_STATUS_CATEGORY_QUOTIENT = 100;
    public static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>%n";
    public static final String BLOCK_LIST_START_TAG = "<BlockList>%n";
    public static final String BLOCK_LIST_END_TAG = "</BlockList>%n";
    public static final String LATEST_BLOCK_FORMAT = "<Latest>%s</Latest>%n";
    private static final String CPK_CONFIG_LIST = "fs.azure.encryption.context.provider.type, fs.azure.encryption.encoded.client-provided-key, fs.azure.encryption.encoded.client-provided-key-sha";
    public static final String CPK_IN_NON_HNS_ACCOUNT_ERROR_MESSAGE = "Non hierarchical-namespace account can not have configs enabled for Customer Provided Keys. Following configs can not be given with non-hierarchical-namespace account:fs.azure.encryption.context.provider.type, fs.azure.encryption.encoded.client-provided-key, fs.azure.encryption.encoded.client-provided-key-sha";
    public static final String HTTP_MAX_CONN_SYS_PROP = "http.maxConnections";
    public static final String JDK_IMPL = "JDK";
    public static final String APACHE_IMPL = "Apache";
    public static final String JDK_FALLBACK = "JDK_fallback";
    public static final String KEEP_ALIVE_CACHE_CLOSED = "KeepAliveCache is closed";
    public static final String DFS_FLUSH = "D";
    public static final String DFS_APPEND = "D";
    public static final String BLOB_FLUSH = "B";
    public static final String BLOB_APPEND = "B";
    public static final String FALLBACK_FLUSH = "FB";
    public static final String FALLBACK_APPEND = "FB";
    public static final String COPY_STATUS_SUCCESS = "success";
    public static final String COPY_STATUS_PENDING = "pending";
    public static final String COPY_STATUS_ABORTED = "aborted";
    public static final String COPY_STATUS_FAILED = "failed";

    private AbfsHttpConstants() {
    }

    public static enum ApiVersion {
        DEC_12_2019("2019-12-12"),
        APR_10_2021("2021-04-10"),
        AUG_03_2023("2023-08-03"),
        NOV_04_2024("2024-11-04");

        private final String xMsApiVersion;

        private ApiVersion(String xMsApiVersion) {
            this.xMsApiVersion = xMsApiVersion;
        }

        public String toString() {
            return this.xMsApiVersion;
        }

        public static ApiVersion getCurrentVersion() {
            return NOV_04_2024;
        }
    }
}

