/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.utils;

import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.fs.azurebfs.utils.UriUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public final class TestUriUtils {
    @Test
    public void testIfUriContainsAbfs() throws Exception {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)UriUtils.containsAbfsUrl((String)"abfs.dfs.core.windows.net"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)UriUtils.containsAbfsUrl((String)"abfs.dfs.preprod.core.windows.net"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)UriUtils.containsAbfsUrl((String)"abfs.dfs.cores.windows.net"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)UriUtils.containsAbfsUrl((String)""));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)UriUtils.containsAbfsUrl(null));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)UriUtils.containsAbfsUrl((String)"abfs.dfs.cores.windows.net"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)UriUtils.containsAbfsUrl((String)"xhdfs.blob.core.windows.net"));
    }

    @Test
    public void testExtractRawAccountName() throws Exception {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abfs", (Object)UriUtils.extractAccountNameFromHostName((String)"abfs.dfs.core.windows.net"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abfs", (Object)UriUtils.extractAccountNameFromHostName((String)"abfs.dfs.preprod.core.windows.net"));
        org.junit.jupiter.api.Assertions.assertEquals(null, (Object)UriUtils.extractAccountNameFromHostName((String)"abfs.dfs.cores.windows.net"));
        org.junit.jupiter.api.Assertions.assertEquals(null, (Object)UriUtils.extractAccountNameFromHostName((String)""));
        org.junit.jupiter.api.Assertions.assertEquals(null, (Object)UriUtils.extractAccountNameFromHostName(null));
        org.junit.jupiter.api.Assertions.assertEquals(null, (Object)UriUtils.extractAccountNameFromHostName((String)"abfs.dfs.cores.windows.net"));
    }

    @Test
    public void testMaskUrlQueryParameters() throws Exception {
        HashSet<String> fullMask = new HashSet<String>(Arrays.asList("abc", "bcd"));
        HashSet<String> partialMask = new HashSet<String>(Arrays.asList("pqr", "xyz"));
        List keyValueList = URLEncodedUtils.parse((String)"abc=123&pqr=45678&def=789&bcd=012&xyz=678", (Charset)StandardCharsets.UTF_8);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abc=XXXXX&pqr=456XX&def=789&bcd=XXXXX&xyz=67X", (Object)UriUtils.maskUrlQueryParameters((List)keyValueList, fullMask, partialMask), (String)"Incorrect masking");
        keyValueList = URLEncodedUtils.parse((String)"abc=123&pqr=256877f2-c094-48c8-83df-ddb5825694fd&def=789", (Charset)StandardCharsets.UTF_8);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abc=XXXXX&pqr=256877f2-c094-48c8XXXXXXXXXXXXXXXXXX&def=789", (Object)UriUtils.maskUrlQueryParameters((List)keyValueList, fullMask, partialMask), (String)"Incorrect partial masking for guid");
        partialMask.add("abc");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abc=XXXXX&pqr=256877f2-c094-48c8XXXXXXXXXXXXXXXXXX&def=789", (Object)UriUtils.maskUrlQueryParameters((List)keyValueList, fullMask, partialMask), (String)"Full mask should apply");
        keyValueList = URLEncodedUtils.parse((String)"abc=123&pqr=4561234&abc=789", (Charset)StandardCharsets.UTF_8);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abc=XXXXX&pqr=4561XXX&abc=XXXXX", (Object)UriUtils.maskUrlQueryParameters((List)keyValueList, fullMask, partialMask), (String)"Duplicate key: Both values should get masked");
        keyValueList = URLEncodedUtils.parse((String)"abc=123&def=456&pqrs=789&def=000", (Charset)StandardCharsets.UTF_8);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abc=XXXXX&def=456&pqrs=789&def=000", (Object)UriUtils.maskUrlQueryParameters((List)keyValueList, fullMask, partialMask), (String)"Duplicate key: Values should not get masked");
        keyValueList = URLEncodedUtils.parse((String)"abc=123&def=&pqr=789&s=1", (Charset)StandardCharsets.UTF_8);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abc=XXXXX&def=&pqr=78X&s=1", (Object)UriUtils.maskUrlQueryParameters((List)keyValueList, fullMask, partialMask), (String)"Incorrect url with empty query value");
        keyValueList = URLEncodedUtils.parse((String)"def=2&pqr=789&s=1", (Charset)StandardCharsets.UTF_8);
        keyValueList.add(new BasicNameValuePair("", "m1"));
        List finalKeyValueList = keyValueList;
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> UriUtils.maskUrlQueryParameters((List)finalKeyValueList, (Set)fullMask, (Set)partialMask));
        keyValueList = URLEncodedUtils.parse((String)"abc=123&s=1", (Charset)StandardCharsets.UTF_8);
        keyValueList.add(new BasicNameValuePair("null1", null));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abc=XXXXX&s=1&null1=", (Object)UriUtils.maskUrlQueryParameters((List)keyValueList, fullMask, partialMask), (String)"Null value, incorrect query construction");
        keyValueList.add(new BasicNameValuePair("null2", null));
        fullMask.add("null2");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abc=XXXXX&s=1&null1=&null2=", (Object)UriUtils.maskUrlQueryParameters((List)keyValueList, fullMask, partialMask), (String)"No mask should be added for null value");
    }

    @Test
    public void testConvertUrlFromDfsToBlob() throws Exception {
        List<String> inputUrls = Arrays.asList("https://accountName.dfs.core.windows.net/containerName", "https://accountName.blob.core.windows.net/containerName", "https:/accountName.dfs.core.windows.net/containerName", "https://accountNamedfs.dfs.core.windows.net/containerName", "https://accountNameblob.dfs.core.windows.net/containerName", "https://accountName.dfs.core.windows.net/dfsContainer", "https://accountName.dfs.core.windows.net/blobcontainerName", "https://accountName.dfs.core.windows.net/dfs.Container", "https://accountName.dfs.core.windows.net/blob.containerName");
        List<String> expectedUrls = Arrays.asList("https://accountName.blob.core.windows.net/containerName", "https://accountName.blob.core.windows.net/containerName", "https:/accountName.dfs.core.windows.net/containerName", "https://accountNamedfs.blob.core.windows.net/containerName", "https://accountNameblob.blob.core.windows.net/containerName", "https://accountName.blob.core.windows.net/dfsContainer", "https://accountName.blob.core.windows.net/blobcontainerName", "https://accountName.blob.core.windows.net/dfs.Container", "https://accountName.blob.core.windows.net/blob.containerName");
        for (int i = 0; i < inputUrls.size(); ++i) {
            ((AbstractStringAssert)Assertions.assertThat((String)UriUtils.changeUrlFromDfsToBlob((URL)new URL(inputUrls.get(i))).toString()).describedAs("URL conversion not as expected", new Object[0])).isEqualTo((Object)expectedUrls.get(i));
        }
    }

    @Test
    public void testConvertUrlFromBlobToDfs() throws Exception {
        List<String> inputUrls = Arrays.asList("https://accountName.blob.core.windows.net/containerName", "https://accountName.dfs.core.windows.net/containerName", "https://accountNamedfs.blob.core.windows.net/containerName", "https://accountNameblob.blob.core.windows.net/containerName", "https://accountName.blob.core.windows.net/dfsContainer", "https://accountName.blob.core.windows.net/blobcontainerName", "https://accountName.blob.core.windows.net/dfs.Container", "https://accountName.blob.core.windows.net/blob.containerName");
        List<String> expectedUrls = Arrays.asList("https://accountName.dfs.core.windows.net/containerName", "https://accountName.dfs.core.windows.net/containerName", "https://accountNamedfs.dfs.core.windows.net/containerName", "https://accountNameblob.dfs.core.windows.net/containerName", "https://accountName.dfs.core.windows.net/dfsContainer", "https://accountName.dfs.core.windows.net/blobcontainerName", "https://accountName.dfs.core.windows.net/dfs.Container", "https://accountName.dfs.core.windows.net/blob.containerName");
        for (int i = 0; i < inputUrls.size(); ++i) {
            ((AbstractStringAssert)Assertions.assertThat((String)UriUtils.changeUrlFromBlobToDfs((URL)new URL(inputUrls.get(i))).toString()).describedAs("Url Conversion Not as Expected", new Object[0])).isEqualTo((Object)expectedUrls.get(i));
        }
    }
}

