/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.utils.ListUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

public class TestListUtils {
    @Test
    public void testRemoveDuplicates() {
        ArrayList<Object> originalList = new ArrayList<FileStatus>();
        this.validateList(originalList, 0);
        originalList = new ArrayList();
        originalList.add(this.getFileStatusObject(new Path("/A")));
        this.validateList(originalList, 1);
        originalList = new ArrayList();
        originalList.add(this.getFileStatusObject(new Path("/A")));
        originalList.add(this.getFileStatusObject(new Path("/A")));
        this.validateList(originalList, 1);
        originalList = new ArrayList();
        originalList.add(this.getFileStatusObject(new Path("/a")));
        originalList.add(this.getFileStatusObject(new Path("/a.bak1")));
        originalList.add(this.getFileStatusObject(new Path("/a.bak1.bak2")));
        originalList.add(this.getFileStatusObject(new Path("/a.bak1.bak2")));
        originalList.add(this.getFileStatusObject(new Path("/a.bak1")));
        originalList.add(this.getFileStatusObject(new Path("/a")));
        originalList.add(this.getFileStatusObject(new Path("/abc")));
        originalList.add(this.getFileStatusObject(new Path("/abc.bak1")));
        originalList.add(this.getFileStatusObject(new Path("/abc")));
        this.validateList(originalList, 5);
        originalList = new ArrayList();
        originalList.add(this.getFileStatusObject(new Path("/a")));
        originalList.add(this.getFileStatusObject(new Path("/a")));
        originalList.add(this.getFileStatusObject(new Path("/a_bak1")));
        originalList.add(this.getFileStatusObject(new Path("/a_bak1")));
        originalList.add(this.getFileStatusObject(new Path("/a_bak1_bak2")));
        originalList.add(this.getFileStatusObject(new Path("/a_bak1_bak2")));
        originalList.add(this.getFileStatusObject(new Path("/abc")));
        originalList.add(this.getFileStatusObject(new Path("/abc")));
        originalList.add(this.getFileStatusObject(new Path("/abc_bak1")));
        this.validateList(originalList, 5);
        originalList = new ArrayList();
        originalList.add(this.getFileStatusObject(new Path("/a")));
        originalList.add(this.getFileStatusObject(new Path("/b")));
        this.validateList(originalList, 2);
        originalList = new ArrayList();
        originalList.add(this.getFileStatusObject(new Path("/a")));
        originalList.add(this.getFileStatusObject(new Path("/b")));
        originalList.add(this.getFileStatusObject(new Path("/b")));
        this.validateList(originalList, 2);
    }

    private void validateList(List<FileStatus> originalList, int expectedSize) {
        List uniqueList = ListUtils.getUniqueListResult(originalList);
        ((ListAssert)Assertions.assertThat((List)uniqueList).describedAs("List Size is not as expected after duplicate removal", new Object[0])).hasSize(expectedSize);
    }

    private FileStatus getFileStatusObject(Path path) {
        FileStatus status = new FileStatus();
        status.setPath(path);
        return status;
    }
}

