/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.utils;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.utils.DirectoryStateHelper;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAzcopyToolHelper
extends AbstractAbfsIntegrationTest {
    @Test
    public void testGetAzcopyToolCommand() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path filePath = this.path("dir/file.txt");
        Path implicitDirPath = this.path("dir1");
        Path explicitDirPath = this.path("dir2/dir3");
        Path nonExistentPath = this.path("dir/nonexistent");
        this.createAzCopyFile(filePath);
        this.createAzCopyFolder(implicitDirPath);
        fs.mkdirs(explicitDirPath);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isImplicitDirectory(filePath.getParent(), fs, this.getTestTracingContext(fs, false))).describedAs("File created by azcopy should have implicit parent", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isImplicitDirectory(implicitDirPath, fs, this.getTestTracingContext(fs, false))).describedAs("Folder created by azcopy should be implicit", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isExplicitDirectory(explicitDirPath, fs, this.getTestTracingContext(fs, false))).describedAs("Folder created by azcopy should be implicit", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isExplicitDirectory(explicitDirPath.getParent(), fs, this.getTestTracingContext(fs, false))).describedAs("Folder created by azcopy should be implicit", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isImplicitDirectory(filePath, fs, this.getTestTracingContext(fs, false))).describedAs("Folder created by azcopy should be implicit", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isExplicitDirectory(filePath, fs, this.getTestTracingContext(fs, false))).describedAs("Folder created by azcopy should be implicit", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isImplicitDirectory(nonExistentPath, fs, this.getTestTracingContext(fs, false))).describedAs("Folder created by azcopy should be implicit", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)DirectoryStateHelper.isExplicitDirectory(nonExistentPath, fs, this.getTestTracingContext(fs, false))).describedAs("Folder created by azcopy should be implicit", new Object[0])).isFalse();
    }
}

