/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.utils;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlobClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.assertj.core.api.Assumptions;

public final class DirectoryStateHelper {
    private DirectoryStateHelper() {
    }

    public static boolean isImplicitDirectory(Path path, AzureBlobFileSystem fs, TracingContext testTracingContext) throws Exception {
        Assumptions.assumeThat((boolean)fs.getAbfsStore().getIsNamespaceEnabled(testTracingContext)).isFalse();
        path = new Path(fs.makeQualified(path).toUri().getPath());
        String relativePath = fs.getAbfsStore().getRelativePath(path);
        AbfsBlobClient client = fs.getAbfsStore().getClientHandler().getBlobClient();
        try {
            client.getPathStatus(relativePath, testTracingContext, null, false);
            return false;
        }
        catch (AbfsRestOperationException ex) {
            int listSize;
            if (ex.getStatusCode() != 404) {
                return false;
            }
            AbfsRestOperation op = client.listPath(relativePath, false, 1, null, testTracingContext, null).getOp();
            return op != null && op.getResult() != null && (listSize = op.getResult().getListResultSchema().paths().size()) > 0;
        }
    }

    public static boolean isExplicitDirectory(Path path, AzureBlobFileSystem fs, TracingContext testTracingContext) throws Exception {
        if (path.isRoot()) {
            return true;
        }
        if (fs.getAbfsStore().getIsNamespaceEnabled(testTracingContext)) {
            try {
                return fs.getFileStatus(path).isDirectory();
            }
            catch (Exception ex) {
                return false;
            }
        }
        path = new Path(fs.makeQualified(path).toUri().getPath());
        AbfsBlobClient client = fs.getAbfsStore().getClientHandler().getBlobClient();
        AbfsRestOperation op = null;
        try {
            op = client.getPathStatus(fs.getAbfsStore().getRelativePath(path), testTracingContext, null, false);
            return client.checkIsDir(op.getResult());
        }
        catch (Exception ex) {
            return false;
        }
    }
}

