/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.utils;

import java.time.Instant;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.azurebfs.services.AbfsUriQueryBuilder;
import org.apache.hadoop.fs.azurebfs.utils.SASGenerator;

public class DelegationSASGenerator
extends SASGenerator {
    private final String skoid;
    private final String sktid;
    private final String skt;
    private final String ske;
    private final String sks = "b";
    private final String skv;

    public DelegationSASGenerator(byte[] userDelegationKey, String skoid, String sktid, String skt, String ske, String skv) {
        super(userDelegationKey);
        this.skoid = skoid;
        this.sktid = sktid;
        this.skt = skt;
        this.ske = ske;
        this.skv = skv;
    }

    public String getDelegationSAS(String accountName, String containerName, String path, String operation, String saoid, String suoid, String scid) {
        String sp;
        String sv = SASGenerator.AuthenticationVersion.Feb20.toString();
        String st = ISO_8601_FORMATTER.format(Instant.now().minus(FIVE_MINUTES));
        String se = ISO_8601_FORMATTER.format(Instant.now().plus(ONE_DAY));
        String sr = "b";
        String sdd = null;
        switch (operation) {
            case "create-file": 
            case "create-directory": 
            case "write": 
            case "set-properties": 
            case "lease-blob": 
            case "copy-blob-dst": {
                sp = "w";
                break;
            }
            case "delete": {
                sp = "d";
                break;
            }
            case "delete-recursive": {
                sp = "d";
                sr = "d";
                sdd = path.equals("/") ? "0" : Integer.toString(StringUtils.countMatches((CharSequence)path, (CharSequence)"/"));
                break;
            }
            case "check-access": 
            case "get-acl": 
            case "get-status": {
                sp = "e";
                break;
            }
            case "list-blob": {
                sp = "l";
                sr = "c";
                break;
            }
            case "list": {
                sp = "l";
                sr = "d";
                sdd = path.equals("/") ? "0" : Integer.toString(StringUtils.countMatches((CharSequence)path, (CharSequence)"/"));
                break;
            }
            case "get-properties": 
            case "read": 
            case "copy-blob-src": {
                sp = "r";
                break;
            }
            case "rename-destination": 
            case "rename-source": {
                sp = "m";
                break;
            }
            case "set-acl": 
            case "set-permission": {
                sp = "p";
                break;
            }
            case "set-owner": {
                sp = "o";
                break;
            }
            default: {
                throw new IllegalArgumentException(operation);
            }
        }
        String signature = this.computeSignatureForSAS(sp, st, se, sv, sr, accountName, containerName, path, saoid, suoid, scid);
        AbfsUriQueryBuilder qb = new AbfsUriQueryBuilder();
        qb.addQuery("skoid", this.skoid);
        qb.addQuery("sktid", this.sktid);
        qb.addQuery("skt", this.skt);
        qb.addQuery("ske", this.ske);
        qb.addQuery("sks", "b");
        qb.addQuery("skv", this.skv);
        if (saoid != null) {
            qb.addQuery("saoid", saoid);
        }
        if (suoid != null) {
            qb.addQuery("suoid", suoid);
        }
        if (scid != null) {
            qb.addQuery("scid", scid);
        }
        qb.addQuery("sp", sp);
        qb.addQuery("st", st);
        qb.addQuery("se", se);
        qb.addQuery("sv", sv);
        qb.addQuery("sr", sr);
        if (sdd != null) {
            qb.addQuery("sdd", sdd);
        }
        qb.addQuery("sig", signature);
        return qb.toString().substring(1);
    }

    private String computeSignatureForSAS(String sp, String st, String se, String sv, String sr, String accountName, String containerName, String path, String saoid, String suoid, String scid) {
        StringBuilder sb = new StringBuilder();
        sb.append(sp);
        sb.append("\n");
        sb.append(st);
        sb.append("\n");
        sb.append(se);
        sb.append("\n");
        sb.append("/blob/");
        sb.append(accountName);
        sb.append("/");
        sb.append(containerName);
        if (path != null && !sr.equals("c")) {
            sb.append(path);
        }
        sb.append("\n");
        sb.append(this.skoid);
        sb.append("\n");
        sb.append(this.sktid);
        sb.append("\n");
        sb.append(this.skt);
        sb.append("\n");
        sb.append(this.ske);
        sb.append("\n");
        sb.append("b");
        sb.append("\n");
        sb.append(this.skv);
        sb.append("\n");
        if (saoid != null) {
            sb.append(saoid);
        }
        sb.append("\n");
        if (suoid != null) {
            sb.append(suoid);
        }
        sb.append("\n");
        if (scid != null) {
            sb.append(scid);
        }
        sb.append("\n");
        sb.append("\n");
        sb.append("\n");
        sb.append(sv);
        sb.append("\n");
        sb.append(sr);
        sb.append("\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("\n");
        String stringToSign = sb.toString();
        LOG.debug("Delegation SAS stringToSign: " + stringToSign.replace("\n", "."));
        return this.computeHmac256(stringToSign);
    }
}

