/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.utils;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageCredentialsAccountAndKey;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupTestContainers
extends AbstractAbfsIntegrationTest {
    private static final Logger LOG = LoggerFactory.getLogger(CleanupTestContainers.class);
    private static final String CONTAINER_PREFIX = "abfs-testcontainer-";

    @Test
    public void testDeleteContainers() throws Throwable {
        int count = 0;
        AbfsConfiguration abfsConfig = this.getAbfsStore(this.getFileSystem()).getAbfsConfiguration();
        String accountName = abfsConfig.getAccountName().split("\\.")[0];
        LOG.debug("Deleting test containers in account - {}", (Object)abfsConfig.getAccountName());
        String accountKey = abfsConfig.getStorageAccountKey();
        if (accountKey == null || accountKey.isEmpty()) {
            LOG.debug("Clean up not possible. Account ket not present in config");
        }
        StorageCredentialsAccountAndKey credentials = new StorageCredentialsAccountAndKey(accountName, accountKey);
        CloudStorageAccount storageAccount = new CloudStorageAccount((StorageCredentials)credentials, true);
        CloudBlobClient blobClient = storageAccount.createCloudBlobClient();
        Iterable containers = blobClient.listContainers(CONTAINER_PREFIX);
        for (CloudBlobContainer container : containers) {
            LOG.info("Container {} URI {}", (Object)container.getName(), (Object)container.getUri());
            if (!container.deleteIfExists()) continue;
            LOG.info("Current deleted test containers count - #{}", (Object)(++count));
        }
        LOG.info("Summary: Deleted {} test containers", (Object)count);
    }
}

