/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.utils;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.assertj.core.api.Assumptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AbfsTestUtils
extends AbstractAbfsIntegrationTest {
    private static final Logger LOG = LoggerFactory.getLogger(AbfsTestUtils.class);
    private static final int TOTAL_THREADS_IN_POOL = 5;

    public void checkContainers() throws Throwable {
        Assumptions.assumeThat((Comparable)this.getAuthType()).isEqualTo((Object)AuthType.SharedKey);
        int count = 0;
        CloudStorageAccount storageAccount = AzureBlobStorageTestAccount.createTestAccount();
        CloudBlobClient blobClient = storageAccount.createCloudBlobClient();
        Iterable containers = blobClient.listContainers("abfs-testcontainer-");
        for (CloudBlobContainer container : containers) {
            ++count;
            LOG.info("Container {}, URI {}", (Object)container.getName(), (Object)container.getUri());
        }
        LOG.info("Found {} test containers", (Object)count);
    }

    public void deleteContainers() throws Throwable {
        Assumptions.assumeThat((Comparable)this.getAuthType()).isEqualTo((Object)AuthType.SharedKey);
        int count = 0;
        CloudStorageAccount storageAccount = AzureBlobStorageTestAccount.createTestAccount();
        CloudBlobClient blobClient = storageAccount.createCloudBlobClient();
        Iterable containers = blobClient.listContainers("abfs-testcontainer-");
        for (CloudBlobContainer container : containers) {
            LOG.info("Container {} URI {}", (Object)container.getName(), (Object)container.getUri());
            if (!container.deleteIfExists()) continue;
            ++count;
        }
        LOG.info("Deleted {} test containers", (Object)count);
    }

    public static void disableFilesystemCaching(Configuration conf) {
        conf.setBoolean(String.format("fs.%s.impl.disable.cache", "abfs"), true);
        conf.setBoolean(String.format("fs.%s.impl.disable.cache", "abfss"), true);
    }

    public static void createFiles(AzureBlobFileSystem fs, Path path, int numFiles) throws ExecutionException, InterruptedException {
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        ArrayList<Future<FSDataOutputStream>> futures = new ArrayList<Future<FSDataOutputStream>>();
        int i = 0;
        while (i < numFiles) {
            int n = i++;
            Future<FSDataOutputStream> future = executorService.submit(() -> fs.create(new Path(path, "file" + iter + ".txt")));
            futures.add(future);
        }
        for (Future future : futures) {
            future.get();
        }
        executorService.shutdown();
    }
}

