/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ClosedIOException;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsTestWithTimeout;
import org.apache.hadoop.fs.azurebfs.services.KeepAliveCache;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.http.HttpClientConnection;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestApacheClientConnectionPool
extends AbstractAbfsTestWithTimeout {
    @Test
    public void testPoolSizeWithNotConfigured() throws Exception {
        Configuration configuration = new Configuration();
        configuration.unset("fs.azure.apache.http.client.max.cache.size");
        AbfsConfiguration abfsConfiguration = new AbfsConfiguration(configuration, "");
        try (KeepAliveCache keepAliveCache = new KeepAliveCache(abfsConfiguration);){
            ((AbstractIntegerAssert)Assertions.assertThat((int)keepAliveCache.getMaxCacheConnections()).describedAs("In case configured cache size is 0, the pool size should be minimum possible value", new Object[0])).isEqualTo(10);
            this.assertCachePutSuccess(keepAliveCache, this.getValidMockConnection());
            this.assertCacheGetIsNonNull(keepAliveCache);
        }
    }

    @Test
    public void testEmptySizePool() throws Exception {
        Configuration configuration = new Configuration();
        configuration.set("fs.azure.apache.http.client.max.cache.size", "0");
        AbfsConfiguration abfsConfiguration = new AbfsConfiguration(configuration, "");
        try (KeepAliveCache keepAliveCache = new KeepAliveCache(abfsConfiguration);){
            ((AbstractIntegerAssert)Assertions.assertThat((int)keepAliveCache.getMaxCacheConnections()).describedAs("In case configured cache size is 0, the pool size should be minimum possible value", new Object[0])).isEqualTo(5);
            this.assertCachePutSuccess(keepAliveCache, this.getValidMockConnection());
            this.assertCacheGetIsNonNull(keepAliveCache);
        }
    }

    private HttpClientConnection getValidMockConnection() {
        HttpClientConnection connection = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        ((HttpClientConnection)Mockito.doReturn((Object)true).when((Object)connection)).isOpen();
        return connection;
    }

    private void assertCacheGetIsNull(KeepAliveCache keepAliveCache) throws IOException {
        ((ObjectAssert)Assertions.assertThat((Object)keepAliveCache.get()).describedAs("cache.get()", new Object[0])).isNull();
    }

    private void assertCacheGetIsNonNull(KeepAliveCache keepAliveCache) throws IOException {
        ((ObjectAssert)Assertions.assertThat((Object)keepAliveCache.get()).describedAs("cache.get()", new Object[0])).isNotNull();
    }

    private void assertCachePutFail(KeepAliveCache keepAliveCache, HttpClientConnection mock) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)keepAliveCache.add(mock)).describedAs("cache.put()", new Object[0])).isFalse();
    }

    private void assertCachePutSuccess(KeepAliveCache keepAliveCache, HttpClientConnection connections) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)keepAliveCache.add(connections)).describedAs("cache.put()", new Object[0])).isTrue();
    }

    private void validatePoolSize(int size) throws Exception {
        try (KeepAliveCache keepAliveCache = new KeepAliveCache(new AbfsConfiguration(new Configuration(), ""));){
            int i;
            keepAliveCache.clear();
            HttpClientConnection[] connections = new HttpClientConnection[size * 2];
            for (i = 0; i < size * 2; ++i) {
                connections[i] = this.getValidMockConnection();
            }
            for (i = 0; i < size; ++i) {
                this.assertCachePutSuccess(keepAliveCache, connections[i]);
                ((HttpClientConnection)Mockito.verify((Object)connections[i], (VerificationMode)Mockito.times((int)0))).close();
            }
            for (i = size; i < size * 2; ++i) {
                this.assertCachePutSuccess(keepAliveCache, connections[i]);
                ((HttpClientConnection)Mockito.verify((Object)connections[i - size], (VerificationMode)Mockito.times((int)1))).close();
            }
            for (i = 0; i < size * 2; ++i) {
                if (i < size) {
                    this.assertCacheGetIsNonNull(keepAliveCache);
                    continue;
                }
                this.assertCacheGetIsNull(keepAliveCache);
            }
        }
    }

    @Test
    public void testKeepAliveCache() throws Exception {
        try (KeepAliveCache keepAliveCache = new KeepAliveCache(new AbfsConfiguration(new Configuration(), ""));){
            keepAliveCache.clear();
            keepAliveCache.add(this.getValidMockConnection());
            this.assertCacheGetIsNonNull(keepAliveCache);
        }
    }

    @Test
    public void testKeepAliveCacheCleanupWithConnections() throws Exception {
        Configuration configuration = new Configuration();
        try (KeepAliveCache keepAliveCache = new KeepAliveCache(new AbfsConfiguration(configuration, ""));){
            keepAliveCache.clear();
            HttpClientConnection connection = this.getValidMockConnection();
            keepAliveCache.add(connection);
            ((HttpClientConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)0))).close();
            ((HttpClientConnection)Mockito.doReturn((Object)false).when((Object)connection)).isOpen();
            this.assertCacheGetIsNull(keepAliveCache);
            ((HttpClientConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).close();
        }
    }

    @Test
    public void testKeepAliveCacheConnectionRecache() throws Exception {
        try (KeepAliveCache keepAliveCache = new KeepAliveCache(new AbfsConfiguration(new Configuration(), ""));){
            keepAliveCache.clear();
            HttpClientConnection connection = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
            ((HttpClientConnection)Mockito.doReturn((Object)true).when((Object)connection)).isOpen();
            keepAliveCache.add(connection);
            this.assertCacheGetIsNonNull(keepAliveCache);
            keepAliveCache.add(connection);
            this.assertCacheGetIsNonNull(keepAliveCache);
        }
    }

    @Test
    public void testKeepAliveCacheRemoveStaleConnection() throws Exception {
        try (KeepAliveCache keepAliveCache = new KeepAliveCache(new AbfsConfiguration(new Configuration(), ""));){
            int i;
            keepAliveCache.clear();
            HttpClientConnection[] connections = new HttpClientConnection[10];
            for (i = 0; i < 10; ++i) {
                connections[i] = this.getValidMockConnection();
                keepAliveCache.add(connections[i]);
            }
            for (i = 0; i < 8; ++i) {
                ((HttpClientConnection)Mockito.doReturn((Object)true).when((Object)connections[i])).isStale();
            }
            for (i = 9; i >= 0; --i) {
                if (i >= 8) {
                    this.assertCacheGetIsNonNull(keepAliveCache);
                    continue;
                }
                this.assertCacheGetIsNull(keepAliveCache);
                ((HttpClientConnection)Mockito.verify((Object)connections[i], (VerificationMode)Mockito.times((int)1))).close();
            }
        }
    }

    @Test
    public void testKeepAliveCacheClosed() throws Exception {
        KeepAliveCache keepAliveCache = (KeepAliveCache)Mockito.spy((Object)new KeepAliveCache(new AbfsConfiguration(new Configuration(), "")));
        keepAliveCache.add((HttpClientConnection)Mockito.mock(HttpClientConnection.class));
        keepAliveCache.close();
        LambdaTestUtils.intercept(ClosedIOException.class, (String)"KeepAliveCache is closed", () -> ((KeepAliveCache)keepAliveCache).get());
        HttpClientConnection conn = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        this.assertCachePutFail(keepAliveCache, conn);
        ((HttpClientConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)1))).close();
        keepAliveCache.close();
        ((KeepAliveCache)Mockito.verify((Object)keepAliveCache, (VerificationMode)Mockito.times((int)1))).closeInternal();
    }

    @Test
    public void keepAliveCacheShouldRemoveStaleConnectionsOnAdd() throws Exception {
        try (KeepAliveCache keepAliveCache = new KeepAliveCache(new AbfsConfiguration(new Configuration(), ""));){
            keepAliveCache.clear();
            HttpClientConnection staleConnection = this.getValidMockConnection();
            ((HttpClientConnection)Mockito.doReturn((Object)true).when((Object)staleConnection)).isStale();
            keepAliveCache.add(staleConnection);
            ((ObjectAssert)Assertions.assertThat((Object)keepAliveCache.get()).describedAs("Getting from cache after adding stale connection should return null", new Object[0])).isNull();
            ((HttpClientConnection)Mockito.verify((Object)staleConnection, (VerificationMode)Mockito.times((int)1))).close();
        }
    }

    @Test
    public void keepAliveCacheClosedTwiceShouldNotThrowException() throws Exception {
        KeepAliveCache keepAliveCache = (KeepAliveCache)Mockito.spy((Object)new KeepAliveCache(new AbfsConfiguration(new Configuration(), "")));
        keepAliveCache.close();
        keepAliveCache.close();
        ((KeepAliveCache)Mockito.verify((Object)keepAliveCache, (VerificationMode)Mockito.times((int)1))).closeInternal();
    }

    @Test
    public void testKeepAliveCacheShouldHandleNullConnectionsGracefully() throws Exception {
        try (KeepAliveCache keepAliveCache = new KeepAliveCache(new AbfsConfiguration(new Configuration(), ""));){
            keepAliveCache.clear();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)keepAliveCache.add(null)).describedAs("Adding null connection should return false", new Object[0])).isFalse();
            ((ObjectAssert)Assertions.assertThat((Object)keepAliveCache.get()).describedAs("Getting from cache with no valid connections should return null", new Object[0])).isNull();
        }
    }

    @Test
    public void testKeepAliveCacheShouldNotAddClosedConnections() throws Exception {
        try (KeepAliveCache keepAliveCache = new KeepAliveCache(new AbfsConfiguration(new Configuration(), ""));){
            keepAliveCache.clear();
            HttpClientConnection connection = this.getValidMockConnection();
            ((HttpClientConnection)Mockito.doReturn((Object)false).when((Object)connection)).isOpen();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)keepAliveCache.add(connection)).describedAs("Adding closed connection should return false", new Object[0])).isFalse();
            ((HttpClientConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).close();
        }
    }

    @Test
    public void testKeepAliveCacheCloseWithMultipleConnections() throws Exception {
        try (KeepAliveCache keepAliveCache = new KeepAliveCache(new AbfsConfiguration(new Configuration(), ""));){
            keepAliveCache.clear();
            HttpClientConnection[] connections = new HttpClientConnection[10];
            for (int i = 0; i < connections.length; ++i) {
                connections[i] = this.getValidMockConnection();
                keepAliveCache.add(connections[i]);
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)keepAliveCache.getSingleThreadPool().isShutdown()).describedAs("singleThreadPool should not be shutdown", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)keepAliveCache.getFixedThreadPool().isShutdown()).describedAs("fixedThreadPool should not be shutdown", new Object[0])).isFalse();
            keepAliveCache.close();
            for (HttpClientConnection connection : connections) {
                ((HttpClientConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).close();
            }
            ((AbstractIntegerAssert)Assertions.assertThat((int)keepAliveCache.size()).describedAs("Cache should be empty after closing", new Object[0])).isEqualTo(0);
            LambdaTestUtils.intercept(ClosedIOException.class, (String)"KeepAliveCache is closed", () -> ((KeepAliveCache)keepAliveCache).get());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)keepAliveCache.getSingleThreadPool().isShutdown()).describedAs("singleThreadPool should be shutdown after close()", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)keepAliveCache.getFixedThreadPool().isShutdown()).describedAs("fixedThreadPool should be shutdown after close()", new Object[0])).isTrue();
        }
    }

    @Test
    public void testKeepAliveCacheStaleConnectionHandling() throws Exception {
        try (KeepAliveCache keepAliveCache = new KeepAliveCache(new AbfsConfiguration(new Configuration(), ""));){
            keepAliveCache.clear();
            HttpClientConnection connection = this.getValidMockConnection();
            keepAliveCache.add(connection);
            ((AbstractIntegerAssert)Assertions.assertThat((int)keepAliveCache.size()).describedAs("Cache size should be 1 after adding a connection", new Object[0])).isEqualTo(1);
            ((HttpClientConnection)Mockito.doReturn((Object)true).when((Object)connection)).isStale();
            ((ObjectAssert)Assertions.assertThat((Object)keepAliveCache.get()).describedAs("Getting from cache after connection becomes stale should return null", new Object[0])).isNull();
            ((HttpClientConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).close();
        }
    }

    @Test
    public void testKeepAliveCacheMaxSizeLimit() throws Exception {
        try (KeepAliveCache keepAliveCache = new KeepAliveCache(new AbfsConfiguration(new Configuration(), ""));){
            keepAliveCache.clear();
            HttpClientConnection[] connections = new HttpClientConnection[11];
            for (int i = 0; i < connections.length; ++i) {
                connections[i] = this.getValidMockConnection();
                keepAliveCache.add(connections[i]);
            }
            ((AbstractIntegerAssert)Assertions.assertThat((int)keepAliveCache.size()).describedAs("Cache size should not exceed the maximum allowed size", new Object[0])).isEqualTo(10);
            ((HttpClientConnection)Mockito.verify((Object)connections[0], (VerificationMode)Mockito.times((int)1))).close();
        }
    }
}

