/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.enums.AbfsBackoffMetricsEnum;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperationType;
import org.apache.hadoop.fs.azurebfs.services.ITestAbfsClient;
import org.apache.hadoop.fs.azurebfs.utils.MetricFormat;
import org.junit.jupiter.api.Test;

public class TestAbfsRestOperation
extends AbstractAbfsIntegrationTest {
    private void checkPrerequisites() {
        this.assumeValidTestConfigPresent(this.getRawConfiguration(), "fs.azure.metric.account.name");
        this.assumeValidTestConfigPresent(this.getRawConfiguration(), "fs.azure.metric.account.key");
        this.assumeValidTestConfigPresent(this.getRawConfiguration(), "fs.azure.metric.uri");
    }

    @Test
    public void testBackoffRetryMetrics() throws Exception {
        this.checkPrerequisites();
        Configuration configuration = this.getRawConfiguration();
        configuration.set("fs.azure.metric.format", String.valueOf(MetricFormat.INTERNAL_BACKOFF_METRIC_FORMAT));
        AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)configuration);
        AbfsConfiguration abfsConfiguration = fs.getAbfsStore().getAbfsConfiguration();
        AbfsClient testClient = super.getAbfsClient(super.getAbfsStore(fs));
        AbfsRestOperation op = ITestAbfsClient.getRestOp(AbfsRestOperationType.DeletePath, testClient, "DELETE", ITestAbfsClient.getTestUrl(testClient, "/NonExistingPath"), ITestAbfsClient.getTestRequestHeaders(testClient), this.getConfiguration());
        ArrayList<String> retryCounts = new ArrayList<String>(Arrays.asList("35", "28", "31", "45", "10", "2", "9"));
        int statusCode = 503;
        for (String retryCount : retryCounts) {
            op.updateBackoffMetrics(Integer.parseInt(retryCount), statusCode);
        }
        TestAbfsRestOperation.assertEquals((Object)"3", (Object)String.valueOf(testClient.getAbfsCounters().getAbfsBackoffMetrics().getMetricValue(AbfsBackoffMetricsEnum.NUMBER_OF_REQUESTS_FAILED)), (String)"Number of failed requests does not match expected value.");
        fs.close();
    }
}

