/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import org.apache.hadoop.fs.azurebfs.services.AbfsReadFooterMetrics;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestAbfsReadFooterMetrics {
    private static final long CONTENT_LENGTH = 50000L;
    private static final int LENGTH = 10000;
    private static final int NEXT_READ_POS = 30000;
    private static final String TEST_FILE1 = "TestFile";
    private static final String TEST_FILE2 = "TestFile2";
    private AbfsReadFooterMetrics metrics;

    @BeforeEach
    public void setUp() {
        this.metrics = new AbfsReadFooterMetrics();
    }

    @Test
    public void metricsUpdateForFirstRead() {
        this.metrics.updateReadMetrics(TEST_FILE1, 10000, 50000L, 30000L);
        ((AbstractLongAssert)Assertions.assertThat((Long)this.metrics.getTotalFiles()).describedAs("Total number of files", new Object[0])).isEqualTo(0L);
    }

    @Test
    public void metricsUpdateForSecondRead() {
        this.metrics.updateReadMetrics(TEST_FILE1, 10000, 50000L, 30000L);
        this.metrics.updateReadMetrics(TEST_FILE1, 10000, 50000L, 40000L);
        ((AbstractLongAssert)Assertions.assertThat((Long)this.metrics.getTotalFiles()).describedAs("Total number of files", new Object[0])).isEqualTo(1L);
    }

    @Test
    public void metricsUpdateForOneFile() {
        this.metrics.updateReadMetrics(TEST_FILE1, 10000, 50000L, 30000L);
        this.metrics.updateReadMetrics(TEST_FILE1, 10000, 50000L, 40000L);
        this.metrics.updateReadMetrics(TEST_FILE1, 10000, 50000L, 50000L);
        ((AbstractLongAssert)Assertions.assertThat((Long)this.metrics.getTotalFiles()).describedAs("Total number of files", new Object[0])).isEqualTo(1L);
        ((AbstractStringAssert)Assertions.assertThat((String)this.metrics.toString()).describedAs("Metrics after reading 3 reads of the same file", new Object[0])).isEqualTo((Object)"$NON_PARQUET:$FR=10000.000_20000.000$SR=10000.000_10000.000$FL=50000.000$RL=10000.000");
    }

    @Test
    public void metricsUpdateForMultipleFiles() {
        this.metrics.updateReadMetrics(TEST_FILE1, 10000, 50000L, 30000L);
        this.metrics.updateReadMetrics(TEST_FILE1, 10000, 50000L, 40000L);
        this.metrics.updateReadMetrics(TEST_FILE1, 10000, 50000L, 50000L);
        this.metrics.updateReadMetrics(TEST_FILE2, 10000, 25000L, 30000L);
        this.metrics.updateReadMetrics(TEST_FILE2, 10000, 25000L, 40000L);
        this.metrics.updateReadMetrics(TEST_FILE2, 10000, 25000L, 50000L);
        ((AbstractLongAssert)Assertions.assertThat((Long)this.metrics.getTotalFiles()).describedAs("Total number of files", new Object[0])).isEqualTo(2L);
        ((AbstractStringAssert)Assertions.assertThat((String)this.metrics.toString()).describedAs("Metrics after reading 3 reads of the same file", new Object[0])).isEqualTo((Object)"$NON_PARQUET:$FR=10000.000_12500.000$SR=10000.000_10000.000$FL=37500.000$RL=10000.000");
    }
}

