/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.constants.AbfsServiceType;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.contracts.services.AppendRequestParameters;
import org.apache.hadoop.fs.azurebfs.security.ContextEncryptionAdapter;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientHandler;
import org.apache.hadoop.fs.azurebfs.services.AbfsDfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStream;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStreamContext;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStreamStatistics;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStreamStatisticsImpl;
import org.apache.hadoop.fs.azurebfs.services.AbfsPerfTracker;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AzureIngressHandler;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderFormat;
import org.apache.hadoop.fs.store.DataBlocks;
import org.apache.hadoop.util.BlockingThreadPoolExecutorService;
import org.apache.hadoop.util.SemaphoredDelegatingExecutor;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class TestAbfsOutputStream {
    private static final int BUFFER_SIZE = 4096;
    private static final int WRITE_SIZE = 1000;
    private static final String PATH = "~/testpath";
    private final String globalKey = "fs.azure.configuration";
    private final String accountName1 = "account1";
    private final String accountKey1 = "fs.azure.configuration.account1";
    private final String accountValue1 = "one";

    private AbfsOutputStreamContext populateAbfsOutputStreamContext(int writeBufferSize, boolean isFlushEnabled, boolean disableOutputStreamFlush, boolean isAppendBlob, boolean isExpectHeaderEnabled, AbfsClientHandler clientHandler, String path, TracingContext tracingContext, ExecutorService executorService) throws IOException, IllegalAccessException {
        AbfsConfiguration abfsConf = new AbfsConfiguration(new Configuration(), "account1");
        String blockFactoryName = abfsConf.getRawConfiguration().getTrimmed("fs.azure.data.blocks.buffer", "bytebuffer");
        DataBlocks.BlockFactory blockFactory = DataBlocks.createFactory((String)"fs.azure.buffer.dir", (Configuration)abfsConf.getRawConfiguration(), (String)blockFactoryName);
        return new AbfsOutputStreamContext(2L).withWriteBufferSize(writeBufferSize).enableExpectHeader(isExpectHeaderEnabled).enableFlush(isFlushEnabled).disableOutputStreamFlush(disableOutputStreamFlush).withStreamStatistics((AbfsOutputStreamStatistics)new AbfsOutputStreamStatisticsImpl()).withAppendBlob(isAppendBlob).withWriteMaxConcurrentRequestCount(abfsConf.getWriteMaxConcurrentRequestCount()).withMaxWriteRequestsToQueue(abfsConf.getMaxWriteRequestsToQueue()).withClientHandler(clientHandler).withPath(path).withTracingContext(tracingContext).withExecutorService(executorService).withBlockFactory(blockFactory).build();
    }

    @Test
    public void verifyShortWriteRequest() throws Exception {
        AbfsClientHandler clientHandler = (AbfsClientHandler)Mockito.mock(AbfsClientHandler.class);
        AbfsDfsClient client = (AbfsDfsClient)Mockito.mock(AbfsDfsClient.class);
        AbfsRestOperation op = (AbfsRestOperation)Mockito.mock(AbfsRestOperation.class);
        Configuration conf = new Configuration();
        conf.set("fs.azure.configuration.account1", "one");
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account1");
        AbfsPerfTracker tracker = new AbfsPerfTracker("test", "account1", abfsConf);
        Mockito.when((Object)client.getAbfsPerfTracker()).thenReturn((Object)tracker);
        Mockito.when((Object)client.getAbfsConfiguration()).thenReturn((Object)abfsConf);
        Mockito.when((Object)client.append(Mockito.anyString(), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)Mockito.any(AppendRequestParameters.class), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class))).thenReturn((Object)op);
        Mockito.when((Object)client.flush(Mockito.anyString(), Mockito.anyLong(), Mockito.anyBoolean(), Mockito.anyBoolean(), (String)Mockito.any(), (String)ArgumentMatchers.isNull(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class), Mockito.anyString())).thenReturn((Object)op);
        Mockito.when((Object)clientHandler.getClient((AbfsServiceType)Mockito.any())).thenReturn((Object)client);
        Mockito.when((Object)clientHandler.getDfsClient()).thenReturn((Object)client);
        AbfsOutputStream out = (AbfsOutputStream)Mockito.spy((Object)new AbfsOutputStream(this.populateAbfsOutputStreamContext(4096, true, false, false, true, clientHandler, PATH, new TracingContext(abfsConf.getClientCorrelationId(), "test-fs-id", FSOperationType.WRITE, abfsConf.getTracingHeaderFormat(), null), this.createExecutorService(abfsConf))));
        Mockito.when((Object)out.getClient()).thenReturn((Object)client);
        Mockito.when((Object)out.getMd5()).thenReturn(null);
        byte[] b = new byte[1000];
        new Random().nextBytes(b);
        out.write(b);
        out.hsync();
        byte[] b1 = new byte[2000];
        new Random().nextBytes(b1);
        out.write(b1);
        out.flush();
        out.hflush();
        out.hsync();
        AppendRequestParameters firstReqParameters = new AppendRequestParameters(0L, 0, 1000, AppendRequestParameters.Mode.APPEND_MODE, false, null, true, null);
        AppendRequestParameters secondReqParameters = new AppendRequestParameters(1000L, 0, 2000, AppendRequestParameters.Mode.APPEND_MODE, false, null, true, null);
        ((AbfsDfsClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).append((String)ArgumentMatchers.eq((Object)PATH), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)ArgumentMatchers.refEq((Object)firstReqParameters, (String[])new String[0]), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class));
        ((AbfsDfsClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).append((String)ArgumentMatchers.eq((Object)PATH), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)ArgumentMatchers.refEq((Object)secondReqParameters, (String[])new String[0]), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class));
        ((AbfsDfsClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)2))).append((String)ArgumentMatchers.eq((Object)PATH), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)Mockito.any(), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class));
    }

    @Test
    public void verifyWriteRequest() throws Exception {
        AbfsClientHandler clientHandler = (AbfsClientHandler)Mockito.mock(AbfsClientHandler.class);
        AbfsDfsClient client = (AbfsDfsClient)Mockito.mock(AbfsDfsClient.class);
        AbfsRestOperation op = (AbfsRestOperation)Mockito.mock(AbfsRestOperation.class);
        Configuration conf = new Configuration();
        conf.set("fs.azure.configuration.account1", "one");
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account1");
        AbfsPerfTracker tracker = new AbfsPerfTracker("test", "account1", abfsConf);
        Mockito.when((Object)client.getAbfsPerfTracker()).thenReturn((Object)tracker);
        Mockito.when((Object)client.getAbfsConfiguration()).thenReturn((Object)abfsConf);
        TracingContext tracingContext = new TracingContext("test-corr-id", "test-fs-id", FSOperationType.WRITE, TracingHeaderFormat.ALL_ID_FORMAT, null);
        Mockito.when((Object)client.getAbfsPerfTracker()).thenReturn((Object)tracker);
        Mockito.when((Object)client.append(Mockito.anyString(), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)Mockito.any(AppendRequestParameters.class), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class))).thenReturn((Object)op);
        Mockito.when((Object)client.flush(Mockito.anyString(), Mockito.anyLong(), Mockito.anyBoolean(), Mockito.anyBoolean(), (String)Mockito.any(), (String)ArgumentMatchers.isNull(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class), Mockito.anyString())).thenReturn((Object)op);
        Mockito.when((Object)clientHandler.getClient((AbfsServiceType)Mockito.any())).thenReturn((Object)client);
        Mockito.when((Object)clientHandler.getDfsClient()).thenReturn((Object)client);
        AbfsOutputStream out = (AbfsOutputStream)Mockito.spy((Object)new AbfsOutputStream(this.populateAbfsOutputStreamContext(4096, true, false, false, true, clientHandler, PATH, tracingContext, this.createExecutorService(abfsConf))));
        Mockito.when((Object)out.getClient()).thenReturn((Object)client);
        Mockito.when((Object)out.getMd5()).thenReturn(null);
        byte[] b = new byte[1000];
        new Random().nextBytes(b);
        for (int i = 0; i < 5; ++i) {
            out.write(b);
        }
        out.close();
        AppendRequestParameters firstReqParameters = new AppendRequestParameters(0L, 0, 4096, AppendRequestParameters.Mode.APPEND_MODE, false, null, true, null);
        AppendRequestParameters secondReqParameters = new AppendRequestParameters(4096L, 0, 904, AppendRequestParameters.Mode.APPEND_MODE, false, null, true, null);
        ((AbfsDfsClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).append((String)ArgumentMatchers.eq((Object)PATH), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)ArgumentMatchers.refEq((Object)firstReqParameters, (String[])new String[0]), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class));
        ((AbfsDfsClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).append((String)ArgumentMatchers.eq((Object)PATH), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)ArgumentMatchers.refEq((Object)secondReqParameters, (String[])new String[0]), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class));
        ((AbfsDfsClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)2))).append((String)ArgumentMatchers.eq((Object)PATH), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)Mockito.any(), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class));
        ArgumentCaptor acFlushPath = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor acFlushPosition = ArgumentCaptor.forClass(Long.class);
        ArgumentCaptor acTracingContext = ArgumentCaptor.forClass(TracingContext.class);
        ArgumentCaptor acFlushRetainUnCommittedData = ArgumentCaptor.forClass(Boolean.class);
        ArgumentCaptor acFlushClose = ArgumentCaptor.forClass(Boolean.class);
        ArgumentCaptor acFlushSASToken = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor acMd5 = ArgumentCaptor.forClass(String.class);
        ((AbfsDfsClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).flush((String)acFlushPath.capture(), ((Long)acFlushPosition.capture()).longValue(), ((Boolean)acFlushRetainUnCommittedData.capture()).booleanValue(), ((Boolean)acFlushClose.capture()).booleanValue(), (String)acFlushSASToken.capture(), (String)ArgumentMatchers.isNull(), (ContextEncryptionAdapter)ArgumentMatchers.isNull(), (TracingContext)acTracingContext.capture(), (String)acMd5.capture());
        ((ListAssert)Assertions.assertThat(Arrays.asList(PATH)).describedAs("path", new Object[0])).isEqualTo((Object)acFlushPath.getAllValues());
        ((ListAssert)Assertions.assertThat(Arrays.asList(5000L)).describedAs("position", new Object[0])).isEqualTo((Object)acFlushPosition.getAllValues());
        ((ListAssert)Assertions.assertThat(Arrays.asList(false)).describedAs("RetainUnCommittedData flag", new Object[0])).isEqualTo((Object)acFlushRetainUnCommittedData.getAllValues());
        ((ListAssert)Assertions.assertThat(Arrays.asList(true)).describedAs("Close flag", new Object[0])).isEqualTo((Object)acFlushClose.getAllValues());
    }

    @Test
    public void verifyWriteRequestOfBufferSizeAndClose() throws Exception {
        AbfsClientHandler clientHandler = (AbfsClientHandler)Mockito.mock(AbfsClientHandler.class);
        AbfsDfsClient client = (AbfsDfsClient)Mockito.mock(AbfsDfsClient.class);
        AbfsRestOperation op = (AbfsRestOperation)Mockito.mock(AbfsRestOperation.class);
        AbfsHttpOperation httpOp = (AbfsHttpOperation)Mockito.mock(AbfsHttpOperation.class);
        Configuration conf = new Configuration();
        conf.set("fs.azure.configuration.account1", "one");
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account1");
        Mockito.when((Object)client.getAbfsConfiguration()).thenReturn((Object)abfsConf);
        AbfsPerfTracker tracker = new AbfsPerfTracker("test", "account1", abfsConf);
        TracingContext tracingContext = new TracingContext(abfsConf.getClientCorrelationId(), "test-fs-id", FSOperationType.WRITE, abfsConf.getTracingHeaderFormat(), null);
        Mockito.when((Object)client.getAbfsPerfTracker()).thenReturn((Object)tracker);
        Mockito.when((Object)client.append(Mockito.anyString(), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)Mockito.any(AppendRequestParameters.class), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class))).thenReturn((Object)op);
        Mockito.when((Object)client.flush(Mockito.anyString(), Mockito.anyLong(), Mockito.anyBoolean(), Mockito.anyBoolean(), (String)Mockito.any(), (String)ArgumentMatchers.isNull(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class), Mockito.anyString())).thenReturn((Object)op);
        Mockito.when((Object)op.getSasToken()).thenReturn((Object)"testToken");
        Mockito.when((Object)op.getResult()).thenReturn((Object)httpOp);
        Mockito.when((Object)clientHandler.getClient((AbfsServiceType)Mockito.any())).thenReturn((Object)client);
        Mockito.when((Object)clientHandler.getDfsClient()).thenReturn((Object)client);
        AbfsOutputStream out = (AbfsOutputStream)Mockito.spy((Object)((AbfsOutputStream)Mockito.spy((Object)new AbfsOutputStream(this.populateAbfsOutputStreamContext(4096, true, false, false, true, clientHandler, PATH, tracingContext, this.createExecutorService(abfsConf))))));
        Mockito.when((Object)out.getClient()).thenReturn((Object)client);
        Mockito.when((Object)out.getMd5()).thenReturn(null);
        byte[] b = new byte[4096];
        new Random().nextBytes(b);
        for (int i = 0; i < 2; ++i) {
            out.write(b);
        }
        out.close();
        AppendRequestParameters firstReqParameters = new AppendRequestParameters(0L, 0, 4096, AppendRequestParameters.Mode.APPEND_MODE, false, null, true, null);
        AppendRequestParameters secondReqParameters = new AppendRequestParameters(4096L, 0, 4096, AppendRequestParameters.Mode.APPEND_MODE, false, null, true, null);
        ((AbfsDfsClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).append((String)ArgumentMatchers.eq((Object)PATH), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)ArgumentMatchers.refEq((Object)firstReqParameters, (String[])new String[0]), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class));
        ((AbfsDfsClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).append((String)ArgumentMatchers.eq((Object)PATH), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)ArgumentMatchers.refEq((Object)secondReqParameters, (String[])new String[0]), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class));
        ((AbfsDfsClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)2))).append((String)ArgumentMatchers.eq((Object)PATH), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)Mockito.any(), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class));
        ArgumentCaptor acFlushPath = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor acFlushPosition = ArgumentCaptor.forClass(Long.class);
        ArgumentCaptor acTracingContext = ArgumentCaptor.forClass(TracingContext.class);
        ArgumentCaptor acFlushRetainUnCommittedData = ArgumentCaptor.forClass(Boolean.class);
        ArgumentCaptor acFlushClose = ArgumentCaptor.forClass(Boolean.class);
        ArgumentCaptor acFlushSASToken = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor acMd5 = ArgumentCaptor.forClass(String.class);
        ((AbfsDfsClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).flush((String)acFlushPath.capture(), ((Long)acFlushPosition.capture()).longValue(), ((Boolean)acFlushRetainUnCommittedData.capture()).booleanValue(), ((Boolean)acFlushClose.capture()).booleanValue(), (String)acFlushSASToken.capture(), (String)ArgumentMatchers.isNull(), (ContextEncryptionAdapter)ArgumentMatchers.isNull(), (TracingContext)acTracingContext.capture(), (String)acMd5.capture());
        ((ListAssert)Assertions.assertThat(Arrays.asList(PATH)).describedAs("path", new Object[0])).isEqualTo((Object)acFlushPath.getAllValues());
        ((ListAssert)Assertions.assertThat(Arrays.asList(8192L)).describedAs("position", new Object[0])).isEqualTo((Object)acFlushPosition.getAllValues());
        ((ListAssert)Assertions.assertThat(Arrays.asList(false)).describedAs("RetainUnCommittedData flag", new Object[0])).isEqualTo((Object)acFlushRetainUnCommittedData.getAllValues());
        ((ListAssert)Assertions.assertThat(Arrays.asList(true)).describedAs("Close flag", new Object[0])).isEqualTo((Object)acFlushClose.getAllValues());
    }

    @Test
    public void verifyWriteRequestOfBufferSize() throws Exception {
        AbfsClientHandler clientHandler = (AbfsClientHandler)Mockito.mock(AbfsClientHandler.class);
        AbfsDfsClient client = (AbfsDfsClient)Mockito.mock(AbfsDfsClient.class);
        AbfsRestOperation op = (AbfsRestOperation)Mockito.mock(AbfsRestOperation.class);
        AbfsHttpOperation httpOp = (AbfsHttpOperation)Mockito.mock(AbfsHttpOperation.class);
        Configuration conf = new Configuration();
        conf.set("fs.azure.configuration.account1", "one");
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account1");
        Mockito.when((Object)client.getAbfsConfiguration()).thenReturn((Object)abfsConf);
        AbfsPerfTracker tracker = new AbfsPerfTracker("test", "account1", abfsConf);
        Mockito.when((Object)client.getAbfsPerfTracker()).thenReturn((Object)tracker);
        Mockito.when((Object)client.append(Mockito.anyString(), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)Mockito.any(AppendRequestParameters.class), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class))).thenReturn((Object)op);
        Mockito.when((Object)client.flush(Mockito.anyString(), Mockito.anyLong(), Mockito.anyBoolean(), Mockito.anyBoolean(), (String)Mockito.any(), (String)ArgumentMatchers.isNull(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class), Mockito.anyString())).thenReturn((Object)op);
        Mockito.when((Object)op.getSasToken()).thenReturn((Object)"testToken");
        Mockito.when((Object)op.getResult()).thenReturn((Object)httpOp);
        Mockito.when((Object)clientHandler.getClient((AbfsServiceType)Mockito.any())).thenReturn((Object)client);
        Mockito.when((Object)clientHandler.getDfsClient()).thenReturn((Object)client);
        AbfsOutputStream out = (AbfsOutputStream)Mockito.spy((Object)new AbfsOutputStream(this.populateAbfsOutputStreamContext(4096, true, false, false, true, clientHandler, PATH, new TracingContext(abfsConf.getClientCorrelationId(), "test-fs-id", FSOperationType.WRITE, abfsConf.getTracingHeaderFormat(), null), this.createExecutorService(abfsConf))));
        Mockito.when((Object)out.getClient()).thenReturn((Object)client);
        Mockito.when((Object)out.getMd5()).thenReturn(null);
        byte[] b = new byte[4096];
        new Random().nextBytes(b);
        for (int i = 0; i < 2; ++i) {
            out.write(b);
        }
        Thread.sleep(1000L);
        AppendRequestParameters firstReqParameters = new AppendRequestParameters(0L, 0, 4096, AppendRequestParameters.Mode.APPEND_MODE, false, null, true, null);
        AppendRequestParameters secondReqParameters = new AppendRequestParameters(4096L, 0, 4096, AppendRequestParameters.Mode.APPEND_MODE, false, null, true, null);
        ((AbfsDfsClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).append((String)ArgumentMatchers.eq((Object)PATH), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)ArgumentMatchers.refEq((Object)firstReqParameters, (String[])new String[0]), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class));
        ((AbfsDfsClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).append((String)ArgumentMatchers.eq((Object)PATH), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)ArgumentMatchers.refEq((Object)secondReqParameters, (String[])new String[0]), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class));
        ((AbfsDfsClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)2))).append((String)ArgumentMatchers.eq((Object)PATH), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)Mockito.any(), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class));
    }

    @Test
    public void verifyWriteRequestOfBufferSizeWithAppendBlob() throws Exception {
        AbfsClientHandler clientHandler = (AbfsClientHandler)Mockito.mock(AbfsClientHandler.class);
        AbfsDfsClient client = (AbfsDfsClient)Mockito.mock(AbfsDfsClient.class);
        AbfsRestOperation op = (AbfsRestOperation)Mockito.mock(AbfsRestOperation.class);
        Configuration conf = new Configuration();
        conf.set("fs.azure.configuration.account1", "one");
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account1");
        Mockito.when((Object)client.getAbfsConfiguration()).thenReturn((Object)abfsConf);
        AbfsPerfTracker tracker = new AbfsPerfTracker("test", "account1", abfsConf);
        Mockito.when((Object)client.getAbfsPerfTracker()).thenReturn((Object)tracker);
        Mockito.when((Object)client.append(Mockito.anyString(), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)Mockito.any(AppendRequestParameters.class), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class))).thenReturn((Object)op);
        Mockito.when((Object)client.flush(Mockito.anyString(), Mockito.anyLong(), Mockito.anyBoolean(), Mockito.anyBoolean(), (String)Mockito.any(), (String)ArgumentMatchers.isNull(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class), Mockito.anyString())).thenReturn((Object)op);
        Mockito.when((Object)clientHandler.getClient((AbfsServiceType)Mockito.any())).thenReturn((Object)client);
        Mockito.when((Object)clientHandler.getDfsClient()).thenReturn((Object)client);
        AbfsOutputStream out = (AbfsOutputStream)Mockito.spy((Object)new AbfsOutputStream(this.populateAbfsOutputStreamContext(4096, true, false, true, true, clientHandler, PATH, new TracingContext(abfsConf.getClientCorrelationId(), "test-fs-id", FSOperationType.OPEN, abfsConf.getTracingHeaderFormat(), null), this.createExecutorService(abfsConf))));
        AzureIngressHandler ingressHandler = (AzureIngressHandler)Mockito.spy((Object)out.getIngressHandler());
        ((AbfsOutputStream)Mockito.doReturn((Object)ingressHandler).when((Object)out)).getIngressHandler();
        ((AzureIngressHandler)Mockito.doReturn((Object)out).when((Object)ingressHandler)).getAbfsOutputStream();
        Mockito.when((Object)out.getClient()).thenReturn((Object)client);
        Mockito.when((Object)out.getMd5()).thenReturn(null);
        byte[] b = new byte[4096];
        new Random().nextBytes(b);
        for (int i = 0; i < 2; ++i) {
            out.write(b);
        }
        Thread.sleep(1000L);
        AppendRequestParameters firstReqParameters = new AppendRequestParameters(0L, 0, 4096, AppendRequestParameters.Mode.APPEND_MODE, true, null, true, null);
        AppendRequestParameters secondReqParameters = new AppendRequestParameters(4096L, 0, 4096, AppendRequestParameters.Mode.APPEND_MODE, true, null, true, null);
        ((AbfsDfsClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).append((String)ArgumentMatchers.eq((Object)PATH), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)ArgumentMatchers.refEq((Object)firstReqParameters, (String[])new String[0]), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class));
        ((AbfsDfsClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).append((String)ArgumentMatchers.eq((Object)PATH), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)ArgumentMatchers.refEq((Object)secondReqParameters, (String[])new String[0]), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class));
        ((AbfsDfsClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)2))).append((String)ArgumentMatchers.eq((Object)PATH), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)Mockito.any(), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class));
    }

    @Test
    public void verifyWriteRequestOfBufferSizeAndHFlush() throws Exception {
        AbfsClientHandler clientHandler = (AbfsClientHandler)Mockito.mock(AbfsClientHandler.class);
        AbfsDfsClient client = (AbfsDfsClient)Mockito.mock(AbfsDfsClient.class);
        AbfsRestOperation op = (AbfsRestOperation)Mockito.mock(AbfsRestOperation.class);
        Mockito.when((Object)op.getSasToken()).thenReturn((Object)"");
        Configuration conf = new Configuration();
        conf.set("fs.azure.configuration.account1", "one");
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account1");
        Mockito.when((Object)client.getAbfsConfiguration()).thenReturn((Object)abfsConf);
        AbfsPerfTracker tracker = new AbfsPerfTracker("test", "account1", abfsConf);
        TracingContext tracingContext = new TracingContext(abfsConf.getClientCorrelationId(), "test-fs-id", FSOperationType.WRITE, abfsConf.getTracingHeaderFormat(), null);
        Mockito.when((Object)client.getAbfsPerfTracker()).thenReturn((Object)tracker);
        Mockito.when((Object)client.append(Mockito.anyString(), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)Mockito.any(AppendRequestParameters.class), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class))).thenReturn((Object)op);
        Mockito.when((Object)client.flush(Mockito.anyString(), Mockito.anyLong(), Mockito.anyBoolean(), Mockito.anyBoolean(), (String)Mockito.any(), (String)ArgumentMatchers.isNull(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class), Mockito.anyString())).thenReturn((Object)op);
        Mockito.when((Object)clientHandler.getClient((AbfsServiceType)Mockito.any())).thenReturn((Object)client);
        Mockito.when((Object)clientHandler.getDfsClient()).thenReturn((Object)client);
        AbfsOutputStream out = (AbfsOutputStream)Mockito.spy((Object)new AbfsOutputStream(this.populateAbfsOutputStreamContext(4096, true, false, false, true, clientHandler, PATH, new TracingContext(abfsConf.getClientCorrelationId(), "test-fs-id", FSOperationType.OPEN, abfsConf.getTracingHeaderFormat(), null), this.createExecutorService(abfsConf))));
        Mockito.when((Object)out.getClient()).thenReturn((Object)client);
        Mockito.when((Object)out.getMd5()).thenReturn(null);
        byte[] b = new byte[4096];
        new Random().nextBytes(b);
        for (int i = 0; i < 2; ++i) {
            out.write(b);
        }
        out.hflush();
        AppendRequestParameters firstReqParameters = new AppendRequestParameters(0L, 0, 4096, AppendRequestParameters.Mode.APPEND_MODE, false, null, true, null);
        AppendRequestParameters secondReqParameters = new AppendRequestParameters(4096L, 0, 4096, AppendRequestParameters.Mode.APPEND_MODE, false, null, true, null);
        ((AbfsDfsClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).append((String)ArgumentMatchers.eq((Object)PATH), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)ArgumentMatchers.refEq((Object)firstReqParameters, (String[])new String[0]), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class));
        ((AbfsDfsClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).append((String)ArgumentMatchers.eq((Object)PATH), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)ArgumentMatchers.refEq((Object)secondReqParameters, (String[])new String[0]), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class));
        ((AbfsDfsClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)2))).append((String)ArgumentMatchers.eq((Object)PATH), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)Mockito.any(), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class));
        ArgumentCaptor acFlushPath = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor acFlushPosition = ArgumentCaptor.forClass(Long.class);
        ArgumentCaptor acTracingContext = ArgumentCaptor.forClass(TracingContext.class);
        ArgumentCaptor acFlushRetainUnCommittedData = ArgumentCaptor.forClass(Boolean.class);
        ArgumentCaptor acFlushClose = ArgumentCaptor.forClass(Boolean.class);
        ArgumentCaptor acFlushSASToken = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor acFlushMd5 = ArgumentCaptor.forClass(String.class);
        ((AbfsDfsClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).flush((String)acFlushPath.capture(), ((Long)acFlushPosition.capture()).longValue(), ((Boolean)acFlushRetainUnCommittedData.capture()).booleanValue(), ((Boolean)acFlushClose.capture()).booleanValue(), (String)acFlushSASToken.capture(), (String)ArgumentMatchers.isNull(), (ContextEncryptionAdapter)ArgumentMatchers.isNull(), (TracingContext)acTracingContext.capture(), (String)acFlushMd5.capture());
        ((ListAssert)Assertions.assertThat(Arrays.asList(PATH)).describedAs("path", new Object[0])).isEqualTo((Object)acFlushPath.getAllValues());
        ((ListAssert)Assertions.assertThat(Arrays.asList(8192L)).describedAs("position", new Object[0])).isEqualTo((Object)acFlushPosition.getAllValues());
        ((ListAssert)Assertions.assertThat(Arrays.asList(false)).describedAs("RetainUnCommittedData flag", new Object[0])).isEqualTo((Object)acFlushRetainUnCommittedData.getAllValues());
        ((ListAssert)Assertions.assertThat(Arrays.asList(false)).describedAs("Close flag", new Object[0])).isEqualTo((Object)acFlushClose.getAllValues());
    }

    @Test
    public void verifyWriteRequestOfBufferSizeAndFlush() throws Exception {
        AbfsClientHandler clientHandler = (AbfsClientHandler)Mockito.mock(AbfsClientHandler.class);
        AbfsDfsClient client = (AbfsDfsClient)Mockito.mock(AbfsDfsClient.class);
        AbfsRestOperation op = (AbfsRestOperation)Mockito.mock(AbfsRestOperation.class);
        Configuration conf = new Configuration();
        conf.set("fs.azure.configuration.account1", "one");
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account1");
        Mockito.when((Object)client.getAbfsConfiguration()).thenReturn((Object)abfsConf);
        AbfsPerfTracker tracker = new AbfsPerfTracker("test", "account1", abfsConf);
        Mockito.when((Object)client.getAbfsPerfTracker()).thenReturn((Object)tracker);
        Mockito.when((Object)client.append(Mockito.anyString(), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)Mockito.any(AppendRequestParameters.class), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class))).thenReturn((Object)op);
        Mockito.when((Object)client.flush(Mockito.anyString(), Mockito.anyLong(), Mockito.anyBoolean(), Mockito.anyBoolean(), (String)Mockito.any(), (String)ArgumentMatchers.isNull(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class), Mockito.anyString())).thenReturn((Object)op);
        Mockito.when((Object)clientHandler.getClient((AbfsServiceType)Mockito.any())).thenReturn((Object)client);
        Mockito.when((Object)clientHandler.getDfsClient()).thenReturn((Object)client);
        AbfsOutputStream out = (AbfsOutputStream)Mockito.spy((Object)new AbfsOutputStream(this.populateAbfsOutputStreamContext(4096, true, false, false, true, clientHandler, PATH, new TracingContext(abfsConf.getClientCorrelationId(), "test-fs-id", FSOperationType.WRITE, abfsConf.getTracingHeaderFormat(), null), this.createExecutorService(abfsConf))));
        Mockito.when((Object)out.getClient()).thenReturn((Object)client);
        Mockito.when((Object)out.getMd5()).thenReturn(null);
        byte[] b = new byte[4096];
        new Random().nextBytes(b);
        for (int i = 0; i < 2; ++i) {
            out.write(b);
        }
        Thread.sleep(1000L);
        out.flush();
        Thread.sleep(1000L);
        AppendRequestParameters firstReqParameters = new AppendRequestParameters(0L, 0, 4096, AppendRequestParameters.Mode.APPEND_MODE, false, null, true, null);
        AppendRequestParameters secondReqParameters = new AppendRequestParameters(4096L, 0, 4096, AppendRequestParameters.Mode.APPEND_MODE, false, null, true, null);
        ((AbfsDfsClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).append((String)ArgumentMatchers.eq((Object)PATH), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)ArgumentMatchers.refEq((Object)firstReqParameters, (String[])new String[0]), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class));
        ((AbfsDfsClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).append((String)ArgumentMatchers.eq((Object)PATH), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)ArgumentMatchers.refEq((Object)secondReqParameters, (String[])new String[0]), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class));
        ((AbfsDfsClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)2))).append((String)ArgumentMatchers.eq((Object)PATH), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)Mockito.any(), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class));
    }

    private ExecutorService createExecutorService(AbfsConfiguration abfsConf) {
        SemaphoredDelegatingExecutor executorService = new SemaphoredDelegatingExecutor((ExecutorService)BlockingThreadPoolExecutorService.newInstance((int)abfsConf.getWriteMaxConcurrentRequestCount(), (int)abfsConf.getMaxWriteRequestsToQueue(), (long)10L, (TimeUnit)TimeUnit.SECONDS, (String)"abfs-test-bounded"), 20, true);
        return executorService;
    }
}

