/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.hadoop.fs.azurebfs.utils.UriUtils;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAbfsHttpOperation {
    @Test
    public void testMaskingAndEncoding() throws MalformedURLException, UnsupportedEncodingException {
        this.testIfMaskAndEncodeSuccessful("Where sig is the only query param", "http://www.testurl.net?sig=abcd", "http://www.testurl.net?sig=XXXXX");
        this.testIfMaskAndEncodeSuccessful("Where oid is the only query param", "http://www.testurl.net?saoid=abcdef", "http://www.testurl.net?saoid=abcXXX");
        this.testIfMaskAndEncodeSuccessful("Where sig is the first query param, oid is last", "http://www.testurl.net?sig=abcd&abc=xyz&saoid=pqrs456", "http://www.testurl.net?sig=XXXXX&abc=xyz&saoid=pqrsXXX");
        this.testIfMaskAndEncodeSuccessful("Where sig/oid are neither first nor last query param", "http://www.testurl.net?lmn=abc&sig=abcd&suoid=mnop789&abc=xyz", "http://www.testurl.net?lmn=abc&sig=XXXXX&suoid=mnopXXX&abc=xyz");
        this.testIfMaskAndEncodeSuccessful("Where sig is the last query param, oid is first", "http://www.testurl.net?skoid=pqrs123&abc=xyz&sig=abcd", "http://www.testurl.net?skoid=pqrsXXX&abc=xyz&sig=XXXXX");
        this.testIfMaskAndEncodeSuccessful("Where sig/oid query param are not present", "http://www.testurl.net?abc=xyz", "http://www.testurl.net?abc=xyz");
        this.testIfMaskAndEncodeSuccessful("Where sig/oid query param are not present but mysig and myoid", "http://www.testurl.net?abc=xyz&mysig=qwerty&mysaoid=uvw", "http://www.testurl.net?abc=xyz&mysig=qwerty&mysaoid=uvw");
        this.testIfMaskAndEncodeSuccessful("Where sig/oid query param is not present but sigmy and oidmy", "http://www.testurl.net?abc=xyz&sigmy=qwerty&skoidmy=uvw", "http://www.testurl.net?abc=xyz&sigmy=qwerty&skoidmy=uvw");
        this.testIfMaskAndEncodeSuccessful("Where sig/oid query param is not present but values sig and oid", "http://www.testurl.net?abc=xyz&mnop=sig&pqr=saoid", "http://www.testurl.net?abc=xyz&mnop=sig&pqr=saoid");
        this.testIfMaskAndEncodeSuccessful("Where sig/oid query param is not present but a value ends with sig/oid", "http://www.testurl.net?abc=xyzsaoid&mnop=abcsig", "http://www.testurl.net?abc=xyzsaoid&mnop=abcsig");
        this.testIfMaskAndEncodeSuccessful("Where sig/oid query param is not present but a value starts with sig/oid", "http://www.testurl.net?abc=saoidxyz&mnop=sigabc", "http://www.testurl.net?abc=saoidxyz&mnop=sigabc");
    }

    @Test
    public void testUrlWithNullValues() throws MalformedURLException, UnsupportedEncodingException {
        this.testIfMaskAndEncodeSuccessful("Where param to be masked has null value", "http://www.testurl.net?abc=xyz&saoid=&mnop=abcsig", "http://www.testurl.net?abc=xyz&saoid=&mnop=abcsig");
        this.testIfMaskAndEncodeSuccessful("Where visible param has null value", "http://www.testurl.net?abc=xyz&pqr=&mnop=abcd", "http://www.testurl.net?abc=xyz&pqr=&mnop=abcd");
        this.testIfMaskAndEncodeSuccessful("Where last param has null value", "http://www.testurl.net?abc=xyz&pqr=&mnop=", "http://www.testurl.net?abc=xyz&pqr=&mnop=");
    }

    private void testIfMaskAndEncodeSuccessful(String scenario, String url, String expectedMaskedUrl) throws UnsupportedEncodingException, MalformedURLException {
        ((AbstractStringAssert)Assertions.assertThat((String)UriUtils.getMaskedUrl((URL)new URL(url))).describedAs(url + " (" + scenario + ") after masking should be: " + expectedMaskedUrl, new Object[0])).isEqualTo((Object)expectedMaskedUrl);
        String expectedMaskedEncodedUrl = URLEncoder.encode(expectedMaskedUrl, "UTF-8");
        ((AbstractStringAssert)Assertions.assertThat((String)UriUtils.encodedUrlStr((String)expectedMaskedUrl)).describedAs(url + " (" + scenario + ") after masking and encoding should be: " + expectedMaskedEncodedUrl, new Object[0])).isEqualTo((Object)expectedMaskedEncodedUrl);
    }
}

