/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbfsCountersImpl;
import org.apache.hadoop.fs.azurebfs.MockIntercept;
import org.apache.hadoop.fs.azurebfs.oauth2.AccessTokenProvider;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientContext;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientContextBuilder;
import org.apache.hadoop.fs.azurebfs.services.AbfsCounters;
import org.apache.hadoop.fs.azurebfs.services.AbfsDfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperationType;
import org.apache.hadoop.fs.azurebfs.utils.Base64;
import org.apache.hadoop.fs.azurebfs.utils.MetricFormat;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestAbfsClient {
    private static final String ACCOUNT_NAME = "bogusAccountName.dfs.core.windows.net";
    private static final String ACCOUNT_KEY = "testKey";
    private static final long SLEEP_DURATION_MS = 500L;

    @Test
    public void testTimerInitializationWithoutMetricCollection() throws Exception {
        Configuration configuration = new Configuration();
        AbfsConfiguration abfsConfiguration = new AbfsConfiguration(configuration, ACCOUNT_NAME);
        abfsConfiguration.unset("fs.azure.metric.format");
        AbfsCounters abfsCounters = (AbfsCounters)Mockito.spy((Object)new AbfsCountersImpl(new URI("abcd")));
        AbfsClientContext abfsClientContext = new AbfsClientContextBuilder().withAbfsCounters(abfsCounters).build();
        AbfsDfsClient client = new AbfsDfsClient(new URL("https://azure.com"), null, abfsConfiguration, (AccessTokenProvider)null, null, abfsClientContext);
        ((ObjectAssert)Assertions.assertThat((Object)client.getTimer()).describedAs("Timer should not be initialized", new Object[0])).isNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.isThreadRunning("abfs-timer-client")).describedAs("Expected thread 'abfs-timer-client' not found", new Object[0])).isEqualTo(false);
        client.close();
    }

    @Test
    public void testTimerInitializationWithMetricCollection() throws Exception {
        Configuration configuration = new Configuration();
        configuration.set("fs.azure.metric.format", String.valueOf(MetricFormat.INTERNAL_BACKOFF_METRIC_FORMAT));
        configuration.set("fs.azure.metric.account.name", ACCOUNT_NAME);
        configuration.set("fs.azure.metric.account.key", Base64.encode((byte[])ACCOUNT_KEY.getBytes()));
        AbfsConfiguration abfsConfiguration = new AbfsConfiguration(configuration, ACCOUNT_NAME);
        AbfsCounters abfsCounters = (AbfsCounters)Mockito.spy((Object)new AbfsCountersImpl(new URI("abcd")));
        AbfsClientContext abfsClientContext = new AbfsClientContextBuilder().withAbfsCounters(abfsCounters).build();
        AbfsDfsClient client = new AbfsDfsClient(new URL("https://azure.com"), null, abfsConfiguration, (AccessTokenProvider)null, null, abfsClientContext);
        ((ObjectAssert)Assertions.assertThat((Object)client.getTimer()).describedAs("Timer should be initialized", new Object[0])).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.isThreadRunning("abfs-timer-client")).describedAs("Expected thread 'abfs-timer-client' not found", new Object[0])).isEqualTo(true);
        client.close();
        Thread.sleep(500L);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.isThreadRunning("abfs-timer-client")).describedAs("Unexpected thread 'abfs-timer-client' found", new Object[0])).isEqualTo(false);
    }

    private boolean isThreadRunning(String threadName) {
        Map<Thread, StackTraceElement[]> allThreads = Thread.getAllStackTraces();
        for (Thread thread : allThreads.keySet()) {
            if (!thread.getName().equals(threadName)) continue;
            return true;
        }
        return false;
    }

    public static void mockAbfsOperationCreation(AbfsClient abfsClient, MockIntercept mockIntercept, int failedCall) throws Exception {
        int[] flag = new int[1];
        ((AbfsClient)Mockito.doAnswer(answer -> {
            if (flag[0] == failedCall) {
                flag[0] = flag[0] + 1;
                AbfsRestOperation op = (AbfsRestOperation)Mockito.spy((Object)new AbfsRestOperation((AbfsRestOperationType)answer.getArgument(0), abfsClient, (String)answer.getArgument(1), (URL)answer.getArgument(2), (List)answer.getArgument(3), abfsClient.getAbfsConfiguration()));
                ((AbfsRestOperation)Mockito.doAnswer(answer1 -> {
                    mockIntercept.answer(op, answer1);
                    return null;
                }).when((Object)op)).execute((TracingContext)ArgumentMatchers.any());
                ((AbfsRestOperation)Mockito.doReturn((Object)true).when((Object)op)).isARetriedRequest();
                return op;
            }
            flag[0] = flag[0] + 1;
            return answer.callRealMethod();
        }).when((Object)abfsClient)).getAbfsRestOperation((AbfsRestOperationType)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (URL)ArgumentMatchers.any(), (List)ArgumentMatchers.any());
    }
}

