/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsRetryPolicy;
import org.apache.hadoop.fs.azurebfs.services.ExponentialRetryPolicy;
import org.apache.hadoop.fs.azurebfs.services.StaticRetryPolicy;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

public class ITestStaticRetryPolicy
extends AbstractAbfsIntegrationTest {
    @Test
    public void testStaticRetryPolicyInitializationDefault() throws Exception {
        Configuration config = new Configuration(this.getRawConfiguration());
        this.assertInitialization(config, StaticRetryPolicy.class);
    }

    @Test
    public void testStaticRetryPolicyInitialization1() throws Exception {
        Configuration config = new Configuration(this.getRawConfiguration());
        config.set("fs.azure.static.retry.for.connection.timeout.enabled", "true");
        this.assertInitialization(config, StaticRetryPolicy.class);
    }

    @Test
    public void testStaticRetryPolicyInitialization2() throws Exception {
        Configuration config = new Configuration(this.getRawConfiguration());
        config.set("fs.azure.static.retry.for.connection.timeout.enabled", "false");
        this.assertInitialization(config, ExponentialRetryPolicy.class);
    }

    private void assertInitialization(Configuration config, Class retryPolicyClass) throws Exception {
        AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((URI)this.getFileSystem().getUri(), (Configuration)config);
        AbfsClient client = fs.getAbfsStore().getClient();
        AbfsRetryPolicy retryPolicy = client.getRetryPolicy("CT");
        ((ObjectAssert)Assertions.assertThat((Object)retryPolicy).describedAs("RetryPolicy Type is Not As Expected", new Object[0])).isInstanceOf(retryPolicyClass);
        retryPolicy = client.getRetryPolicy("");
        this.assertIsExponentialRetryPolicy(retryPolicy);
        retryPolicy = client.getRetryPolicy(null);
        this.assertIsExponentialRetryPolicy(retryPolicy);
        retryPolicy = client.getRetryPolicy("CR");
        this.assertIsExponentialRetryPolicy(retryPolicy);
    }

    @Test
    public void testStaticRetryInterval() throws Exception {
        Configuration config = new Configuration(this.getRawConfiguration());
        long retryInterval = 1000L;
        int maxIoRetry = 5;
        config.set("fs.azure.static.retry.for.connection.timeout.enabled", "true");
        config.set("fs.azure.static.retry.interval", "1000");
        config.set("fs.azure.io.retry.max.retries", "5");
        AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((URI)this.getFileSystem().getUri(), (Configuration)config);
        AbfsClient client = fs.getAbfsStore().getClient();
        AbfsRetryPolicy retryPolicy = client.getRetryPolicy("CT");
        this.assertIsStaticRetryPolicy(retryPolicy);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)retryPolicy.shouldRetry(0, -1)).describedAs("Should retry should be true", new Object[0])).isEqualTo(true);
        ((AbstractLongAssert)Assertions.assertThat((long)retryPolicy.getRetryInterval(0)).describedAs("Retry Interval Value Not as expected", new Object[0])).isEqualTo(retryInterval);
        ((AbstractLongAssert)Assertions.assertThat((long)retryPolicy.getRetryInterval(1)).describedAs("Retry Interval Value Not as expected", new Object[0])).isEqualTo(retryInterval);
        ((AbstractLongAssert)Assertions.assertThat((long)retryPolicy.getRetryInterval(2)).describedAs("Retry Interval Value Not as expected", new Object[0])).isEqualTo(retryInterval);
        ((AbstractLongAssert)Assertions.assertThat((long)retryPolicy.getRetryInterval(3)).describedAs("Retry Interval Value Not as expected", new Object[0])).isEqualTo(retryInterval);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)retryPolicy.shouldRetry(maxIoRetry, -1)).describedAs("Should retry for maxretrycount should be false", new Object[0])).isEqualTo(false);
    }

    private void assertIsExponentialRetryPolicy(AbfsRetryPolicy retryPolicy) {
        ((ObjectAssert)Assertions.assertThat((Object)retryPolicy).describedAs("Exponential Retry policy must be used", new Object[0])).isInstanceOf(ExponentialRetryPolicy.class);
    }

    private void assertIsStaticRetryPolicy(AbfsRetryPolicy retryPolicy) {
        ((ObjectAssert)Assertions.assertThat((Object)retryPolicy).describedAs("Static Retry policy must be used", new Object[0])).isInstanceOf(StaticRetryPolicy.class);
    }
}

