/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStream;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ITestAbfsUnbuffer
extends AbstractAbfsIntegrationTest {
    private Path dest;

    @Override
    @BeforeEach
    public void setup() throws Exception {
        super.setup();
        this.dest = this.path("ITestAbfsUnbuffer");
        byte[] data = ContractTestUtils.dataset((int)16, (int)97, (int)26);
        ContractTestUtils.writeDataset((FileSystem)this.getFileSystem(), (Path)this.dest, (byte[])data, (int)data.length, (int)16, (boolean)true);
    }

    @Test
    public void testUnbuffer() throws IOException {
        try (FSDataInputStream inputStream = this.getFileSystem().open(this.dest);){
            ITestAbfsUnbuffer.assertTrue((boolean)(inputStream.getWrappedStream() instanceof AbfsInputStream), (String)("unexpected stream type " + inputStream.getWrappedStream().getClass().getSimpleName()));
            ITestAbfsUnbuffer.readAndAssertBytesRead(inputStream, 8);
            ITestAbfsUnbuffer.assertFalse((boolean)this.isBufferNull(inputStream), (String)"AbfsInputStream buffer should not be null");
            inputStream.unbuffer();
            ITestAbfsUnbuffer.assertTrue((boolean)this.isBufferNull(inputStream), (String)"AbfsInputStream buffer should be null");
        }
    }

    private boolean isBufferNull(FSDataInputStream inputStream) {
        return ((AbfsInputStream)inputStream.getWrappedStream()).getBuffer() == null;
    }

    private static void readAndAssertBytesRead(FSDataInputStream inputStream, int bytesToRead) throws IOException {
        ITestAbfsUnbuffer.assertEquals((int)bytesToRead, (int)inputStream.read(new byte[bytesToRead]), (String)"AbfsInputStream#read did not read the correct number of bytes");
    }
}

