/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FutureDataInputStreamBuilder;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStream;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ITestAbfsPositionedRead
extends AbstractAbfsIntegrationTest {
    private static final int TEST_FILE_DATA_SIZE = 100;

    @Test
    public void testPositionedRead() throws IOException {
        this.describe("Testing positioned reads in AbfsInputStream", new Object[0]);
        Path dest = this.path(this.methodName.getMethodName());
        byte[] data = ContractTestUtils.dataset((int)100, (int)97, (int)122);
        ContractTestUtils.writeDataset((FileSystem)this.getFileSystem(), (Path)dest, (byte[])data, (int)data.length, (int)100, (boolean)true);
        int bytesToRead = 10;
        try (FSDataInputStream inputStream = this.getFileSystem().open(dest);){
            ITestAbfsPositionedRead.assertTrue((boolean)(inputStream.getWrappedStream() instanceof AbfsInputStream), (String)("unexpected stream type " + inputStream.getWrappedStream().getClass().getSimpleName()));
            byte[] readBuffer = new byte[bytesToRead];
            int readPos = 0;
            ((AbstractIntegerAssert)Assertions.assertThat((int)inputStream.read((long)readPos, readBuffer, 0, bytesToRead)).describedAs("AbfsInputStream pread did not read the correct number of bytes", new Object[0])).isEqualTo(bytesToRead);
            ((AbstractByteArrayAssert)Assertions.assertThat((byte[])readBuffer).describedAs("AbfsInputStream pread did not read correct data", new Object[0])).containsExactly(Arrays.copyOfRange(data, readPos, readPos + bytesToRead));
            ((AbstractByteArrayAssert)Assertions.assertThat((byte[])Arrays.copyOfRange(((AbfsInputStream)inputStream.getWrappedStream()).getBuffer(), 0, 100)).describedAs("AbfsInputStream pread did not read more data into its buffer", new Object[0])).containsExactly(data);
            this.assertStatistics(inputStream.getIOStatistics(), bytesToRead, 1L, 1L, 100L);
            readPos = 50;
            ((AbstractIntegerAssert)Assertions.assertThat((int)inputStream.read((long)readPos, readBuffer, 0, bytesToRead)).describedAs("AbfsInputStream pread did not read the correct number of bytes", new Object[0])).isEqualTo(bytesToRead);
            ((AbstractByteArrayAssert)Assertions.assertThat((byte[])readBuffer).describedAs("AbfsInputStream pread did not read correct data", new Object[0])).containsExactly(Arrays.copyOfRange(data, readPos, readPos + bytesToRead));
            this.assertStatistics(inputStream.getIOStatistics(), 2 * bytesToRead, 2L, 1L, 100L);
            ((AbstractLongAssert)Assertions.assertThat((long)inputStream.getPos()).describedAs("AbfsInputStream positioned reads moved stream position", new Object[0])).isEqualTo(0L);
        }
    }

    private void assertStatistics(IOStatistics ioStatistics, long expectedBytesRead, long expectedReadOps, long expectedRemoteReadOps, long expectedRemoteReadBytes) {
        ((AbstractLongAssert)Assertions.assertThat((long)((Long)ioStatistics.counters().get("stream_read_bytes"))).describedAs("Mismatch in bytesRead statistics", new Object[0])).isEqualTo(expectedBytesRead);
        ((AbstractLongAssert)Assertions.assertThat((long)((Long)ioStatistics.counters().get("stream_read_operations"))).describedAs("Mismatch in readOps statistics", new Object[0])).isEqualTo(expectedReadOps);
        ((AbstractLongAssert)Assertions.assertThat((long)((Long)ioStatistics.counters().get("remote_read_op"))).describedAs("Mismatch in remoteReadOps statistics", new Object[0])).isEqualTo(expectedRemoteReadOps);
        ((AbstractLongAssert)Assertions.assertThat((long)((Long)ioStatistics.counters().get("remote_bytes_read"))).describedAs("Mismatch in remoteReadBytes statistics", new Object[0])).isEqualTo(expectedRemoteReadBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPositionedReadWithBufferedReadDisabled() throws IOException {
        this.describe("Testing positioned reads in AbfsInputStream with BufferedReadDisabled", new Object[0]);
        Path dest = this.path(this.methodName.getMethodName());
        byte[] data = ContractTestUtils.dataset((int)100, (int)97, (int)122);
        ContractTestUtils.writeDataset((FileSystem)this.getFileSystem(), (Path)dest, (byte[])data, (int)data.length, (int)100, (boolean)true);
        FutureDataInputStreamBuilder builder = this.getFileSystem().openFile(dest);
        builder.opt("fs.azure.buffered.pread.disable", true);
        FSDataInputStream inputStream = null;
        try {
            inputStream = (FSDataInputStream)builder.build().get();
        }
        catch (IllegalArgumentException | InterruptedException | UnsupportedOperationException | ExecutionException e) {
            throw new IOException("Exception opening " + dest + " with FutureDataInputStreamBuilder", e);
        }
        ITestAbfsPositionedRead.assertNotNull((Object)inputStream, (String)("Null InputStream over " + dest));
        int bytesToRead = 10;
        try {
            AbfsInputStream abfsIs = (AbfsInputStream)inputStream.getWrappedStream();
            byte[] readBuffer = new byte[bytesToRead];
            int readPos = 10;
            ((AbstractIntegerAssert)Assertions.assertThat((int)inputStream.read((long)readPos, readBuffer, 0, bytesToRead)).describedAs("AbfsInputStream pread did not read the correct number of bytes", new Object[0])).isEqualTo(bytesToRead);
            ((AbstractByteArrayAssert)Assertions.assertThat((byte[])readBuffer).describedAs("AbfsInputStream pread did not read correct data", new Object[0])).containsExactly(Arrays.copyOfRange(data, readPos, readPos + bytesToRead));
            ITestAbfsPositionedRead.assertNull((Object)abfsIs.getBuffer(), (String)"AbfsInputStream pread caused the internal buffer creation");
            this.assertStatistics(inputStream.getIOStatistics(), bytesToRead, 1L, 1L, bytesToRead);
            readPos = 40;
            ((AbstractIntegerAssert)Assertions.assertThat((int)inputStream.read((long)readPos, readBuffer, 0, bytesToRead)).describedAs("AbfsInputStream pread did not read the correct number of bytes", new Object[0])).isEqualTo(bytesToRead);
            ((AbstractByteArrayAssert)Assertions.assertThat((byte[])readBuffer).describedAs("AbfsInputStream pread did not read correct data", new Object[0])).containsExactly(Arrays.copyOfRange(data, readPos, readPos + bytesToRead));
            this.assertStatistics(inputStream.getIOStatistics(), 2 * bytesToRead, 2L, 2L, 2 * bytesToRead);
            inputStream.seek(0L);
            ((AbstractIntegerAssert)Assertions.assertThat((int)inputStream.read(readBuffer)).describedAs("AbfsInputStream seek+read did not read the correct number of bytes", new Object[0])).isEqualTo(bytesToRead);
            ((AbstractByteArrayAssert)Assertions.assertThat((byte[])Arrays.copyOfRange(((AbfsInputStream)inputStream.getWrappedStream()).getBuffer(), 0, 100)).describedAs("AbfsInputStream seek+read did not read more data into its buffer", new Object[0])).containsExactly(data);
            this.assertStatistics(inputStream.getIOStatistics(), 3 * bytesToRead, 3L, 3L, 100 + 2 * bytesToRead);
            this.resetBuffer(abfsIs.getBuffer());
            readPos = 0;
            ((AbstractIntegerAssert)Assertions.assertThat((int)inputStream.read((long)readPos, readBuffer, 0, bytesToRead)).describedAs("AbfsInputStream pread did not read the correct number of bytes", new Object[0])).isEqualTo(bytesToRead);
            ((AbstractByteArrayAssert)Assertions.assertThat((byte[])readBuffer).describedAs("AbfsInputStream pread did not read correct data", new Object[0])).containsExactly(Arrays.copyOfRange(data, readPos, readPos + bytesToRead));
            ((AbstractByteArrayAssert)Assertions.assertThat((byte[])Arrays.copyOfRange(((AbfsInputStream)inputStream.getWrappedStream()).getBuffer(), 0, 100)).describedAs("AbfsInputStream pread read more data into its buffer than expected", new Object[0])).doesNotContain(data);
            this.assertStatistics(inputStream.getIOStatistics(), 4 * bytesToRead, 4L, 4L, 100 + 3 * bytesToRead);
        }
        finally {
            inputStream.close();
        }
    }

    private void resetBuffer(byte[] buf) {
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = 0;
        }
    }
}

