/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStream;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStreamTestUtils;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ITestAbfsInputStream
extends AbstractAbfsIntegrationTest {
    private final AbfsInputStreamTestUtils abfsInputStreamTestUtils = new AbfsInputStreamTestUtils(this);

    @Test
    public void testWithNoOptimization() throws Exception {
        for (int i = 2; i <= 7; ++i) {
            int fileSize = i * 0x100000;
            AzureBlobFileSystem fs = this.getFileSystem(false, false, fileSize);
            String fileName = this.methodName.getMethodName() + i;
            byte[] fileContent = this.abfsInputStreamTestUtils.getRandomBytesArray(fileSize);
            Path testFilePath = this.abfsInputStreamTestUtils.createFileWithContent((FileSystem)fs, fileName, fileContent);
            this.testWithNoOptimization((FileSystem)fs, testFilePath, 100, fileContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testWithNoOptimization(FileSystem fs, Path testFilePath, int seekPos, byte[] fileContent) throws IOException {
        try (FSDataInputStream iStream = fs.open(testFilePath);){
            AbfsInputStream abfsInputStream = (AbfsInputStream)iStream.getWrappedStream();
            iStream = new FSDataInputStream((InputStream)abfsInputStream);
            this.abfsInputStreamTestUtils.seek(iStream, seekPos);
            long totalBytesRead = 0L;
            int length = 10000;
            do {
                byte[] buffer;
                int bytesRead;
                if ((totalBytesRead += (long)(bytesRead = iStream.read(buffer = new byte[length], 0, length))) + (long)seekPos >= (long)fileContent.length) {
                    length = (fileContent.length - seekPos) % length;
                }
                ITestAbfsInputStream.assertEquals((int)length, (int)bytesRead);
                this.abfsInputStreamTestUtils.assertContentReadCorrectly(fileContent, (int)((long)seekPos + totalBytesRead - (long)length), length, buffer, testFilePath);
                ITestAbfsInputStream.assertTrue((abfsInputStream.getFCursor() >= (long)seekPos + totalBytesRead ? 1 : 0) != 0);
                ITestAbfsInputStream.assertTrue((abfsInputStream.getFCursorAfterLastRead() >= (long)seekPos + totalBytesRead ? 1 : 0) != 0);
                ITestAbfsInputStream.assertTrue(((long)abfsInputStream.getBCursor() >= totalBytesRead % (long)abfsInputStream.getBufferSize() ? 1 : 0) != 0);
                ITestAbfsInputStream.assertTrue((abfsInputStream.getLimit() >= totalBytesRead % (long)abfsInputStream.getBufferSize() ? 1 : 0) != 0);
            } while (totalBytesRead + (long)seekPos < (long)fileContent.length);
        }
    }

    @Test
    public void testExceptionInOptimization() throws Exception {
        for (int i = 2; i <= 7; ++i) {
            int fileSize = i * 0x100000;
            AzureBlobFileSystem fs = this.getFileSystem(true, true, fileSize);
            String fileName = this.methodName.getMethodName() + i;
            byte[] fileContent = this.abfsInputStreamTestUtils.getRandomBytesArray(fileSize);
            Path testFilePath = this.abfsInputStreamTestUtils.createFileWithContent((FileSystem)fs, fileName, fileContent);
            this.testExceptionInOptimization((FileSystem)fs, testFilePath, fileSize - 100, fileSize / 4, fileContent);
        }
    }

    @Test
    public void testAzureBlobFileSystemBackReferenceInInputStream() throws IOException {
        Path path = this.path(this.getMethodName());
        try (FSDataOutputStream out = this.getFileSystem().create(path);
             FSDataInputStream in = this.getFileSystem().open(path);){
            AbfsInputStream abfsInputStream = (AbfsInputStream)in.getWrappedStream();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)abfsInputStream.getFsBackRef().isNull()).describedAs("BackReference in input stream should not be null", new Object[0])).isFalse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testExceptionInOptimization(FileSystem fs, Path testFilePath, int seekPos, int length, byte[] fileContent) throws IOException {
        try (FSDataInputStream iStream = fs.open(testFilePath);){
            AbfsInputStream abfsInputStream = (AbfsInputStream)iStream.getWrappedStream();
            abfsInputStream = (AbfsInputStream)Mockito.spy((Object)abfsInputStream);
            ((AbfsInputStream)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).doCallRealMethod().when((Object)abfsInputStream)).readRemote(ArgumentMatchers.anyLong(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), (TracingContext)ArgumentMatchers.any(TracingContext.class));
            iStream = new FSDataInputStream((InputStream)abfsInputStream);
            this.abfsInputStreamTestUtils.verifyAbfsInputStreamBaseStateBeforeSeek(abfsInputStream);
            this.abfsInputStreamTestUtils.seek(iStream, seekPos);
            byte[] buffer = new byte[length];
            int bytesRead = iStream.read(buffer, 0, length);
            long actualLength = length;
            if (seekPos + length > fileContent.length) {
                long delta = seekPos + length - fileContent.length;
                actualLength = (long)length - delta;
            }
            ITestAbfsInputStream.assertEquals((long)bytesRead, (long)actualLength);
            this.abfsInputStreamTestUtils.assertContentReadCorrectly(fileContent, seekPos, (int)actualLength, buffer, testFilePath);
            ITestAbfsInputStream.assertEquals((long)fileContent.length, (long)abfsInputStream.getFCursor());
            ITestAbfsInputStream.assertEquals((long)fileContent.length, (long)abfsInputStream.getFCursorAfterLastRead());
            ITestAbfsInputStream.assertEquals((long)actualLength, (long)abfsInputStream.getBCursor());
            ITestAbfsInputStream.assertTrue((abfsInputStream.getLimit() >= actualLength ? 1 : 0) != 0);
        }
    }

    private AzureBlobFileSystem getFileSystem(boolean optimizeFooterRead, boolean readSmallFileCompletely, int fileSize) throws IOException {
        AzureBlobFileSystem fs = this.getFileSystem();
        this.getAbfsStore(fs).getAbfsConfiguration().setOptimizeFooterRead(optimizeFooterRead);
        this.getAbfsStore(fs).getAbfsConfiguration().setIsChecksumValidationEnabled(true);
        if (fileSize <= this.getAbfsStore(fs).getAbfsConfiguration().getReadBufferSize()) {
            this.getAbfsStore(fs).getAbfsConfiguration().setReadSmallFilesCompletely(readSmallFileCompletely);
        }
        return fs;
    }
}

