/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.constants.AbfsServiceType;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlobClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientHandler;
import org.apache.hadoop.fs.azurebfs.services.AbfsDfsClient;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ITestAbfsClientHandler
extends AbstractAbfsIntegrationTest {
    @Test
    public void testAbfsClientHandlerInitialization() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        AbfsClientHandler clientHandler = fs.getAbfsStore().getClientHandler();
        if (this.getAbfsServiceType() == AbfsServiceType.DFS) {
            Assertions.assertThat((Object)clientHandler.getClient()).isInstanceOf(AbfsDfsClient.class);
        } else {
            Assertions.assertThat((Object)clientHandler.getClient()).isInstanceOf(AbfsBlobClient.class);
        }
        if (this.getIngressServiceType() == AbfsServiceType.DFS) {
            Assertions.assertThat((Object)clientHandler.getIngressClient()).isInstanceOf(AbfsDfsClient.class);
        } else {
            Assertions.assertThat((Object)clientHandler.getIngressClient()).isInstanceOf(AbfsBlobClient.class);
        }
        Assertions.assertThat((Object)clientHandler.getClient(AbfsServiceType.DFS)).isInstanceOf(AbfsDfsClient.class);
        Assertions.assertThat((Object)clientHandler.getClient(AbfsServiceType.BLOB)).isInstanceOf(AbfsBlobClient.class);
    }
}

