/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.oauth2;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsTestWithTimeout;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADToken;
import org.apache.hadoop.fs.azurebfs.oauth2.ClientAssertionProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.WorkloadIdentityTokenProvider;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestWorkloadIdentityTokenProvider
extends AbstractAbfsTestWithTimeout {
    private static final String AUTHORITY = "authority";
    private static final String TENANT_ID = "00000000-0000-0000-0000-000000000000";
    private static final String CLIENT_ID = "00000000-0000-0000-0000-000000000000";
    private static final String TOKEN_FILE = "/tmp/does_not_exist";
    private static final String CLIENT_ASSERTION = "dummy-client-assertion";
    private static final String TOKEN = "dummy-token";
    private static final long FEW_SECONDS = 5000L;
    private static final long ONE_MINUTE = 60000L;
    private static final long FIVE_MINUTES = 300000L;

    @Test
    public void testTokenStartsAsExpired() {
        WorkloadIdentityTokenProvider provider = new WorkloadIdentityTokenProvider(AUTHORITY, "00000000-0000-0000-0000-000000000000", "00000000-0000-0000-0000-000000000000", TOKEN_FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)provider.isTokenAboutToExpire()).describedAs("Token should start as expired", new Object[0])).isTrue();
    }

    @Test
    public void testTokenFetchAndExpiry() throws Exception {
        long startTime = System.currentTimeMillis();
        AzureADToken adToken = new AzureADToken();
        adToken.setAccessToken(TOKEN);
        adToken.setExpiry(new Date(System.currentTimeMillis() + 5000L + 300000L));
        File tokenFile = File.createTempFile(TOKEN_FILE, "txt");
        FileUtils.write((File)tokenFile, (CharSequence)CLIENT_ASSERTION, (Charset)StandardCharsets.UTF_8);
        WorkloadIdentityTokenProvider mockedTokenProvider = (WorkloadIdentityTokenProvider)Mockito.spy((Object)new WorkloadIdentityTokenProvider(AUTHORITY, "00000000-0000-0000-0000-000000000000", "00000000-0000-0000-0000-000000000000", tokenFile.getPath()));
        ((WorkloadIdentityTokenProvider)Mockito.doReturn((Object)adToken).when((Object)mockedTokenProvider)).getTokenUsingJWTAssertion(CLIENT_ASSERTION);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)mockedTokenProvider.isTokenAboutToExpire()).describedAs("Token should not be expired", new Object[0])).isTrue();
        ((AbstractStringAssert)Assertions.assertThat((String)mockedTokenProvider.getToken().getAccessToken()).describedAs("Token should be fetched", new Object[0])).isEqualTo((Object)TOKEN);
        ((AbstractLongAssert)Assertions.assertThat((long)mockedTokenProvider.getTokenFetchTime()).describedAs("Token should not be expired", new Object[0])).isGreaterThan(startTime);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)mockedTokenProvider.isTokenAboutToExpire()).describedAs("Token should not be expired", new Object[0])).isFalse();
        Thread.sleep(5000L);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)mockedTokenProvider.isTokenAboutToExpire()).describedAs("Token should be expired", new Object[0])).isTrue();
    }

    @Test
    public void testTokenFetchWithEmptyTokenFile() throws Exception {
        File tokenFile = File.createTempFile("azure-identity-token", "txt");
        AzureADToken azureAdToken = new AzureADToken();
        WorkloadIdentityTokenProvider tokenProvider = (WorkloadIdentityTokenProvider)Mockito.spy((Object)new WorkloadIdentityTokenProvider(AUTHORITY, "00000000-0000-0000-0000-000000000000", "00000000-0000-0000-0000-000000000000", tokenFile.getPath()));
        ((WorkloadIdentityTokenProvider)Mockito.doReturn((Object)azureAdToken).when((Object)tokenProvider)).getTokenUsingJWTAssertion(TOKEN);
        IOException ex = (IOException)LambdaTestUtils.intercept(IOException.class, () -> tokenProvider.getToken());
        ((AbstractStringAssert)Assertions.assertThat((String)ex.getMessage()).describedAs("Exception should be thrown when the token file is empty", new Object[0])).contains(new CharSequence[]{"Empty token file"});
    }

    @Test
    public void testTokenFetchWithTokenFileNotFound() throws Exception {
        AzureADToken azureAdToken = new AzureADToken();
        WorkloadIdentityTokenProvider tokenProvider = (WorkloadIdentityTokenProvider)Mockito.spy((Object)new WorkloadIdentityTokenProvider(AUTHORITY, "00000000-0000-0000-0000-000000000000", "00000000-0000-0000-0000-000000000000", TOKEN_FILE));
        ((WorkloadIdentityTokenProvider)Mockito.doReturn((Object)azureAdToken).when((Object)tokenProvider)).getTokenUsingJWTAssertion(TOKEN);
        IOException ex = (IOException)LambdaTestUtils.intercept(IOException.class, () -> tokenProvider.getToken());
        ((AbstractStringAssert)Assertions.assertThat((String)ex.getMessage()).describedAs("Exception should be thrown when the token file not found", new Object[0])).contains(new CharSequence[]{"Error reading token file"});
    }

    @Test
    public void testTokenTrimsWhitespace() throws Exception {
        String tokenWithWhitespace = "  dummy-client-assertion  \n\t  ";
        AzureADToken adToken = new AzureADToken();
        adToken.setAccessToken(TOKEN);
        adToken.setExpiry(new Date(System.currentTimeMillis() + 300000L));
        File tokenFile = File.createTempFile("azure-identity-token", "txt");
        FileUtils.write((File)tokenFile, (CharSequence)tokenWithWhitespace, (Charset)StandardCharsets.UTF_8);
        WorkloadIdentityTokenProvider mockedTokenProvider = (WorkloadIdentityTokenProvider)Mockito.spy((Object)new WorkloadIdentityTokenProvider(AUTHORITY, "00000000-0000-0000-0000-000000000000", "00000000-0000-0000-0000-000000000000", tokenFile.getPath()));
        ((WorkloadIdentityTokenProvider)Mockito.doReturn((Object)adToken).when((Object)mockedTokenProvider)).getTokenUsingJWTAssertion(CLIENT_ASSERTION);
        ((AbstractStringAssert)Assertions.assertThat((String)mockedTokenProvider.getToken().getAccessToken()).describedAs("Token should be fetched successfully with trimmed whitespace", new Object[0])).isEqualTo((Object)TOKEN);
        ((WorkloadIdentityTokenProvider)Mockito.verify((Object)mockedTokenProvider)).getTokenUsingJWTAssertion(CLIENT_ASSERTION);
    }

    @Test
    public void testTokenFileWithOnlyWhitespace() throws Exception {
        String whitespaceOnlyToken = "   \n\t  \r  ";
        File tokenFile = File.createTempFile("azure-identity-token", "txt");
        FileUtils.write((File)tokenFile, (CharSequence)whitespaceOnlyToken, (Charset)StandardCharsets.UTF_8);
        WorkloadIdentityTokenProvider tokenProvider = new WorkloadIdentityTokenProvider(AUTHORITY, "00000000-0000-0000-0000-000000000000", "00000000-0000-0000-0000-000000000000", tokenFile.getPath());
        IOException ex = (IOException)LambdaTestUtils.intercept(IOException.class, () -> tokenProvider.getToken());
        ((AbstractStringAssert)Assertions.assertThat((String)ex.getMessage()).describedAs("Exception should be thrown when the token file contains only whitespace", new Object[0])).contains(new CharSequence[]{"Empty token file"});
    }

    @Test
    public void testCustomClientAssertionProvider() throws Exception {
        AzureADToken adToken = new AzureADToken();
        adToken.setAccessToken(TOKEN);
        adToken.setExpiry(new Date(System.currentTimeMillis() + 300000L));
        ClientAssertionProvider mockProvider = (ClientAssertionProvider)Mockito.mock(ClientAssertionProvider.class);
        Mockito.when((Object)mockProvider.getClientAssertion()).thenReturn((Object)CLIENT_ASSERTION);
        WorkloadIdentityTokenProvider mockedTokenProvider = (WorkloadIdentityTokenProvider)Mockito.spy((Object)new WorkloadIdentityTokenProvider(AUTHORITY, "00000000-0000-0000-0000-000000000000", "00000000-0000-0000-0000-000000000000", mockProvider));
        ((WorkloadIdentityTokenProvider)Mockito.doReturn((Object)adToken).when((Object)mockedTokenProvider)).getTokenUsingJWTAssertion(CLIENT_ASSERTION);
        ((AbstractStringAssert)Assertions.assertThat((String)mockedTokenProvider.getToken().getAccessToken()).describedAs("Token should be fetched using custom provider", new Object[0])).isEqualTo((Object)TOKEN);
        ((ClientAssertionProvider)Mockito.verify((Object)mockProvider)).getClientAssertion();
        ((WorkloadIdentityTokenProvider)Mockito.verify((Object)mockedTokenProvider)).getTokenUsingJWTAssertion(CLIENT_ASSERTION);
    }

    @Test
    public void testCustomClientAssertionProviderInitialize() throws Exception {
        ClientAssertionProvider mockProvider = (ClientAssertionProvider)Mockito.mock(ClientAssertionProvider.class);
        Mockito.when((Object)mockProvider.getClientAssertion()).thenReturn((Object)CLIENT_ASSERTION);
        WorkloadIdentityTokenProvider tokenProvider = new WorkloadIdentityTokenProvider(AUTHORITY, "00000000-0000-0000-0000-000000000000", "00000000-0000-0000-0000-000000000000", mockProvider);
        ((ObjectAssert)Assertions.assertThat((Object)tokenProvider).describedAs("Token provider should be created successfully", new Object[0])).isNotNull();
    }

    @Test
    public void testCustomClientAssertionProviderThrowsException() throws Exception {
        ClientAssertionProvider mockProvider = (ClientAssertionProvider)Mockito.mock(ClientAssertionProvider.class);
        Mockito.when((Object)mockProvider.getClientAssertion()).thenThrow(new Throwable[]{new IOException("Custom provider error")});
        WorkloadIdentityTokenProvider tokenProvider = new WorkloadIdentityTokenProvider(AUTHORITY, "00000000-0000-0000-0000-000000000000", "00000000-0000-0000-0000-000000000000", mockProvider);
        IOException ex = (IOException)LambdaTestUtils.intercept(IOException.class, () -> tokenProvider.getToken());
        ((AbstractStringAssert)Assertions.assertThat((String)ex.getMessage()).describedAs("Exception from custom provider should be propagated", new Object[0])).contains(new CharSequence[]{"Custom provider error"});
    }

    @Test
    public void testCustomProviderConstructorValidation() throws Exception {
        ClientAssertionProvider mockProvider = (ClientAssertionProvider)Mockito.mock(ClientAssertionProvider.class);
        Throwable ex1 = LambdaTestUtils.intercept(RuntimeException.class, () -> new WorkloadIdentityTokenProvider(null, "00000000-0000-0000-0000-000000000000", "00000000-0000-0000-0000-000000000000", mockProvider));
        ((AbstractStringAssert)Assertions.assertThat((String)ex1.getMessage()).describedAs("Should validate authority parameter", new Object[0])).contains(new CharSequence[]{AUTHORITY});
        Throwable ex2 = LambdaTestUtils.intercept(RuntimeException.class, () -> new WorkloadIdentityTokenProvider(AUTHORITY, null, "00000000-0000-0000-0000-000000000000", mockProvider));
        ((AbstractStringAssert)Assertions.assertThat((String)ex2.getMessage()).describedAs("Should validate tenantId parameter", new Object[0])).contains(new CharSequence[]{"tenantId"});
        Throwable ex3 = LambdaTestUtils.intercept(RuntimeException.class, () -> new WorkloadIdentityTokenProvider(AUTHORITY, "00000000-0000-0000-0000-000000000000", null, mockProvider));
        ((AbstractStringAssert)Assertions.assertThat((String)ex3.getMessage()).describedAs("Should validate clientId parameter", new Object[0])).contains(new CharSequence[]{"clientId"});
        Throwable ex4 = LambdaTestUtils.intercept(RuntimeException.class, () -> new WorkloadIdentityTokenProvider(AUTHORITY, "00000000-0000-0000-0000-000000000000", "00000000-0000-0000-0000-000000000000", (ClientAssertionProvider)null));
        ((AbstractStringAssert)Assertions.assertThat((String)ex4.getMessage()).describedAs("Should validate clientAssertionProvider parameter", new Object[0])).contains(new CharSequence[]{"clientAssertionProvider"});
    }

    @Test
    public void testFileBasedProviderImplementsInterface() throws Exception {
        File tokenFile = File.createTempFile("azure-identity-token", "txt");
        FileUtils.write((File)tokenFile, (CharSequence)CLIENT_ASSERTION, (Charset)StandardCharsets.UTF_8);
        WorkloadIdentityTokenProvider provider = new WorkloadIdentityTokenProvider(AUTHORITY, "00000000-0000-0000-0000-000000000000", "00000000-0000-0000-0000-000000000000", tokenFile.getPath());
        ((ObjectAssert)Assertions.assertThat((Object)provider).describedAs("File-based provider should be created successfully", new Object[0])).isNotNull();
        tokenFile.delete();
    }
}

