/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.extensions;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsTestWithTimeout;
import org.apache.hadoop.fs.azurebfs.extensions.KerberizedAbfsCluster;
import org.apache.hadoop.fs.azurebfs.extensions.StubAbfsTokenIdentifier;
import org.apache.hadoop.fs.azurebfs.extensions.StubDelegationTokenManager;
import org.apache.hadoop.fs.azurebfs.security.AbfsDelegationTokenManager;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestDTManagerLifecycle
extends AbstractAbfsTestWithTimeout {
    public static final String RENEWER = "resourcemanager";
    private Configuration conf;
    public static final String ABFS = "abfs://testing@account.dfs.core.windows.net";
    public static final URI FSURI = KerberizedAbfsCluster.newURI("abfs://testing@account.dfs.core.windows.net");
    public static final Text OWNER = new Text("owner");
    public static final Text KIND2 = new Text("kind2");

    @BeforeEach
    public void setup() throws Exception {
        this.conf = StubDelegationTokenManager.useStubDTManager(new Configuration());
    }

    @AfterEach
    public void teardown() throws Exception {
    }

    protected void assertTokenKind(Text kind, Token<DelegationTokenIdentifier> dt) {
        TestDTManagerLifecycle.assertEquals((Object)kind, (Object)dt.getKind(), (String)"Token Kind");
    }

    @Test
    public void testClassicLifecycle() throws Throwable {
        AbfsDelegationTokenManager manager = new AbfsDelegationTokenManager(this.conf);
        StubDelegationTokenManager stub = this.getTokenManager(manager);
        TestDTManagerLifecycle.assertTrue((boolean)stub.isInitialized(), (String)("Not initialized: " + stub));
        Token<DelegationTokenIdentifier> dt = stub.getDelegationToken(RENEWER);
        this.assertTokenKind(StubAbfsTokenIdentifier.TOKEN_KIND, dt);
        TestDTManagerLifecycle.assertNull((Object)manager.getCanonicalServiceName(), (String)("canonicalServiceName in " + stub));
        TestDTManagerLifecycle.assertEquals((int)1, (int)stub.getIssued(), (String)("Issued count number in " + stub));
        StubAbfsTokenIdentifier id = StubAbfsTokenIdentifier.decodeIdentifier(dt);
        TestDTManagerLifecycle.assertEquals((int)1, (int)id.getSequenceNumber(), (String)("Sequence number in " + id));
        stub.renewDelegationToken(dt);
        TestDTManagerLifecycle.assertEquals((int)1, (int)stub.getRenewals(), (String)("Renewal count in " + stub));
        stub.cancelDelegationToken(dt);
        TestDTManagerLifecycle.assertEquals((int)1, (int)stub.getCancellations(), (String)("Cancel count in " + stub));
    }

    protected StubDelegationTokenManager getTokenManager(AbfsDelegationTokenManager manager) {
        return (StubDelegationTokenManager)manager.getTokenManager();
    }

    @Test
    public void testBindingLifecycle() throws Throwable {
        AbfsDelegationTokenManager manager = new AbfsDelegationTokenManager(this.conf);
        StubDelegationTokenManager stub = this.getTokenManager(manager);
        TestDTManagerLifecycle.assertTrue((boolean)stub.isInitialized(), (String)("Not initialized: " + stub));
        stub.bind(FSURI, this.conf);
        TestDTManagerLifecycle.assertEquals((Object)FSURI, (Object)stub.getFsURI(), (String)("URI in " + stub));
        StubAbfsTokenIdentifier.decodeIdentifier(stub.getDelegationToken(RENEWER));
        stub.close();
        TestDTManagerLifecycle.assertTrue((boolean)stub.isClosed(), (String)("Not closed: " + stub));
        stub.close();
        TestDTManagerLifecycle.assertTrue((boolean)stub.isClosed(), (String)("Not closed: " + stub));
    }

    @Test
    public void testBindingThroughManager() throws Throwable {
        AbfsDelegationTokenManager manager = new AbfsDelegationTokenManager(this.conf);
        manager.bind(FSURI, this.conf);
        StubDelegationTokenManager stub = this.getTokenManager(manager);
        TestDTManagerLifecycle.assertEquals((Object)ABFS, (Object)stub.createServiceText().toString(), (String)("Service in " + manager));
        TestDTManagerLifecycle.assertEquals((Object)FSURI, (Object)stub.getFsURI(), (String)("Binding URI of " + stub));
        Token token = manager.getDelegationToken(RENEWER);
        TestDTManagerLifecycle.assertEquals((Object)ABFS, (Object)token.getService().toString(), (String)("Service in " + token));
        StubAbfsTokenIdentifier.decodeIdentifier(token);
        this.assertTokenKind(StubAbfsTokenIdentifier.TOKEN_KIND, (Token<DelegationTokenIdentifier>)token);
        stub.setKind(KIND2);
        Token dt2 = manager.getDelegationToken("");
        this.assertTokenKind(KIND2, (Token<DelegationTokenIdentifier>)dt2);
        TestDTManagerLifecycle.assertNull((Object)dt2.decodeIdentifier(), (String)"Token is of unknown kind, must not decode");
        manager.close();
        TestDTManagerLifecycle.assertTrue((boolean)stub.isClosed(), (String)("Not closed: " + stub));
    }

    @Test
    public void testRenewalThroughManager() throws Throwable {
        Token<DelegationTokenIdentifier> dt = StubDelegationTokenManager.createToken(0, FSURI, OWNER, new Text(RENEWER));
        AbfsDelegationTokenManager manager = new AbfsDelegationTokenManager(this.conf);
        StubDelegationTokenManager stub = this.getTokenManager(manager);
        TestDTManagerLifecycle.assertNull((Object)stub.getFsURI(), (String)("Stub should not bebound " + stub));
        StubAbfsTokenIdentifier dtId = (StubAbfsTokenIdentifier)dt.decodeIdentifier();
        String idStr = dtId.toString();
        TestDTManagerLifecycle.assertEquals((Object)FSURI, (Object)dtId.getUri(), (String)("URI in " + idStr));
        TestDTManagerLifecycle.assertEquals((Object)RENEWER, (Object)dtId.getRenewer().toString(), (String)("renewer in " + idStr));
        manager.renewDelegationToken(dt);
        TestDTManagerLifecycle.assertEquals((int)1, (int)stub.getRenewals(), (String)("Renewal count in " + stub));
        manager.cancelDelegationToken(dt);
        TestDTManagerLifecycle.assertEquals((int)1, (int)stub.getCancellations(), (String)("Cancel count in " + stub));
        manager.close();
        TestDTManagerLifecycle.assertTrue((boolean)stub.isClosed(), (String)("Not closed: " + stub));
    }
}

