/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.extensions;

import java.net.URI;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsTestWithTimeout;
import org.apache.hadoop.fs.azurebfs.extensions.ExtensionHelper;
import org.apache.hadoop.fs.azurebfs.extensions.WrappingTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADToken;
import org.apache.hadoop.fs.azurebfs.oauth2.CustomTokenProviderAdapter;
import org.junit.jupiter.api.Test;

public class TestCustomOauthTokenProvider
extends AbstractAbfsTestWithTimeout {
    @Test
    public void testCustomProviderBinding() throws Throwable {
        Configuration conf = new Configuration();
        WrappingTokenProvider.enable(conf);
        AbfsConfiguration abfs = new AbfsConfiguration(conf, "not-a-real-account");
        CustomTokenProviderAdapter provider = (CustomTokenProviderAdapter)abfs.getTokenProvider();
        TestCustomOauthTokenProvider.assertEquals((Object)"provider=inited", (Object)provider.getUserAgentSuffix(), (String)"User agent");
        ExtensionHelper.bind((Object)provider, (URI)new URI("abfs://store@user.dfs.core.windows.net"), (Configuration)conf);
        TestCustomOauthTokenProvider.assertEquals((Object)"provider=bound", (Object)ExtensionHelper.getUserAgentSuffix((Object)provider, (String)""), (String)"User agent");
        AzureADToken token = provider.getToken();
        TestCustomOauthTokenProvider.assertEquals((Object)"accessToken", (Object)token.getAccessToken(), (String)"Access token propagation");
        Date expiry = token.getExpiry();
        long time = expiry.getTime();
        TestCustomOauthTokenProvider.assertTrue((time <= System.currentTimeMillis() ? 1 : 0) != 0, (String)("date wrong: " + expiry));
        provider.close();
        TestCustomOauthTokenProvider.assertEquals((Object)"provider=closed", (Object)provider.getUserAgentSuffix(), (String)"User agent");
    }
}

