/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.extensions;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Random;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.extensions.EncryptionContextProvider;
import org.apache.hadoop.fs.azurebfs.security.ABFSKey;

public class MockEncryptionContextProvider
implements EncryptionContextProvider {
    private HashMap<String, String> pathToContextMap = new HashMap();
    private HashMap<String, byte[]> contextToKeyByteMap = new HashMap();

    public void initialize(Configuration configuration, String accountName, String fileSystem) throws IOException {
    }

    public ABFSKey getEncryptionContext(String path) throws IOException {
        String newContext = UUID.randomUUID().toString();
        this.pathToContextMap.put(path, newContext);
        byte[] newKey = new byte[32];
        new Random().nextBytes(newKey);
        ABFSKey key = new ABFSKey(newKey);
        this.contextToKeyByteMap.put(newContext, key.getEncoded());
        return new ABFSKey(newContext.getBytes(StandardCharsets.UTF_8));
    }

    public ABFSKey getEncryptionKey(String path, ABFSKey encryptionContext) throws IOException {
        String encryptionContextString = new String(encryptionContext.getEncoded(), StandardCharsets.UTF_8);
        if (!encryptionContextString.equals(this.pathToContextMap.get(path))) {
            throw new IOException("encryption context does not match path");
        }
        return new ABFSKey(this.contextToKeyByteMap.get(encryptionContextString));
    }

    public byte[] getEncryptionKeyForTest(String encryptionContext) {
        return this.contextToKeyByteMap.get(encryptionContext);
    }

    public String getEncryptionContextForTest(String path) {
        return this.pathToContextMap.get(path);
    }
}

