/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.extensions;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidUriException;
import org.apache.hadoop.fs.azurebfs.extensions.SASTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.ClientCredsTokenProvider;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpHeader;
import org.apache.hadoop.fs.azurebfs.services.AbfsJdkHttpOperation;
import org.apache.hadoop.fs.azurebfs.utils.Base64;
import org.apache.hadoop.fs.azurebfs.utils.DelegationSASGenerator;
import org.apache.hadoop.fs.azurebfs.utils.SASGenerator;
import org.apache.hadoop.security.AccessControlException;

public class MockDelegationSASTokenProvider
implements SASTokenProvider {
    private DelegationSASGenerator generator;
    public static final String TEST_OWNER = "325f1619-4205-432f-9fce-3fd594325ce5";
    public static final String CORRELATION_ID = "66ff4ffc-ff17-417e-a2a9-45db8c5b0b5c";
    public static final String NO_AGENT_PATH = "NoAgentPath";

    public void initialize(Configuration configuration, String accountName) throws IOException {
        String appID = configuration.get("fs.azure.test.app.id");
        String appSecret = configuration.get("fs.azure.test.app.secret");
        String sktid = configuration.get("fs.azure.test.app.service.principal.tenant.id");
        String skoid = configuration.get("fs.azure.test.app.service.principal.object.id");
        String skt = SASGenerator.ISO_8601_FORMATTER.format(Instant.now().minus(SASGenerator.FIVE_MINUTES));
        String ske = SASGenerator.ISO_8601_FORMATTER.format(Instant.now().plus(SASGenerator.ONE_DAY));
        String skv = SASGenerator.AuthenticationVersion.Dec19.toString();
        byte[] key = this.getUserDelegationKey(accountName, appID, appSecret, sktid, skt, ske, skv);
        this.generator = new DelegationSASGenerator(key, skoid, sktid, skt, ske, skv);
    }

    private String getAuthorizationHeader(String accountName, String appID, String appSecret, String sktid) throws IOException {
        String authEndPoint = String.format("https://login.microsoftonline.com/%s/oauth2/v2.0/token", sktid);
        ClientCredsTokenProvider provider = new ClientCredsTokenProvider(authEndPoint, appID, appSecret);
        return "Bearer " + provider.getToken().getAccessToken();
    }

    private byte[] getUserDelegationKey(String accountName, String appID, String appSecret, String sktid, String skt, String ske, String skv) throws IOException {
        URL url;
        String method = "POST";
        String account = accountName.substring(0, accountName.indexOf("."));
        StringBuilder sb = new StringBuilder(128);
        sb.append("https://");
        sb.append(account);
        sb.append(".blob.core.windows.net/?restype=service&comp=userdelegationkey");
        try {
            url = new URL(sb.toString());
        }
        catch (MalformedURLException ex) {
            throw new InvalidUriException(sb.toString());
        }
        ArrayList<AbfsHttpHeader> requestHeaders = new ArrayList<AbfsHttpHeader>();
        requestHeaders.add(new AbfsHttpHeader("x-ms-version", skv));
        requestHeaders.add(new AbfsHttpHeader("Content-Type", "application/x-www-form-urlencoded"));
        requestHeaders.add(new AbfsHttpHeader("Authorization", this.getAuthorizationHeader(account, appID, appSecret, sktid)));
        StringBuilder requestBody = new StringBuilder(512);
        requestBody.append("<?xml version=\"1.0\" encoding=\"utf-8\"?><KeyInfo><Start>");
        requestBody.append(skt);
        requestBody.append("</Start><Expiry>");
        requestBody.append(ske);
        requestBody.append("</Expiry></KeyInfo>");
        AbfsJdkHttpOperation op = new AbfsJdkHttpOperation(url, method, requestHeaders, Duration.ofMillis(2000L), Duration.ofMillis(30000L), null);
        byte[] requestBuffer = requestBody.toString().getBytes(StandardCharsets.UTF_8.toString());
        op.sendPayload(requestBuffer, 0, requestBuffer.length);
        byte[] responseBuffer = new byte[4096];
        op.processResponse(responseBuffer, 0, responseBuffer.length);
        String responseBody = new String(responseBuffer, 0, (int)op.getBytesReceived(), StandardCharsets.UTF_8);
        int beginIndex = responseBody.indexOf("<Value>") + "<Value>".length();
        int endIndex = responseBody.indexOf("</Value>");
        String value = responseBody.substring(beginIndex, endIndex);
        return Base64.decode((String)value);
    }

    public String getSASToken(String accountName, String fileSystem, String path, String operation) throws IOException, AccessControlException {
        String saoid = null;
        String suoid = null;
        if (path == null || !path.endsWith(NO_AGENT_PATH)) {
            saoid = operation == "check-access" ? null : TEST_OWNER;
            suoid = operation == "check-access" ? TEST_OWNER : null;
        }
        return this.generator.getDelegationSAS(accountName, fileSystem, path, operation, saoid, suoid, CORRELATION_ID);
    }
}

