/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.extensions;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberizedAbfsCluster
extends CompositeService {
    private static final Logger LOG = LoggerFactory.getLogger(KerberizedAbfsCluster.class);
    public static final String ALICE = "alice";
    public static final String BOB = "bob";
    public static final String HTTP_LOCALHOST = "HTTP/localhost@$LOCALHOST";
    public static final String LOCALHOST_NAME = Path.WINDOWS ? "127.0.0.1" : "localhost";
    private MiniKdc kdc;
    private File keytab;
    private File workDir;
    private String krbInstance;
    private String loginUsername;
    private String loginPrincipal;
    private String sslConfDir;
    private String clientSSLConfigFileName;
    private String serverSSLConfigFileName;
    private String alicePrincipal;
    private String bobPrincipal;

    public KerberizedAbfsCluster() {
        super("KerberizedAbfsCluster");
        new JobConf();
        if (LOG.isDebugEnabled()) {
            System.setProperty("sun.security.krb5.debug", "true");
            System.setProperty("sun.security.spnego.debug", "true");
        }
    }

    public MiniKdc getKdc() {
        return this.kdc;
    }

    public File getKeytab() {
        return this.keytab;
    }

    public String getKeytabPath() {
        return this.keytab.getAbsolutePath();
    }

    public UserGroupInformation createBobUser() throws IOException {
        return UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)this.bobPrincipal, (String)this.keytab.getAbsolutePath());
    }

    public UserGroupInformation createAliceUser() throws IOException {
        return UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)this.alicePrincipal, (String)this.keytab.getAbsolutePath());
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public String getKrbInstance() {
        return this.krbInstance;
    }

    public String getLoginUsername() {
        return this.loginUsername;
    }

    public String getLoginPrincipal() {
        return this.loginPrincipal;
    }

    public String withRealm(String user) {
        return user + "@EXAMPLE.COM";
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.patchConfigAtInit(conf);
        super.serviceInit(conf);
        Properties kdcConf = MiniKdc.createConf();
        this.workDir = GenericTestUtils.getTestDir((String)"kerberos");
        this.workDir.mkdirs();
        this.kdc = new MiniKdc(kdcConf, this.workDir);
        this.krbInstance = LOCALHOST_NAME;
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        this.kdc.start();
        this.keytab = new File(this.workDir, "keytab.bin");
        this.loginUsername = UserGroupInformation.getLoginUser().getShortUserName();
        this.loginPrincipal = this.loginUsername + "/" + this.krbInstance;
        this.alicePrincipal = "alice/" + this.krbInstance;
        this.bobPrincipal = "bob/" + this.krbInstance;
        this.kdc.createPrincipal(this.keytab, new String[]{this.alicePrincipal, this.bobPrincipal, "HTTP/" + this.krbInstance, HTTP_LOCALHOST, this.loginPrincipal});
        File keystoresDir = new File(this.workDir, "ssl");
        keystoresDir.mkdirs();
        this.sslConfDir = KeyStoreTestUtil.getClasspathDir(((Object)((Object)this)).getClass());
        KeyStoreTestUtil.setupSSLConfig((String)keystoresDir.getAbsolutePath(), (String)this.sslConfDir, (Configuration)this.getConfig(), (boolean)false);
        this.clientSSLConfigFileName = KeyStoreTestUtil.getClientSSLConfigFileName();
        this.serverSSLConfigFileName = KeyStoreTestUtil.getServerSSLConfigFileName();
        String kerberosRule = "RULE:[1:$1@$0](.*@EXAMPLE.COM)s/@.*//\nDEFAULT";
        KerberosName.setRules((String)kerberosRule);
    }

    protected void serviceStop() throws Exception {
        super.serviceStop();
        this.kdc.stop();
    }

    protected void patchConfigAtInit(Configuration conf) {
        int timeout = (int)Duration.ofHours(1L).toMillis();
        conf.setInt("jvm.pause.info-threshold.ms", timeout);
        conf.setInt("jvm.pause.warn-threshold.ms", timeout);
    }

    public void resetUGI() {
        UserGroupInformation.reset();
    }

    private String userOnHost(String shortname) {
        return shortname + "/" + this.krbInstance + "@" + this.getRealm();
    }

    public String getRealm() {
        return this.kdc.getRealm();
    }

    public void loginUser(String user) throws IOException {
        UserGroupInformation.loginUserFromKeytab((String)user, (String)this.getKeytabPath());
    }

    public void loginPrincipal() throws IOException {
        this.loginUser(this.getLoginPrincipal());
    }

    public static void assertSecurityEnabled() {
        Assertions.assertTrue((boolean)UserGroupInformation.isSecurityEnabled(), (String)"Security is needed for this test");
    }

    public static void closeUserFileSystems(UserGroupInformation ugi) throws IOException {
        if (ugi != null) {
            FileSystem.closeAllForUGI((UserGroupInformation)ugi);
        }
    }

    public void bindConfToCluster(Configuration conf) {
        conf.set("hadoop.security.authentication", UserGroupInformation.AuthenticationMethod.KERBEROS.name());
        conf.set("hadoop.user.group.static.mapping.overrides", "alice,alice");
        conf.set("yarn.resourcemanager.principal", BOB);
    }

    public static URI newURI(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public File createTempTokenFile() throws IOException {
        File tokenfile = File.createTempFile("tokens", ".bin", this.getWorkDir());
        tokenfile.delete();
        return tokenfile;
    }
}

