/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.contract;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemContractBaseTest;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.contract.ABFSContractTestBinding;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=900000L, unit=TimeUnit.MILLISECONDS)
public class ITestAzureBlobFileSystemBasics
extends FileSystemContractBaseTest {
    private final ABFSContractTestBinding binding = new ABFSContractTestBinding(false);

    @BeforeEach
    public void setUp() throws Exception {
        this.binding.setup();
        this.fs = this.binding.getFileSystem();
    }

    public void tearDown() throws Exception {
        try {
            super.tearDown();
        }
        finally {
            this.binding.teardown();
        }
    }

    @Test
    public void testListOnFolderWithNoChildren() throws IOException {
        Assertions.assertTrue((boolean)this.fs.mkdirs(this.path("testListStatus/c/1")));
        FileStatus[] paths = this.fs.listStatus(this.path("testListStatus"));
        Assertions.assertEquals((int)1, (int)paths.length);
        paths = this.fs.listStatus(this.path("testListStatus/c"));
        Assertions.assertEquals((int)1, (int)paths.length);
        this.fs.delete(this.path("testListStatus/c/1"), true);
        paths = this.fs.listStatus(this.path("testListStatus/c"));
        Assertions.assertEquals((int)0, (int)paths.length);
        Assertions.assertTrue((boolean)this.fs.delete(this.path("testListStatus"), true));
    }

    @Test
    public void testListOnfileAndFolder() throws IOException {
        Path folderPath = this.path("testListStatus/folder");
        Path filePath = this.path("testListStatus/file");
        Assertions.assertTrue((boolean)this.fs.mkdirs(folderPath));
        ContractTestUtils.touch((FileSystem)this.fs, (Path)filePath);
        FileStatus[] listFolderStatus = this.fs.listStatus(this.path("testListStatus"));
        Assertions.assertEquals((Object)filePath, (Object)listFolderStatus[0].getPath());
        FileStatus[] listFileStatus = this.fs.listStatus(filePath);
        Assertions.assertEquals((Object)filePath, (Object)listFileStatus[0].getPath());
    }

    @Disabled(value="Not implemented in ABFS yet")
    public void testMkdirsWithUmask() throws Exception {
    }
}

