/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.contract;

import java.net.URI;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assumptions;

public class ABFSContractTestBinding
extends AbstractAbfsIntegrationTest {
    private final URI testUri;

    public ABFSContractTestBinding() throws Exception {
        this(true);
    }

    public ABFSContractTestBinding(boolean useExistingFileSystem) throws Exception {
        if (useExistingFileSystem) {
            AbfsConfiguration configuration = this.getConfiguration();
            String testUrl = configuration.get("fs.contract.test.fs.abfs");
            ((AbstractStringAssert)Assumptions.assumeThat((String)testUrl).as("Contract tests are skipped because of missing config property :fs.contract.test.fs.abfs", new Object[0])).isNotNull();
            if (this.getAuthType() != AuthType.SharedKey) {
                testUrl = testUrl.replaceFirst("abfs", "abfss");
            }
            this.setTestUrl(testUrl);
            this.testUri = new URI(testUrl);
            configuration.set("fs.defaultFS", this.testUri.toString());
            String[] splitAuthority = this.testUri.getAuthority().split("\\@");
            this.setFileSystemName(splitAuthority[0]);
        } else {
            this.testUri = new URI(super.getTestUrl());
        }
    }

    public boolean isSecureMode() {
        return this.getAuthType() != AuthType.SharedKey;
    }
}

