/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.commit;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.commit.AbfsCommitTestHelper;
import org.apache.hadoop.fs.azurebfs.contract.ABFSContractTestBinding;
import org.apache.hadoop.fs.azurebfs.contract.AbfsFileSystemContract;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.contract.AbstractFSContract;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.TestRenameStageFailure;
import org.junit.jupiter.api.BeforeEach;

public class ITestAbfsRenameStageFailure
extends TestRenameStageFailure {
    private static final int FILES_TO_CREATE = 20;
    private final ABFSContractTestBinding binding = new ABFSContractTestBinding();

    protected boolean isNamespaceEnabled() throws AzureBlobFileSystemException {
        AzureBlobFileSystem fs = (AzureBlobFileSystem)this.getFileSystem();
        return fs.getAbfsStore().getIsNamespaceEnabled(AbstractAbfsIntegrationTest.getSampleTracingContext(fs, false));
    }

    @BeforeEach
    public void setup() throws Exception {
        this.binding.setup();
        super.setup();
    }

    protected Configuration createConfiguration() {
        return AbfsCommitTestHelper.prepareTestConfiguration(this.binding);
    }

    protected AbstractFSContract createContract(Configuration conf) {
        return new AbfsFileSystemContract(conf, this.binding.isSecureMode());
    }

    protected boolean requireRenameResilience() throws AzureBlobFileSystemException {
        return this.isNamespaceEnabled();
    }

    protected int filesToCreate() {
        return 20;
    }
}

