/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.commit;

import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.commit.AbfsCommitTestHelper;
import org.apache.hadoop.fs.azurebfs.commit.AbfsManifestStoreOperations;
import org.apache.hadoop.fs.azurebfs.contract.ABFSContractTestBinding;
import org.apache.hadoop.fs.azurebfs.contract.AbfsFileSystemContract;
import org.apache.hadoop.fs.contract.AbstractFSContract;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.AbstractManifestCommitterTest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.FileEntry;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestStoreOperations;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITestAbfsManifestStoreOperations
extends AbstractManifestCommitterTest {
    private static final Logger LOG = LoggerFactory.getLogger(ITestAbfsManifestStoreOperations.class);
    private final ABFSContractTestBinding binding = new ABFSContractTestBinding();

    @BeforeEach
    public void setup() throws Exception {
        this.binding.setup();
        super.setup();
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.getFileSystem().hasPathCapability(this.getContract().getTestPath(), "fs.capability.etags.preserved.in.rename")).as("Resilient rename not available", new Object[0])).isTrue();
    }

    protected Configuration createConfiguration() {
        return this.enableManifestCommitter(AbfsCommitTestHelper.prepareTestConfiguration(this.binding));
    }

    protected AbstractFSContract createContract(Configuration conf) {
        return new AbfsFileSystemContract(conf, this.binding.isSecureMode());
    }

    @Test
    public void testEtagConsistencyAcrossListAndHead() throws Throwable {
        this.describe("Etag values must be non-empty and consistent across LIST and HEAD Calls.");
        Path path = this.methodPath();
        FileSystem fs = this.getFileSystem();
        ContractTestUtils.touch((FileSystem)fs, (Path)path);
        ManifestStoreOperations operations = this.createManifestStoreOperations();
        ((ObjectAssert)Assertions.assertThat((Object)operations).describedAs("Store operations class loaded via Configuration", new Object[0])).isInstanceOf(AbfsManifestStoreOperations.class);
        FileStatus st = operations.getFileStatus(path);
        String etag = operations.getEtag(st);
        ((AbstractStringAssert)Assertions.assertThat((String)etag).describedAs("Etag of %s", new Object[]{st})).isNotBlank();
        LOG.info("etag of empty file is \"{}\"", (Object)etag);
        Object[] statuses = fs.listStatus(path);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])statuses).describedAs("List(%s)", new Object[]{path})).hasSize(1);
        Object lsStatus = statuses[0];
        ((AbstractStringAssert)Assertions.assertThat((String)operations.getEtag((FileStatus)lsStatus)).describedAs("etag of list status (%s) compared to HEAD value of %s", new Object[]{lsStatus, st})).isEqualTo((Object)etag);
    }

    @Test
    public void testEtagsOfDifferentDataDifferent() throws Throwable {
        this.describe("Verify that two different blocks of data written have different tags");
        Path path = this.methodPath();
        FileSystem fs = this.getFileSystem();
        Path src = new Path(path, "src");
        ContractTestUtils.createFile((FileSystem)fs, (Path)src, (boolean)true, (byte[])"data1234".getBytes(StandardCharsets.UTF_8));
        ManifestStoreOperations operations = this.createManifestStoreOperations();
        FileStatus srcStatus = operations.getFileStatus(src);
        String srcTag = operations.getEtag(srcStatus);
        LOG.info("etag of file 1 is \"{}\"", (Object)srcTag);
        ContractTestUtils.createFile((FileSystem)fs, (Path)src, (boolean)true, (byte[])"1234data".getBytes(StandardCharsets.UTF_8));
        String tag2 = operations.getEtag(operations.getFileStatus(src));
        LOG.info("etag of file 2 is \"{}\"", (Object)tag2);
        ((AbstractStringAssert)Assertions.assertThat((String)tag2).describedAs("etag of updated file", new Object[0])).isNotEqualTo((Object)srcTag);
    }

    @Test
    public void testEtagConsistencyAcrossRename() throws Throwable {
        this.describe("Verify that when a file is renamed, the etag remains unchanged");
        Path path = this.methodPath();
        FileSystem fs = this.getFileSystem();
        Path src = new Path(path, "src");
        Path dest = new Path(path, "dest");
        ContractTestUtils.createFile((FileSystem)fs, (Path)src, (boolean)true, (byte[])"sample data".getBytes(StandardCharsets.UTF_8));
        ManifestStoreOperations operations = this.createManifestStoreOperations();
        FileStatus srcStatus = operations.getFileStatus(src);
        String srcTag = operations.getEtag(srcStatus);
        LOG.info("etag of short file is \"{}\"", (Object)srcTag);
        ((AbstractStringAssert)Assertions.assertThat((String)srcTag).describedAs("Etag of %s", new Object[]{srcStatus})).isNotBlank();
        operations.commitFile(new FileEntry(src, dest, 0L, srcTag));
        FileStatus destStatus = operations.getFileStatus(dest);
        String destTag = operations.getEtag(destStatus);
        ((AbstractStringAssert)Assertions.assertThat((String)destTag).describedAs("etag of list status (%s) compared to HEAD value of %s", new Object[]{destStatus, srcStatus})).isEqualTo((Object)srcTag);
    }
}

