/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.commit;

import java.io.Closeable;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.azure.integration.AzureTestUtils;
import org.apache.hadoop.fs.azurebfs.commit.AbfsCommitTestHelper;
import org.apache.hadoop.fs.azurebfs.contract.ABFSContractTestBinding;
import org.apache.hadoop.fs.azurebfs.contract.AbfsFileSystemContract;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.fs.contract.AbstractFSContract;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.AbstractManifestCommitterTest;
import org.apache.hadoop.mapreduce.v2.MiniMRYarnCluster;
import org.apache.hadoop.util.DurationInfo;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeEach;

public abstract class AbstractAbfsClusterITest
extends AbstractManifestCommitterTest {
    public static final int NO_OF_NODEMANAGERS = 2;
    private final ABFSContractTestBinding binding = new ABFSContractTestBinding();
    private static ClusterBinding clusterBinding;

    protected AbstractAbfsClusterITest() throws Exception {
    }

    protected int getTestTimeoutMillis() {
        return 1800000;
    }

    @BeforeEach
    public void setup() throws Exception {
        this.binding.setup();
        super.setup();
        this.requireScaleTestsEnabled();
        if (this.getClusterBinding() == null) {
            clusterBinding = this.demandCreateClusterBinding();
        }
        AbstractAbfsClusterITest.assertNotNull((Object)this.getClusterBinding(), (String)"cluster is not bound");
    }

    @AfterAll
    public static void teardownClusters() throws IOException {
        AbstractAbfsClusterITest.terminateCluster(clusterBinding);
        clusterBinding = null;
    }

    protected AbstractFSContract createContract(Configuration conf) {
        return new AbfsFileSystemContract(conf, this.binding.isSecureMode());
    }

    protected Configuration createConfiguration() {
        return AbfsCommitTestHelper.prepareTestConfiguration(this.binding);
    }

    protected static ClusterBinding createCluster(JobConf conf) throws IOException {
        try (DurationInfo d = new DurationInfo(LOG, "Creating YARN MiniCluster", new Object[0]);){
            conf.setBoolean("mapreduce.jobhistory.cleaner.enable", false);
            String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd-HH.mm.ss.SS"));
            String clusterName = "yarn-" + timestamp;
            MiniMRYarnCluster yarnCluster = new MiniMRYarnCluster(clusterName, 2);
            yarnCluster.init((Configuration)conf);
            yarnCluster.start();
            ClusterBinding clusterBinding = new ClusterBinding(clusterName, yarnCluster);
            return clusterBinding;
        }
    }

    protected static void terminateCluster(ClusterBinding cluster) {
        if (cluster != null) {
            cluster.terminate();
        }
    }

    protected ClusterBinding getClusterBinding() {
        return clusterBinding;
    }

    protected MiniMRYarnCluster getYarn() {
        return this.getClusterBinding().getYarn();
    }

    protected ClusterBinding demandCreateClusterBinding() throws Exception {
        return AbstractAbfsClusterITest.createCluster(new JobConf());
    }

    protected JobConf newJobConf() throws IOException {
        JobConf jobConf = new JobConf(this.getYarn().getConfig());
        jobConf.addResource(this.getConfiguration());
        if (this.getConfiguration().getEnum("fs.azure.account.auth.type", (Enum)AuthType.SharedKey) == AuthType.OAuth) {
            this.assumeValidTestConfigPresent("fs.azure.account.oauth2.client.service.principal.object.id");
            String pid = jobConf.get("fs.azure.account.oauth2.client.service.principal.object.id");
            jobConf.set("fs.azure.identity.transformer.service.principal.id", pid);
            jobConf.set("fs.azure.identity.transformer.service.principal.substitution.list", "*");
            jobConf.setBoolean(String.format("fs.%s.impl.disable.cache", "abfss"), true);
        }
        this.applyCustomConfigOptions(jobConf);
        return jobConf;
    }

    protected Configuration patchConfigurationForCommitter(Configuration jobConf) {
        this.enableManifestCommitter(jobConf);
        return jobConf;
    }

    protected void applyCustomConfigOptions(JobConf jobConf) throws IOException {
    }

    protected void requireScaleTestsEnabled() {
        AzureTestUtils.assumeScaleTestsEnabled(this.getConfiguration());
    }

    protected void assumeValidTestConfigPresent(String key) {
        String configuredValue = this.getConfiguration().get(key);
        Assumptions.assumeThat((configuredValue != null && !configuredValue.isEmpty() ? 1 : 0) != 0).isTrue();
    }

    protected static final class ClusterBinding {
        private String clusterName;
        private final MiniMRYarnCluster yarn;

        public ClusterBinding(String clusterName, MiniMRYarnCluster yarn) {
            this.clusterName = clusterName;
            this.yarn = Objects.requireNonNull(yarn);
        }

        public FileSystem getClusterFS() throws IOException {
            return FileSystem.getLocal((Configuration)this.yarn.getConfig());
        }

        public MiniMRYarnCluster getYarn() {
            return this.yarn;
        }

        public Configuration getConf() {
            return this.getYarn().getConfig();
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public void terminate() {
            IOUtils.closeStream((Closeable)this.getYarn());
        }
    }
}

