/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.ConfigurationPropertyNotFoundException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidConfigurationValueException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.TokenAccessProviderException;
import org.apache.hadoop.fs.azurebfs.oauth2.AccessTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.ClientAssertionProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.ClientCredsTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.CustomTokenProviderAdapter;
import org.apache.hadoop.fs.azurebfs.oauth2.MsiTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.RefreshTokenBasedTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.UserPasswordTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.WorkloadIdentityTokenProvider;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

public class TestAccountConfiguration {
    private static final String TEST_OAUTH_PROVIDER_CLASS_CONFIG = "org.apache.hadoop.fs.azurebfs.oauth2.ClientCredsTokenProvider";
    private static final String TEST_OAUTH_MSI_TOKEN_PROVIDER_CLASS_CONFIG = "org.apache.hadoop.fs.azurebfs.oauth2.MsiTokenProvider";
    private static final String TEST_CUSTOM_PROVIDER_CLASS_CONFIG = "org.apache.hadoop.fs.azurebfs.oauth2.RetryTestTokenProvider";
    private static final String TEST_SAS_PROVIDER_CLASS_CONFIG_1 = "org.apache.hadoop.fs.azurebfs.extensions.MockErrorSASTokenProvider";
    private static final String TEST_SAS_PROVIDER_CLASS_CONFIG_2 = "org.apache.hadoop.fs.azurebfs.extensions.MockSASTokenProvider";
    private static final String TEST_OAUTH_ENDPOINT = "oauthEndpoint";
    private static final String TEST_CLIENT_ID = "clientId";
    private static final String TEST_CLIENT_SECRET = "clientSecret";
    private static final String TEST_USER_NAME = "userName";
    private static final String TEST_USER_PASSWORD = "userPassword";
    private static final String TEST_MSI_TENANT = "msiTenant";
    private static final String TEST_REFRESH_TOKEN = "refreshToken";
    private static final String TEST_CUSTOM_CLIENT_ASSERTION_PROVIDER = "org.apache.hadoop.fs.azurebfs.TestAccountConfiguration$MockClientAssertionProvider";
    private static final String TEST_TOKEN_FILE = "/tmp/test-token-file";
    private static final List<String> CLIENT_CREDENTIAL_OAUTH_CONFIG_KEYS = Collections.unmodifiableList(Arrays.asList("fs.azure.account.oauth2.client.endpoint", "fs.azure.account.oauth2.client.id", "fs.azure.account.oauth2.client.secret"));
    private static final List<String> USER_PASSWORD_OAUTH_CONFIG_KEYS = Collections.unmodifiableList(Arrays.asList("fs.azure.account.oauth2.client.endpoint", "fs.azure.account.oauth2.user.name", "fs.azure.account.oauth2.user.password"));
    private static final List<String> REFRESH_TOKEN_OAUTH_CONFIG_KEYS = Collections.unmodifiableList(Arrays.asList("fs.azure.account.oauth2.refresh.token", "fs.azure.account.oauth2.client.id"));
    private static final List<String> WORKLOAD_IDENTITY_OAUTH_CONFIG_KEYS = Collections.unmodifiableList(Arrays.asList("fs.azure.account.oauth2.msi.tenant", "fs.azure.account.oauth2.client.id"));

    @Test
    public void testStringPrecedence() throws IllegalAccessException, IOException, InvalidConfigurationValueException {
        Configuration conf = new Configuration();
        String accountName1 = "account1";
        String accountName2 = "account2";
        String accountName3 = "account3";
        String globalKey = "fs.azure.configuration";
        String accountKey1 = "fs.azure.configuration.account1";
        String accountKey2 = "fs.azure.configuration.account2";
        String accountKey3 = "fs.azure.configuration.account3";
        String globalValue = "global";
        String accountValue1 = "one";
        String accountValue2 = "two";
        conf.set("fs.azure.configuration.account1", "one");
        conf.set("fs.azure.configuration.account2", "two");
        conf.set("fs.azure.configuration", "global");
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account1");
        org.junit.jupiter.api.Assertions.assertEquals((Object)abfsConf.get("fs.azure.configuration.account1"), (Object)"one", (String)"Wrong value returned when account-specific value was requested");
        org.junit.jupiter.api.Assertions.assertEquals((Object)abfsConf.get("fs.azure.configuration"), (Object)"one", (String)"Account-specific value was not returned when one existed");
        abfsConf = new AbfsConfiguration(conf, "account2");
        org.junit.jupiter.api.Assertions.assertEquals((Object)abfsConf.get("fs.azure.configuration.account1"), (Object)"one", (String)"Wrong value returned when a different account-specific value was requested");
        org.junit.jupiter.api.Assertions.assertEquals((Object)abfsConf.get("fs.azure.configuration.account2"), (Object)"two", (String)"Wrong value returned when account-specific value was requested");
        org.junit.jupiter.api.Assertions.assertEquals((Object)abfsConf.get("fs.azure.configuration"), (Object)"two", (String)"Account-agnostic value return even though account-specific value was set");
        abfsConf = new AbfsConfiguration(conf, "account3");
        org.junit.jupiter.api.Assertions.assertNull((Object)abfsConf.get("fs.azure.configuration.account3"), (String)"Account-specific value returned when none was set");
        org.junit.jupiter.api.Assertions.assertEquals((Object)abfsConf.get("fs.azure.configuration"), (Object)"global", (String)"Account-agnostic value not returned when no account-specific value was set");
    }

    @Test
    public void testPasswordPrecedence() throws IllegalAccessException, IOException, InvalidConfigurationValueException {
        Configuration conf = new Configuration();
        String accountName1 = "account1";
        String accountName2 = "account2";
        String accountName3 = "account3";
        String globalKey = "fs.azure.password";
        String accountKey1 = "fs.azure.password.account1";
        String accountKey2 = "fs.azure.password.account2";
        String accountKey3 = "fs.azure.password.account3";
        String globalValue = "global";
        String accountValue1 = "one";
        String accountValue2 = "two";
        conf.set("fs.azure.password.account1", "one");
        conf.set("fs.azure.password.account2", "two");
        conf.set("fs.azure.password", "global");
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account1");
        org.junit.jupiter.api.Assertions.assertEquals((Object)abfsConf.getPasswordString("fs.azure.password.account1"), (Object)"one", (String)"Wrong value returned when account-specific value was requested");
        org.junit.jupiter.api.Assertions.assertEquals((Object)abfsConf.getPasswordString("fs.azure.password"), (Object)"one", (String)"Account-specific value was not returned when one existed");
        abfsConf = new AbfsConfiguration(conf, "account2");
        org.junit.jupiter.api.Assertions.assertEquals((Object)abfsConf.getPasswordString("fs.azure.password.account1"), (Object)"one", (String)"Wrong value returned when a different account-specific value was requested");
        org.junit.jupiter.api.Assertions.assertEquals((Object)abfsConf.getPasswordString("fs.azure.password.account2"), (Object)"two", (String)"Wrong value returned when account-specific value was requested");
        org.junit.jupiter.api.Assertions.assertEquals((Object)abfsConf.getPasswordString("fs.azure.password"), (Object)"two", (String)"Account-agnostic value return even though account-specific value was set");
        abfsConf = new AbfsConfiguration(conf, "account3");
        org.junit.jupiter.api.Assertions.assertNull((Object)abfsConf.getPasswordString("fs.azure.password.account3"), (String)"Account-specific value returned when none was set");
        org.junit.jupiter.api.Assertions.assertEquals((Object)abfsConf.getPasswordString("fs.azure.password"), (Object)"global", (String)"Account-agnostic value not returned when no account-specific value was set");
    }

    @Test
    public void testBooleanPrecedence() throws IllegalAccessException, IOException, InvalidConfigurationValueException {
        String accountName = "account";
        String globalKey = "fs.azure.bool";
        String accountKey = "fs.azure.bool.account";
        Configuration conf = new Configuration();
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account");
        conf.setBoolean("fs.azure.bool", false);
        org.junit.jupiter.api.Assertions.assertEquals((Object)abfsConf.getBoolean("fs.azure.bool", true), (Object)false, (String)"Default value returned even though account-agnostic config was set");
        conf.unset("fs.azure.bool");
        org.junit.jupiter.api.Assertions.assertEquals((Object)abfsConf.getBoolean("fs.azure.bool", true), (Object)true, (String)"Default value not returned even though config was unset");
        conf.setBoolean("fs.azure.bool.account", false);
        org.junit.jupiter.api.Assertions.assertEquals((Object)abfsConf.getBoolean("fs.azure.bool", true), (Object)false, (String)"Default value returned even though account-specific config was set");
        conf.unset("fs.azure.bool.account");
        org.junit.jupiter.api.Assertions.assertEquals((Object)abfsConf.getBoolean("fs.azure.bool", true), (Object)true, (String)"Default value not returned even though config was unset");
        conf.setBoolean("fs.azure.bool.account", true);
        conf.setBoolean("fs.azure.bool", false);
        org.junit.jupiter.api.Assertions.assertEquals((Object)abfsConf.getBoolean("fs.azure.bool", false), (Object)true, (String)"Account-agnostic or default value returned even though account-specific config was set");
    }

    @Test
    public void testLongPrecedence() throws IllegalAccessException, IOException, InvalidConfigurationValueException {
        String accountName = "account";
        String globalKey = "fs.azure.long";
        String accountKey = "fs.azure.long.account";
        Configuration conf = new Configuration();
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account");
        conf.setLong("fs.azure.long", 0L);
        org.junit.jupiter.api.Assertions.assertEquals((long)abfsConf.getLong("fs.azure.long", 1L), (long)0L, (String)"Default value returned even though account-agnostic config was set");
        conf.unset("fs.azure.long");
        org.junit.jupiter.api.Assertions.assertEquals((long)abfsConf.getLong("fs.azure.long", 1L), (long)1L, (String)"Default value not returned even though config was unset");
        conf.setLong("fs.azure.long.account", 0L);
        org.junit.jupiter.api.Assertions.assertEquals((long)abfsConf.getLong("fs.azure.long", 1L), (long)0L, (String)"Default value returned even though account-specific config was set");
        conf.unset("fs.azure.long.account");
        org.junit.jupiter.api.Assertions.assertEquals((long)abfsConf.getLong("fs.azure.long", 1L), (long)1L, (String)"Default value not returned even though config was unset");
        conf.setLong("fs.azure.long.account", 1L);
        conf.setLong("fs.azure.long", 0L);
        org.junit.jupiter.api.Assertions.assertEquals((long)abfsConf.getLong("fs.azure.long", 0L), (long)1L, (String)"Account-agnostic or default value returned even though account-specific config was set");
    }

    @Test
    public void testEnumPrecedence() throws IllegalAccessException, IOException, InvalidConfigurationValueException {
        String accountName = "account";
        String globalKey = "fs.azure.enum";
        String accountKey = "fs.azure.enum.account";
        Configuration conf = new Configuration();
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account");
        conf.setEnum("fs.azure.enum", (Enum)GetEnumType.FALSE);
        org.junit.jupiter.api.Assertions.assertEquals((Object)abfsConf.getEnum("fs.azure.enum", (Enum)GetEnumType.TRUE), (Object)((Object)GetEnumType.FALSE), (String)"Default value returned even though account-agnostic config was set");
        conf.unset("fs.azure.enum");
        org.junit.jupiter.api.Assertions.assertEquals((Object)abfsConf.getEnum("fs.azure.enum", (Enum)GetEnumType.TRUE), (Object)((Object)GetEnumType.TRUE), (String)"Default value not returned even though config was unset");
        conf.setEnum("fs.azure.enum.account", (Enum)GetEnumType.FALSE);
        org.junit.jupiter.api.Assertions.assertEquals((Object)abfsConf.getEnum("fs.azure.enum", (Enum)GetEnumType.TRUE), (Object)((Object)GetEnumType.FALSE), (String)"Default value returned even though account-specific config was set");
        conf.unset("fs.azure.enum.account");
        org.junit.jupiter.api.Assertions.assertEquals((Object)abfsConf.getEnum("fs.azure.enum", (Enum)GetEnumType.TRUE), (Object)((Object)GetEnumType.TRUE), (String)"Default value not returned even though config was unset");
        conf.setEnum("fs.azure.enum.account", (Enum)GetEnumType.TRUE);
        conf.setEnum("fs.azure.enum", (Enum)GetEnumType.FALSE);
        org.junit.jupiter.api.Assertions.assertEquals((Object)abfsConf.getEnum("fs.azure.enum", (Enum)GetEnumType.FALSE), (Object)((Object)GetEnumType.TRUE), (String)"Account-agnostic or default value returned even though account-specific config was set");
    }

    @Test
    public void testClass() throws IllegalAccessException, IOException, InvalidConfigurationValueException {
        String accountName = "account";
        String globalKey = "fs.azure.class";
        String accountKey = "fs.azure.class.account";
        Configuration conf = new Configuration();
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account");
        Class<GetClassImpl0> class0 = GetClassImpl0.class;
        Class<GetClassImpl1> class1 = GetClassImpl1.class;
        Class<GetClassInterface> xface = GetClassInterface.class;
        conf.setClass("fs.azure.class", class0, xface);
        org.junit.jupiter.api.Assertions.assertEquals((Object)abfsConf.getAccountAgnosticClass("fs.azure.class", class1, xface), class0, (String)"Default value returned even though account-agnostic config was set");
        conf.unset("fs.azure.class");
        org.junit.jupiter.api.Assertions.assertEquals((Object)abfsConf.getAccountAgnosticClass("fs.azure.class", class1, xface), class1, (String)"Default value not returned even though config was unset");
        conf.setClass("fs.azure.class.account", class0, xface);
        org.junit.jupiter.api.Assertions.assertEquals((Object)abfsConf.getAccountSpecificClass("fs.azure.class", class1, xface), class0, (String)"Default value returned even though account-specific config was set");
        conf.unset("fs.azure.class.account");
        org.junit.jupiter.api.Assertions.assertEquals((Object)abfsConf.getAccountSpecificClass("fs.azure.class", class1, xface), class1, (String)"Default value not returned even though config was unset");
        conf.setClass("fs.azure.class.account", class1, xface);
        conf.setClass("fs.azure.class", class0, xface);
        org.junit.jupiter.api.Assertions.assertEquals((Object)abfsConf.getAccountSpecificClass("fs.azure.class", class0, xface), class1, (String)"Account-agnostic or default value returned even though account-specific config was set");
    }

    @Test
    public void testSASProviderPrecedence() throws IOException, IllegalAccessException {
        String accountName = "account";
        Configuration conf = new Configuration();
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account");
        abfsConf.set("fs.azure.account.auth.type.account", "SAS");
        abfsConf.set("fs.azure.sas.token.provider.type.account", TEST_SAS_PROVIDER_CLASS_CONFIG_1);
        abfsConf.set("fs.azure.account.auth.type", AuthType.SAS.toString());
        abfsConf.set("fs.azure.sas.token.provider.type", TEST_SAS_PROVIDER_CLASS_CONFIG_2);
        ((AbstractStringAssert)Assertions.assertThat((String)abfsConf.getSASTokenProvider().getClass().getName()).describedAs("Account-specific SAS token provider should be in effect.", new Object[0])).isEqualTo((Object)TEST_SAS_PROVIDER_CLASS_CONFIG_1);
    }

    @Test
    public void testAccessTokenProviderPrecedence() throws IllegalAccessException, IOException {
        String accountName = "account";
        Configuration conf = new Configuration();
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account");
        this.testGlobalAndAccountOAuthPrecedence(abfsConf, AuthType.Custom, AuthType.OAuth);
        this.testGlobalAndAccountOAuthPrecedence(abfsConf, AuthType.OAuth, AuthType.Custom);
        this.testGlobalAndAccountOAuthPrecedence(abfsConf, AuthType.SAS, AuthType.Custom);
        this.testGlobalAndAccountOAuthPrecedence(abfsConf, AuthType.Custom, null);
        this.testGlobalAndAccountOAuthPrecedence(abfsConf, AuthType.OAuth, null);
        this.testGlobalAndAccountOAuthPrecedence(abfsConf, null, AuthType.Custom);
        this.testGlobalAndAccountOAuthPrecedence(abfsConf, null, AuthType.OAuth);
    }

    @Test
    public void testOAuthConfigPropNotFound() throws Throwable {
        this.testConfigPropNotFound(CLIENT_CREDENTIAL_OAUTH_CONFIG_KEYS, ClientCredsTokenProvider.class.getName());
        this.testConfigPropNotFound(USER_PASSWORD_OAUTH_CONFIG_KEYS, UserPasswordTokenProvider.class.getName());
        this.testConfigPropNotFound(REFRESH_TOKEN_OAUTH_CONFIG_KEYS, RefreshTokenBasedTokenProvider.class.getName());
        this.testConfigPropNotFound(WORKLOAD_IDENTITY_OAUTH_CONFIG_KEYS, WorkloadIdentityTokenProvider.class.getName());
    }

    private void testConfigPropNotFound(List<String> configKeys, String tokenProviderClassName) throws Throwable {
        String accountName = "account";
        Configuration conf = new Configuration();
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account");
        for (String key : configKeys) {
            this.setAuthConfig(abfsConf, true, AuthType.OAuth, tokenProviderClassName);
            abfsConf.unset(key);
            abfsConf.unset(key + ".account");
            TestAccountConfiguration.testMissingConfigKey(abfsConf, key);
        }
        this.unsetAuthConfig(abfsConf, false);
        this.unsetAuthConfig(abfsConf, true);
    }

    private static void testMissingConfigKey(AbfsConfiguration abfsConf, String confKey) throws Throwable {
        GenericTestUtils.assertExceptionContains((String)("Configuration property " + confKey + " not found."), (Throwable)LambdaTestUtils.verifyCause(ConfigurationPropertyNotFoundException.class, (Throwable)LambdaTestUtils.intercept(TokenAccessProviderException.class, () -> abfsConf.getTokenProvider().getClass().getTypeName())));
    }

    @Test
    public void testClientAndTenantIdOptionalWhenUsingMsiTokenProvider() throws Throwable {
        String accountName = "account";
        Configuration conf = new Configuration();
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account");
        String accountNameSuffix = "." + abfsConf.getAccountName();
        String authKey = "fs.azure.account.auth.type" + accountNameSuffix;
        Object providerClassKey = "";
        String providerClassValue = "";
        providerClassKey = "fs.azure.account.oauth.provider.type" + accountNameSuffix;
        providerClassValue = TEST_OAUTH_MSI_TOKEN_PROVIDER_CLASS_CONFIG;
        abfsConf.set(authKey, AuthType.OAuth.toString());
        abfsConf.set((String)providerClassKey, providerClassValue);
        AccessTokenProvider tokenProviderTypeName = abfsConf.getTokenProvider();
        ((ObjectAssert)Assertions.assertThat((Object)tokenProviderTypeName).describedAs("Token Provider Should be MsiTokenProvider", new Object[0])).isInstanceOf(MsiTokenProvider.class);
    }

    public void testGlobalAndAccountOAuthPrecedence(AbfsConfiguration abfsConf, AuthType globalAuthType, AuthType accountSpecificAuthType) throws IOException {
        if (globalAuthType == null) {
            this.unsetAuthConfig(abfsConf, false);
        } else {
            this.setAuthConfig(abfsConf, false, globalAuthType, TEST_OAUTH_PROVIDER_CLASS_CONFIG);
        }
        if (accountSpecificAuthType == null) {
            this.unsetAuthConfig(abfsConf, true);
        } else {
            this.setAuthConfig(abfsConf, true, accountSpecificAuthType, TEST_OAUTH_PROVIDER_CLASS_CONFIG);
        }
        AuthType expectedEffectiveAuthType = accountSpecificAuthType != null ? accountSpecificAuthType : globalAuthType;
        Class expectedEffectiveTokenProviderClassType = expectedEffectiveAuthType == AuthType.OAuth ? ClientCredsTokenProvider.class : CustomTokenProviderAdapter.class;
        ((AbstractStringAssert)Assertions.assertThat((String)abfsConf.getTokenProvider().getClass().getTypeName()).describedAs("Account-specific settings takes precendence to global settings. In absence of Account settings, global settings should take effect.", new Object[0])).isEqualTo((Object)expectedEffectiveTokenProviderClassType.getTypeName());
        this.unsetAuthConfig(abfsConf, false);
        this.unsetAuthConfig(abfsConf, true);
    }

    public void setAuthConfig(AbfsConfiguration abfsConf, boolean isAccountSetting, AuthType authType, String tokenProviderClassName) {
        String accountNameSuffix = "." + abfsConf.getAccountName();
        String authKey = "fs.azure.account.auth.type" + (String)(isAccountSetting ? accountNameSuffix : "");
        Object providerClassKey = "";
        String providerClassValue = "";
        switch (authType) {
            case OAuth: {
                providerClassKey = "fs.azure.account.oauth.provider.type" + (String)(isAccountSetting ? accountNameSuffix : "");
                providerClassValue = tokenProviderClassName;
                this.setOAuthConfigs(abfsConf, isAccountSetting, tokenProviderClassName);
                abfsConf.set("fs.azure.account.oauth2.client.endpoint" + (String)(isAccountSetting ? accountNameSuffix : ""), TEST_OAUTH_ENDPOINT);
                abfsConf.set("fs.azure.account.oauth2.client.id" + (String)(isAccountSetting ? accountNameSuffix : ""), TEST_CLIENT_ID);
                abfsConf.set("fs.azure.account.oauth2.client.secret" + (String)(isAccountSetting ? accountNameSuffix : ""), TEST_CLIENT_SECRET);
                break;
            }
            case Custom: {
                providerClassKey = "fs.azure.account.oauth.provider.type" + (String)(isAccountSetting ? accountNameSuffix : "");
                providerClassValue = TEST_CUSTOM_PROVIDER_CLASS_CONFIG;
                break;
            }
            case SAS: {
                providerClassKey = "fs.azure.sas.token.provider.type" + (String)(isAccountSetting ? accountNameSuffix : "");
                providerClassValue = TEST_SAS_PROVIDER_CLASS_CONFIG_1;
                break;
            }
        }
        abfsConf.set(authKey, authType.toString());
        abfsConf.set((String)providerClassKey, providerClassValue);
    }

    private void setOAuthConfigs(AbfsConfiguration abfsConfig, boolean isAccountSettings, String tokenProviderClassName) {
        String accountNameSuffix;
        String string = accountNameSuffix = isAccountSettings ? "." + abfsConfig.getAccountName() : "";
        if (tokenProviderClassName.equals(ClientCredsTokenProvider.class.getName())) {
            abfsConfig.set("fs.azure.account.oauth2.client.endpoint" + accountNameSuffix, TEST_OAUTH_ENDPOINT);
            abfsConfig.set("fs.azure.account.oauth2.client.id" + accountNameSuffix, TEST_CLIENT_ID);
            abfsConfig.set("fs.azure.account.oauth2.client.secret" + accountNameSuffix, TEST_CLIENT_SECRET);
        }
        if (tokenProviderClassName.equals(UserPasswordTokenProvider.class.getName())) {
            abfsConfig.set("fs.azure.account.oauth2.client.endpoint" + accountNameSuffix, TEST_OAUTH_ENDPOINT);
            abfsConfig.set("fs.azure.account.oauth2.user.name" + accountNameSuffix, TEST_USER_NAME);
            abfsConfig.set("fs.azure.account.oauth2.user.password" + accountNameSuffix, TEST_USER_PASSWORD);
        }
        if (tokenProviderClassName.equals(MsiTokenProvider.class.getName())) {
            abfsConfig.set("fs.azure.account.oauth2.msi.tenant" + accountNameSuffix, TEST_MSI_TENANT);
            abfsConfig.set("fs.azure.account.oauth2.client.id" + accountNameSuffix, TEST_CLIENT_ID);
        }
        if (tokenProviderClassName.equals(RefreshTokenBasedTokenProvider.class.getName())) {
            abfsConfig.set("fs.azure.account.oauth2.refresh.token" + accountNameSuffix, TEST_REFRESH_TOKEN);
            abfsConfig.set("fs.azure.account.oauth2.client.id" + accountNameSuffix, TEST_CLIENT_ID);
        }
        if (tokenProviderClassName.equals(WorkloadIdentityTokenProvider.class.getName())) {
            abfsConfig.set("fs.azure.account.oauth2.msi.tenant" + accountNameSuffix, TEST_MSI_TENANT);
            abfsConfig.set("fs.azure.account.oauth2.client.id" + accountNameSuffix, TEST_CLIENT_ID);
        }
    }

    private void unsetAuthConfig(AbfsConfiguration abfsConf, boolean isAccountSettings) {
        String accountNameSuffix = isAccountSettings ? "." + abfsConf.getAccountName() : "";
        abfsConf.unset("fs.azure.account.auth.type" + accountNameSuffix);
        abfsConf.unset("fs.azure.account.oauth.provider.type" + accountNameSuffix);
        abfsConf.unset("fs.azure.sas.token.provider.type" + accountNameSuffix);
        abfsConf.unset("fs.azure.account.oauth2.client.endpoint" + accountNameSuffix);
        abfsConf.unset("fs.azure.account.oauth2.client.id" + accountNameSuffix);
        abfsConf.unset("fs.azure.account.oauth2.client.secret" + accountNameSuffix);
        abfsConf.unset("fs.azure.account.oauth2.user.name" + accountNameSuffix);
        abfsConf.unset("fs.azure.account.oauth2.user.password" + accountNameSuffix);
        abfsConf.unset("fs.azure.account.oauth2.msi.tenant" + accountNameSuffix);
        abfsConf.unset("fs.azure.account.oauth2.refresh.token" + accountNameSuffix);
        abfsConf.unset("fs.azure.account.oauth2.client.assertion.provider.type" + accountNameSuffix);
    }

    @Test
    public void testWorkloadIdentityTokenProviderWithCustomClientAssertionProvider() throws Exception {
        String accountName = "account";
        Configuration conf = new Configuration();
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account");
        String accountNameSuffix = "." + abfsConf.getAccountName();
        abfsConf.set("fs.azure.account.auth.type" + accountNameSuffix, AuthType.OAuth.toString());
        abfsConf.set("fs.azure.account.oauth.provider.type" + accountNameSuffix, WorkloadIdentityTokenProvider.class.getName());
        abfsConf.set("fs.azure.account.oauth2.msi.tenant" + accountNameSuffix, TEST_MSI_TENANT);
        abfsConf.set("fs.azure.account.oauth2.client.id" + accountNameSuffix, TEST_CLIENT_ID);
        abfsConf.set("fs.azure.account.oauth2.client.assertion.provider.type" + accountNameSuffix, TEST_CUSTOM_CLIENT_ASSERTION_PROVIDER);
        AccessTokenProvider tokenProvider = abfsConf.getTokenProvider();
        ((ObjectAssert)Assertions.assertThat((Object)tokenProvider).describedAs("Should create WorkloadIdentityTokenProvider with custom ClientAssertionProvider", new Object[0])).isInstanceOf(WorkloadIdentityTokenProvider.class);
        String customProviderType = abfsConf.getPasswordString("fs.azure.account.oauth2.client.assertion.provider.type");
        ((AbstractStringAssert)Assertions.assertThat((String)customProviderType).describedAs("Custom provider type should be configured", new Object[0])).isEqualTo((Object)TEST_CUSTOM_CLIENT_ASSERTION_PROVIDER);
    }

    @Test
    public void testWorkloadIdentityTokenProviderWithFileBasedFallback() throws Exception {
        String accountName = "account";
        Configuration conf = new Configuration();
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account");
        String accountNameSuffix = "." + abfsConf.getAccountName();
        abfsConf.set("fs.azure.account.auth.type" + accountNameSuffix, AuthType.OAuth.toString());
        abfsConf.set("fs.azure.account.oauth.provider.type" + accountNameSuffix, WorkloadIdentityTokenProvider.class.getName());
        abfsConf.set("fs.azure.account.oauth2.msi.tenant" + accountNameSuffix, TEST_MSI_TENANT);
        abfsConf.set("fs.azure.account.oauth2.client.id" + accountNameSuffix, TEST_CLIENT_ID);
        AccessTokenProvider tokenProvider = abfsConf.getTokenProvider();
        ((ObjectAssert)Assertions.assertThat((Object)tokenProvider).describedAs("Should create WorkloadIdentityTokenProvider with file-based fallback", new Object[0])).isInstanceOf(WorkloadIdentityTokenProvider.class);
        String customProviderType = abfsConf.getPasswordString("fs.azure.account.oauth2.client.assertion.provider.type");
        ((AbstractStringAssert)Assertions.assertThat((String)customProviderType).describedAs("No custom provider should be configured for file-based fallback", new Object[0])).isNull();
    }

    @Test
    public void testWorkloadIdentityTokenProviderWithInvalidCustomProvider() throws Exception {
        String accountName = "account";
        Configuration conf = new Configuration();
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account");
        String accountNameSuffix = "." + abfsConf.getAccountName();
        abfsConf.set("fs.azure.account.auth.type" + accountNameSuffix, AuthType.OAuth.toString());
        abfsConf.set("fs.azure.account.oauth.provider.type" + accountNameSuffix, WorkloadIdentityTokenProvider.class.getName());
        abfsConf.set("fs.azure.account.oauth2.msi.tenant" + accountNameSuffix, TEST_MSI_TENANT);
        abfsConf.set("fs.azure.account.oauth2.client.id" + accountNameSuffix, TEST_CLIENT_ID);
        abfsConf.set("fs.azure.account.oauth2.client.assertion.provider.type" + accountNameSuffix, "non.existent.InvalidProvider");
        TokenAccessProviderException exception = (TokenAccessProviderException)LambdaTestUtils.intercept(TokenAccessProviderException.class, () -> abfsConf.getTokenProvider());
        ((AbstractStringAssert)Assertions.assertThat((String)exception.getMessage()).describedAs("Should contain error about unable to load OAuth token provider class", new Object[0])).contains(new CharSequence[]{"Unable to load OAuth token provider class"});
    }

    @Test
    public void testWorkloadIdentityTokenProviderWithEmptyCustomProviderConfig() throws Exception {
        String accountName = "account";
        Configuration conf = new Configuration();
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account");
        String accountNameSuffix = "." + abfsConf.getAccountName();
        abfsConf.set("fs.azure.account.auth.type" + accountNameSuffix, AuthType.OAuth.toString());
        abfsConf.set("fs.azure.account.oauth.provider.type" + accountNameSuffix, WorkloadIdentityTokenProvider.class.getName());
        abfsConf.set("fs.azure.account.oauth2.msi.tenant" + accountNameSuffix, TEST_MSI_TENANT);
        abfsConf.set("fs.azure.account.oauth2.client.id" + accountNameSuffix, TEST_CLIENT_ID);
        abfsConf.set("fs.azure.account.oauth2.client.assertion.provider.type" + accountNameSuffix, "   ");
        AccessTokenProvider tokenProvider = abfsConf.getTokenProvider();
        ((ObjectAssert)Assertions.assertThat((Object)tokenProvider).describedAs("Should create WorkloadIdentityTokenProvider with file-based fallback when provider config is empty", new Object[0])).isInstanceOf(WorkloadIdentityTokenProvider.class);
        String customProviderType = abfsConf.getPasswordString("fs.azure.account.oauth2.client.assertion.provider.type");
        ((AbstractStringAssert)Assertions.assertThat((String)customProviderType).describedAs("Empty custom provider config should be present but whitespace-only", new Object[0])).isEqualTo((Object)"   ");
        ((AbstractStringAssert)Assertions.assertThat((String)customProviderType.trim()).describedAs("Trimmed custom provider config should be empty", new Object[0])).isEmpty();
    }

    @Test
    public void testWorkloadIdentityCustomProviderConfigPrecedence() throws Exception {
        String accountName = "account";
        Configuration conf = new Configuration();
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account");
        String accountNameSuffix = "." + abfsConf.getAccountName();
        abfsConf.set("fs.azure.account.auth.type" + accountNameSuffix, AuthType.OAuth.toString());
        abfsConf.set("fs.azure.account.oauth.provider.type" + accountNameSuffix, WorkloadIdentityTokenProvider.class.getName());
        abfsConf.set("fs.azure.account.oauth2.msi.tenant" + accountNameSuffix, TEST_MSI_TENANT);
        abfsConf.set("fs.azure.account.oauth2.client.id" + accountNameSuffix, TEST_CLIENT_ID);
        abfsConf.set("fs.azure.account.oauth2.client.assertion.provider.type", "some.other.Provider");
        abfsConf.set("fs.azure.account.oauth2.client.assertion.provider.type" + accountNameSuffix, TEST_CUSTOM_CLIENT_ASSERTION_PROVIDER);
        AccessTokenProvider tokenProvider = abfsConf.getTokenProvider();
        ((ObjectAssert)Assertions.assertThat((Object)tokenProvider).describedAs("Should create WorkloadIdentityTokenProvider with account-specific custom provider taking precedence", new Object[0])).isInstanceOf(WorkloadIdentityTokenProvider.class);
        String accountSpecificProvider = abfsConf.getPasswordString("fs.azure.account.oauth2.client.assertion.provider.type");
        ((AbstractStringAssert)Assertions.assertThat((String)accountSpecificProvider).describedAs("Account-specific custom provider should take precedence", new Object[0])).isEqualTo((Object)TEST_CUSTOM_CLIENT_ASSERTION_PROVIDER);
        String accountAgnosticProvider = abfsConf.getRawConfiguration().get("fs.azure.account.oauth2.client.assertion.provider.type");
        ((AbstractStringAssert)Assertions.assertThat((String)accountAgnosticProvider).describedAs("Account-agnostic setting should exist but not be used", new Object[0])).isEqualTo((Object)"some.other.Provider");
    }

    public static enum GetEnumType {
        TRUE,
        FALSE;

    }

    private class GetClassImpl0
    implements GetClassInterface {
        private GetClassImpl0() {
        }
    }

    private class GetClassImpl1
    implements GetClassInterface {
        private GetClassImpl1() {
        }
    }

    static interface GetClassInterface {
    }

    public static class MockClientAssertionProvider
    implements ClientAssertionProvider {
        public void initialize(Configuration configuration, String accountName) throws IOException {
        }

        public String getClientAssertion() throws IOException {
            return "mock-jwt-token";
        }
    }
}

