/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.ITestAzureBlobFileSystemAttributes;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITestWasbAbfsCompatibility
extends AbstractAbfsIntegrationTest {
    private static final String WASB_TEST_CONTEXT = "wasb test file";
    private static final String ABFS_TEST_CONTEXT = "abfs test file";
    private static final String TEST_CONTEXT = "THIS IS FOR TEST";
    private static final String TEST_CONTEXT1 = "THIS IS FOR TEST1";
    private static final byte[] ATTRIBUTE_VALUE_1 = "one".getBytes(StandardCharsets.UTF_8);
    private static final byte[] ATTRIBUTE_VALUE_2 = "two".getBytes(StandardCharsets.UTF_8);
    private static final String ATTRIBUTE_NAME_1 = "user_someAttribute";
    private static final String ATTRIBUTE_NAME_2 = "user_someAttribute1";
    private static final EnumSet<XAttrSetFlag> CREATE_FLAG = EnumSet.of(XAttrSetFlag.CREATE);
    private static final Logger LOG = LoggerFactory.getLogger(ITestWasbAbfsCompatibility.class);

    public ITestWasbAbfsCompatibility() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isIPAddress()).as("Emulator is not supported", new Object[0])).isFalse();
        this.assumeHnsDisabled();
        this.assumeBlobServiceType();
    }

    @Test
    public void testListFileStatus() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isAppendBlobEnabled()).as("Not valid for APPEND BLOB", new Object[0])).isFalse();
        AzureBlobFileSystem fs = this.getFileSystem();
        NativeAzureFileSystem wasb = this.getWasbFileSystem();
        Path testFiles = this.path("/testfiles");
        Path path1 = new Path(testFiles + "/~12/!008/3/abFsTestfile");
        try (FSDataOutputStream abfsStream = fs.create(path1, true);){
            abfsStream.write(ABFS_TEST_CONTEXT.getBytes());
            abfsStream.flush();
            abfsStream.hsync();
        }
        Path path2 = new Path(testFiles + "/~12/!008/3/nativeFsTestfile");
        LOG.info("{}", (Object)wasb.getUri());
        try (FSDataOutputStream nativeFsStream = wasb.create(path2, true);){
            nativeFsStream.write(WASB_TEST_CONTEXT.getBytes());
            nativeFsStream.flush();
            nativeFsStream.hsync();
        }
        FileStatus[] abfsFileStatus = fs.listStatus(new Path(testFiles + "/~12/!008/3/"));
        FileStatus[] nativeFsFileStatus = wasb.listStatus(new Path(testFiles + "/~12/!008/3/"));
        ITestWasbAbfsCompatibility.assertEquals((int)2, (int)abfsFileStatus.length);
        ITestWasbAbfsCompatibility.assertEquals((int)2, (int)nativeFsFileStatus.length);
    }

    @Test
    public void testReadFile() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isAppendBlobEnabled()).as("Not valid for APPEND BLOB", new Object[0])).isFalse();
        boolean[] createFileWithAbfs = new boolean[]{false, true, false, true};
        boolean[] readFileWithAbfs = new boolean[]{false, true, true, false};
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.full.blob.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            for (int i = 0; i < 4; ++i) {
                Path path = new Path(testFile + "/~12/!008/testfile" + i);
                AzureBlobFileSystem createFs = createFileWithAbfs[i] ? abfs : wasb;
                AzureBlobFileSystem readFs = readFileWithAbfs[i] ? abfs : wasb;
                try (FSDataOutputStream nativeFsStream = createFs.create(path, true);){
                    nativeFsStream.write(TEST_CONTEXT.getBytes());
                    nativeFsStream.flush();
                    nativeFsStream.hsync();
                }
                ContractTestUtils.assertIsFile((FileSystem)createFs, (Path)path);
                try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)readFs.open(path)));){
                    String line = br.readLine();
                    ITestWasbAbfsCompatibility.assertEquals((Object)TEST_CONTEXT, (Object)line, (String)("Wrong text from " + (FileSystem)readFs));
                }
                ContractTestUtils.assertDeleted((FileSystem)readFs, (Path)path, (boolean)true);
            }
        }
    }

    @Test
    public void testwriteFile() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isAppendBlobEnabled()).as("Not valid for APPEND BLOB", new Object[0])).isFalse();
        AzureBlobFileSystem abfs = this.getFileSystem();
        NativeAzureFileSystem wasb = this.getWasbFileSystem();
        Path testFile = this.path("/testReadFile");
        Path path = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
        try (FSDataOutputStream nativeFsStream = wasb.create(path, true);){
            nativeFsStream.write(TEST_CONTEXT.getBytes());
            nativeFsStream.flush();
            nativeFsStream.hsync();
        }
        ContractTestUtils.assertIsFile((FileSystem)wasb, (Path)path);
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)abfs.open(path)));){
            String line = br.readLine();
            ITestWasbAbfsCompatibility.assertEquals((Object)TEST_CONTEXT, (Object)line, (String)("Wrong text from " + abfs));
        }
        try (FSDataOutputStream abfsOutputStream = abfs.append(path);){
            abfsOutputStream.write(TEST_CONTEXT.getBytes());
            abfsOutputStream.flush();
            abfsOutputStream.hsync();
        }
        ContractTestUtils.assertDeleted((FileSystem)abfs, (Path)path, (boolean)true);
    }

    @Test
    public void testwriteFile1() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isAppendBlobEnabled()).as("Not valid for APPEND BLOB", new Object[0])).isFalse();
        AzureBlobFileSystem abfs = this.getFileSystem();
        NativeAzureFileSystem wasb = this.getWasbFileSystem();
        Path testFile = this.path("/testReadFile");
        Path path = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
        try (FSDataOutputStream nativeFsStream = abfs.create(path, true);){
            nativeFsStream.write(TEST_CONTEXT.getBytes());
            nativeFsStream.flush();
            nativeFsStream.hsync();
        }
        ContractTestUtils.assertIsFile((FileSystem)abfs, (Path)path);
        nativeFsStream = wasb.append(path);
        try {
            nativeFsStream.write(TEST_CONTEXT.getBytes());
            nativeFsStream.flush();
            nativeFsStream.hsync();
        }
        finally {
            if (nativeFsStream != null) {
                nativeFsStream.close();
            }
        }
        nativeFsStream = abfs.append(path);
        try {
            nativeFsStream.write(TEST_CONTEXT1.getBytes());
            nativeFsStream.flush();
            nativeFsStream.hsync();
        }
        finally {
            if (nativeFsStream != null) {
                nativeFsStream.close();
            }
        }
        ContractTestUtils.assertDeleted((FileSystem)abfs, (Path)path, (boolean)true);
    }

    @Test
    public void testazcopywasbcompatibility() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isAppendBlobEnabled()).as("Not valid for APPEND BLOB", new Object[0])).isFalse();
        AzureBlobFileSystem abfs = this.getFileSystem();
        Path testFile = this.path("/testReadFile");
        Path path = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
        this.createAzCopyFile(path);
        try (FSDataOutputStream nativeFsStream = abfs.append(path);){
            nativeFsStream.write(TEST_CONTEXT1.getBytes());
            nativeFsStream.flush();
            nativeFsStream.hsync();
        }
        ContractTestUtils.assertDeleted((FileSystem)abfs, (Path)path, (boolean)true);
    }

    @Test
    public void testDir() throws Exception {
        boolean[] createDirWithAbfs = new boolean[]{false, true, false, true};
        boolean[] readDirWithAbfs = new boolean[]{false, true, true, false};
        AzureBlobFileSystem abfs = this.getFileSystem();
        NativeAzureFileSystem wasb = this.getWasbFileSystem();
        Path testDir = this.path("/testDir");
        for (int i = 0; i < 4; ++i) {
            Path path = new Path(testDir + "/t" + i);
            AzureBlobFileSystem createFs = createDirWithAbfs[i] ? abfs : wasb;
            ITestWasbAbfsCompatibility.assertTrue((boolean)createFs.mkdirs(path));
            ContractTestUtils.assertPathExists((FileSystem)createFs, (String)("Created dir not found with " + (FileSystem)createFs), (Path)path);
            AzureBlobFileSystem readFs = readDirWithAbfs[i] ? abfs : wasb;
            ContractTestUtils.assertPathExists((FileSystem)readFs, (String)("Created dir not found with " + (FileSystem)readFs), (Path)path);
            ContractTestUtils.assertIsDirectory((FileSystem)readFs, (Path)path);
            ContractTestUtils.assertDeleted((FileSystem)readFs, (Path)path, (boolean)true);
        }
    }

    @Test
    public void testUrlConversion() {
        String abfsUrl = "abfs://abcde-1111-1111-1111-1111@xxxx.dfs.xxx.xxx.xxxx.xxxx";
        String wabsUrl = "wasb://abcde-1111-1111-1111-1111@xxxx.blob.xxx.xxx.xxxx.xxxx";
        ITestWasbAbfsCompatibility.assertEquals((Object)abfsUrl, (Object)ITestWasbAbfsCompatibility.wasbUrlToAbfsUrl(wabsUrl));
        ITestWasbAbfsCompatibility.assertEquals((Object)wabsUrl, (Object)ITestWasbAbfsCompatibility.abfsUrlToWasbUrl(abfsUrl, false));
    }

    @Test
    public void testSetWorkingDirectory() throws Exception {
        AzureBlobFileSystem abfs = this.getFileSystem();
        NativeAzureFileSystem wasb = this.getWasbFileSystem();
        Path d1 = this.path("/d1");
        Path d1d4 = new Path(d1 + "/d2/d3/d4");
        ContractTestUtils.assertMkdirs((FileSystem)abfs, (Path)d1d4);
        Path path1 = new Path(d1 + "/d2");
        wasb.setWorkingDirectory(path1);
        abfs.setWorkingDirectory(path1);
        ITestWasbAbfsCompatibility.assertEquals((Object)path1, (Object)wasb.getWorkingDirectory());
        ITestWasbAbfsCompatibility.assertEquals((Object)path1, (Object)abfs.getWorkingDirectory());
        Path path2 = new Path("d3/d4");
        wasb.setWorkingDirectory(path2);
        abfs.setWorkingDirectory(path2);
        Path path3 = d1d4;
        ITestWasbAbfsCompatibility.assertEquals((Object)path3, (Object)wasb.getWorkingDirectory());
        ITestWasbAbfsCompatibility.assertEquals((Object)path3, (Object)abfs.getWorkingDirectory());
    }

    @Test
    public void testScenario1() throws Exception {
        AzureBlobFileSystem abfs = this.getFileSystem();
        NativeAzureFileSystem wasb = this.getWasbFileSystem();
        Path testFile = this.path("/testReadFile");
        Path path = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
        try (FSDataOutputStream nativeFsStream = wasb.create(path, true);){
            nativeFsStream.write(TEST_CONTEXT.getBytes());
            nativeFsStream.flush();
            nativeFsStream.hsync();
        }
        ContractTestUtils.assertIsFile((FileSystem)wasb, (Path)path);
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)abfs.open(path)));){
            String line = br.readLine();
            ITestWasbAbfsCompatibility.assertEquals((Object)TEST_CONTEXT, (Object)line, (String)("Wrong text from " + abfs));
        }
        ContractTestUtils.assertDeleted((FileSystem)abfs, (Path)path, (boolean)true);
    }

    @Test
    public void testScenario2() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isAppendBlobEnabled()).as("Not valid for APPEND BLOB", new Object[0])).isFalse();
        AzureBlobFileSystem abfs = this.getFileSystem();
        NativeAzureFileSystem wasb = this.getWasbFileSystem();
        Path testFile = this.path("/testReadFile");
        Path path = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
        try (FSDataOutputStream nativeFsStream = wasb.create(path, true);){
            nativeFsStream.write(TEST_CONTEXT.getBytes());
            nativeFsStream.flush();
            nativeFsStream.hsync();
        }
        ContractTestUtils.assertIsFile((FileSystem)wasb, (Path)path);
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)abfs.open(path)));){
            String line = br.readLine();
            ITestWasbAbfsCompatibility.assertEquals((Object)TEST_CONTEXT, (Object)line, (String)("Wrong text from " + wasb));
        }
        try (FSDataOutputStream abfsOutputStream = abfs.append(path);){
            abfsOutputStream.write(TEST_CONTEXT1.getBytes());
            abfsOutputStream.flush();
            abfsOutputStream.hsync();
        }
        ContractTestUtils.assertDeleted((FileSystem)abfs, (Path)path, (boolean)true);
    }

    @Test
    public void testScenario3() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isAppendBlobEnabled()).as("Not valid for APPEND BLOB", new Object[0])).isFalse();
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.full.blob.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path path = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            try (FSDataOutputStream abfsOutputStream = abfs.create(path, true);){
                abfsOutputStream.write(TEST_CONTEXT.getBytes());
                abfsOutputStream.flush();
                abfsOutputStream.hsync();
            }
            ContractTestUtils.assertIsFile((FileSystem)abfs, (Path)path);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)wasb.open(path)));){
                String line = br.readLine();
                ITestWasbAbfsCompatibility.assertEquals((Object)TEST_CONTEXT, (Object)line, (String)("Wrong text from " + wasb));
            }
            ContractTestUtils.assertDeleted((FileSystem)abfs, (Path)path, (boolean)true);
        }
    }

    @Test
    public void testScenario4() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isAppendBlobEnabled()).as("Not valid for APPEND BLOB", new Object[0])).isFalse();
        AzureBlobFileSystem abfs = this.getFileSystem();
        NativeAzureFileSystem wasb = this.getWasbFileSystem();
        Path testFile = this.path("/testReadFile");
        Path path = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
        wasb.create(path, true);
        try (FSDataOutputStream abfsOutputStream = abfs.append(path);){
            abfsOutputStream.write(TEST_CONTEXT.getBytes());
            abfsOutputStream.flush();
            abfsOutputStream.hsync();
        }
        try (FSDataOutputStream nativeFsStream = wasb.append(path);){
            nativeFsStream.write(TEST_CONTEXT1.getBytes());
            nativeFsStream.flush();
            nativeFsStream.hsync();
        }
        ContractTestUtils.assertIsFile((FileSystem)abfs, (Path)path);
        ContractTestUtils.assertDeleted((FileSystem)abfs, (Path)path, (boolean)true);
    }

    @Test
    public void testScenario5() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isAppendBlobEnabled()).as("Not valid for APPEND BLOB", new Object[0])).isFalse();
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", false);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path path = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            abfs.create(path, true);
            try (FSDataOutputStream nativeFsStream = wasb.append(path);){
                nativeFsStream.write(TEST_CONTEXT.getBytes());
                nativeFsStream.flush();
                nativeFsStream.hsync();
            }
            ContractTestUtils.assertIsFile((FileSystem)abfs, (Path)path);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)abfs.open(path)));){
                String line = br.readLine();
                ITestWasbAbfsCompatibility.assertEquals((Object)TEST_CONTEXT, (Object)line, (String)("Wrong text from " + abfs));
            }
            ContractTestUtils.assertDeleted((FileSystem)abfs, (Path)path, (boolean)true);
        }
    }

    @Test
    public void testScenario6() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isAppendBlobEnabled()).as("Not valid for APPEND BLOB", new Object[0])).isFalse();
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path path = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            abfs.create(path, true);
            try (FSDataOutputStream nativeFsStream = wasb.append(path);){
                nativeFsStream.write(TEST_CONTEXT.getBytes());
                nativeFsStream.flush();
                nativeFsStream.hsync();
            }
            ContractTestUtils.assertIsFile((FileSystem)abfs, (Path)path);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)abfs.open(path)));){
                String line = br.readLine();
                ITestWasbAbfsCompatibility.assertEquals((Object)TEST_CONTEXT, (Object)line, (String)("Wrong text from " + abfs));
            }
            ContractTestUtils.assertDeleted((FileSystem)abfs, (Path)path, (boolean)true);
        }
    }

    @Test
    public void testScenario7() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isAppendBlobEnabled()).as("Not valid for APPEND BLOB", new Object[0])).isFalse();
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path path = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            try (FSDataOutputStream nativeFsStream = wasb.create(path, true);){
                nativeFsStream.write(TEST_CONTEXT.getBytes());
                nativeFsStream.flush();
                nativeFsStream.hsync();
            }
            ContractTestUtils.assertIsFile((FileSystem)abfs, (Path)path);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)abfs.open(path)));){
                String line = br.readLine();
                ITestWasbAbfsCompatibility.assertEquals((Object)TEST_CONTEXT, (Object)line, (String)("Wrong text from " + abfs));
            }
            abfs.create(path, true);
            FileStatus fileStatus = abfs.getFileStatus(path);
            ((AbstractLongAssert)Assertions.assertThat((long)fileStatus.getLen()).as("Expected file length to be 0 after overwrite", new Object[0])).isEqualTo(0L);
            ContractTestUtils.assertDeleted((FileSystem)abfs, (Path)path, (boolean)true);
        }
    }

    @Test
    public void testScenario8() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isAppendBlobEnabled()).as("Not valid for APPEND BLOB", new Object[0])).isFalse();
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path path = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            try (FSDataOutputStream nativeFsStream = wasb.create(path, true);){
                nativeFsStream.write(TEST_CONTEXT.getBytes());
                nativeFsStream.flush();
                nativeFsStream.hsync();
            }
            ContractTestUtils.assertIsFile((FileSystem)abfs, (Path)path);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)abfs.open(path)));){
                String line = br.readLine();
                ITestWasbAbfsCompatibility.assertEquals((Object)TEST_CONTEXT, (Object)line, (String)("Wrong text from " + abfs));
            }
            try {
                abfs.create(path, false);
            }
            catch (IOException e) {
                AbfsRestOperationException restEx = (AbfsRestOperationException)e.getCause();
                if (restEx != null) {
                    ((AbstractIntegerAssert)Assertions.assertThat((int)restEx.getStatusCode()).as("Expected HTTP status code 409 (Conflict) when file already exists", new Object[0])).isEqualTo(409);
                }
                ((AbstractStringAssert)Assertions.assertThat((String)e.getMessage()).as("Expected error message to contain 'Exists'", new Object[0])).containsIgnoringCase((CharSequence)"Exists");
            }
            ContractTestUtils.assertDeleted((FileSystem)abfs, (Path)path, (boolean)true);
        }
    }

    @Test
    public void testScenario9() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isAppendBlobEnabled()).as("Not valid for APPEND BLOB", new Object[0])).isFalse();
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path path = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            try (FSDataOutputStream abfsOutputStream = abfs.create(path, true);){
                abfsOutputStream.write(TEST_CONTEXT.getBytes());
                abfsOutputStream.flush();
                abfsOutputStream.hsync();
            }
            ContractTestUtils.assertIsFile((FileSystem)abfs, (Path)path);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)abfs.open(path)));){
                String line = br.readLine();
                ITestWasbAbfsCompatibility.assertEquals((Object)TEST_CONTEXT, (Object)line, (String)("Wrong text from " + abfs));
            }
            wasb.create(path, true);
            FileStatus fileStatus = abfs.getFileStatus(path);
            ((AbstractLongAssert)Assertions.assertThat((long)fileStatus.getLen()).as("Expected file length to be 0 after overwrite", new Object[0])).isEqualTo(0L);
            ContractTestUtils.assertDeleted((FileSystem)abfs, (Path)path, (boolean)true);
        }
    }

    @Test
    public void testScenario10() throws Exception {
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path path = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            try (FSDataOutputStream abfsOutputStream = abfs.create(path, true);){
                abfsOutputStream.write(TEST_CONTEXT.getBytes());
                abfsOutputStream.flush();
                abfsOutputStream.hsync();
            }
            ContractTestUtils.assertIsFile((FileSystem)abfs, (Path)path);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)abfs.open(path)));){
                String line = br.readLine();
                ITestWasbAbfsCompatibility.assertEquals((Object)TEST_CONTEXT, (Object)line, (String)("Wrong text from " + abfs));
            }
            try {
                wasb.create(path, false);
            }
            catch (IOException e) {
                AbfsRestOperationException restEx = (AbfsRestOperationException)e.getCause();
                if (restEx != null) {
                    ((AbstractIntegerAssert)Assertions.assertThat((int)restEx.getStatusCode()).as("Expected HTTP status code 409 (Conflict) when file already exists", new Object[0])).isEqualTo(409);
                }
                ((AbstractStringAssert)Assertions.assertThat((String)e.getMessage()).as("Expected error message to contain 'exists'", new Object[0])).contains(new CharSequence[]{"exists"});
            }
            ContractTestUtils.assertDeleted((FileSystem)abfs, (Path)path, (boolean)true);
        }
    }

    @Test
    public void testScenario11() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isAppendBlobEnabled()).as("Not valid for APPEND BLOB", new Object[0])).isFalse();
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path path = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            abfs.create(path, true);
            try (FSDataOutputStream nativeFsStream = wasb.append(path);){
                nativeFsStream.write(TEST_CONTEXT.getBytes());
                nativeFsStream.flush();
                nativeFsStream.hsync();
            }
            ContractTestUtils.assertIsFile((FileSystem)abfs, (Path)path);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)abfs.open(path)));){
                String line = br.readLine();
                ITestWasbAbfsCompatibility.assertEquals((Object)TEST_CONTEXT, (Object)line, (String)("Wrong text from " + abfs));
            }
            abfs.delete(path, true);
        }
    }

    @Test
    public void testScenario12() throws Exception {
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path path = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            try (FSDataOutputStream abfsOutputStream = abfs.create(path, true);){
                abfsOutputStream.write(TEST_CONTEXT.getBytes());
                abfsOutputStream.flush();
                abfsOutputStream.hsync();
            }
            ContractTestUtils.assertIsFile((FileSystem)abfs, (Path)path);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)abfs.open(path)));){
                String line = br.readLine();
                ITestWasbAbfsCompatibility.assertEquals((Object)TEST_CONTEXT, (Object)line, (String)("Wrong text from " + abfs));
            }
            wasb.delete(path, true);
        }
    }

    @Test
    public void testScenario13() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isAppendBlobEnabled()).as("Not valid for APPEND BLOB", new Object[0])).isFalse();
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path path = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            abfs.create(path, true);
            try (FSDataOutputStream nativeFsStream = wasb.append(path);){
                nativeFsStream.write(TEST_CONTEXT.getBytes());
                nativeFsStream.flush();
                nativeFsStream.hsync();
            }
            ContractTestUtils.assertIsFile((FileSystem)abfs, (Path)path);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)wasb.open(path)));){
                String line = br.readLine();
                ITestWasbAbfsCompatibility.assertEquals((Object)TEST_CONTEXT, (Object)line, (String)("Wrong text from " + wasb));
            }
            abfs.delete(path, true);
        }
    }

    @Test
    public void testScenario14() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isAppendBlobEnabled()).as("Not valid for APPEND BLOB", new Object[0])).isFalse();
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path path = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            abfs.create(path, true);
            try (FSDataOutputStream nativeFsStream = wasb.append(path);){
                nativeFsStream.write(TEST_CONTEXT.getBytes());
                nativeFsStream.flush();
                nativeFsStream.hsync();
            }
            ContractTestUtils.assertIsFile((FileSystem)abfs, (Path)path);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)wasb.open(path)));){
                String line = br.readLine();
                ITestWasbAbfsCompatibility.assertEquals((Object)TEST_CONTEXT, (Object)line, (String)("Wrong text from " + wasb));
            }
            wasb.delete(path, true);
        }
    }

    @Test
    public void testScenario15() throws Exception {
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path path = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            try (FSDataOutputStream nativeFsStream = wasb.create(path, true);){
                nativeFsStream.write(TEST_CONTEXT.getBytes());
                nativeFsStream.flush();
                nativeFsStream.hsync();
            }
            ContractTestUtils.assertIsFile((FileSystem)abfs, (Path)path);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)wasb.open(path)));){
                String line = br.readLine();
                ITestWasbAbfsCompatibility.assertEquals((Object)TEST_CONTEXT, (Object)line, (String)("Wrong text from " + wasb));
            }
            abfs.delete(path, true);
        }
    }

    @Test
    public void testScenario16() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isAppendBlobEnabled()).as("Not valid for APPEND BLOB", new Object[0])).isFalse();
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path path = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            wasb.create(path, true);
            try (FSDataOutputStream abfsOutputStream = abfs.append(path);){
                abfsOutputStream.write(TEST_CONTEXT.getBytes());
                abfsOutputStream.flush();
                abfsOutputStream.hsync();
            }
            ContractTestUtils.assertIsFile((FileSystem)abfs, (Path)path);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)abfs.open(path)));){
                String line = br.readLine();
                ITestWasbAbfsCompatibility.assertEquals((Object)TEST_CONTEXT, (Object)line, (String)("Wrong text from " + abfs));
            }
            wasb.delete(path, true);
        }
    }

    @Test
    public void testScenario17() throws Exception {
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            Path testFile = this.path("/testReadFile");
            Path path = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            try (FSDataOutputStream abfsOutputStream = abfs.create(path, true);){
                abfsOutputStream.write(TEST_CONTEXT.getBytes());
                abfsOutputStream.flush();
                abfsOutputStream.hsync();
            }
            FileStatus status = abfs.getFileStatus(path);
            ITestWasbAbfsCompatibility.assertIsFile(path, status);
            abfs.setXAttr(path, ATTRIBUTE_NAME_1, ATTRIBUTE_VALUE_1);
            byte[] readValue = abfs.getXAttr(path, ATTRIBUTE_NAME_1);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_1, "one");
            abfs.setXAttr(path, ATTRIBUTE_NAME_2, ATTRIBUTE_VALUE_2);
            readValue = abfs.getXAttr(path, ATTRIBUTE_NAME_2);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_2, "two");
            readValue = abfs.getXAttr(path, ATTRIBUTE_NAME_1);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_1, "one");
            abfs.delete(path, true);
        }
    }

    @Test
    public void testScenario18() throws Exception {
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path path = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            try (FSDataOutputStream nativeFsStream = wasb.create(path, true);){
                nativeFsStream.write(TEST_CONTEXT.getBytes());
                nativeFsStream.flush();
                nativeFsStream.hsync();
            }
            FileStatus status = wasb.getFileStatus(path);
            ITestWasbAbfsCompatibility.assertIsFile(path, status);
            wasb.setXAttr(path, ATTRIBUTE_NAME_1, ATTRIBUTE_VALUE_1);
            byte[] readValue = wasb.getXAttr(path, ATTRIBUTE_NAME_1);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_1, "one");
            wasb.setXAttr(path, ATTRIBUTE_NAME_2, ATTRIBUTE_VALUE_2);
            readValue = wasb.getXAttr(path, ATTRIBUTE_NAME_2);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_2, "two");
            readValue = wasb.getXAttr(path, ATTRIBUTE_NAME_1);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_1, "one");
            wasb.delete(path, true);
        }
    }

    @Test
    public void testScenario19() throws Exception {
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path path = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            try (FSDataOutputStream nativeFsStream = wasb.create(path, true);){
                nativeFsStream.write(TEST_CONTEXT.getBytes());
                nativeFsStream.flush();
                nativeFsStream.hsync();
            }
            FileStatus status = wasb.getFileStatus(path);
            ITestWasbAbfsCompatibility.assertIsFile(path, status);
            wasb.setXAttr(path, ATTRIBUTE_NAME_1, ATTRIBUTE_VALUE_1);
            byte[] readValue = abfs.getXAttr(path, ATTRIBUTE_NAME_1);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_1, "one");
            wasb.setXAttr(path, ATTRIBUTE_NAME_2, ATTRIBUTE_VALUE_2);
            readValue = abfs.getXAttr(path, ATTRIBUTE_NAME_2);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_2, "two");
            readValue = abfs.getXAttr(path, ATTRIBUTE_NAME_1);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_1, "one");
            wasb.delete(path, true);
        }
    }

    @Test
    public void testScenario20() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isAppendBlobEnabled()).as("Not valid for APPEND BLOB", new Object[0])).isFalse();
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path path = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            try (FSDataOutputStream nativeFsStream = wasb.create(path, true);){
                nativeFsStream.write(TEST_CONTEXT.getBytes());
                nativeFsStream.flush();
                nativeFsStream.hsync();
            }
            FileStatus status = wasb.getFileStatus(path);
            ITestWasbAbfsCompatibility.assertIsFile(path, status);
            wasb.setXAttr(path, ATTRIBUTE_NAME_1, ATTRIBUTE_VALUE_1);
            byte[] readValue = abfs.getXAttr(path, ATTRIBUTE_NAME_1);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_1, "one");
            wasb.setXAttr(path, ATTRIBUTE_NAME_2, ATTRIBUTE_VALUE_2);
            readValue = abfs.getXAttr(path, ATTRIBUTE_NAME_2);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_2, "two");
            readValue = abfs.getXAttr(path, ATTRIBUTE_NAME_1);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_1, "one");
            abfs.create(path, true);
            FileStatus fileStatus = abfs.getFileStatus(path);
            ((AbstractLongAssert)Assertions.assertThat((long)fileStatus.getLen()).as("Expected file length to be 0 after overwrite", new Object[0])).isEqualTo(0L);
            wasb.delete(path, true);
        }
    }

    @Test
    public void testScenario21() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isAppendBlobEnabled()).as("Not valid for APPEND BLOB", new Object[0])).isFalse();
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path path = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            try (FSDataOutputStream abfsOutputStream = abfs.create(path, true);){
                abfsOutputStream.write(TEST_CONTEXT.getBytes());
                abfsOutputStream.flush();
                abfsOutputStream.hsync();
            }
            FileStatus status = wasb.getFileStatus(path);
            ITestWasbAbfsCompatibility.assertIsFile(path, status);
            abfs.setXAttr(path, ATTRIBUTE_NAME_1, ATTRIBUTE_VALUE_1);
            byte[] readValue = wasb.getXAttr(path, ATTRIBUTE_NAME_1);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_1, "one");
            abfs.setXAttr(path, ATTRIBUTE_NAME_2, ATTRIBUTE_VALUE_2);
            readValue = wasb.getXAttr(path, ATTRIBUTE_NAME_2);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_2, "two");
            readValue = wasb.getXAttr(path, ATTRIBUTE_NAME_1);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_1, "one");
            wasb.create(path, true);
            FileStatus fileStatus = abfs.getFileStatus(path);
            ((AbstractLongAssert)Assertions.assertThat((long)fileStatus.getLen()).as("Expected file length to be 0 after overwrite", new Object[0])).isEqualTo(0L);
            wasb.delete(path, true);
        }
    }

    @Test
    public void testScenario22() throws Exception {
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path path = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            try (FSDataOutputStream nativeFsStream = wasb.create(path, true);){
                nativeFsStream.write(TEST_CONTEXT.getBytes());
                nativeFsStream.flush();
                nativeFsStream.hsync();
            }
            FileStatus status = wasb.getFileStatus(path);
            ITestWasbAbfsCompatibility.assertIsFile(path, status);
            abfs.setXAttr(path, ATTRIBUTE_NAME_1, ATTRIBUTE_VALUE_1);
            byte[] readValue = wasb.getXAttr(path, ATTRIBUTE_NAME_1);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_1, "one");
            abfs.setXAttr(path, ATTRIBUTE_NAME_2, ATTRIBUTE_VALUE_2);
            readValue = wasb.getXAttr(path, ATTRIBUTE_NAME_2);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_2, "two");
            readValue = wasb.getXAttr(path, ATTRIBUTE_NAME_1);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_1, "one");
            wasb.create(path, true);
            FileStatus fileStatus = abfs.getFileStatus(path);
            ((AbstractLongAssert)Assertions.assertThat((long)fileStatus.getLen()).as("Expected file length to be 0 after overwrite", new Object[0])).isEqualTo(0L);
            wasb.delete(path, true);
        }
    }

    @Test
    public void testScenario23() throws Exception {
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path path = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            try (FSDataOutputStream nativeFsStream = wasb.create(path, true);){
                nativeFsStream.write(TEST_CONTEXT.getBytes());
                nativeFsStream.flush();
                nativeFsStream.hsync();
            }
            FileStatus status = wasb.getFileStatus(path);
            ITestWasbAbfsCompatibility.assertIsFile(path, status);
            abfs.setXAttr(path, ATTRIBUTE_NAME_1, ATTRIBUTE_VALUE_1);
            byte[] readValue = abfs.getXAttr(path, ATTRIBUTE_NAME_1);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_1, "one");
            wasb.setXAttr(path, ATTRIBUTE_NAME_2, ATTRIBUTE_VALUE_2, CREATE_FLAG);
            readValue = abfs.getXAttr(path, ATTRIBUTE_NAME_2);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_2, "two");
            readValue = abfs.getXAttr(path, ATTRIBUTE_NAME_1);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_1, "one");
            wasb.delete(path, true);
        }
    }

    @Test
    public void testScenario24() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isAppendBlobEnabled()).as("Not valid for APPEND BLOB", new Object[0])).isFalse();
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path path = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            try (FSDataOutputStream abfsOutputStream = abfs.create(path, true);){
                abfsOutputStream.write(TEST_CONTEXT.getBytes());
                abfsOutputStream.flush();
                abfsOutputStream.hsync();
            }
            FileStatus status = wasb.getFileStatus(path);
            ITestWasbAbfsCompatibility.assertIsFile(path, status);
            wasb.setXAttr(path, ATTRIBUTE_NAME_1, ATTRIBUTE_VALUE_1);
            byte[] readValue = abfs.getXAttr(path, ATTRIBUTE_NAME_1);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_1, "one");
            wasb.setXAttr(path, ATTRIBUTE_NAME_2, ATTRIBUTE_VALUE_2, CREATE_FLAG);
            readValue = abfs.getXAttr(path, ATTRIBUTE_NAME_2);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_2, "two");
            readValue = abfs.getXAttr(path, ATTRIBUTE_NAME_1);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_1, "one");
            wasb.delete(path, true);
        }
    }

    @Test
    public void testScenario25() throws Exception {
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path path = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            try (FSDataOutputStream nativeFsStream = wasb.create(path, true);){
                nativeFsStream.write(TEST_CONTEXT.getBytes());
                nativeFsStream.flush();
                nativeFsStream.hsync();
            }
            FileStatus status = wasb.getFileStatus(path);
            ITestWasbAbfsCompatibility.assertIsFile(path, status);
            abfs.setXAttr(path, ATTRIBUTE_NAME_1, ATTRIBUTE_VALUE_1);
            byte[] readValue = abfs.getXAttr(path, ATTRIBUTE_NAME_1);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_1, "one");
            abfs.setXAttr(path, ATTRIBUTE_NAME_2, ATTRIBUTE_VALUE_2, CREATE_FLAG);
            readValue = abfs.getXAttr(path, ATTRIBUTE_NAME_2);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_2, "two");
            readValue = abfs.getXAttr(path, ATTRIBUTE_NAME_1);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_1, "one");
            wasb.delete(path, true);
        }
    }

    @Test
    public void testScenario26() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isAppendBlobEnabled()).as("Not valid for APPEND BLOB", new Object[0])).isFalse();
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path path = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            try (FSDataOutputStream abfsOutputStream = abfs.create(path, true);){
                abfsOutputStream.write(TEST_CONTEXT.getBytes());
                abfsOutputStream.flush();
                abfsOutputStream.hsync();
            }
            FileStatus status = abfs.getFileStatus(path);
            ITestWasbAbfsCompatibility.assertIsFile(path, status);
            wasb.setXAttr(path, ATTRIBUTE_NAME_1, ATTRIBUTE_VALUE_1);
            byte[] readValue = wasb.getXAttr(path, ATTRIBUTE_NAME_1);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_1, "one");
            wasb.setXAttr(path, ATTRIBUTE_NAME_2, ATTRIBUTE_VALUE_2, CREATE_FLAG);
            readValue = wasb.getXAttr(path, ATTRIBUTE_NAME_2);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_2, "two");
            readValue = wasb.getXAttr(path, ATTRIBUTE_NAME_1);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_1, "one");
            wasb.delete(path, true);
        }
    }

    @Test
    public void testScenario27() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isAppendBlobEnabled()).as("Not valid for APPEND BLOB", new Object[0])).isFalse();
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path testPath1 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            Path testPath2 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            try (FSDataOutputStream abfsOutputStream = abfs.create(testPath1, true);){
                abfsOutputStream.write(TEST_CONTEXT.getBytes());
                abfsOutputStream.flush();
                abfsOutputStream.hsync();
            }
            ContractTestUtils.assertIsFile((FileSystem)abfs, (Path)testPath1);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)abfs.open(testPath1)));){
                String line = br.readLine();
                ITestWasbAbfsCompatibility.assertEquals((Object)TEST_CONTEXT, (Object)line, (String)("Wrong text from " + abfs));
            }
            boolean renamed = wasb.rename(testPath1, testPath2);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)renamed).as("Rename failed", new Object[0])).isTrue();
            Path parentDir = new Path(testFile + "/~12/!008");
            int noOfFiles = ITestWasbAbfsCompatibility.listAllFilesAndDirs((FileSystem)wasb, parentDir);
            ((AbstractIntegerAssert)Assertions.assertThat((int)noOfFiles).as("Expected only 1 file or directory under path: %s", new Object[]{parentDir})).isEqualTo(1);
            wasb.delete(testPath2, true);
        }
    }

    @Test
    public void testScenario28() throws Exception {
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path testPath1 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            Path testPath2 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            try (FSDataOutputStream nativeFsStream = wasb.create(testPath1, true);){
                nativeFsStream.write(TEST_CONTEXT.getBytes());
                nativeFsStream.flush();
                nativeFsStream.hsync();
            }
            ContractTestUtils.assertIsFile((FileSystem)abfs, (Path)testPath1);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)abfs.open(testPath1)));){
                String line = br.readLine();
                ITestWasbAbfsCompatibility.assertEquals((Object)TEST_CONTEXT, (Object)line, (String)("Wrong text from " + abfs));
            }
            boolean renamed = abfs.rename(testPath1, testPath2);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)renamed).as("Rename failed", new Object[0])).isTrue();
            Path parentDir = new Path(testFile + "/~12/!008");
            int noOfFiles = ITestWasbAbfsCompatibility.listAllFilesAndDirs((FileSystem)abfs, parentDir);
            ((AbstractIntegerAssert)Assertions.assertThat((int)noOfFiles).as("Expected only 1 file or directory under path: %s", new Object[]{parentDir})).isEqualTo(1);
            wasb.delete(testPath2, true);
        }
    }

    @Test
    public void testScenario29() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isAppendBlobEnabled()).as("Not valid for APPEND BLOB", new Object[0])).isFalse();
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path testPath1 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            Path testPath2 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            wasb.create(testPath1, true);
            try (FSDataOutputStream abfsOutputStream = abfs.append(testPath1);){
                abfsOutputStream.write(TEST_CONTEXT.getBytes());
                abfsOutputStream.flush();
                abfsOutputStream.hsync();
            }
            ContractTestUtils.assertIsFile((FileSystem)abfs, (Path)testPath1);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)abfs.open(testPath1)));){
                String line = br.readLine();
                ITestWasbAbfsCompatibility.assertEquals((Object)TEST_CONTEXT, (Object)line, (String)("Wrong text from " + abfs));
            }
            boolean renamed = abfs.rename(testPath1, testPath2);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)renamed).as("Rename failed", new Object[0])).isTrue();
            Path parentDir = new Path(testFile + "/~12/!008");
            int noOfFiles = ITestWasbAbfsCompatibility.listAllFilesAndDirs((FileSystem)abfs, parentDir);
            ((AbstractIntegerAssert)Assertions.assertThat((int)noOfFiles).as("Expected only 1 file or directory under path: %s", new Object[]{parentDir})).isEqualTo(1);
            wasb.delete(testPath2, true);
        }
    }

    @Test
    public void testScenario30() throws Exception {
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path testPath1 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            Path testPath2 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            Path testPath3 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            try (FSDataOutputStream nativeFsStream = wasb.create(testPath1, true);){
                nativeFsStream.write(TEST_CONTEXT.getBytes());
                nativeFsStream.flush();
                nativeFsStream.hsync();
            }
            ContractTestUtils.assertIsFile((FileSystem)abfs, (Path)testPath1);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)abfs.open(testPath1)));){
                String line = br.readLine();
                ITestWasbAbfsCompatibility.assertEquals((Object)TEST_CONTEXT, (Object)line, (String)("Wrong text from " + abfs));
            }
            boolean renamed = wasb.rename(testPath1, testPath2);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)renamed).as("Rename failed", new Object[0])).isTrue();
            boolean renamed1 = abfs.rename(testPath2, testPath3);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)renamed1).as("Rename failed", new Object[0])).isTrue();
            Path parentDir = new Path(testFile + "/~12/!008");
            int noOfFiles = ITestWasbAbfsCompatibility.listAllFilesAndDirs((FileSystem)abfs, parentDir);
            ((AbstractIntegerAssert)Assertions.assertThat((int)noOfFiles).as("Expected only 1 file or directory under path: %s", new Object[]{parentDir})).isEqualTo(1);
            wasb.delete(testPath3, true);
        }
    }

    @Test
    public void testScenario31() throws Exception {
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path testPath1 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            Path testPath2 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            try (FSDataOutputStream nativeFsStream = wasb.create(testPath1, true);){
                nativeFsStream.write(TEST_CONTEXT.getBytes());
                nativeFsStream.flush();
                nativeFsStream.hsync();
            }
            ContractTestUtils.assertIsFile((FileSystem)abfs, (Path)testPath1);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)abfs.open(testPath1)));){
                String line = br.readLine();
                ITestWasbAbfsCompatibility.assertEquals((Object)TEST_CONTEXT, (Object)line, (String)("Wrong text from " + abfs));
            }
            wasb.delete(testPath1, true);
            boolean renamed = abfs.rename(testPath1, testPath2);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)renamed).as("Rename operation should have failed but returned true", new Object[0])).isFalse();
        }
    }

    @Test
    public void testScenario32() throws Exception {
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path testFile1 = this.path("/testReadFile1");
            Path testPath1 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            Path testPath2 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            Path testPath3 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            wasb.mkdirs(testFile);
            try (FSDataOutputStream nativeFsStream = wasb.create(testPath1, true);){
                nativeFsStream.write(TEST_CONTEXT.getBytes());
                nativeFsStream.flush();
                nativeFsStream.hsync();
            }
            wasb.create(testPath2, true);
            wasb.create(testPath3, true);
            ContractTestUtils.assertIsFile((FileSystem)abfs, (Path)testPath1);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)abfs.open(testPath1)));){
                String line = br.readLine();
                ITestWasbAbfsCompatibility.assertEquals((Object)TEST_CONTEXT, (Object)line, (String)("Wrong text from " + abfs));
            }
            boolean renamed = abfs.rename(testFile, testFile1);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)renamed).as("Rename failed", new Object[0])).isTrue();
            int listResult = ITestWasbAbfsCompatibility.listAllFilesAndDirs((FileSystem)abfs, testFile1);
            ((AbstractIntegerAssert)Assertions.assertThat((int)listResult).as("Expected only 5 entries under path: %s", new Object[]{testFile1})).isEqualTo(5);
        }
    }

    @Test
    public void testScenario33() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isAppendBlobEnabled()).as("Not valid for APPEND BLOB", new Object[0])).isFalse();
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path testFile1 = this.path("/testReadFile1");
            Path testPath1 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            Path testPath2 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            Path testPath3 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            abfs.mkdirs(testFile);
            try (FSDataOutputStream abfsOutputStream = abfs.create(testPath1, true);){
                abfsOutputStream.write(TEST_CONTEXT.getBytes());
                abfsOutputStream.flush();
                abfsOutputStream.hsync();
            }
            abfs.create(testPath2, true);
            abfs.create(testPath3, true);
            ContractTestUtils.assertIsFile((FileSystem)abfs, (Path)testPath1);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)abfs.open(testPath1)));){
                String line = br.readLine();
                ITestWasbAbfsCompatibility.assertEquals((Object)TEST_CONTEXT, (Object)line, (String)("Wrong text from " + abfs));
            }
            boolean renamed = wasb.rename(testFile, testFile1);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)renamed).as("Rename failed", new Object[0])).isTrue();
            int listResult = ITestWasbAbfsCompatibility.listAllFilesAndDirs((FileSystem)wasb, testFile1);
            ((AbstractIntegerAssert)Assertions.assertThat((int)listResult).as("Expected only 5 entries under path: %s", new Object[]{testFile1})).isEqualTo(5);
        }
    }

    @Test
    public void testScenario34() throws Exception {
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path testPath1 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            Path testPath2 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            Path testPath3 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            abfs.mkdirs(testFile);
            try (FSDataOutputStream abfsOutputStream = abfs.create(testPath1, true);){
                abfsOutputStream.write(TEST_CONTEXT.getBytes());
                abfsOutputStream.flush();
                abfsOutputStream.hsync();
            }
            abfs.create(testPath3, true);
            ContractTestUtils.assertIsFile((FileSystem)abfs, (Path)testPath1);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)abfs.open(testPath1)));){
                String line = br.readLine();
                ITestWasbAbfsCompatibility.assertEquals((Object)TEST_CONTEXT, (Object)line, (String)("Wrong text from " + abfs));
            }
            boolean renamed = wasb.rename(testPath1, testPath2);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)renamed).as("Rename failed", new Object[0])).isTrue();
            int listResult = ITestWasbAbfsCompatibility.listAllFilesAndDirs((FileSystem)abfs, testFile);
            ((AbstractIntegerAssert)Assertions.assertThat((int)listResult).as("Expected only 4 entries under path: %s", new Object[]{testFile})).isEqualTo(4);
        }
    }

    @Test
    public void testScenario35() throws Exception {
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path testPath1 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            Path testPath2 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            Path testPath3 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            wasb.mkdirs(testFile);
            try (FSDataOutputStream nativeFsStream = wasb.create(testPath1, true);){
                nativeFsStream.write(TEST_CONTEXT.getBytes());
                nativeFsStream.flush();
                nativeFsStream.hsync();
            }
            wasb.create(testPath3, true);
            ContractTestUtils.assertIsFile((FileSystem)abfs, (Path)testPath1);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)abfs.open(testPath1)));){
                String line = br.readLine();
                ITestWasbAbfsCompatibility.assertEquals((Object)TEST_CONTEXT, (Object)line, (String)("Wrong text from " + abfs));
            }
            boolean renamed = abfs.rename(testPath1, testPath2);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)renamed).as("Rename failed", new Object[0])).isTrue();
            int listResult = ITestWasbAbfsCompatibility.listAllFilesAndDirs((FileSystem)wasb, testFile);
            ((AbstractIntegerAssert)Assertions.assertThat((int)listResult).as("Expected only 4 entries under path: %s", new Object[]{testFile})).isEqualTo(4);
        }
    }

    @Test
    public void testScenario36() throws Exception {
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path testPath1 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            Path testPath3 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            wasb.mkdirs(testFile);
            try (FSDataOutputStream nativeFsStream = wasb.create(testPath1, true);){
                nativeFsStream.write(TEST_CONTEXT.getBytes());
                nativeFsStream.flush();
                nativeFsStream.hsync();
            }
            wasb.create(testPath3, true);
            ContractTestUtils.assertIsFile((FileSystem)abfs, (Path)testPath1);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)abfs.open(testPath1)));){
                String line = br.readLine();
                ITestWasbAbfsCompatibility.assertEquals((Object)TEST_CONTEXT, (Object)line, (String)("Wrong text from " + abfs));
            }
            boolean renamed = abfs.rename(testFile, testFile);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)renamed).as("Rename operation should have failed but returned true", new Object[0])).isFalse();
        }
    }

    @Test
    public void testScenario37() throws Exception {
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path testPath1 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            Path testPath2 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            Path testPath3 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            abfs.mkdirs(testFile);
            try (FSDataOutputStream abfsOutputStream = abfs.create(testPath1, true);){
                abfsOutputStream.write(TEST_CONTEXT.getBytes());
                abfsOutputStream.flush();
                abfsOutputStream.hsync();
            }
            abfs.create(testPath3, true);
            ContractTestUtils.assertIsFile((FileSystem)abfs, (Path)testPath1);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)abfs.open(testPath1)));){
                String line = br.readLine();
                ITestWasbAbfsCompatibility.assertEquals((Object)TEST_CONTEXT, (Object)line, (String)("Wrong text from " + abfs));
            }
            boolean renamed = wasb.rename(testPath2, testPath3);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)renamed).as("Rename operation should have failed but returned true", new Object[0])).isFalse();
        }
    }

    @Test
    public void testScenario38() throws Exception {
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            Path testFile = this.path("/testReadFile");
            Path path = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            try (FSDataOutputStream nativeFsStream = wasb.create(path, true);){
                nativeFsStream.write(TEST_CONTEXT.getBytes());
                nativeFsStream.flush();
                nativeFsStream.hsync();
            }
            FileStatus status = wasb.getFileStatus(path);
            ITestWasbAbfsCompatibility.assertIsFile(path, status);
            wasb.setXAttr(path, ATTRIBUTE_NAME_1, ATTRIBUTE_VALUE_1);
            byte[] readValue = wasb.getXAttr(path, ATTRIBUTE_NAME_1);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_1, "one");
            wasb.setXAttr(path, ATTRIBUTE_NAME_2, ATTRIBUTE_VALUE_2);
            readValue = wasb.getXAttr(path, ATTRIBUTE_NAME_2);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_2, "two");
            readValue = wasb.getXAttr(path, ATTRIBUTE_NAME_1);
            ITestAzureBlobFileSystemAttributes.assertAttributeEqual(abfs, readValue, ATTRIBUTE_VALUE_1, "one");
            wasb.create(path, true);
            FileStatus fileStatus = abfs.getFileStatus(path);
            ((AbstractLongAssert)Assertions.assertThat((long)fileStatus.getLen()).as("Expected file length to be 0 after overwrite", new Object[0])).isEqualTo(0L);
            wasb.delete(path, true);
        }
    }

    @Test
    public void testScenario39() throws Exception {
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.checksum.validation", true);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        try (AzureBlobFileSystem abfs = (AzureBlobFileSystem)fileSystem;){
            NativeAzureFileSystem wasb = this.getWasbFileSystem();
            String testRunId = UUID.randomUUID().toString();
            Path baseDir = this.path("/testScenario39_" + testRunId);
            Path testFile = new Path(baseDir, "testReadFile");
            Path testPath1 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            Path testPath2 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            Path testPath3 = new Path(testFile + "/~12/!008/testfile_" + UUID.randomUUID());
            wasb.mkdirs(testFile);
            try (FSDataOutputStream nativeFsStream = wasb.create(testPath1, true);){
                nativeFsStream.write(TEST_CONTEXT.getBytes());
                nativeFsStream.flush();
                nativeFsStream.hsync();
            }
            wasb.create(testPath3, true);
            ContractTestUtils.assertIsFile((FileSystem)abfs, (Path)testPath1);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)abfs.open(testPath1)));){
                String line = br.readLine();
                ITestWasbAbfsCompatibility.assertEquals((Object)TEST_CONTEXT, (Object)line, (String)("Wrong text from " + abfs));
            }
            boolean renamed = wasb.rename(testPath1, testPath2);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)renamed).as("Rename failed", new Object[0])).isTrue();
            int listResult = ITestWasbAbfsCompatibility.listAllFilesAndDirs((FileSystem)wasb, testFile);
            ((AbstractIntegerAssert)Assertions.assertThat((int)listResult).as("Expected only 4 entries under path: %s", new Object[]{testFile})).isEqualTo(4);
        }
    }

    public static int listAllFilesAndDirs(FileSystem fs, Path path) throws IOException {
        int count = 0;
        RemoteIterator iter = fs.listStatusIterator(path);
        while (iter.hasNext()) {
            FileStatus status = (FileStatus)iter.next();
            ++count;
            if (!status.isDirectory()) continue;
            count += ITestWasbAbfsCompatibility.listAllFilesAndDirs(fs, status.getPath());
        }
        return count;
    }

    private static void assertIsFile(Path path, FileStatus status) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)status.isDirectory()).as("Expected a regular file, but was a directory: %s %s", new Object[]{path, status})).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)status.isSymlink()).as("Expected a regular file, but was a symlink: %s %s", new Object[]{path, status})).isFalse();
    }
}

