/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.lang.reflect.Field;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.Test;

public class ITestOauthOverAbfsScheme
extends AbstractAbfsIntegrationTest {
    public ITestOauthOverAbfsScheme() throws Exception {
        ((AbstractComparableAssert)Assumptions.assumeThat((Comparable)this.getAuthType()).as("ITestOauthOverAbfsScheme is skipped because auth type is not OAuth", new Object[0])).isEqualTo((Object)AuthType.OAuth);
    }

    @Test
    public void testOauthOverSchemeAbfs() throws Exception {
        String[] urlWithoutScheme = this.getTestUrl().split(":");
        String fsUrl = "abfs:" + urlWithoutScheme[1];
        Configuration config = this.getRawConfiguration();
        config.set("fs.defaultFS", fsUrl.toString());
        AbfsClient client = this.getFileSystem(config).getAbfsClient();
        Field baseUrlField = AbfsClient.class.getDeclaredField("baseUrl");
        baseUrlField.setAccessible(true);
        String url = ((URL)baseUrlField.get(client)).toString();
        ((AbstractStringAssert)Assumptions.assumeThat((String)url).as("OAuth authentication over scheme abfs must use HTTPS", new Object[0])).startsWith((CharSequence)"https");
    }
}

