/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.constants.AbfsServiceType;
import org.apache.hadoop.fs.azurebfs.constants.ConfigurationKeys;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidConfigurationValueException;
import org.apache.hadoop.fs.azurebfs.enums.Trilean;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsDfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ITestGetNameSpaceEnabled
extends AbstractAbfsIntegrationTest {
    private static final String TRUE_STR = "true";
    private static final String FALSE_STR = "false";
    private static final String FILESYSTEM_NOT_FOUND_ERROR = "The specified filesystem does not exist.";
    private static final String CONTAINER_NOT_FOUND_ERROR = "The specified container does not exist.";
    private boolean isUsingXNSAccount = this.getConfiguration().getBoolean("fs.azure.test.namespace.enabled", false);

    @Test
    public void testXNSAccount() throws IOException {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isUsingXNSAccount).as("Skip this test because the account being used for test is a non XNS account", new Object[0])).isTrue();
        ITestGetNameSpaceEnabled.assertTrue((boolean)this.getIsNamespaceEnabled(this.getFileSystem()), (String)"Expecting getIsNamespaceEnabled() return true");
    }

    @Test
    public void testNonXNSAccount() throws IOException {
        this.assumeValidTestConfigPresent(this.getRawConfiguration(), "fs.azure.test.namespace.enabled");
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isUsingXNSAccount).as("Skip this test because the account being used for test is a XNS account", new Object[0])).isFalse();
        ITestGetNameSpaceEnabled.assertFalse((boolean)this.getIsNamespaceEnabled(this.getFileSystem()), (String)"Expecting getIsNamespaceEnabled() return false");
    }

    @Test
    public void testGetIsNamespaceEnabledWhenConfigIsTrue() throws Exception {
        this.assumeValidTestConfigPresent(this.getRawConfiguration(), "fs.azure.test.namespace.enabled");
        ((AbstractComparableAssert)Assumptions.assumeThat((Comparable)this.getAbfsServiceType()).as("Blob Endpoint Does not Allow FS init on HNS Account", new Object[0])).isEqualTo((Object)AbfsServiceType.DFS);
        AzureBlobFileSystem fs = this.getNewFSWithHnsConf(TRUE_STR);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.getIsNamespaceEnabled(fs)).describedAs("getIsNamespaceEnabled should return true when the config is set as true", new Object[0])).isTrue();
        fs.getAbfsStore().deleteFilesystem(this.getTestTracingContext(fs, false));
        this.unsetAndAssert();
    }

    @Test
    public void testGetIsNamespaceEnabledWhenConfigIsFalse() throws Exception {
        this.assumeValidTestConfigPresent(this.getRawConfiguration(), "fs.azure.test.namespace.enabled");
        AzureBlobFileSystem fs = this.getNewFSWithHnsConf(FALSE_STR);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.getIsNamespaceEnabled(fs)).describedAs("getIsNamespaceEnabled should return false when the config is set as false", new Object[0])).isFalse();
        fs.getAbfsStore().deleteFilesystem(this.getTestTracingContext(fs, false));
        this.unsetAndAssert();
    }

    private void unsetAndAssert() throws Exception {
        AzureBlobFileSystem fs = this.getNewFSWithHnsConf("");
        boolean expectedValue = this.getConfiguration().getBoolean("fs.azure.test.namespace.enabled", false);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.getIsNamespaceEnabled(fs)).describedAs("getIsNamespaceEnabled should return the value configured for fs.azure.test.namespace.enabled", new Object[0])).isEqualTo(expectedValue);
        fs.getAbfsStore().deleteFilesystem(this.getTestTracingContext(fs, false));
    }

    private AzureBlobFileSystem getNewFSWithHnsConf(String isNamespaceEnabledAccount) throws Exception {
        Configuration rawConfig = new Configuration();
        rawConfig.addResource("azure-test.xml");
        rawConfig.set("fs.azure.account.hns.enabled", isNamespaceEnabledAccount);
        rawConfig.set(ConfigurationKeys.accountProperty((String)"fs.azure.account.hns.enabled", (String)this.getAccountName()), isNamespaceEnabledAccount);
        rawConfig.setBoolean("fs.azure.createRemoteFileSystemDuringInitialization", true);
        rawConfig.set("fs.defaultFS", this.getNonExistingUrl());
        return (AzureBlobFileSystem)FileSystem.get((Configuration)rawConfig);
    }

    private String getNonExistingUrl() {
        String testUri = this.getTestUrl();
        return this.getAbfsScheme() + "://" + UUID.randomUUID() + testUri.substring(testUri.indexOf("@"));
    }

    @Test
    public void testFailedRequestWhenFSNotExist() throws Exception {
        this.assumeValidTestConfigPresent(this.getRawConfiguration(), "fs.azure.test.namespace.enabled");
        AbfsConfiguration config = this.getConfiguration();
        config.setBoolean("fs.azure.createRemoteFileSystemDuringInitialization", false);
        String testUri = this.getTestUrl();
        String nonExistingFsUrl = this.getAbfsScheme() + "://" + UUID.randomUUID() + testUri.substring(testUri.indexOf("@"));
        config.setBoolean("fs.azure.account.hns.enabled", this.isUsingXNSAccount);
        AzureBlobFileSystem fs = this.getFileSystem(nonExistingFsUrl);
        fs.getAbfsStore().getAbfsConfiguration().setIsNamespaceEnabledAccountForTesting(Trilean.UNKNOWN);
        FileNotFoundException ex = (FileNotFoundException)LambdaTestUtils.intercept(FileNotFoundException.class, () -> fs.getFileStatus(new Path("/")));
        String expectedExceptionMessage = this.getAbfsServiceType() == AbfsServiceType.DFS ? FILESYSTEM_NOT_FOUND_ERROR : CONTAINER_NOT_FOUND_ERROR;
        ((AbstractStringAssert)Assertions.assertThat((String)ex.getMessage()).describedAs("Expecting FileNotFoundException with message: " + expectedExceptionMessage, new Object[0])).contains(new CharSequence[]{expectedExceptionMessage});
    }

    @Test
    public void testEnsureGetAclCallIsMadeOnceWhenConfigIsInvalid() throws Exception {
        this.unsetConfAndEnsureGetAclCallIsMadeOnce();
        this.ensureGetAclCallIsMadeOnceForInvalidConf(" ");
        this.unsetConfAndEnsureGetAclCallIsMadeOnce();
        this.ensureGetAclCallIsMadeOnceForInvalidConf("Invalid conf");
        this.unsetConfAndEnsureGetAclCallIsMadeOnce();
    }

    @Test
    public void testEnsureGetAclCallIsNeverMadeWhenConfigIsValid() throws Exception {
        this.unsetConfAndEnsureGetAclCallIsMadeOnce();
        this.ensureGetAclCallIsNeverMadeForValidConf(FALSE_STR.toLowerCase());
        this.unsetConfAndEnsureGetAclCallIsMadeOnce();
        this.ensureGetAclCallIsNeverMadeForValidConf(FALSE_STR.toUpperCase());
        this.unsetConfAndEnsureGetAclCallIsMadeOnce();
        this.ensureGetAclCallIsNeverMadeForValidConf(TRUE_STR.toLowerCase());
        this.unsetConfAndEnsureGetAclCallIsMadeOnce();
        this.ensureGetAclCallIsNeverMadeForValidConf(TRUE_STR.toUpperCase());
        this.unsetConfAndEnsureGetAclCallIsMadeOnce();
    }

    @Test
    public void testEnsureGetAclCallIsMadeOnceWhenConfigIsNotPresent() throws IOException {
        this.unsetConfAndEnsureGetAclCallIsMadeOnce();
    }

    private void ensureGetAclCallIsMadeOnceForInvalidConf(String invalidConf) throws Exception {
        this.getFileSystem().getAbfsStore().getAbfsConfiguration().setIsNamespaceEnabledAccountForTesting(Trilean.getTrilean((String)invalidConf));
        AbfsClient mockClient = this.callAbfsGetIsNamespaceEnabledAndReturnMockAbfsClient();
        ((AbfsClient)Mockito.verify((Object)mockClient, (VerificationMode)Mockito.times((int)1))).getAclStatus(ArgumentMatchers.anyString(), (TracingContext)ArgumentMatchers.any(TracingContext.class));
    }

    private void ensureGetAclCallIsNeverMadeForValidConf(String validConf) throws Exception {
        this.getFileSystem().getAbfsStore().getAbfsConfiguration().setIsNamespaceEnabledAccountForTesting(Trilean.getTrilean((String)validConf));
        AbfsClient mockClient = this.callAbfsGetIsNamespaceEnabledAndReturnMockAbfsClient();
        ((AbfsClient)Mockito.verify((Object)mockClient, (VerificationMode)Mockito.never())).getAclStatus(ArgumentMatchers.anyString(), (TracingContext)ArgumentMatchers.any(TracingContext.class));
    }

    private void unsetConfAndEnsureGetAclCallIsMadeOnce() throws IOException {
        this.getFileSystem().getAbfsStore().getAbfsConfiguration().setIsNamespaceEnabledAccountForTesting(Trilean.UNKNOWN);
        AbfsClient mockClient = this.callAbfsGetIsNamespaceEnabledAndReturnMockAbfsClient();
        ((AbfsClient)Mockito.verify((Object)mockClient, (VerificationMode)Mockito.times((int)1))).getAclStatus(ArgumentMatchers.anyString(), (TracingContext)ArgumentMatchers.any(TracingContext.class));
    }

    private AbfsClient callAbfsGetIsNamespaceEnabledAndReturnMockAbfsClient() throws IOException {
        AzureBlobFileSystem abfs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        AzureBlobFileSystemStore abfsStore = (AzureBlobFileSystemStore)Mockito.spy((Object)abfs.getAbfsStore());
        AbfsDfsClient mockClient = (AbfsDfsClient)Mockito.mock(AbfsDfsClient.class);
        ((AzureBlobFileSystem)Mockito.doReturn((Object)abfsStore).when((Object)abfs)).getAbfsStore();
        ((AzureBlobFileSystemStore)Mockito.doReturn((Object)mockClient).when((Object)abfsStore)).getClient();
        ((AzureBlobFileSystemStore)Mockito.doReturn((Object)mockClient).when((Object)abfsStore)).getClient((AbfsServiceType)ArgumentMatchers.any());
        ((AbfsDfsClient)Mockito.doReturn((Object)Mockito.mock(AbfsRestOperation.class)).when((Object)mockClient)).getAclStatus(ArgumentMatchers.anyString(), (TracingContext)ArgumentMatchers.any(TracingContext.class));
        this.getIsNamespaceEnabled(abfs);
        return mockClient;
    }

    @Test
    public void ensureGetAclDetermineHnsStatusAccurately() throws Exception {
        this.ensureGetAclDetermineHnsStatusAccuratelyInternal(400, false, false);
        this.ensureGetAclDetermineHnsStatusAccuratelyInternal(404, true, true);
        this.ensureGetAclDetermineHnsStatusAccuratelyInternal(500, true, true);
        this.ensureGetAclDetermineHnsStatusAccuratelyInternal(503, true, true);
    }

    private void ensureGetAclDetermineHnsStatusAccuratelyInternal(int statusCode, boolean expectedValue, boolean isExceptionExpected) throws Exception {
        AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)this.getFileSystem().getAbfsStore());
        AbfsClient mockClient = (AbfsClient)Mockito.mock(AbfsClient.class);
        store.getAbfsConfiguration().setIsNamespaceEnabledAccountForTesting(Trilean.UNKNOWN);
        ((AzureBlobFileSystemStore)Mockito.doReturn((Object)mockClient).when((Object)store)).getClient(AbfsServiceType.DFS);
        AbfsRestOperationException ex = new AbfsRestOperationException(statusCode, null, Integer.toString(statusCode), null);
        ((AbfsClient)Mockito.doThrow((Throwable[])new Throwable[]{ex}).when((Object)mockClient)).getAclStatus(ArgumentMatchers.anyString(), (TracingContext)ArgumentMatchers.any(TracingContext.class));
        if (isExceptionExpected) {
            try {
                store.getIsNamespaceEnabled(this.getTestTracingContext(this.getFileSystem(), false));
                Assertions.fail((String)("Exception Should have been thrown with status code: " + statusCode));
            }
            catch (AbfsRestOperationException caughtEx) {
                Assertions.assertThat((int)caughtEx.getStatusCode()).isEqualTo(statusCode);
                Assertions.assertThat((String)caughtEx.getErrorMessage()).isEqualTo((Object)ex.getErrorMessage());
            }
        }
        boolean isHnsEnabled = store.getIsNamespaceEnabled(this.getTestTracingContext(this.getFileSystem(), false));
        Assertions.assertThat((boolean)isHnsEnabled).isEqualTo(expectedValue);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)store.getClient().getIsNamespaceEnabled()).describedAs("ABFS Client should return same isNameSpace value as store", new Object[0])).isEqualTo(expectedValue);
        ((AbfsClient)Mockito.verify((Object)mockClient, (VerificationMode)Mockito.times((int)1))).getAclStatus(ArgumentMatchers.anyString(), (TracingContext)ArgumentMatchers.any(TracingContext.class));
    }

    @Test
    public void testAccountSpecificConfig() throws Exception {
        Configuration rawConfig = new Configuration();
        rawConfig.addResource("azure-test.xml");
        rawConfig.unset("fs.azure.account.hns.enabled");
        rawConfig.unset(ConfigurationKeys.accountProperty((String)"fs.azure.account.hns.enabled", (String)this.getAccountName()));
        String testAccountName = "testAccount.dfs.core.windows.net";
        String otherAccountName = "otherAccount.dfs.core.windows.net";
        String dummyAcountKey = "dummyKey";
        String defaultUri = this.getTestUrl().replace(this.getAccountName(), testAccountName);
        String otherUri = this.getTestUrl().replace(this.getAccountName(), otherAccountName);
        rawConfig.set(ConfigurationKeys.accountProperty((String)"fs.azure.account.hns.enabled", (String)testAccountName), FALSE_STR);
        rawConfig.set("fs.azure.account.hns.enabled", TRUE_STR);
        rawConfig.set(ConfigurationKeys.accountProperty((String)"fs.azure.account.key", (String)testAccountName), dummyAcountKey);
        rawConfig.set(ConfigurationKeys.accountProperty((String)"fs.azure.account.key", (String)otherAccountName), dummyAcountKey);
        rawConfig.set("fs.defaultFS", defaultUri);
        this.assertFileSystemInitWithExpectedHNSSettings(rawConfig, false);
        rawConfig.set("fs.defaultFS", otherUri);
        this.assertFileSystemInitWithExpectedHNSSettings(rawConfig, true);
        rawConfig.set(ConfigurationKeys.accountProperty((String)"fs.azure.account.hns.enabled", (String)testAccountName), FALSE_STR);
        rawConfig.unset("fs.azure.account.hns.enabled");
        rawConfig.set("fs.defaultFS", defaultUri);
        this.assertFileSystemInitWithExpectedHNSSettings(rawConfig, false);
        rawConfig.set("fs.azure.account.hns.enabled", FALSE_STR);
        rawConfig.unset(ConfigurationKeys.accountProperty((String)"fs.azure.account.hns.enabled", (String)testAccountName));
        rawConfig.set("fs.defaultFS", defaultUri);
        this.assertFileSystemInitWithExpectedHNSSettings(rawConfig, false);
        rawConfig.unset("fs.azure.account.hns.enabled");
        rawConfig.unset(ConfigurationKeys.accountProperty((String)"fs.azure.account.hns.enabled", (String)testAccountName));
        rawConfig.set("fs.defaultFS", defaultUri);
        rawConfig.set("fs.azure.io.retry.max.retries", "0");
        try {
            this.assertFileSystemInitWithExpectedHNSSettings(rawConfig, false);
        }
        catch (Exception e) {
            ((AbstractStringAssert)Assertions.assertThat((String)e.getCause().getMessage()).describedAs("getAcl() to determine HNS Nature of account shouldfail with Unknown Host Exception", new Object[0])).contains(new CharSequence[]{"UnknownHostException"});
        }
    }

    @Test
    public void testNameSpaceConfig() throws Exception {
        Configuration configuration = this.getConfigurationWithoutHnsConfig();
        AzureBlobFileSystem abfs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)configuration);
        AbfsConfiguration abfsConfig = new AbfsConfiguration(configuration, "bogusAccountName");
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)abfsConfig.getIsNamespaceEnabledAccount()).describedAs("Namespace enabled should be unknown in case config is not set", new Object[0])).isEqualTo((Object)Trilean.UNKNOWN);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)abfs.getIsNamespaceEnabled(this.getTestTracingContext(abfs, false))).describedAs("getIsNamespaceEnabled should return account type based on getAcl() call", new Object[0])).isEqualTo(abfs.getAbfsClient().getIsNamespaceEnabled());
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)abfs.getAbfsStore().getAbfsConfiguration().getIsNamespaceEnabledAccount()).describedAs("getIsNamespaceEnabled() should return updated account type based on getAcl() call", new Object[0])).isNotEqualTo((Object)Trilean.UNKNOWN);
        configuration.set("fs.azure.account.hns.enabled", TRUE_STR);
        abfs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)configuration);
        abfsConfig = new AbfsConfiguration(configuration, "bogusAccountName");
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)abfsConfig.getIsNamespaceEnabledAccount()).describedAs("Namespace enabled should be true in case config is set to true", new Object[0])).isEqualTo((Object)Trilean.TRUE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)abfs.getIsNamespaceEnabled(this.getTestTracingContext(abfs, false))).describedAs("getIsNamespaceEnabled() should return true when config is set to true", new Object[0])).isEqualTo(true);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)abfs.getAbfsClient().getIsNamespaceEnabled()).describedAs("Client's getIsNamespaceEnabled() should return true when config is set to true", new Object[0])).isEqualTo(true);
        configuration.set("fs.azure.account.hns.enabled", FALSE_STR);
        abfs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)configuration);
        abfsConfig = new AbfsConfiguration(configuration, "bogusAccountName");
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)abfsConfig.getIsNamespaceEnabledAccount()).describedAs("Namespace enabled should be false in case config is set to false", new Object[0])).isEqualTo((Object)Trilean.FALSE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)abfs.getIsNamespaceEnabled(this.getTestTracingContext(abfs, false))).describedAs("getIsNamespaceEnabled() should return false when config is set to false", new Object[0])).isEqualTo(false);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)abfs.getAbfsClient().getIsNamespaceEnabled()).describedAs("Client's getIsNamespaceEnabled() should return false when config is set to false", new Object[0])).isEqualTo(false);
    }

    @Test
    public void testFsInitShouldSetNamespaceConfig() throws Exception {
        AzureBlobFileSystem mockFileSystem = (AzureBlobFileSystem)Mockito.spy((Object)((AzureBlobFileSystem)FileSystem.newInstance((Configuration)this.getConfigurationWithoutHnsConfig())));
        AzureBlobFileSystemStore mockStore = (AzureBlobFileSystemStore)Mockito.spy((Object)mockFileSystem.getAbfsStore());
        AbfsClient abfsClient = (AbfsClient)Mockito.spy((Object)mockStore.getClient());
        ((AzureBlobFileSystemStore)Mockito.doReturn((Object)abfsClient).when((Object)mockStore)).getClient();
        ((AzureBlobFileSystemStore)Mockito.doReturn((Object)abfsClient).when((Object)mockStore)).getClient((AbfsServiceType)ArgumentMatchers.any());
        abfsClient.getIsNamespaceEnabled();
        ((AbfsClient)Mockito.verify((Object)abfsClient, (VerificationMode)Mockito.times((int)0))).getAclStatus(ArgumentMatchers.anyString(), (TracingContext)ArgumentMatchers.any(TracingContext.class));
        mockStore.getAbfsConfiguration().setIsNamespaceEnabledAccountForTesting(Trilean.UNKNOWN);
        String errorMessage = ((InvalidConfigurationValueException)LambdaTestUtils.intercept(InvalidConfigurationValueException.class, () -> abfsClient.getIsNamespaceEnabled())).getMessage();
        ((AbstractStringAssert)Assertions.assertThat((String)errorMessage).describedAs("Client should throw exception when namespace is unknown", new Object[0])).contains(new CharSequence[]{"Failed to determine account type"});
        mockStore.getIsNamespaceEnabled(this.getTestTracingContext(mockFileSystem, false));
        ((AbfsClient)Mockito.verify((Object)abfsClient, (VerificationMode)Mockito.times((int)1))).getAclStatus(ArgumentMatchers.anyString(), (TracingContext)ArgumentMatchers.any(TracingContext.class));
        abfsClient.getIsNamespaceEnabled();
        ((AbfsClient)Mockito.verify((Object)abfsClient, (VerificationMode)Mockito.times((int)1))).getAclStatus(ArgumentMatchers.anyString(), (TracingContext)ArgumentMatchers.any(TracingContext.class));
    }

    private Configuration getConfigurationWithoutHnsConfig() {
        Configuration rawConfig = new Configuration();
        rawConfig.addResource("azure-test.xml");
        rawConfig.unset("fs.azure.account.hns.enabled");
        rawConfig.unset(ConfigurationKeys.accountProperty((String)"fs.azure.account.hns.enabled", (String)this.getAccountName()));
        String defaultUri = this.getRawConfiguration().get("fs.defaultFS").replace(".blob.", ".dfs.");
        rawConfig.set("fs.defaultFS", defaultUri);
        return rawConfig;
    }

    private void assertFileSystemInitWithExpectedHNSSettings(Configuration configuration, boolean expectedIsHnsEnabledValue) throws IOException {
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)configuration);){
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.getIsNamespaceEnabled(fs)).describedAs("getIsNamespaceEnabled should return true when the account specific config is not set", new Object[0])).isEqualTo(expectedIsHnsEnabledValue);
        }
    }
}

