/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.SecureAzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ITestFileSystemInitialization
extends AbstractAbfsIntegrationTest {
    @Test
    public void ensureAzureBlobFileSystemIsInitialized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        String accountName = this.getAccountName();
        String filesystem = this.getFileSystemName();
        String scheme = this.getAuthType() == AuthType.SharedKey ? "abfs" : "abfss";
        ITestFileSystemInitialization.assertEquals((Object)fs.getUri(), (Object)new URI(scheme, filesystem + "@" + accountName, null, null, null));
        ITestFileSystemInitialization.assertNotNull((Object)fs.getWorkingDirectory(), (String)"working directory");
    }

    @Test
    public void ensureSecureAzureBlobFileSystemIsInitialized() throws Exception {
        String accountName = this.getAccountName();
        String filesystem = this.getFileSystemName();
        URI defaultUri = new URI("abfss", filesystem + "@" + accountName, null, null, null);
        Configuration rawConfig = this.getRawConfiguration();
        rawConfig.set("fs.defaultFS", defaultUri.toString());
        try (SecureAzureBlobFileSystem fs = (SecureAzureBlobFileSystem)FileSystem.newInstance((Configuration)rawConfig);){
            ITestFileSystemInitialization.assertEquals((Object)fs.getUri(), (Object)new URI("abfss", filesystem + "@" + accountName, null, null, null));
            ITestFileSystemInitialization.assertNotNull((Object)fs.getWorkingDirectory(), (String)"working directory");
        }
    }

    @Test
    public void testFileSystemCapabilities() throws Throwable {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path p = new Path("}");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.hasPathCapability(p, "fs.capability.etags.available")).describedAs("path capability %s in %s", new Object[]{"fs.capability.etags.available", fs})).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.hasPathCapability(p, "fs.azure.capability.readahead.safe")).describedAs("path capability %s in %s", new Object[]{"fs.azure.capability.readahead.safe", fs})).isTrue();
        boolean etagsAcrossRename = fs.hasPathCapability(p, "fs.capability.etags.preserved.in.rename");
        boolean acls = fs.hasPathCapability(p, "fs.capability.paths.acls");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)etagsAcrossRename).describedAs("capabilities %s=%s and %s=%s in %s", new Object[]{"fs.capability.etags.preserved.in.rename", etagsAcrossRename, "fs.capability.paths.acls", acls, fs})).isEqualTo(acls);
    }

    @Test
    public void testABFSCloseWithoutInit() throws Exception {
        AzureBlobFileSystem fs = new AzureBlobFileSystem();
        Assertions.assertThat((boolean)fs.isClosed()).isTrue();
        fs.close();
        fs.initialize(this.getFileSystem().getUri(), this.getRawConfiguration());
        Assertions.assertThat((boolean)fs.isClosed()).isFalse();
        fs.close();
        Assertions.assertThat((boolean)fs.isClosed()).isTrue();
    }

    @Test
    public void testABFSUninitializedFileSystem() throws Exception {
        AzureBlobFileSystem fs = new AzureBlobFileSystem();
        Assertions.assertThat((boolean)fs.isClosed()).isTrue();
        Path testPath = new Path("testPath");
        LambdaTestUtils.intercept(IllegalStateException.class, (String)"Invalid state for AzureBlobFilesystem. Either Filesystem was closed or not initialized.", () -> ((AzureBlobFileSystem)fs).toString());
        LambdaTestUtils.intercept(IllegalStateException.class, (String)"Invalid state for AzureBlobFilesystem. Either Filesystem was closed or not initialized.", () -> fs.open(testPath, 0x100000));
        LambdaTestUtils.intercept(IllegalStateException.class, (String)"Invalid state for AzureBlobFilesystem. Either Filesystem was closed or not initialized.", () -> fs.create(testPath, FsPermission.getDefault(), false, 0x100000, fs.getDefaultReplication(testPath), 0x100000L, null));
        LambdaTestUtils.intercept(IllegalStateException.class, (String)"Invalid state for AzureBlobFilesystem. Either Filesystem was closed or not initialized.", () -> fs.createNonRecursive(testPath, FsPermission.getDefault(), false, 0x100000, fs.getDefaultReplication(testPath), 0x100000L, null));
        LambdaTestUtils.intercept(IllegalStateException.class, (String)"Invalid state for AzureBlobFilesystem. Either Filesystem was closed or not initialized.", () -> fs.append(testPath, 0x100000, null));
        LambdaTestUtils.intercept(IllegalStateException.class, (String)"Invalid state for AzureBlobFilesystem. Either Filesystem was closed or not initialized.", () -> fs.rename(testPath, testPath));
        LambdaTestUtils.intercept(IllegalStateException.class, (String)"Invalid state for AzureBlobFilesystem. Either Filesystem was closed or not initialized.", () -> fs.delete(testPath, true));
        LambdaTestUtils.intercept(IllegalStateException.class, (String)"Invalid state for AzureBlobFilesystem. Either Filesystem was closed or not initialized.", () -> fs.listStatus(testPath));
        LambdaTestUtils.intercept(IllegalStateException.class, (String)"Invalid state for AzureBlobFilesystem. Either Filesystem was closed or not initialized.", () -> fs.mkdirs(testPath, FsPermission.getDefault()));
        LambdaTestUtils.intercept(IllegalStateException.class, (String)"Invalid state for AzureBlobFilesystem. Either Filesystem was closed or not initialized.", () -> fs.getFileStatus(testPath));
        LambdaTestUtils.intercept(IllegalStateException.class, (String)"Invalid state for AzureBlobFilesystem. Either Filesystem was closed or not initialized.", () -> fs.breakLease(testPath));
        LambdaTestUtils.intercept(IllegalStateException.class, (String)"Invalid state for AzureBlobFilesystem. Either Filesystem was closed or not initialized.", () -> fs.makeQualified(testPath));
        LambdaTestUtils.intercept(IllegalStateException.class, (String)"Invalid state for AzureBlobFilesystem. Either Filesystem was closed or not initialized.", () -> fs.setOwner(testPath, "", ""));
        LambdaTestUtils.intercept(IllegalStateException.class, (String)"Invalid state for AzureBlobFilesystem. Either Filesystem was closed or not initialized.", () -> fs.setXAttr(testPath, "xattr", new byte[0], EnumSet.of(XAttrSetFlag.CREATE)));
        LambdaTestUtils.intercept(IllegalStateException.class, (String)"Invalid state for AzureBlobFilesystem. Either Filesystem was closed or not initialized.", () -> fs.getXAttr(testPath, "xattr"));
        LambdaTestUtils.intercept(IllegalStateException.class, (String)"Invalid state for AzureBlobFilesystem. Either Filesystem was closed or not initialized.", () -> fs.setPermission(testPath, FsPermission.getDefault()));
        LambdaTestUtils.intercept(IllegalStateException.class, (String)"Invalid state for AzureBlobFilesystem. Either Filesystem was closed or not initialized.", () -> fs.modifyAclEntries(testPath, new ArrayList()));
        LambdaTestUtils.intercept(IllegalStateException.class, (String)"Invalid state for AzureBlobFilesystem. Either Filesystem was closed or not initialized.", () -> fs.removeAclEntries(testPath, new ArrayList()));
        LambdaTestUtils.intercept(IllegalStateException.class, (String)"Invalid state for AzureBlobFilesystem. Either Filesystem was closed or not initialized.", () -> fs.removeDefaultAcl(testPath));
        LambdaTestUtils.intercept(IllegalStateException.class, (String)"Invalid state for AzureBlobFilesystem. Either Filesystem was closed or not initialized.", () -> fs.removeAcl(testPath));
        LambdaTestUtils.intercept(IllegalStateException.class, (String)"Invalid state for AzureBlobFilesystem. Either Filesystem was closed or not initialized.", () -> fs.setAcl(testPath, new ArrayList()));
        LambdaTestUtils.intercept(IllegalStateException.class, (String)"Invalid state for AzureBlobFilesystem. Either Filesystem was closed or not initialized.", () -> fs.getAclStatus(testPath));
        LambdaTestUtils.intercept(IllegalStateException.class, (String)"Invalid state for AzureBlobFilesystem. Either Filesystem was closed or not initialized.", () -> fs.access(testPath, FsAction.ALL));
        LambdaTestUtils.intercept(IllegalStateException.class, (String)"Invalid state for AzureBlobFilesystem. Either Filesystem was closed or not initialized.", () -> fs.exists(testPath));
    }
}

