/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.lang.reflect.Field;
import java.net.URL;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedClass;
import org.junit.jupiter.params.provider.MethodSource;

@ParameterizedClass
@MethodSource(value={"params"})
public class ITestClientUrlScheme
extends AbstractAbfsIntegrationTest {
    public boolean useSecureScheme;
    public boolean alwaysUseHttps;

    public static Iterable<Object[]> params() {
        return Arrays.asList({false, false}, {false, true}, {true, true}, {true, false});
    }

    public ITestClientUrlScheme(boolean pUseSecureScheme, boolean pAlwaysUseHttps) throws Exception {
        this.useSecureScheme = pUseSecureScheme;
        this.alwaysUseHttps = pAlwaysUseHttps;
        ((AbstractComparableAssert)Assumptions.assumeThat((Comparable)this.getAuthType()).as("ITestClientUrlScheme is skipped because auth type is not SharedKey", new Object[0])).isEqualTo((Object)AuthType.SharedKey);
    }

    @Test
    public void testClientUrlScheme() throws Exception {
        String[] urlWithoutScheme = this.getTestUrl().split(":");
        String fsUrl = this.useSecureScheme ? "abfss:" + urlWithoutScheme[1] : "abfs:" + urlWithoutScheme[1];
        Configuration config = this.getRawConfiguration();
        config.set("fs.defaultFS", fsUrl.toString());
        config.setBoolean("fs.azure.always.use.https", this.alwaysUseHttps);
        boolean expectHttpConnection = !this.useSecureScheme && !this.alwaysUseHttps;
        AbfsClient client = null;
        try {
            client = this.getFileSystem(config).getAbfsClient();
        }
        catch (AbfsRestOperationException e) {
            if (AzureServiceErrorCode.ACCOUNT_REQUIRES_HTTPS.equals((Object)e.getErrorCode()) && expectHttpConnection) {
                return;
            }
            throw e;
        }
        Field baseUrlField = AbfsClient.class.getDeclaredField("baseUrl");
        baseUrlField.setAccessible(true);
        String url = ((URL)baseUrlField.get(client)).toString();
        if (expectHttpConnection) {
            Assertions.assertTrue((boolean)url.startsWith("http"));
        } else {
            Assertions.assertTrue((boolean)url.startsWith("https"));
        }
    }
}

